/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.mytrip.HotelBillStrategy;
import kd.fi.er.business.mytrip.PlaneBillStrategy;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class BaseBillMobPlugin
extends AbstractMobBillPlugIn
implements TabSelectListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", "btnalter"});
        Tab tab = (Tab)this.getControl("TabAp");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTab();
    }

    private void initTab() {
        this.initTabCount();
        this.showData("tabpageap");
    }

    private void initTabCount() {
        PlaneBillStrategy planeStrategy = new PlaneBillStrategy();
        HotelBillStrategy hotelStrategy = new HotelBillStrategy();
        TabPage tabPage = (TabPage)this.getControl("tabpageap");
        tabPage.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u4f7f\u7528(%s)", (String)"BaseBillMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), planeStrategy.count("tabpageap") + hotelStrategy.count("tabpageap")));
        tabPage = (TabPage)this.getControl("tabpageap1");
        tabPage.setMessage(String.format(ResManager.loadKDString((String)"\u5df2\u5173\u95ed(%s)", (String)"BaseBillMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), planeStrategy.count("tabpageap1") + hotelStrategy.count("tabpageap1")));
    }

    private void showData(String tabKey) {
        List<Map> orderBills = this.getData(tabKey);
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int size = orderBills.size();
        if (size == 0) {
            return;
        }
        model.batchCreateNewEntryRow("entryentity", size);
        int idx = 0;
        for (Map bill : orderBills) {
            model.setValue("title", bill.get("title"), idx);
            model.setValue("amount", bill.get("amount"), idx);
            model.setValue("info", bill.get("info"), idx);
            model.setValue("address", bill.get("address"), idx);
            model.setValue("billid", bill.get("billId"), idx);
            model.setValue("billtype", bill.get("billType"), idx);
            model.setValue("orderStatus", bill.get("orderStatus"), idx);
            ++idx;
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control c = (Control)source;
            String key = c.getKey();
            if ("er_planebill".equals(c.getModel().getValue("billType").toString()) && ("btncancel".equalsIgnoreCase(key) || "btnalter".equalsIgnoreCase(key))) {
                this.showPage(new FormModel("er_externalsystem", ResManager.loadKDString((String)"\u9000\u6539\u7b7e", (String)"BaseBillMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", false, BaseBillMobPlugin.getZteSsoOrderParameter("domairorder")));
            }
        }
    }

    private static Map<String, Object> getZteSsoOrderParameter(String businessType) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("externalInvokeClass", "kd.fi.er.business.externalsystem.BeeToCInvoke");
        customParam.put("businessType", businessType);
        HashMap<String, String> urlDataMap = new HashMap<String, String>();
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)BaseBillMobPlugin.getCurrentUser())};
        DynamicObject userObject = QueryServiceHelper.queryOne((String)"bos_user", (String)"number", (QFilter[])qFilters1);
        urlDataMap.put("employeeNumber", userObject.get("number").toString());
        customParam.put("urlDataMap", urlDataMap);
        return customParam;
    }

    private static Long getCurrentUser() throws NumberFormatException {
        RequestContext requestContext = RequestContext.get();
        return Long.valueOf(requestContext.getUserId());
    }

    private void showPage(FormModel formModel) {
        if (formModel == null) {
            return;
        }
        String formId = formModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"BaseBillMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private List<Map> getData(String tabKey) {
        List ret = new PlaneBillStrategy().getData(tabKey);
        ret.addAll(new HotelBillStrategy().getData(tabKey));
        this.orderByBeginDate(ret);
        return ret;
    }

    private List<Map> orderByBeginDate(List<Map> ret) {
        ret.sort((v1, v2) -> ((Date)v1.get("orderDate")).compareTo((Date)v2.get("orderDate")));
        return ret;
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        this.showData(tabKey);
        IFormView view = this.getView();
        if ("tabpageap1".equalsIgnoreCase(tabKey)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"cardentryflexpanelap3"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"cardentryflexpanelap3"});
        }
    }
}

