/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterMobileListPushDownRefreshListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import org.apache.commons.lang3.StringUtils;

public abstract class CoreBaseBillListNew
extends AbstractMobListPlugin
implements ClickListener,
TabSelectListener,
AfterMobileListPushDownRefreshListener {
    protected static final String BILLLISTAP = "billlistap";
    protected static final String TODOTAB = "todotab";
    protected static final String DOINGTAB = "doingtab";
    protected static final String DIDTAB = "didtab";
    public static final String REFRESH_AUDITOR = "refresh_auditor";
    public static final String REFRESH_AUDITOR_SEC = "refresh_auditor_sec";
    private Map<String, MobileListStateInfo> paramMap;
    private static Log logger = LogFactory.getLog(CoreBaseBillListNew.class);

    public CoreBaseBillListNew(List<MobileListStateInfo> stateInfoList) {
        this.paramMap = stateInfoList.stream().collect(Collectors.toMap(MobileListStateInfo::getTabNum, Function.identity()));
    }

    protected String getEntityName() {
        return ((MobileListView)this.getView()).getListModel().getEntityId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        if (billlistap != null) {
            billlistap.addMobileListPushDownRefreshistener(afterMobileListPushDownRefreshEvent -> this.initTabLabelCount());
        }
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        this.regRefreshEvent();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IPageCache pageCache;
        String currentTabNumStr;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = null;
        if (tab != null && !(currentTab = tab.getCurrentTab()).isEmpty() && StringUtils.isNumeric((CharSequence)(currentTabNumStr = (pageCache = this.getPageCache()).get(currentTab)))) {
            String removeOperates = String.join((CharSequence)",", "delete");
            if (removeOperates.contains(operateKey)) {
                int currentTabNumber = Integer.parseInt(currentTabNumStr);
                int currentTabNewNum = currentTabNumber - operationResult.getSuccessPkIds().size();
                MobileListStateInfo mobileListStateInfo = this.paramMap.get(currentTab);
                ((TabPage)this.getControl(currentTab)).setMessage(mobileListStateInfo.getTabName() + "(" + currentTabNewNum + ")");
                pageCache.put(currentTab, String.valueOf(currentTabNewNum));
            } else {
                this.initTabLabelCount();
            }
        }
    }

    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.refresh();
        String tabKey = paramTabSelectEvent.getTabKey();
        this.showDefaultViewInfo(this.getTabCount(tabKey) > 0);
    }

    private int getTabCount(String paramKey) {
        String count = this.getPageCache().get(paramKey);
        if (count != null) {
            return Integer.parseInt(count);
        }
        return 0;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTabLabelCount();
    }

    protected void showDefaultViewInfo(boolean existData) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexinfo"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        IFormView view = this.getView();
        Tab tab = (Tab)view.getControl("tabap");
        if (tab == null) {
            return;
        }
        String currentTab = tab.getCurrentTab();
        List qFilters = e.getQFilters();
        List<QFilter> commonFilters = this.getCommonFilters(currentTab);
        List<ControlAp<?>> metaItems = this.getItems(view);
        this.otherSetFilter(view, commonFilters, metaItems);
        qFilters.addAll(commonFilters);
        QFilter specialDataPermQFilter = e.getSpecialDataPermQFilter();
        if (specialDataPermQFilter != null && view instanceof MobileListView) {
            this.getNewFilter(specialDataPermQFilter, metaItems);
        }
    }

    private QFilter getcurrentTabFilter(String ... tabname) {
        if (tabname.length != 1) {
            return null;
        }
        String currentTab = tabname[0];
        List<String> mobStateList = this.handleTabStateList(this.paramMap.get(currentTab).getStateList());
        QFilter statusFilter = null;
        if (mobStateList.contains("E")) {
            statusFilter = new QFilter("billstatus", "=", (Object)"E");
        }
        QFilter payamountFilter = null;
        String billFormId = this.getEntityName();
        if (StringUtils.equalsIgnoreCase((CharSequence)DOINGTAB, (CharSequence)currentTab) || StringUtils.equals((CharSequence)TODOTAB, (CharSequence)currentTab)) {
            payamountFilter = this.getPayAmountEQU0Filter(billFormId, false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DIDTAB, (CharSequence)currentTab)) {
            payamountFilter = this.getPayAmountEQU0Filter(billFormId, true);
        }
        return statusFilter == null ? null : statusFilter.and(payamountFilter);
    }

    private QFilter getPayAmountEQU0Filter(String entityId, boolean isEquals) {
        String compare = isEquals ? "=" : "!=";
        logger.info("CoreBaseBillListNew.class'log entityId:" + entityId);
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return new QFilter("payamount", compare, (Object)BigDecimal.ZERO);
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return new QFilter("encashamount", compare, (Object)BigDecimal.ZERO);
        }
        return null;
    }

    private List<String> handleTabStateList(List<String> tabStateList) {
        ArrayList<String> converStateList = new ArrayList<String>();
        for (String billState : tabStateList) {
            if (billState.matches("E\\d")) {
                converStateList.add("E");
                continue;
            }
            converStateList.add(billState);
        }
        return converStateList;
    }

    private List<QFilter> getCommonFilters(String ... tabname) {
        ArrayList stateList = Lists.newArrayListWithCapacity((int)4);
        for (String currentTab : tabname) {
            MobileListStateInfo mobileListStateInfo = this.paramMap.get(currentTab);
            if (mobileListStateInfo == null) continue;
            stateList.addAll(this.handleTabStateList(mobileListStateInfo.getStateList()));
        }
        QFilter currentTabFilter = this.getcurrentTabFilter(tabname);
        Optional.ofNullable(currentTabFilter).ifPresent(e -> stateList.remove("E"));
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)stateList).or(currentTabFilter);
        QFilter extFilter = this.getExtFilter(tabname);
        QFilter specialFilter = CommonUtilHelper.getSpecialDataPermissionFilter(this.getView(), this.getEntityName());
        return Lists.newArrayList((Object[])new QFilter[]{specialFilter, statusFilter, extFilter});
    }

    protected QFilter getExtFilter(String ... tabname) {
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setOrderBy("bizdate desc,billno desc");
    }

    protected Map<String, Integer> initTabLabelCount() {
        List<QFilter> commonFilters = this.getCommonFilters(this.paramMap.keySet().toArray(new String[0]));
        IFormView view = this.getView();
        this.otherSetFilter(view, commonFilters, this.getItems(view));
        List<QFilter> metaDataFilters = this.getFilterFromMetaData();
        if (metaDataFilters != null && !metaDataFilters.isEmpty()) {
            commonFilters.addAll(metaDataFilters);
        }
        Map<String, Integer> countMap = this.getStateCount(commonFilters);
        Map<String, Integer> tabCountMap = this.totalCount(countMap);
        for (Map.Entry<String, MobileListStateInfo> entryinfo : this.paramMap.entrySet()) {
            TabPage tabPage;
            MobileListStateInfo stateInfo = entryinfo.getValue();
            int count = 0;
            if (tabCountMap.get(entryinfo.getKey()) != null) {
                count = tabCountMap.get(entryinfo.getKey());
            }
            if ((tabPage = (TabPage)this.getControl(entryinfo.getKey())) == null) continue;
            tabPage.setMessage(stateInfo.getTabName() + "(" + count + ")");
            this.getPageCache().put(entryinfo.getKey(), String.valueOf(count));
        }
        return tabCountMap;
    }

    private String getFieldsName() {
        String billFormId = this.getEntityName();
        logger.info("CoreBaseBillListNew.class'log billFormId:" + billFormId);
        if (ErEntityTypeUtils.isDailyReimburseBill((String)billFormId) || ErEntityTypeUtils.isPublicReimburseBill((String)billFormId)) {
            return "id,billstatus,payamount";
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)billFormId)) {
            return "id,billstatus,encashamount";
        }
        return "id,billstatus";
    }

    private QFilter[] getCombinaFilter(List<QFilter> commonFilters, QFilter qFilter) {
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"E");
        List<QFilter> excludeBillStateFilter = this.getExcludeBillStateFilter(commonFilters);
        excludeBillStateFilter.add(billStatusFilter.and(qFilter));
        return excludeBillStateFilter.toArray(new QFilter[0]);
    }

    protected Map<String, Integer> getStateCount(List<QFilter> commonFilters) {
        Throwable throwable;
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)10);
        ORM orm = ORM.create();
        QFilter[] qFilters = null;
        String entityName = this.getEntityName();
        boolean flag = this.handleCommonFilter(commonFilters);
        qFilters = commonFilters.toArray(new QFilter[0]);
        try {
            throwable = null;
            try (DataSet dataset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), entityName, this.getFieldsName(), qFilters);){
                if (null != dataset) {
                    DataSet groupSet = dataset.groupBy(new String[]{"billstatus"}).count("num").finish();
                    for (Row row : groupSet) {
                        countMap.put(row.getString("billstatus"), row.getInteger("num"));
                    }
                }
            }
            catch (Throwable groupSet) {
                throwable = groupSet;
                throw groupSet;
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        if (flag) {
            try {
                throwable = null;
                try (DataSet E1 = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), entityName, this.getFieldsName(), this.getCombinaFilter(commonFilters, this.getPayAmountEQU0Filter(entityName, false)));){
                    if (E1 != null) {
                        DataSet E1GroupSet = E1.groupBy(new String[]{"billstatus"}).count("num").finish();
                        for (Row row : E1GroupSet) {
                            countMap.put("E1", row.getInteger("num"));
                        }
                    }
                }
                catch (Throwable E1GroupSet) {
                    throwable = E1GroupSet;
                    throw E1GroupSet;
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            try {
                throwable = null;
                try (DataSet E2 = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), entityName, this.getFieldsName(), this.getCombinaFilter(commonFilters, this.getPayAmountEQU0Filter(entityName, true)));){
                    if (null != E2) {
                        DataSet E2GroupSet = E2.groupBy(new String[]{"billstatus"}).count("num").finish();
                        for (Row row : E2GroupSet) {
                            countMap.put("E2", row.getInteger("num"));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return countMap;
    }

    private boolean handleCommonFilter(List<QFilter> commonFilters) {
        boolean flag = false;
        String entityName = this.getEntityName();
        if (!(ErEntityTypeUtils.isTripReimburseBill((String)entityName) || ErEntityTypeUtils.isPublicReimburseBill((String)entityName) || ErEntityTypeUtils.isDailyReimburseBill((String)entityName))) {
            return false;
        }
        for (QFilter qFilter : commonFilters) {
            Set stateList;
            Object value;
            String property;
            if (qFilter == null || !StringUtils.equals((CharSequence)(property = qFilter.getProperty()), (CharSequence)"billstatus") || !((value = qFilter.getValue()) instanceof ArrayList) || !(stateList = Arrays.stream(((ArrayList)value).toArray()).collect(Collectors.toSet())).remove("E")) continue;
            qFilter.__setValue(stateList);
            flag = true;
        }
        return flag;
    }

    private List<QFilter> getExcludeBillStateFilter(List<QFilter> commonFilters) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(commonFilters.size());
        for (QFilter qFilter : commonFilters) {
            String property;
            if (qFilter == null || StringUtils.equals((CharSequence)(property = qFilter.getProperty()), (CharSequence)"billstatus")) continue;
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    private Map<String, Integer> totalCount(Map<String, Integer> countMap) {
        HashMap totalCount = Maps.newHashMapWithExpectedSize((int)this.paramMap.size());
        for (Map.Entry<String, MobileListStateInfo> entry : this.paramMap.entrySet()) {
            List<String> stateList = entry.getValue().getStateList();
            Integer sum = 0;
            for (String state : stateList) {
                sum = sum + countMap.getOrDefault(state, 0);
            }
            totalCount.put(entry.getKey(), sum);
        }
        return totalCount;
    }

    private List<QFilter> getFilterFromMetaData() {
        List qFilters = null;
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        FilterCondition filterCondition = billList.getFilter();
        if (filterCondition != null) {
            FilterBuilder filterBuilder = new FilterBuilder((MainEntityType)billList.getEntityType(), billList.getFilter(), this.getModel());
            filterBuilder.buildFilter();
            qFilters = filterBuilder.getQFilters();
        }
        return qFilters;
    }

    private List<ControlAp<?>> getMetaItems(String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        FormMetadata taskMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return taskMeta.getItems();
    }

    private void getNewFilter(QFilter filter, List<ControlAp<?>> metaItems) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        boolean paramValue = TripSyncConfigUtil.getBoolean((String)"Reservation_ personnel_range");
        for (ControlAp<?> metaItem : metaItems) {
            QFilter qf;
            if (!(metaItem instanceof FieldAp)) continue;
            if (metaItem.getKey().equalsIgnoreCase("projectower")) {
                qf = new QFilter("projectower.fbasedataid_id", "=", (Object)userId);
                filter.or(qf);
            }
            if (!paramValue || !metaItem.getKey().equalsIgnoreCase("multitravelers")) continue;
            qf = new QFilter("multitravelers.fbasedataid_id", "=", (Object)userId);
            filter.or(qf);
        }
    }

    private void otherSetFilter(IFormView view, List<QFilter> commonFilters, List<ControlAp<?>> metaItems) {
        if (CollectionUtils.isNotEmpty(commonFilters) && commonFilters.get(0) != null && view instanceof MobileListView) {
            this.getNewFilter(commonFilters.get(0), metaItems);
        }
    }

    private List<ControlAp<?>> getItems(IFormView view) {
        List<Object> metaItems = new ArrayList();
        if (view instanceof MobileListView) {
            MobileListView listView = (MobileListView)view;
            String billFormId = listView.getBillFormId();
            if ("er_tripreim_grid_mb".equals(billFormId)) {
                billFormId = "er_tripreimbursebill";
            }
            try {
                metaItems = this.getMetaItems(billFormId);
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                metaItems = new ArrayList();
            }
        }
        return metaItems;
    }

    private void regRefreshEvent() {
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("regRefreshEvent"))) {
            String isRefresh;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map mapCustomParam = showParameter.getCustomParams();
            if (null != mapCustomParam && null != mapCustomParam.get("need_refresh") && "Y".equals(isRefresh = mapCustomParam.get("need_refresh").toString())) {
                this.getView().addClientCallBack(REFRESH_AUDITOR, Integer.valueOf(3000));
            }
            this.getPageCache().put("regRefreshEvent", "done");
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name;
        switch (name = e.getName()) {
            case "refresh_auditor": {
                this.getView().addClientCallBack(REFRESH_AUDITOR_SEC, Integer.valueOf(3000));
            }
            case "refresh_auditor_sec": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }
}

