/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.formplugin.mobile.amount.query.AmountControlName;
import kd.fi.er.formplugin.mobile.amount.query.AmountEntity;
import kd.fi.er.formplugin.mobile.amount.query.AmountQueryAndReimburseForMobUtils;
import kd.fi.er.formplugin.util.AmountQueryAndReimburseUtils;
import org.apache.commons.lang3.StringUtils;

public class EmployeeAmountQueryListMob
extends AbstractMobBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(EmployeeAmountQueryListMob.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"balanceentrycard", "reimbursebutton", "usedareacard"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("amountentryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"lastyearlabel"});
    }

    public void afterCreateNewData(EventObject e) {
        Long defaltCompnyId = AmountQueryAndReimburseForMobUtils.initDefaultOrg((AbstractFormPlugin)this);
        this.getModel().setValue("org", (Object)defaltCompnyId);
        this.initAmountEntry();
    }

    protected void initAmountEntry() {
        DynamicObjectCollection amountEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("amountentryentity");
        if (!amountEntry.isEmpty()) {
            AmountQueryAndReimburseForMobUtils.clearEntry(this.getModel(), "amountentryentity");
        }
        if (this.getModel().getDataEntity(true).getDynamicObject("org") == null) {
            return;
        }
        Map<String, AmountEntity> personalMap = this.buildPersonAmountEntry();
        this.setAmountEntryEntity(personalMap);
        Map<String, AmountEntity> deptMap = this.buildDeptAmountEntry();
        this.setAmountEntryEntity(deptMap);
        if (personalMap.size() > 0 || deptMap.size() > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultflexpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"amountentryentity"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultflexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"amountentryentity"});
        }
    }

    protected Map<String, AmountEntity> buildPersonAmountEntry() {
        Long companyId = (Long)this.getModel().getDataEntity(true).getDynamicObject("org").getPkValue();
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = requestContext.getCurrUserId();
        String[] regiom = new String[]{Year.now().toString()};
        logger.info("\u5f53\u524d\u989d\u5ea6\u67e5\u8be2\u6761\u4ef6: companyId->" + companyId + " currentUserId->" + currentUserId);
        QFilter[] qFilters = new QFilter[]{new QFilter("employee", "=", (Object)currentUserId), new QFilter("company", "=", (Object)companyId), new QFilter("auditstatus", "=", (Object)"1"), new QFilter("dateyear", "in", (Object)regiom)};
        DataSet amountInfo = QueryServiceHelper.queryDataSet((String)EmployeeAmountQueryListMob.class.getName(), (String)"er_reimburseamount", (String)"id,expenseitem,expenseitem.isreimburseamountctl as ctrlmode,expenseitem.reimburseamountctlmethod as controlmethod,expenseitem.reimburseamountctlcount as ctlcount,expenseitem.expenseitemicon as expenseimg,expenseitem.name as expensename,employee as userdeptid,currency,dateyear,totalamount as yeartotalamount,company,amounttype ", (QFilter[])qFilters, null);
        amountInfo = amountInfo.filter(new QFilter("dateyear", "=", (Object)Year.now()).or("controlmethod", "=", (Object)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()).or("controlmethod", "=", (Object)ErExpenseItemConstant.ReimburseAmountCtlMethod.MonthlyAndIndex.getValue()).toString());
        Map<String, AmountEntity> entityMap = this.buildAmountEntry(amountInfo);
        return entityMap;
    }

    protected Map<String, AmountEntity> buildDeptAmountEntry() {
        HashMap deptAmountMap = Maps.newHashMap();
        Long companyId = (Long)this.getModel().getDataEntity(true).getDynamicObject("org").getPkValue();
        String depts = this.getPageCache().get(String.valueOf(companyId));
        if (StringUtils.isBlank((CharSequence)depts)) {
            return deptAmountMap;
        }
        List deptList = Arrays.stream(StringUtils.split((String)depts, (char)',')).map(dept -> Long.parseLong(dept)).collect(Collectors.toList());
        String[] regiom = new String[]{Year.now().toString()};
        logger.info("\u5f53\u524d\u90e8\u95e8\u989d\u5ea6\u67e5\u8be2\u6761\u4ef6: companyId->" + companyId + " depts->" + depts);
        QFilter[] qFilters = new QFilter[]{new QFilter("dept", "in", deptList), new QFilter("company", "=", (Object)companyId), new QFilter("auditstatus", "=", (Object)"1"), new QFilter("dateyear", "in", (Object)regiom)};
        String selectClumn = "id,expenseitem,expenseitem.isreimburseamountctl as ctrlmode,expenseitem.reimburseamountctlmethod as controlmethod,expenseitem.reimburseamountctlcount as ctlcount,expenseitem.expenseitemicon as expenseimg,expenseitem.name as expensename,employee,currency,dateyear,totalamount as yeartotalamount,company,amounttype,dept as userdeptid";
        DataSet amountInfo = QueryServiceHelper.queryDataSet((String)AmountQueryAndReimburseForMobUtils.class.getName(), (String)"er_dept_reimctl", (String)selectClumn, (QFilter[])qFilters, null);
        Map<String, AmountEntity> entityMap = this.buildAmountEntry(amountInfo);
        return entityMap;
    }

    protected Map<String, AmountEntity> buildAmountEntry(DataSet amountInfo) {
        HashMap<String, AmountEntity> amountMap = new HashMap<String, AmountEntity>();
        Long companyId = (Long)this.getModel().getDataEntity(true).getDynamicObject("org").getPkValue();
        boolean allowPreviousYear = ReimburseControlUtils.isAllowPreviousYear((Long)companyId);
        Month deadlineMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes((Long)companyId);
        String personCtrlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)companyId);
        String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)companyId);
        LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
        Iterator iter = amountInfo.iterator();
        while (iter.hasNext()) {
            AmountEntity amountRow;
            BigDecimal balanceAmount;
            String yearTotalLab = "";
            String balanceLab = "";
            String usedLabe = "";
            Row row = (Row)iter.next();
            QuotaAmountBO reimAmountBO = new QuotaAmountBO();
            reimAmountBO.setCompanyId(companyId);
            Long userdeptid = row.getLong("userdeptid");
            reimAmountBO.setUserOrDeptId(userdeptid);
            String empCltBillStr = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"empquotaapplicablebill");
            String deptCltBillStr = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"deptquotaapplicablebill");
            List<String> empCltList = Arrays.asList(empCltBillStr.split(","));
            List<String> deptCltList = Arrays.asList(deptCltBillStr.split(","));
            reimAmountBO.setEmpCtlBill(empCltList);
            reimAmountBO.setDeptCtlBill(deptCltList);
            Long expenseItemId = row.getLong("expenseitem");
            reimAmountBO.setExpenseItemId(expenseItemId);
            String ctrlmode = row.getString("ctrlmode");
            reimAmountBO.setCtrlMode(ctrlmode);
            String controlmethod = row.getString("controlmethod");
            reimAmountBO.setCtrlMethod(controlmethod);
            Long currencyId = row.getLong("currency");
            if ("1".equals(ctrlmode)) {
                QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)currencyId, (Long)currencyId);
            } else if ("2".equals(ctrlmode)) {
                QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)currencyId, (Long)currencyId);
            }
            QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
            String year = row.getString("dateyear");
            YearMonth yearMonth = YearMonth.from(LocalDate.now());
            reimAmountBO.setHappenDate(yearMonth);
            if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue().equals(controlmethod)) {
                yearTotalLab = ResManager.loadKDString((String)"\u53ef\u62a5\u6708(\u53bb\u5e74)", (String)"EmployeeAmountQueryListMob_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceLab = ResManager.loadKDString((String)"\u6708\u989d\u5ea6", (String)"EmployeeAmountQueryListMob_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedLabe = ResManager.loadKDString((String)"\u53ef\u62a5\u6708(\u4eca\u5e74)", (String)"EmployeeAmountQueryListMob_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
                yearMonth = yearMonth.minusMonths(1L);
                if (!allowPreviousYear && year.equals(Year.now().minusYears(1L).toString())) continue;
                if (year.equals(Year.now().minusYears(1L).toString())) {
                    if (currentLocalDate.getMonthValue() > deadlineMonth.getValue()) continue;
                    yearMonth = YearMonth.of(Integer.parseInt(year), 12);
                }
                reimAmountBO.setHappenDate(yearMonth);
                balanceAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
            } else if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue().equals(controlmethod)) {
                yearTotalLab = ResManager.loadKDString((String)"\u53ef\u62a5\u5b63(\u53bb\u5e74)", (String)"EmployeeAmountQueryListMob_10", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceLab = ResManager.loadKDString((String)"\u5b63\u989d\u5ea6", (String)"EmployeeAmountQueryListMob_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedLabe = ResManager.loadKDString((String)"\u53ef\u62a5\u5b63(\u4eca\u5e74)", (String)"EmployeeAmountQueryListMob_12", (String)"fi-er-formplugin", (Object[])new Object[0]);
                if (!allowPreviousYear && year.equals(Year.now().minusYears(1L).toString())) continue;
                if (year.equals(Year.now().minusYears(1L).toString())) {
                    if ((currentLocalDate.getMonth().firstMonthOfQuarter().getValue() + 2) / 3 > (deadlineMonth.firstMonthOfQuarter().getValue() + 2) / 3) continue;
                    yearMonth = YearMonth.of(Integer.parseInt(year), 12);
                }
                reimAmountBO.setHappenDate(yearMonth);
                balanceAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
            } else {
                yearTotalLab = ResManager.loadKDString((String)"\u5e74\u603b\u989d", (String)"EmployeeAmountQueryListMob_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceLab = ResManager.loadKDString((String)"\u53ef\u62a5\u9500", (String)"EmployeeAmountQueryListMob_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedLabe = ResManager.loadKDString((String)"\u5df2\u62a5\u9500", (String)"EmployeeAmountQueryListMob_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO);
            }
            BigDecimal usedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
            String expenseImgUrl = row.getString("expenseimg");
            String expenseNameLab = row.getString("expensename");
            String controlMethodLab = AmountControlName.getName(controlmethod);
            Integer ctlcount = row.getInteger("ctlcount");
            if (ctlcount == null) {
                ctlcount = 0;
            }
            if (ctlcount > 0) {
                String ctlcountstr = String.format(ResManager.loadKDString((String)"(%s\u6b21)", (String)"EmployeeAmountQueryListMob_13", (String)"fi-er-formplugin", (Object[])new Object[0]), ctlcount);
                controlMethodLab = controlMethodLab + ctlcountstr;
            }
            reimAmountBO.setCtrlCount(ctlcount);
            BigDecimal yearTotalAmount = row.getBigDecimal("yeartotalamount");
            String key = String.valueOf(expenseItemId).concat(controlmethod).concat(String.valueOf(currencyId)).concat(String.valueOf(userdeptid));
            if (controlmethod.equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue())) {
                amountRow = amountMap.get(key) != null ? (AmountEntity)amountMap.get(key) : new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceAmount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, ctrlmode, userdeptid);
                if (allowPreviousYear && currentLocalDate.getMonthValue() <= deadlineMonth.getValue()) {
                    amountRow.addLastyearmonths(this.getUnreimbursedMonths(reimAmountBO, Year.now().minusYears(1L)));
                }
                amountRow.addThisyearmonths(this.getUnreimbursedMonths(reimAmountBO, Year.now()));
            } else if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue().equals(controlmethod)) {
                amountRow = amountMap.get(key) != null ? (AmountEntity)amountMap.get(key) : new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceAmount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, ctrlmode, userdeptid);
                if (allowPreviousYear && (currentLocalDate.getMonth().firstMonthOfQuarter().getValue() + 2) / 3 <= (deadlineMonth.firstMonthOfQuarter().getValue() + 2) / 3) {
                    amountRow.addLastyearmonths(this.getUnreimbursedQuarters(reimAmountBO, Year.now().minusYears(1L)));
                }
                amountRow.addThisyearmonths(this.getUnreimbursedQuarters(reimAmountBO, Year.now()));
            } else {
                amountRow = new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceAmount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, ctrlmode, userdeptid);
            }
            amountRow.setCtlcount(ctlcount);
            amountMap.put(key, amountRow);
        }
        amountInfo.close();
        logger.info("\u5f53\u524d\u989d\u5ea6\u67e5\u8be2\u7ed3\u679c: size->" + amountMap.size() + " result->" + ((Object)amountMap).toString());
        return amountMap;
    }

    private void setAmountEntryEntity(Map<String, AmountEntity> amountMap) {
        if (amountMap.size() <= 0) {
            return;
        }
        IDataModel model = this.getModel();
        int[] newRowIndex = model.batchCreateNewEntryRow("amountentryentity", amountMap.size());
        int i = newRowIndex[0];
        for (Map.Entry<String, AmountEntity> entry : amountMap.entrySet()) {
            int flag = 2;
            AmountEntity amountEntity = entry.getValue();
            model.setValue("currency", (Object)amountEntity.getCurrencyid(), i);
            model.setValue("expenseitemid", (Object)amountEntity.getExpenseid(), i);
            model.setValue("expenseimg", (Object)amountEntity.getExpenseimgurl(), i);
            model.setValue("expensenamelab", (Object)amountEntity.getExpensenamelab(), i);
            model.setValue("controlmethodlab", (Object)amountEntity.getControlmethodlab(), i);
            model.setValue("balancelab", (Object)amountEntity.getBalancelab(), i);
            model.setValue("balanceamount", (Object)amountEntity.getBalanceamount(), i);
            model.setValue("usedlabe", (Object)amountEntity.getUsedlabe(), i);
            model.setValue("usedamount", (Object)amountEntity.getUsedamount(), i);
            model.setValue("yeartotallab", (Object)amountEntity.getYeartotallab(), i);
            model.setValue("lastmonthlabel", (Object)amountEntity.getYeartotallab(), i);
            model.setValue("yeartotalamount", (Object)amountEntity.getYeartotalamount(), i);
            model.setValue("controlmethod", (Object)amountEntity.getControlmethod(), i);
            String amountType = amountEntity.getAmounttype();
            if (StringUtils.equals((CharSequence)amountType, (CharSequence)"2")) {
                model.setValue("amounttype", (Object)amountEntity.getAmounttype(), i);
                model.setValue("dept", (Object)amountEntity.getDeptId(), i);
            }
            if (amountEntity.getControlmethod().equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) || amountEntity.getControlmethod().equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue())) {
                List monthList = amountEntity.getLastyearmonths().stream().distinct().collect(Collectors.toList());
                flag -= this.setMonthLabel(model, monthList, i, "lastyearmonthlabe");
                this.setMonthLabel(model, monthList, i, "lastyearmonthlabel");
                monthList = amountEntity.getThisyearmonths().stream().distinct().collect(Collectors.toList());
                flag -= this.setMonthLabel(model, monthList, i, "thisyearmonthlabe");
            } else if (amountEntity.getBalanceamount() == null || amountEntity.getBalanceamount().compareTo(BigDecimal.ZERO) == 0) {
                flag = 0;
            }
            if (flag == 0) {
                model.setValue("iscanreimburse", (Object)false, i);
            }
            ++i;
        }
    }

    private int setMonthLabel(IDataModel model, List<?> monthList, int index, String monthLabelName) {
        int flag;
        String monthLabel = "";
        if (monthList != null && monthList.size() > 0) {
            monthLabel = monthList.toString().substring(1, monthList.toString().lastIndexOf(93));
            monthLabel = monthLabel.replaceAll(", ", " ");
            model.setValue(monthLabelName, (Object)monthLabel, index);
            flag = 0;
        } else {
            switch (monthLabelName) {
                case "lastyearmonthlabe": {
                    model.setValue("ishaslastyearmonth", (Object)false, index);
                    break;
                }
                case "thisyearmonthlabe": {
                    model.setValue("ishasthisyearmonth", (Object)false, index);
                }
            }
            flag = 1;
            String usedLabe = ResManager.loadKDString((String)"\u65e0", (String)"EmployeeAmountQueryListMob_8", (String)"fi-er-formplugin", (Object[])new Object[0]);
            model.setValue(monthLabelName, (Object)usedLabe, index);
        }
        return flag;
    }

    protected List<String> getUnreimbursedMonths(QuotaAmountBO reimAmountBO, Year year) {
        int region = year.isBefore(Year.now()) ? 12 : YearMonth.now().getMonth().getValue() - 1;
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= region; ++i) {
            BigDecimal balanceAmount;
            YearMonth yearMonth = year.atMonth(i);
            reimAmountBO.setHappenDate(yearMonth);
            List reimbursedBills = quotaCtrlMode.getReimbursedBills(reimAmountBO);
            if (reimAmountBO.getCtrlCount() != 0 && reimbursedBills.size() >= reimAmountBO.getCtrlCount() || (balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO)) == null || BigDecimal.ZERO.compareTo(balanceAmount) >= 0) continue;
            list.add(String.valueOf(i));
        }
        return list;
    }

    protected List<String> getUnreimbursedQuarters(QuotaAmountBO reimAmountBO, Year year) {
        int region = year.isBefore(Year.now()) ? 4 : (YearMonth.now().getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= region; ++i) {
            BigDecimal balanceAmount;
            YearMonth yearMonth = year.atMonth(i * 3);
            reimAmountBO.setHappenDate(yearMonth);
            List reimbursedBills = quotaCtrlMode.getReimbursedBills(reimAmountBO);
            if (reimAmountBO.getCtrlCount() != 0 && reimbursedBills.size() >= reimAmountBO.getCtrlCount() || (balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO)) == null || BigDecimal.ZERO.compareTo(balanceAmount) >= 0) continue;
            list.add(String.valueOf(i));
        }
        return list;
    }

    public void click(EventObject evt) {
        String key;
        evt.getSource();
        CardEntry entry = (CardEntry)this.getControl("amountentryentity");
        int index = entry.getEntryState().getFocusRow();
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "balanceentrycard": 
            case "reimbursebutton": {
                this.toReimburse(this.getModel(), index);
                break;
            }
            case "usedareacard": {
                if (index == -1) break;
                this.showReimburseAmountUseDetail(index, LocalDate.now().getYear());
                break;
            }
            case "lastyearlabel": {
                if (index < 0 || !StringUtils.isNotBlank((CharSequence)((String)this.getModel().getValue("lastyearmonthlabel", index)))) break;
                this.showReimburseAmountUseDetail(index, LocalDate.now().getYear() - 1);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "org": {
                this.initAmountEntry();
            }
        }
    }

    protected void toReimburse(IDataModel model, Integer index) {
        BigDecimal balanceAmount;
        DynamicObject currency;
        BigDecimal balanceamount = (BigDecimal)model.getValue("balanceamount", index.intValue());
        IFormView thisView = this.getView();
        if (balanceamount == null || balanceamount.compareTo(BigDecimal.ZERO) == 0) {
            thisView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53ef\u62a5\u9500\u989d\u5ea6\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"EmployeeAmountQueryListMob_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        Long expenseItemId = 0L;
        if (model.getValue("expenseitemid", index.intValue()) != null && StringUtils.isNumeric((CharSequence)String.valueOf(model.getValue("expenseitemid", index.intValue())))) {
            expenseItemId = Long.valueOf(String.valueOf(model.getValue("expenseitemid", index.intValue())));
        }
        Long currencyId = (currency = (DynamicObject)model.getValue("currency", index.intValue())) != null ? (Long)currency.getPkValue() : 0L;
        Long companyId = (Long)((DynamicObject)model.getValue("org")).getPkValue();
        String controlMethod = String.valueOf(model.getValue("expenseitemid", index.intValue()));
        if (controlMethod.equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue())) {
            ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)controlMethod));
            YearMonth yearMonth = YearMonth.from(LocalDate.now()).minusMonths(1L);
            balanceAmount = service.getReimburseBalanceAmount(companyId, currentUserId, expenseItemId, currencyId, yearMonth, Collections.emptyList());
        } else {
            balanceAmount = (BigDecimal)model.getValue("balanceamount", index.intValue());
        }
        String amountType = (String)model.getValue("amounttype", index.intValue());
        if (StringUtils.equals((CharSequence)amountType, (CharSequence)"2")) {
            Long deptId = (Long)((DynamicObject)model.getValue("dept", index.intValue())).getPkValue();
            AmountQueryAndReimburseUtils.CreateDailyReimburseByDeptReimParam param = new AmountQueryAndReimburseUtils.CreateDailyReimburseByDeptReimParam();
            param.setBalanceAmount(balanceAmount);
            param.setCompanyId((Object)companyId);
            param.setCurrencyId((Object)currencyId);
            param.setDeptId((Object)deptId);
            param.setExpenseItemId((Object)expenseItemId);
            param.setFormPlugin((AbstractFormPlugin)this);
            param.setHappendDate(CommonServiceHelper.getLastDayOfLastMonthBy((Date)new Date()));
            param.setUserId((Object)currentUserId);
            AmountQueryAndReimburseUtils.createDailyReimburseByDeptReim((AmountQueryAndReimburseUtils.CreateDailyReimburseByDeptReimParam)param);
        } else {
            AmountQueryAndReimburseUtils.CreateDailyReimburseByEmployeeReimParam param = new AmountQueryAndReimburseUtils.CreateDailyReimburseByEmployeeReimParam();
            param.setBalanceAmount(balanceAmount);
            param.setCompanyId((Object)companyId);
            param.setCurrencyId((Object)currencyId);
            param.setExpenseItemId((Object)expenseItemId);
            param.setFormPlugin((AbstractFormPlugin)this);
            param.setHappendDate(CommonServiceHelper.getLastDayOfLastMonthBy((Date)new Date()));
            param.setUserId((Object)currentUserId);
            AmountQueryAndReimburseUtils.createDailyReimburseByEmployeeReim((AmountQueryAndReimburseUtils.CreateDailyReimburseByEmployeeReimParam)param);
        }
    }

    private void showReimburseAmountUseDetail(int index, int year) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject rowData = model.getEntryRowEntity("amountentryentity", index);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"EmployeeAmountQueryListMob_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("er_reimctl_usedetail_mb");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)model.getValue("org")));
        QuotaCtrlUtil.genQuotaExpItem((QuotaAmountBO)reimAmountBO, (Long)Long.valueOf(rowData.getString("expenseitemid")));
        String empCltBillStr = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)model.getValue("org")), (String)"empquotaapplicablebill");
        String deptCltBillStr = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)model.getValue("org")), (String)"deptquotaapplicablebill");
        List<String> empCltList = Arrays.asList(empCltBillStr.split(","));
        List<String> deptCltList = Arrays.asList(deptCltBillStr.split(","));
        reimAmountBO.setEmpCtlBill(empCltList);
        reimAmountBO.setDeptCtlBill(deptCltList);
        reimAmountBO.setHappenYear(Integer.valueOf(year));
        String reimburseType = rowData.getString("amounttype");
        if (StringUtils.equals((CharSequence)reimburseType, (CharSequence)"1")) {
            reimAmountBO.setUserOrDeptId(Long.valueOf(RequestContext.get().getCurrUserId()));
            String personCtlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)model.getValue("org")));
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtlCurrency, (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")));
            showParameter.setCustomParam("isDeptAmount", (Object)false);
        } else if (StringUtils.equals((CharSequence)reimburseType, (CharSequence)"2")) {
            reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)rowData.getDynamicObject("dept")));
            String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)model.getValue("org")));
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")));
            showParameter.setCustomParam("isDeptAmount", (Object)true);
        }
        showParameter.setCustomParam("reimAmountQueryBean", (Object)reimAmountBO);
        view.showForm((FormShowParameter)showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"org")) {
            event.getFormShowParameter().setCustomParam("range", AmountQueryAndReimburseForMobUtils.getUserAllDept((AbstractFormPlugin)this));
        }
    }
}

