/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.IntegralServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang.StringUtils;

public class MyViewPage
extends AbstractMobBillPlugIn
implements ClickListener {
    private final Log logger = LogFactory.getLog(MyViewPage.class);
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();
    protected static final Map<String, MainPageModel> dailyControlMap = new HashMap<String, MainPageModel>();
    private static final String ER_APP_ID = "18XD+/5EDN8X";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap_bank", "imageap_enterbank", "imageap_bank", "labelap_bank1", "flexpanelap", "labelap_personalsetting", "labelap_personalsetting1", "imageap_personalsetting", "imageap_enpersonalsetting", "labelap_helpfeedbackq", "flexpanel_helpfeedback", "labelap_helpfeedback", "imageap_enhelpfeedback", "labelap_service1", "labelap_service", "imageap_service", "imageap_enterservice"});
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            IntegralServiceHelper.ishaveMyId((Long)CommonServiceHelper.getCurrentUserID());
        }
        catch (SQLException e1) {
            this.logger.error("MyViewPage_afterCreateNewData", (Throwable)e1);
        }
        ((Label)this.getControl("labelap_name")).setText(CommonServiceHelper.getCurrentUserName());
        Map userInfoMap = CommonServiceHelper.getUserMap((Long)CommonServiceHelper.getCurrentUserID());
        if (userInfoMap != null && userInfoMap.size() > 0 && userInfoMap.get("org") != null) {
            DynamicObject dept = (DynamicObject)userInfoMap.get("org");
            String deptStr = "";
            if (dept.getLocaleString("name") != null) {
                deptStr = dept.getLocaleString("name").getLocaleValue();
            }
            ((Label)this.getControl("labelap_dept")).setText(deptStr);
        }
        Long userID = CommonServiceHelper.getCurrentUserID();
        String favatarUrl = null;
        if (userID != null) {
            favatarUrl = ErCommonUtils.getUserImageFullPath((Long)userID);
        }
        Image avatarImage = (Image)this.getView().getControl("image_avatar");
        avatarImage.setUrl(favatarUrl);
        DynamicObject scoreInfo = IntegralServiceHelper.getNowScore((Long)CommonServiceHelper.getCurrentUserID());
        int FYearScore = 0;
        if (scoreInfo != null) {
            FYearScore = scoreInfo.getInt("yearscore");
        }
        ((Label)this.getControl("labelap_sorce")).setText(String.format(ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206  %s", (String)"MyViewPage_8", (String)"fi-er-formplugin", (Object[])new Object[0]), FYearScore));
    }

    private DynamicObject getUserObj(Long userId) {
        String selectProperties = "id,name,number,phone,picturefield";
        DynamicObject userObject = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)selectProperties);
        return userObject;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        if (key.equalsIgnoreCase("labelap_bank") || key.equalsIgnoreCase("imageap_bank") || key.equalsIgnoreCase("imageap_enterbank") || key.equalsIgnoreCase("labelap_bank1")) {
            Long currentUserID = CommonServiceHelper.getCurrentUserID();
            int count = CommonServiceHelper.getPayerCount((Long)currentUserID, (Long)currentUserID);
            MobileListShowParameter MobileListShowParameter2 = new MobileListShowParameter();
            MobileListShowParameter2.setBillFormId("er_payeer");
            MobileListShowParameter2.setFormId("er_payertemplate");
            MobileListShowParameter2.getOpenStyle().setShowType(ShowType.Floating);
            MobileListShowParameter2.setAppId(ER_APP_ID);
            MobileListShowParameter2.setHasRight(true);
            this.getView().showForm((FormShowParameter)MobileListShowParameter2);
        } else if (key.equalsIgnoreCase("labelap_service1") || key.equalsIgnoreCase("labelap_service") || key.equalsIgnoreCase("imageap_service") || key.equalsIgnoreCase("imageap_enterservice")) {
            MobileListShowParameter mobileListShowParameter = new MobileListShowParameter();
            mobileListShowParameter.setBillFormId("er_entrustreimburse");
            mobileListShowParameter.setAppId(ER_APP_ID);
            mobileListShowParameter.setHasRight(true);
            mobileListShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileListShowParameter);
        } else if (key.equalsIgnoreCase("flexpanelap")) {
            ShowPageUtils.showPage((FormModel)new FormModel("er_my_yearendreport", ResManager.loadKDString((String)"\u6211\u76842017", (String)"MyViewPage_9", (String)"fi-er-formplugin", (Object[])new Object[0]), "11"), (AbstractFormPlugin)this);
        } else if (key.equalsIgnoreCase("labelap_personalsetting") || key.equalsIgnoreCase("labelap_personalsetting1") || key.equalsIgnoreCase("imageap_personalsetting") || key.equalsIgnoreCase("imageap_enpersonalsetting")) {
            parameter.setFormId("er_tripsettingdata_mob");
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setAppId(ER_APP_ID);
            parameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e", (String)"MyViewPage_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (key.equalsIgnoreCase("labelap_helpfeedbackq") || key.equalsIgnoreCase("imageap_enhelpfeedback") || key.equalsIgnoreCase("flexpanel_helpfeedback") || key.equalsIgnoreCase("labelap_helpfeedback")) {
            parameter.setFormId("er_helpandfeedback_mb");
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setAppId(ER_APP_ID);
            parameter.setCaption(ResManager.loadKDString((String)"\u5e2e\u52a9\u4e0e\u53cd\u9988", (String)"MyViewPage_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            boolean result = this.isDailyExpense(this.getView());
            FormModel formModel = null;
            MainPageModel mainPageModel = null;
            mainPageModel = result ? dailyControlMap.get(key) : controlMap.get(key);
            if (mainPageModel != null) {
                formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue(), mainPageModel.getCustomParam());
            }
            if (formModel == null) {
                return;
            }
            String formId = formModel.getFormId();
            if (StringUtils.isEmpty((String)formId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"MyViewPage_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            ShowPageUtils.showPage(formModel, (AbstractFormPlugin)this);
        }
    }

    private boolean isDailyExpense(IFormView formView) {
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((String)parentView.getEntityId(), (String)"er_mainpage_daily")) {
            return true;
        }
        return this.isDailyExpense(parentView);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (("er_addNew_dialog".equalsIgnoreCase(e.getActionId()) || "er_addNew_dialog_daily".equalsIgnoreCase(e.getActionId())) && e.getReturnData() != null) {
            FormModel formModel = (FormModel)e.getReturnData();
            if (formModel == null) {
                return;
            }
            String formId = formModel.getFormId();
            if (StringUtils.isEmpty((String)formId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"MyViewPage_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter viewFormShowParameter = this.getView().getFormShowParameter();
            viewFormShowParameter.setAppId(ER_APP_ID);
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        }
    }

    static {
        controlMap.put("mbaritemap_homepage", new MainPageModel("er_mainpage", ResManager.loadKDString((String)"\u9996\u9875", (String)"MyViewPage_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "11"));
        controlMap.put("mbaritemap_report", new MainPageModel("er_trip_report", ResManager.loadKDString((String)"\u8db3\u8ff9", (String)"MyViewPage_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("mbaritemap_trip", new MainPageModel("er_trip", ResManager.loadKDString((String)"\u5546\u65c5", (String)"MyViewPage_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("mbaritemap_my", new MainPageModel("er_myviewpage_m", ResManager.loadKDString((String)"\u6211\u7684", (String)"MyViewPage_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog", ResManager.loadKDString((String)"\u65b0\u589e", (String)"MyViewPage_4", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
        controlMap.put("imageap_enterinvoicing", new MainPageModel("er_billinginform_m", ResManager.loadKDString((String)"\u5f00\u7968\u4fe1\u606f", (String)"MyViewPage_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_enterinvoicing", new MainPageModel("er_billinginform_m", ResManager.loadKDString((String)"\u5f00\u7968\u4fe1\u606f", (String)"MyViewPage_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_enterinvoicing1", new MainPageModel("er_billinginform_m", ResManager.loadKDString((String)"\u5f00\u7968\u4fe1\u606f", (String)"MyViewPage_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("imageap_invoicing", new MainPageModel("er_billinginform_m", ResManager.loadKDString((String)"\u5f00\u7968\u4fe1\u606f", (String)"MyViewPage_5", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_tripstd1", new MainPageModel("er_mytripstd_mb", ResManager.loadKDString((String)"\u5dee\u65c5\u6807\u51c6\u67e5\u8be2", (String)"MyViewPage_6", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("labelap_feestd", new MainPageModel("er_myfeestandard_mb", null, "5"));
        controlMap.put("labelap_sorce", new MainPageModel("er_integralboard_m", ResManager.loadKDString((String)"\u4f4e\u78b3\u79ef\u5206", (String)"MyViewPage_7", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        dailyControlMap.putAll(controlMap);
        dailyControlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog_daily", ResManager.loadKDString((String)"\u65b0\u589e", (String)"MyViewPage_4", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
    }
}

