/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.dailybiz.DailyReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.mobile.PublicReimBillOrderMobileEdit;
import org.apache.commons.lang3.StringUtils;

public class PublicReimBillSecondOrderMobileEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(PublicReimBillOrderMobileEdit.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"chooseorder"});
        EntryGrid entryEntityControl = (EntryGrid)this.getControl("expenseentryentity");
        if (entryEntityControl != null) {
            entryEntityControl.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        IDataModel parentmodel = parentView.getModel();
        DynamicObjectCollection orderentrys = parentmodel.getEntryEntity("orderentry");
        DynamicObjectCollection entryEntity = model.getEntryEntity("expenseentryentity");
        if (orderentrys.size() == 0 || entryEntity.size() == 0) {
            return;
        }
        model.setValue("monthsettleamount", parentmodel.getValue("monthsettleamount"));
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (!entry.getBoolean("isexistmonthly") || !StringUtils.isBlank((CharSequence)((String)model.getValue("ordernum")))) continue;
            String odernumStr = DailyReimCreateOrderEntrysUtil.getOrderNumStr((DynamicObjectCollection)orderentrys, (Long)ErCommonUtils.getPk((Object)entry.getPkValue()));
            model.setValue("ordernum", (Object)odernumStr, i);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("chooseorder".equals(key)) {
            this.openChooseOrder();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        if ("ordernum".equals(fieldName)) {
            String ordernumber;
            IDataModel model = this.getModel();
            DynamicObject entry = (DynamicObject)model.getEntryEntity("expenseentryentity").get(rowIndex);
            Long detailid = ErCommonUtils.getPk((Object)entry);
            IDataModel parentModel = this.getView().getParentView().getModel();
            StringBuilder orderNum = new StringBuilder();
            StringBuilder orderFormid = new StringBuilder();
            DynamicObjectCollection parentorderEntrys = parentModel.getEntryEntity("orderentry");
            DynamicObjectCollection orderEntrys = model.getEntryEntity("orderentry");
            for (DynamicObject orderEntry : orderEntrys) {
                if (detailid.longValue() != orderEntry.getLong("ordexpenseentryid")) continue;
                ordernumber = orderEntry.getString("ordernumber");
                if (orderNum.toString().contains(ordernumber)) continue;
                orderNum.append(ordernumber).append(",");
                orderFormid.append(orderEntry.getString("orderformid")).append(",");
            }
            for (DynamicObject orderEntry : parentorderEntrys) {
                if (detailid.longValue() != orderEntry.getLong("ordexpenseentryid")) continue;
                ordernumber = orderEntry.getString("ordernumber");
                if (orderNum.toString().contains(ordernumber)) continue;
                orderNum.append(ordernumber).append(",");
                orderFormid.append(orderEntry.getString("orderformid")).append(",");
            }
            if (orderNum.length() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
                paramMap.put("formId", "er_reimbursedetail_mb");
                paramMap.put("formName", ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u6708\u7ed3\u5206\u5f55\u8be6\u60c5", (String)"PublicReimBillOrderMobileEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                paramMap.put("formType", "5");
                paramMap.put("needCallBack", Boolean.TRUE);
                mapCustomParam.put("ordernum", orderNum.toString());
                mapCustomParam.put("currencyId", ErCommonUtils.getPk((Object)entry.getDynamicObject("entrycurrency")));
                mapCustomParam.put("orderformid", orderFormid.toString());
                paramMap.put("customParam", mapCustomParam);
                ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (this.getFormId().equals(closedCallBackEvent.getActionId())) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            if (map == null || map.size() == 0) {
                return;
            }
            List list = (List)map.get("entryentity");
            Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
            companyId = companyId == null ? Long.valueOf(0L) : companyId;
            Set ordernums = list.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            List orders = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByOrderId(ordernums, (Long)companyId, (Boolean)false);
            if (orders.size() == 0) {
                return;
            }
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            String formId = view.getFormShowParameter().getFormId();
            int expenseIndex = model.getEntryCurrentRowIndex("expenseentryentity");
            DynamicObject expenseEntry = (DynamicObject)dynamicObject.getDynamicObjectCollection("expenseentryentity").get(expenseIndex);
            DynamicObjectCollection orderEntrys = dynamicObject.getDynamicObjectCollection("orderentry");
            DailyReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)dynamicObject, (DynamicObject)expenseEntry, (DynamicObjectCollection)orderEntrys, (List)orders, (boolean)true, null, null, (String)formId, null);
            String orderNumStr = DailyReimCreateOrderEntrysUtil.getOrderNumStr((DynamicObjectCollection)orderEntrys, (Long)ErCommonUtils.getPk((Object)expenseEntry));
            String parentorderNumStr = DailyReimCreateOrderEntrysUtil.getOrderNumStr((DynamicObjectCollection)view.getParentView().getModel().getEntryEntity("orderentry"), (Long)ErCommonUtils.getPk((Object)expenseEntry));
            if (parentorderNumStr.length() > 0) {
                parentorderNumStr = parentorderNumStr + "\uff0c";
            }
            model.setValue("ordernum", (Object)(parentorderNumStr + orderNumStr), expenseIndex);
            view.updateView("expenseentryentity", expenseIndex);
        }
    }

    protected void openChooseOrder() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
        Map customParam = showParameter.getCustomParams();
        customParam.put("existOrderNums", this.getExistOrderNums());
        customParam.put("applier", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
        customParam.put("creator", ErCommonUtils.getPk((Object)this.getModel().getValue("creator")));
        Object value = ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"onlychoosetriporder");
        customParam.put("reqbillIds", this.getApplybillIds(value));
        customParam.put("onlychoosetriporder", value);
        customParam.put("companyId", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        this.getView().showForm(showParameter);
    }

    protected String getFormId() {
        return "er_travel_up_mobileorder";
    }

    protected Set<String> getExistOrderNums() {
        HashSet<String> ordernums = new HashSet<String>(12);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getEntryOrderNums(parentView, ordernums);
        }
        this.getEntryOrderNums(this.getView(), ordernums);
        return ordernums;
    }

    protected void getEntryOrderNums(IFormView view, Set<String> ordernums) {
        DynamicObjectCollection orderEntry = view.getModel().getEntryEntity("orderentry");
        orderEntry.stream().forEach(m -> {
            if (StringUtils.isNotBlank((CharSequence)m.getString("ordernumber"))) {
                ordernums.add(m.getString("ordernumber"));
            }
        });
    }

    protected Set<Long> getApplybillIds(Object value) {
        HashSet<Long> applybillIds = new HashSet<Long>(2);
        IFormView parentView = this.getView().getParentView();
        if ("1".equals(value) && parentView != null) {
            parentView.getModel().getEntryEntity("writeoffapply").forEach(e -> e.getDynamicObjectCollection("writeoffapply_lk").forEach(m -> applybillIds.add(m.getLong("writeoffapply_lk_sbillid"))));
        }
        return applybillIds;
    }
}

