/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang.StringUtils;

public class TripNaviBarPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();

    public void registerListener(EventObject e) {
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MenuItem munuItem = (MenuItem)this.getControl("mbaritemap_report");
        if (munuItem != null && this.isLeader()) {
            HashMap textMap = Maps.newHashMapWithExpectedSize((int)1);
            textMap.put(Lang.get().getLangTag().replace("-", "_"), ResManager.loadKDString((String)"\u5206\u6790", (String)"TripNaviBarPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("text", textMap);
            this.getView().updateControlMetadata("mbaritemap_report", (Map)map);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        FormModel formModel = null;
        MainPageModel mainPageModel = this.getMultilingualModel(controlMap, key);
        boolean leader = this.isLeader();
        if ("mbaritemap_report".equals(key)) {
            formModel = leader ? new FormModel("er_m_dept_rpt", ResManager.loadKDString((String)"\u90e8\u95e8\u8d39\u7528\u5206\u6790", (String)"TripNaviBarPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]), "5") : new FormModel("er_timeline", ResManager.loadKDString((String)"\u4e2a\u4eba\u8db3\u8ff9", (String)"TripNaviBarPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5");
        } else if (mainPageModel != null) {
            formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue());
        }
        if (formModel == null) {
            return;
        }
        String formId = formModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripNaviBarPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.showPage(formModel, (AbstractFormPlugin)this);
    }

    private boolean isLeader() {
        return TripCommonUtil.isCurrentUserLeader((Long)CommonServiceHelper.getCurrentUserID());
    }

    private MainPageModel getMultilingualModel(Map<String, MainPageModel> controlMap, String key) {
        MainPageModel model = controlMap.get(key);
        if (model == null) {
            return null;
        }
        String fromName = null;
        switch (key) {
            case "mbaritemap_homepage": {
                fromName = ResManager.loadKDString((String)"\u9996\u9875", (String)"TripNaviBarPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                break;
            }
            case "mbaritemap_report": {
                fromName = ResManager.loadKDString((String)"\u4e2a\u4eba\u8db3\u8ff9", (String)"TripNaviBarPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                break;
            }
            case "mbaritemap_trip": {
                fromName = ResManager.loadKDString((String)"\u5546\u65c5", (String)"TripNaviBarPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                break;
            }
            case "mbaritemap_my": {
                fromName = ResManager.loadKDString((String)"\u6211\u7684", (String)"TripNaviBarPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
        }
        if (fromName != null) {
            model.setFormName(fromName);
        }
        return model;
    }

    static {
        controlMap.put("mbaritemap_homepage", new MainPageModel("er_mainpage", ResManager.loadKDString((String)"\u9996\u9875", (String)"TripNaviBarPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "11"));
        controlMap.put("mbaritemap_report", new MainPageModel("er_timeline", ResManager.loadKDString((String)"\u4e2a\u4eba\u8db3\u8ff9", (String)"TripNaviBarPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("mbaritemap_trip", new MainPageModel("er_trip", ResManager.loadKDString((String)"\u5546\u65c5", (String)"TripNaviBarPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("mbaritemap_my", new MainPageModel("er_myviewpage_m", ResManager.loadKDString((String)"\u6211\u7684", (String)"TripNaviBarPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
    }
}

