/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.CalculateTripSumUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.enums.CreateAssignOtherNoEnum;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.formplugin.daily.mobile.common.ExpenseBaseMobPlugin;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import kd.fi.er.formplugin.mobile.CoreBaseBillEdit;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;
import kd.fi.er.formplugin.mobile.TripReimburseFormPluginUtil;
import kd.fi.er.formplugin.util.OffsetUtils;
import kd.fi.er.formplugin.web.ErTripReimAutoWriteDescription;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseBill
extends CoreBaseBillEdit {
    private static Log logger = LogFactory.getLog(TripReimburseBill.class);
    private static final String ER_APP_ID = "18XD+/5EDN8X";

    @Override
    public void initialize() {
        super.initialize();
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            String billPageId = view.getPageId();
            IPageCache parentPageCache = (IPageCache)parentView.getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addsection", "btn_change", "labelap_addpayer", "next", "labelap_edit", "labelap_done", "imageap_delete"});
        AbstractGrid tripgrid = (AbstractGrid)this.getView().getControl("tripentry");
        tripgrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.containsKey("invoiceReimburse")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unsubmit", "checkloanamount", "flexpanel_mytrip", "next"});
        } else {
            Control next = this.getControl("next");
            if (next != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "submit", "unsubmit", "checkloanamount", "flexpanel_mytrip", "btn_addsection"});
            }
        }
        IDataModel model = this.getModel();
        model.setValue("editentry", (Object)"0");
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        this.ishaveAccountEntry(model, this.getView());
        this.initTripEntry(model);
        model.setValue("editentry", (Object)"0");
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject targetBill;
        DynamicObject company;
        BillShowParameter billShowParameter;
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (view != null && parentView != null && parentView.getFormShowParameter() != null && parentView.getFormShowParameter().getFormId() != null) {
            FormShowParameter pbillShowParameter = parentView.getFormShowParameter();
            String pFormId = pbillShowParameter.getFormId();
            if ("er_tripreqlisttemplate".equalsIgnoreCase(pFormId) || "er_unconfirmbillinfo".equalsIgnoreCase(pFormId) || "er_tripreqbill_mob".equalsIgnoreCase(pFormId)) {
                this.ishaveAccountEntry(model, this.getView());
                this.initTripEntry(model);
                view.setVisible(Boolean.FALSE, new String[]{"unsubmit", "next"});
            }
            if ("er_expense_list_card_mb".equalsIgnoreCase(pFormId)) {
                view.setVisible(Boolean.FALSE, new String[]{"next"});
            }
        }
        if (view != null && view.getFormShowParameter() != null && (billShowParameter = (BillShowParameter)view.getFormShowParameter()).getStatus() != null && billShowParameter.getStatus() != OperationStatus.ADDNEW) {
            String status;
            switch (status = (String)this.getModel().getValue("billstatus")) {
                case "A": {
                    view.setVisible(Boolean.FALSE, new String[]{"unsubmit", "next"});
                    view.setVisible(Boolean.TRUE, new String[]{"save", "submit"});
                }
            }
        }
        Long companyId = (company = (targetBill = model.getDataEntity()).getDynamicObject("company")) == null ? Long.valueOf(0L) : (Long)company.getPkValue();
        boolean alterFlag = CoreBaseBillServiceHelper.isEnableAlterCostOrgInfoFromSrcBill((Long)companyId, (DynamicObject)targetBill);
        model.setValue("enablealtercostbear", (Object)alterFlag);
        DynamicObjectCollection tripEntries = model.getEntryEntity("tripentry");
        for (int i = 0; i < tripEntries.size(); ++i) {
            DynamicObject tripEntry = (DynamicObject)tripEntries.get(i);
            Optional<DynamicObject> findFirst = tripEntry.getDynamicObjectCollection("entryentity").stream().filter(v -> "2".equals(v.getString("settlementtype"))).findFirst();
            if (!findFirst.isPresent()) continue;
            model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)findFirst.get().get("entrycurrency")), i);
        }
        CommonServiceHelper.setUnsubmitToVisible((IDataModel)model, (IFormView)view, (String)"unsubmit");
        this.refreshLoanClearLabel();
        ErReimburseUpRequestMobPlugin.hiddenOrShow(model, view, false, "clearloanentry", "lab_done_writeoff", "lab_delete_writeoff", "image_delete_writeoff");
        CoreBaseBillServiceHelper.setValueVhc((IDataModel)model);
        CoreBaseBillServiceHelper.refreshTrip2TravelersCount((IDataModel)model);
        TripReimburseServiceHelper.handleExpenseFieldDefaultValue((IDataModel)model);
        Object currencyDO = model.getValue("currency");
        if (currencyDO == null) {
            companyId = ErCommonUtils.getPk((Object)model.getValue("company"));
            Long costCompanyId = ErCommonUtils.getPk((Object)model.getValue("costcompany"));
            Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)companyId, (Object)costCompanyId);
            logger.info("\u518d\u6b21\u83b7\u53d6\u672c\u4f4d\u5e01\uff0ccompanyId={}, costCompanyId={}, currencyId={}", new Object[]{companyId, costCompanyId, currencyId});
            model.setValue("currency", (Object)currencyId);
        }
        if (this.initAccount()) {
            CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)model);
            this.ishaveAccountEntry(model, this.getView());
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                Map exchangeMap = AmountChangeUtil.getCurrencyByParamentForInit((IFormView)this.getView(), (IDataModel)model, (String)isgetaccountcurrency);
                AmountChangeUtil.iscurrencyChangeSetAccInfo((IDataModel)model, (IFormView)this.getView(), (Map)exchangeMap, (String)isgetaccountcurrency);
                model.setValue("iscurrency", (Object)Boolean.TRUE);
            } else {
                Boolean isCurrency = this.refreshIsCurrency(model);
                model.setValue("iscurrency", (Object)isCurrency);
            }
        }
        PayeeServiceHelper.viewStorageLimits((IFormView)this.getView());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "tripentry": {
                ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
                DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection(entryName);
                BigDecimal monthSettleAmount = tripEntry.stream().flatMap(row -> row.getDynamicObjectCollection("entryentity").stream()).filter(row -> StringUtils.equals((CharSequence)row.getString("settlementtype"), (CharSequence)"2")).map(row -> row.getBigDecimal("entryappamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                model.setValue("monthsettleamount", (Object)(monthSettleAmount == null ? BigDecimal.ZERO : monthSettleAmount));
                this.refreshTotalAmount(model, "tripentry", "tripamount", "amount");
                break;
            }
            case "entryentity": {
                AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)this.getModel().getEntryCurrentRowIndex("tripentry"));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        int parentIndex = changeData.getParentRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        IFormView view = this.getView();
        switch (propName) {
            case "company": {
                DynamicObject company = (DynamicObject)model.getValue("company");
                if (company != null) {
                    ChangeData[] valueSet = e.getChangeSet();
                    this.delTripItemByCompanyChange(model, valueSet, company);
                }
            }
            case "costcompany": {
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])e.getChangeSet());
                if (StringUtils.equals((CharSequence)"1", (CharSequence)SystemParamterUtil.getLoanDrawRange((Long)ErCommonUtils.getPk((Object)this.getModel().getValue("company"))))) {
                    while (this.getModel().getEntryRowCount("clearloanentry") > 0) {
                        model.deleteEntryRow("clearloanentry", 0);
                    }
                }
                InvoiceUtils.changeAutoInvoice((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)((Long)((DynamicObject)newValue).getPkValue()));
                break;
            }
            case "applier": {
                model.deleteEntryData("clearloanentry");
                this.getModel().setValue("checkloanamount", (Object)BigDecimal.ZERO);
                break;
            }
            case "org": {
                Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                String range = SystemParamterUtil.getLoanDrawRange((Long)companyId);
                if (!StringUtils.equals((CharSequence)range, (CharSequence)"2")) break;
                model.deleteEntryData("clearloanentry");
                this.getModel().setValue("checkloanamount", (Object)BigDecimal.ZERO);
                break;
            }
            case "checkloanamount": {
                this.refreshLoanClearLabel();
                break;
            }
            case "headexpenseitem": {
                if (StringUtils.isNotBlank((CharSequence)((String)this.getModel().getValue("description")))) break;
                ErTripReimAutoWriteDescription.setDiscription(this.getView());
                break;
            }
            case "orientryamount": {
                AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)newValue), (String)"entryamount", (String)"exchangerate", (String)"detailquotetype", (int)rowIndex, (int)parentIndex);
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                model.setValue("orientryappamount", newValue, rowIndex, parentIndex);
                AmountChangeUtil.recalcReimburseAmountField((IFormView)view, (IDataModel)model, (int)changeData.getParentRowIndex(), Collections.singletonList(changeData.getRowIndex()), (boolean)true);
                this.detailEntryReimburseAmountChange(newValue, changeData.getRowIndex(), changeData.getParentRowIndex());
                break;
            }
            case "tripamount": {
                this.sumAllReimburseAmount();
                break;
            }
            case "price": {
                AmountChangeUtil.setCurPrice((IDataModel)model, (IFormView)view, (BigDecimal)((BigDecimal)newValue), (int)changeData.getRowIndex(), (int)changeData.getParentRowIndex(), (String)"currency");
                break;
            }
            case "entryappamount": {
                CalculateTripSumUtil.calculate((DynamicObject)this.getModel().getDataEntity(true), (IFormView)this.getView());
                break;
            }
            case "curprice": {
                CalculateTripSumUtil.calculateAppnotaxamount((IFormView)this.getView(), (int)changeData.getParentRowIndex());
                break;
            }
            case "orientryappamount": {
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
                AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)newValue), (String)"entryappamount", (String)"exchangerate", (String)"detailquotetype", (int)rowIndex, (int)parentIndex);
                AmountChangeUtil.updateTripApproveInfo((IDataModel)this.getModel(), (IFormView)this.getView(), (int)parentIndex, (int)rowIndex, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0, (String)propName);
                AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"orientryappamount", (int)rowIndex, (int)parentIndex, (String)"entrycurrency", (ChangeField)ChangeField.ORIENTRYAPP_AMOUNT);
                break;
            }
            case "expenseitem": {
                if (model.getProperty("pic") == null || newValue == null) break;
                model.setValue("pic", (Object)((DynamicObject)newValue).getString("expenseitemicon"), changeData.getRowIndex(), changeData.getParentRowIndex());
                break;
            }
            case "deductibletax": {
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex, parentIndex);
                if (taxAmount.subtract((BigDecimal)newValue).compareTo(BigDecimal.ZERO) < 0) {
                    model.setValue("approvetax", oldValue, rowIndex, parentIndex);
                    return;
                }
                ReimburseUtils.sumTripDeduxibleAmount((IDataModel)this.getModel(), (int)parentIndex);
                AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"orientryappamount", (int)changeData.getRowIndex(), (int)changeData.getParentRowIndex(), (String)"entrycurrency", (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
                break;
            }
            case "approvetax": {
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex, parentIndex);
                if (taxAmount.subtract((BigDecimal)newValue).compareTo(BigDecimal.ZERO) < 0) {
                    model.setValue("approvetax", oldValue, rowIndex, parentIndex);
                    return;
                }
                AmountChangeUtil.updatePrice((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"orientryappamount", (int)rowIndex, (int)parentIndex, (String)"entrycurrency", (ChangeField)ChangeField.APPROVE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.APPROVE_TAX);
                break;
            }
            case "offset": {
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0, (String)propName);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
                break;
            }
            case "iteminoutamount": {
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex);
                break;
            }
            case "taxrate": 
            case "airportconstructionfee": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (boolean)true);
                AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)parentIndex);
                break;
            }
            case "taxamount": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (boolean)false);
                this.setDefaultApproveTax(rowIndex, parentIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentIndex, (boolean)false, (String)propName);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentIndex, (ChangeField)ChangeField.TAX_AMOUNT);
                AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)parentIndex);
                break;
            }
            case "entrycurrency": {
                if (newValue == null) {
                    model.setValue("entrycurrency", changeData.getOldValue(), rowIndex, parentIndex);
                    break;
                }
                Object applyCompany = this.getModel().getValue("company");
                Object costCompany = this.getModel().getValue("costcompany");
                Long headCurrency = (Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue();
                Long entryCurrencyId = (Long)((DynamicObject)newValue).getPkValue();
                Map changeRateMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)applyCompany, (Object)costCompany, (Long)entryCurrencyId, (Long)headCurrency, (Object)this.getModel());
                if (changeRateMap == null || changeRateMap.isEmpty()) break;
                this.getModel().setValue("detailquotetype", changeRateMap.get("quoteType"), rowIndex, parentIndex);
                this.getModel().setValue("exchangerate", changeRateMap.get("exchangeRate"), rowIndex, parentIndex);
                break;
            }
        }
    }

    private void setDefaultApproveTax(int rowIndex, int parentIndex) {
        if (this.getModel().getProperty("approvetax") != null) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex, parentIndex);
            this.getModel().setValue("approvetax", (Object)taxAmount, rowIndex, parentIndex);
        }
    }

    private void detailEntryReimburseAmountChange(Object newValue, int currentIndex, int parentIndex) {
        DynamicObject tripEntry;
        DynamicObjectCollection detailEntryColl;
        if (newValue == null) {
            return;
        }
        DynamicObjectCollection tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (parentIndex < tripEntryColl.size() && currentIndex < (detailEntryColl = (tripEntry = (DynamicObject)tripEntryColl.get(parentIndex)).getDynamicObjectCollection("entryentity")).size()) {
            TripReimburseFormPluginUtil.afterEditTrip((AbstractFormPlugin)this, this.getModel());
        }
    }

    private void sumAllReimburseAmount() {
        DynamicObjectCollection tripentrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        BigDecimal amount = tripentrys.stream().map(entryentity -> entryentity.getBigDecimal("tripamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        this.getModel().setValue("amount", (Object)amount);
        this.getModel().setValue("approveamount", (Object)amount);
    }

    private void refreshLoanClearLabel() {
        BigDecimal clearLoanAmount = (BigDecimal)this.getModel().getValue("checkloanamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        String sign = "";
        Integer amtprecision = 4;
        if (currency != null) {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        clearLoanAmount = clearLoanAmount == null ? BigDecimal.ZERO : clearLoanAmount;
        clearLoanAmount = clearLoanAmount.setScale((int)amtprecision, 4);
        Label loanClearLabel = (Label)this.getControl("label_writeoff_account");
        if (loanClearLabel != null) {
            loanClearLabel.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)sign, (BigDecimal)clearLoanAmount, (int)amtprecision));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate c = (FormOperate)args.getSource();
        switch (key = c.getOperateKey()) {
            case "save": 
            case "submit": {
                DynamicObjectCollection accountentrys;
                Object value = this.getModel().getValue("payer");
                Object payerName = this.getModel().getValue("payername");
                if (value == null && payerName == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6536\u6b3e\u660e\u7ec6\u3002", (String)"TripReimburseBill_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.cancel = true;
                }
                if (!(accountentrys = (DynamicObjectCollection)model.getDataEntity(true).get("accountentry")).isEmpty() || !key.equals("submit")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6536\u6b3e\u660e\u7ec6\u3002", (String)"TripReimburseBill_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                break;
            }
            case "unsubmit": {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_change"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult result;
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        if ("submit".equalsIgnoreCase(afterDoOperationEventArgs.getObjectId())) {
            OperationResult result2 = afterDoOperationEventArgs.getOperationResult();
            if (result2.isSuccess()) {
                String billKind = (String)this.getModel().getValue("billkind");
                IFormView view = this.getView();
                IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
                if (parentView != null) {
                    if (StringUtils.equals((CharSequence)parentView.getEntityId(), (CharSequence)"er_approvalrecord")) {
                        parentView.updateView();
                        view.sendFormAction(parentView);
                        view.close();
                        return;
                    }
                    parentView.close();
                    view.sendFormAction(parentView);
                    String formId = StringUtils.equals((CharSequence)billKind, (CharSequence)"1") ? this.getView().getFormShowParameter().getFormId() : this.getView().getEntityId();
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
                    paramMap.put("need_refresh", "Y");
                    this.showMobList(formId, "er_tripreimbilltemplate", paramMap, ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"TripReimburseBill_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                view.close();
            }
            return;
        }
        if ("unsubmit".equalsIgnoreCase(afterDoOperationEventArgs.getObjectId()) && (result = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_change"});
        }
    }

    private void showMobList(String billFormId, String formId, Map<String, Object> paraMap, String Caption) {
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId(ER_APP_ID);
        if (Caption != null) {
            showParameter.setCaption(Caption);
        }
        if (paraMap != null) {
            showParameter.setCustomParams(paraMap);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
        HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        switch (key) {
            case "btn_addsection": {
                paramMap.put("formId", this.getTripEntryEditForm());
                paramMap.put("formName", ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f", (String)"TripReimburseBill_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                paramMap.put("formType", "6");
                mapCustomParam.put("status", 0);
                if (currency != null) {
                    mapCustomParam.put("currency", currency.getPkValue());
                }
                mapCustomParam.put("isquerybudget", (Boolean)this.getModel().getValue("isquerybudget"));
                paramMap.put("customParam", mapCustomParam);
                paramMap.put("needCallBack", Boolean.TRUE);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("tripentry");
                if (null != entryEntity && !entryEntity.isEmpty()) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryEntity.size() - 1);
                    Long to = dynamicObject.getLong("to_id");
                    Object enddate = dynamicObject.get("enddate");
                    mapCustomParam.put("to", to);
                    mapCustomParam.put("enddate", enddate);
                }
                ShowPageUtils.showPage((Map)paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "btn_change": 
            case "labelap_addpayer": {
                paramMap.put("formId", "er_tripreimappilerinfo");
                paramMap.put("formName", ResManager.loadKDString((String)"\u57fa\u7840\u4fe1\u606f", (String)"TripReimburseBill_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                paramMap.put("formType", "6");
                paramMap.put("needCallBack", Boolean.TRUE);
                paramMap.put("appId", ER_APP_ID);
                mapCustomParam.put("billtype", this.getModel().getDataEntity().getDataEntityType().getName());
                paramMap.put("customParam", mapCustomParam);
                ShowPageUtils.showPage((Map)paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "next": {
                paramMap.put("formId", this.getTripEntryEditForm());
                paramMap.put("formName", ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f", (String)"TripReimburseBill_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                paramMap.put("formType", "6");
                int status = this.getView().getFormShowParameter().getStatusValue();
                mapCustomParam.put("status", status);
                if (applier != null) {
                    mapCustomParam.put("applier", applier.getPkValue());
                }
                if (currency != null) {
                    mapCustomParam.put("currency", currency.getPkValue());
                }
                mapCustomParam.put("isquerybudget", (Boolean)this.getModel().getValue("isquerybudget"));
                paramMap.put("customParam", mapCustomParam);
                paramMap.put("needCallBack", Boolean.TRUE);
                Object[] parma = new Object[]{this.getView(), this.getModel(), paramMap};
                Boolean boo = Boolean.TRUE;
                List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, (Object[])new Object[]{TripReimburseBill.class, this.getTripEntryEditForm(), Boolean.FALSE, parma});
                if (!result.isEmpty() && result.get(0) != null) {
                    boo = (Boolean)result.get(0);
                }
                if (!boo.booleanValue()) break;
                ShowPageUtils.showPage((Map)paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "labelap_edit": {
                this.getModel().setValue("editentry", (Object)"1");
                break;
            }
            case "imageap_delete": {
                this.getModel().setValue("editentry", (Object)"2");
                break;
            }
            case "labelap_done": {
                this.getModel().setValue("editentry", (Object)"3");
            }
        }
        ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
        this.getView().updateView();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnMap = (HashMap)closedCallBackEvent.getReturnData();
        if (returnMap == null || returnMap.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        Object[] parma = new Object[]{this.getView(), closedCallBackEvent.getReturnData()};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_BEFORECLOSEDCALLBACK, (Object[])new Object[]{TripReimburseBill.class, closedCallBackEvent.getActionId(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if ("er_payeer_mob".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() != null) {
                returnMap = (HashMap)closedCallBackEvent.getReturnData();
                String payeraccount02 = returnMap.get("payeraccount02").toString();
                ((Label)this.getControl("lable_payeraccount02")).setText(payeraccount02);
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_change", "lable_payeraccount02"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap_addpayer"});
            }
        } else if ("er_tripreimappilerinfo".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean b = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                b.set(p.beforeClosedCallBack(TripReimburseBill.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), closedCallBackEvent.getReturnData()}));
                return null;
            });
            if (b.get() && closedCallBackEvent.getReturnData() != null) {
                DynamicObjectCollection writeOffApply;
                returnMap = (HashMap)closedCallBackEvent.getReturnData();
                if (ErEntityTypeUtils.isTripReimburseBill((String)model.getDataEntityType().getName())) {
                    Long companyId = ErCommonUtils.getPk(returnMap.get("company"));
                    Long userId = ErCommonUtils.getPk(returnMap.get("applier"));
                    Long deptId = ErCommonUtils.getPk(returnMap.get("org"));
                    Long oldCompanyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                    if (!TripReimOpenTypeUtils.isSameType((IFormView)this.getView(), (Long)userId, (Long)oldCompanyId, (Long)companyId)) {
                        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                        UserCurrentDeptInfo ucdi = new UserCurrentDeptInfo(userId.longValue(), deptId.longValue(), companyId.longValue(), oldCompanyId.longValue());
                        this.getView().returnDataToParent((Object)ucdi);
                        this.getView().setReturnData((Object)ucdi);
                        this.getView().sendFormAction(parentView);
                        this.getView().close();
                        return;
                    }
                }
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                Long oldApplierId = ErCommonUtils.getPk((Object)model.getValue("applier"));
                DynamicObject applier = (DynamicObject)returnMap.get("applier");
                Long newApplierId = ErCommonUtils.getPk((Object)applier);
                if (applier != null) {
                    pageCache.put("consignorId", applier.getPkValue().toString());
                }
                this.setChangeAppilerInfo(model, returnMap);
                Object returnCompany = returnMap.get("company");
                Object company = model.getValue("company");
                if (returnCompany != company) {
                    try {
                        model.deleteEntryData("clearloanentry");
                        logger.info("kd.fi.er.formplugin.mobile.TripReimburseBill>>>>>\u51b2\u501f\u6b3e\u5220\u9664\u6210\u529f");
                    }
                    catch (Exception e) {
                        logger.info("kd.fi.er.formplugin.mobile.TripReimburseBill>>>>>\u51b2\u501f\u6b3e\u5220\u9664\u5931\u8d25");
                    }
                }
                this.orgChanged(model, returnMap);
                this.initUserInfo(this.getModel());
                this.ishaveAccountEntry(this.getModel(), this.getView());
                if (ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) && !newApplierId.equals(oldApplierId) && (writeOffApply = model.getDataEntity(true).getDynamicObjectCollection("writeoffapply")) != null && !writeOffApply.isEmpty()) {
                    Set applyBillNo = writeOffApply.stream().map(v -> v.getString("applybillno")).collect(Collectors.toSet());
                    QFilter qFilter = new QFilter("tripentry.travelers.fbasedataid_id", "=", (Object)newApplierId);
                    qFilter.or("applier.id", "=", (Object)newApplierId);
                    qFilter.and("billno", "in", applyBillNo);
                    DynamicObjectCollection bills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno", (QFilter[])new QFilter[]{qFilter});
                    if (bills == null || bills.size() == 0) {
                        model.deleteEntryData("writeoffapply");
                    } else {
                        Set billno = bills.stream().map(v -> v.getString("billno")).collect(Collectors.toSet());
                        int index = 0;
                        int[] deleteIndex = new int[billno.size()];
                        for (int i = 0; i < writeOffApply.size(); ++i) {
                            DynamicObject row = (DynamicObject)writeOffApply.get(i);
                            if (billno.contains(row.getString("applybillno"))) continue;
                            deleteIndex[index++] = i;
                        }
                        model.deleteEntryRows("writeoffapply", deleteIndex);
                    }
                }
                ExpenseBaseMobPlugin.changeAppilerinfoAndAccInfo(model, this.getView());
                this.getView().updateView();
            }
            pluginProxy.callReplace(p -> {
                p.afterClosedCallBack(TripReimburseBill.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), closedCallBackEvent.getReturnData()});
                return null;
            });
        }
        if (this.getTripEntryEditForm().equalsIgnoreCase(closedCallBackEvent.getActionId()) && boo.booleanValue()) {
            Object tripentryarea;
            InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_next"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tbmain", "bar_save", "bar_submit", "tripentry", "flexpanel_mytrip", "listcard_tripentry", "listcardviewap", "btn_addsection"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"save", "submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"next"});
            this.setTripEntryCompanyAndDept();
            this.updateInvoiceLabel();
            String isoverstd = (String)returnMap.get("isoverstd");
            this.pageCache.put("isoverstd", isoverstd);
            int tripcurrentRowIndex = (Integer)returnMap.get("tripcurrentRowIndex");
            if (isoverstd != null) {
                model.setValue("isoverstd", (Object)isoverstd, tripcurrentRowIndex);
            }
            if ((tripentryarea = returnMap.get("tripentryarea")) != null) {
                model.setValue("tripentryarea", tripentryarea, tripcurrentRowIndex);
            }
            OffsetUtils.setHeadSumOffsetAmount((IDataModel)model);
            this.getView().updateView("tripentry");
            this.getModel().setValue("editentry", (Object)"3");
            returnMap = (HashMap)closedCallBackEvent.getReturnData();
            if (returnMap.get("tripcurrentRowIndex") != null) {
                this.refreshTripEntrysAmout(this.getView(), model, tripcurrentRowIndex);
            }
            this.updateMobReimBurseAmount(model);
            TripReimburseFormPluginUtil.afterEditTrip((AbstractFormPlugin)this, this.getModel());
            if (!StringUtils.isNotBlank((CharSequence)((String)this.getModel().getValue("description")))) {
                ErTripReimAutoWriteDescription.setDiscription(this.getView());
            }
            CoreBaseBillServiceHelper.setValueVhc((IDataModel)model);
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            CommonViewControlUtil.setAmountToLabel(model, this.getView(), "accountentry", "receiveamount", "label_account_amount", currency);
        }
        ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AFTERCLOSEDCALLBACK, (Object[])new Object[]{TripReimburseBill.class, closedCallBackEvent.getActionId(), Boolean.FALSE, parma});
    }

    protected String getTripEntryEditForm() {
        return "er_tripreimconsumer_mb";
    }

    private void updateMobReimBurseAmount(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntrys = dataEntity.getDynamicObjectCollection("tripentry");
        String quoteType = "0";
        BigDecimal exchangeRate = BigDecimal.ONE;
        BigDecimal entryamount = BigDecimal.ONE;
        BigDecimal entryappamount = BigDecimal.ONE;
        if (tripEntrys == null) {
            return;
        }
        int oldIndex = model.getEntryCurrentRowIndex("tripentry");
        for (int tripEntryRowIndex = 0; tripEntryRowIndex < tripEntrys.size(); ++tripEntryRowIndex) {
            model.setEntryCurrentRowIndex("tripentry", tripEntryRowIndex);
            DynamicObjectCollection entryItemEntrys = ((DynamicObject)tripEntrys.get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity");
            DynamicObjectCollection reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryItemEntrys.size(); ++i) {
                DynamicObject reimburseDetail = (DynamicObject)reimburseDetails.get(i);
                BigDecimal reimburseAmountOri = reimburseDetail.getBigDecimal("orientryamount");
                BigDecimal reimburseAppAmountOri = reimburseDetail.getBigDecimal("orientryappamount");
                DynamicObject entrycurrency = (DynamicObject)((DynamicObject)entryItemEntrys.get(i)).get("entrycurrency");
                exchangeRate = (BigDecimal)((DynamicObject)entryItemEntrys.get(i)).get("exchangeRate");
                quoteType = (String)((DynamicObject)entryItemEntrys.get(i)).get("detailquotetype");
                if (exchangeRate == null) {
                    logger.info(String.format("\u5e01\u79cdid:%s \u672a\u8bbe\u7f6e\u6c47\u7387", entrycurrency.getPkValue()));
                    exchangeRate = BigDecimal.ONE;
                }
                if (StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
                    entryamount = reimburseAmountOri.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"entrycurrency"), RoundingMode.HALF_UP);
                    entryappamount = reimburseAppAmountOri.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"entrycurrency"), RoundingMode.HALF_UP);
                } else if (StringUtils.equals((CharSequence)"1", (CharSequence)quoteType)) {
                    exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
                    entryamount = reimburseAmountOri.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"entrycurrency"), 4);
                    entryappamount = reimburseAppAmountOri.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"entrycurrency"), 4);
                }
                model.setValue("entryamount", (Object)entryamount, i, tripEntryRowIndex);
                model.setValue("entryappamount", (Object)entryappamount, i, tripEntryRowIndex);
                ErCommonUtils.updateView((IFormView)this.getView(), (int)i, (String[])new String[]{"entryamount", "entryappamount", "taxrate", "notaxamount", "taxamount", "deductibletax"});
            }
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)model, (int)tripEntryRowIndex);
        }
        model.setEntryCurrentRowIndex("tripentry", oldIndex);
    }

    private void refreshTripEntrysAmout(IFormView view, IDataModel model, int tripcurrentRowIndex) {
        boolean isCurrencyShowinTripentry;
        DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObject curTripentry = (DynamicObject)tripEntrys.get(tripcurrentRowIndex);
        boolean bl = isCurrencyShowinTripentry = !DailyBillServiceHelper.isNewTripReim((IDataModel)this.getModel()) && SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        if (isCurrencyShowinTripentry) {
            AmountChangeUtil.refreshCurrencyShowInTripEntryAmount((IFormView)view, (IDataModel)model, (DynamicObject)curTripentry);
        } else {
            AmountChangeUtil.refreshCurrencyShowInExpenseEntryAmount((IFormView)view, (IDataModel)model, (DynamicObject)curTripentry, null);
        }
    }

    private void setTripEntryCompanyAndDept() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("tripentry");
        while (rowCount > 0) {
            DynamicObject tempCompany;
            int index;
            DynamicObject tempDept;
            if ((tempDept = (DynamicObject)model.getValue("entrycostdept", index = --rowCount)) == null) {
                model.setValue("entrycostdept", (Object)ErCommonUtils.getPk((Object)model.getValue("costdept")), index);
            }
            if ((tempCompany = (DynamicObject)model.getValue("entrycostcompany", index)) != null) continue;
            model.setValue("entrycostcompany", (Object)ErCommonUtils.getPk((Object)model.getValue("costcompany")), index);
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
        String key;
        CardEntry source = (CardEntry)arg0.getSource();
        switch (key = source.getKey()) {
            case "tripentry": {
                this.choooseTripEntryRow();
            }
        }
    }

    private void choooseTripEntryRow() {
        this.setAllTripInfoId();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("tripentry");
        int index = grid.getEntryState().getFocusRow();
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId(this.getTripEntryEditForm());
        HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
        mapCustomParam.put("index", index);
        this.pageCache.put("viewTripIndex", String.valueOf(index));
        mapCustomParam.put("status", 1);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            mapCustomParam.put("currency", currency.getPkValue());
        }
        mapCustomParam.put("isquerybudget", (Boolean)this.getModel().getValue("isquerybudget"));
        ErMobWorkFlowOtherViewEditUtils.setWorkFlowParams(mapCustomParam, (IFormView)this.getView());
        ShowPageUtils.setFormStatusToCustomParam(mapCustomParam, (IFormView)this.getView());
        showParameter.setCustomParams(mapCustomParam);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId(ER_APP_ID);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
        Object[] parma = new Object[]{this.getView(), this.getModel(), showParameter, mapCustomParam};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, (Object[])new Object[]{TripReimburseBill.class, this.getTripEntryEditForm(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (boo.booleanValue()) {
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setAllTripInfoId() {
        DynamicObjectCollection tripEntry = this.getModel().getEntryEntity("tripentry");
        tripEntry.stream().forEach(tripItem -> {
            this.setAndGetSelectedRowEntryId((DynamicObject)tripItem);
            DynamicObjectCollection expenseEntry = tripItem.getDynamicObjectCollection("entryentity");
            expenseEntry.stream().forEach(expenseItem -> this.setAndGetSelectedRowEntryId((DynamicObject)expenseItem));
        });
        this.getModel().setValue("tripentry", (Object)tripEntry);
    }

    private Long setAndGetSelectedRowEntryId(DynamicObject entryEntity) {
        Long entryId = (Long)entryEntity.getPkValue();
        if (Objects.equals(entryId, 0L)) {
            entryId = ORM.create().genLongId(this.getView().getEntityId());
            entryEntity.set("id", (Object)entryId);
        }
        return entryId;
    }

    private void initTripEntry(IDataModel model) {
        DynamicObject tripEntity;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)dataEntity.get("tripentry");
        if (!dynamicObjectCollection.isEmpty() && (tripEntity = (DynamicObject)dynamicObjectCollection.get(0)) != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_mytrip", "btn_addsection", "tbmain"});
        }
    }

    private void updateInvoiceLabel() {
        DynamicObjectCollection invoiceHeadEntryDOs = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        BigDecimal invoiceAmount = invoiceHeadEntryDOs.stream().map(invoiceHeadDO -> invoiceHeadDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Label invoiceCountLab = (Label)this.getControl("lbl_invoicecount");
        Label invoiceAmountLab = (Label)this.getControl("lbl_totalamount");
        invoiceCountLab.setText(String.valueOf(invoiceHeadEntryDOs.size()));
        Integer amtprecision = 4;
        String sign = "\uffe5";
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        Long invoiceEntryCurrency = SystemParamterUtil.getInvoiceEntryCurrency((Long)((Long)company.getPkValue()));
        if (invoiceEntryCurrency != null && !currency.getPkValue().equals(invoiceEntryCurrency)) {
            String selectPropties = "id,createorg,number,name,enable,sign,amtprecision";
            DynamicObject invoiceCurrency = BusinessDataServiceHelper.loadSingle((Object)invoiceEntryCurrency, (String)"bd_currency", (String)selectPropties);
            this.getModel().setValue("iscurrency", (Object)true);
            sign = invoiceCurrency.getString("sign");
            amtprecision = invoiceCurrency.getInt("amtprecision");
        } else {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceAmount);
        invoiceAmountLab.setText(formatMoneyByUser);
    }

    private void delTripItemByCompanyChange(IDataModel model, ChangeData[] valueSet, DynamicObject company) {
        if (company.getPkValue() != null && !Objects.equals(valueSet[0].getNewValue(), valueSet[0].getOldValue())) {
            DynamicObjectCollection reimburseDetails;
            int i;
            QFilter qC = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter bdFilter = null;
            Object companyId = company.getPkValue();
            if (companyId instanceof Integer) {
                Integer compId = (Integer)companyId;
                bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)compId.longValue());
            } else if (companyId instanceof Long) {
                bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)((Long)companyId));
            }
            QFilter[] qFilters = new QFilter[]{qC, bdFilter};
            String selectExpensePros = "id,number,longnumber,expenseitemicon,isdefault,isvactax";
            Map tripExpenseitem = BusinessDataServiceHelper.loadFromCache((String)"er_tripexpenseitem", (String)selectExpensePros, (QFilter[])qFilters);
            Set tripExpenseitemEntries = tripExpenseitem.entrySet();
            int length = tripExpenseitemEntries.size();
            HashSet itemIdSet = Sets.newHashSetWithExpectedSize((int)length);
            for (Map.Entry tripExpenseitemEntrie : tripExpenseitemEntries) {
                DynamicObject tripExpenseitemObj = (DynamicObject)tripExpenseitemEntrie.getValue();
                itemIdSet.add((Long)tripExpenseitemObj.getPkValue());
            }
            int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
            DynamicObject dataEntity = model.getDataEntity(true);
            int tripEntrySize = dataEntity.getDynamicObjectCollection("tripentry").size();
            boolean isEntryChange = false;
            if (tripEntrySize > 0) {
                for (i = 0; i < tripEntrySize; ++i) {
                    reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(i)).getDynamicObjectCollection("entryentity");
                    if (reimburseDetails.size() <= 0) continue;
                    ArrayList needRemoveRows = Lists.newArrayList();
                    DynamicObjectCollection needRemoveObs = new DynamicObjectCollection();
                    for (int j = 0; j < reimburseDetails.size(); ++j) {
                        Long tripItemId;
                        DynamicObject reimburseDetail = (DynamicObject)reimburseDetails.get(j);
                        DynamicObject tripItemDO = reimburseDetail.getDynamicObject("expenseitem");
                        if (tripItemDO == null || itemIdSet.contains(tripItemId = (Long)tripItemDO.getPkValue())) continue;
                        if (tripEntryIndex == i) {
                            needRemoveRows.add(j);
                            continue;
                        }
                        needRemoveObs.add((Object)reimburseDetail);
                    }
                    if (!needRemoveRows.isEmpty()) {
                        model.deleteEntryRows("entryentity", needRemoveRows.stream().mapToInt(Integer::intValue).toArray());
                        isEntryChange = true;
                    }
                    if (needRemoveObs.isEmpty()) continue;
                    reimburseDetails.removeAll((Collection)needRemoveObs);
                    isEntryChange = true;
                }
            }
            if (isEntryChange) {
                this.updateMobReimBurseAmount(model);
                if (tripEntrySize > 0) {
                    for (i = 0; i < tripEntrySize; ++i) {
                        reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(i)).getDynamicObjectCollection("entryentity");
                        if (reimburseDetails != null && reimburseDetails.size() != 0) continue;
                        this.getModel().setValue("isoverstd", (Object)false, i);
                    }
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (e.getSource() instanceof BillView && ((BillView)e.getSource()).getReturnData() instanceof UserCurrentDeptInfo) {
            e.setCheckDataChange(false);
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        ActionLocalCache.get().put(CreateAssignOtherNoEnum.TRIPSTD_GRID_MOB.getVal(), (Object)true);
    }
}

