/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ReimburseUtils;

public class TripReimburseFormPluginUtil {
    public static void afterEditTrip(AbstractFormPlugin formPlugin, IDataModel model) {
        TripReimburseFormPluginUtil.updateTitleAmountTotal(model);
        IFormView view = formPlugin.getView();
        String loanType = (String)model.getValue("loanchecktype");
        AmountChangeUtil.loanClearEntryChange((IFormView)view, (IDataModel)model, (String)loanType);
        BigDecimal totalClearLoanAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)"clearloanentry", (String)"loanclearamount");
        model.setValue("checkloanamount", (Object)totalClearLoanAmount);
        AmountChangeUtil.refreshPayAmount((IFormView)view, (IDataModel)model, (String)loanType);
        AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)formPlugin.getControl("totalencashamountlabel")), (String)"encashamount");
        BigDecimal totalOffsetAmount = ReimburseUtils.sumOffsetAmount((IDataModel)model, (IFormView)view);
        model.setValue("totaloffsetamount", (Object)totalOffsetAmount);
    }

    public static void updateTitleAmountTotal(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        List entryEntitys = dataEntity.getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        BigDecimal reimburseAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, (String)"entryamount");
        BigDecimal reimburseAppAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, (String)"entryappamount");
        model.setValue("amount", (Object)reimburseAmountTotal);
        model.setValue("approveamount", (Object)reimburseAppAmountTotal);
    }
}

