/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.common.enums.CreateAssignOtherNoEnum;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import kd.fi.er.formplugin.util.EntryCopyUtil;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseNewSecondViewMobPlugin
extends AbstractMobFormPlugin {
    private static Log logger = LogFactory.getLog(TripReimburseNewSecondViewMobPlugin.class);
    private static final String BAR_SAVE = "bar_save";
    private static String[] fields = new String[]{"trip2from", "trip2to", "trip2startdate", "trip2enddate", "triparea", "daycount", "caldaycount"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_SAVE});
        this.setTravelsF7Filter();
        this.setCostCompanyF7Filter();
        this.setCostCentorF7Filter();
    }

    private void setCostCentorF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("travelcostcenter");
        if (costCenterF7 != null) {
            BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("travelcostcompany");
        Object costDept = this.getModel().getValue("travelcostdept");
        Object company = this.getModel().getValue("company");
        if (costCompanyF7 != null && costDept != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    protected void setTravelsF7Filter() {
        MulBasedataEdit travelersF7 = (MulBasedataEdit)this.getControl("trip2travelers");
        DynamicObject company = (DynamicObject)this.getView().getParentView().getModel().getValue("company");
        DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        TripBillTravelerUtils.getF7FilterInfo((DynamicObject)company, (DynamicObject)org, (BasedataEdit)travelersF7);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initHeadFieldValue();
        this.initEntryData();
        ShowPageUtils.setMobilePageFormStatus((IFormView)this.getView());
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.hideField("comment");
        }
    }

    public void afterBindData(EventObject e) {
        Object costorgusemodeObj;
        super.afterBindData(e);
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        String billStatus = (String)this.getView().getParentView().getModel().getValue("billstatus");
        DynamicObject tripExpenseItem = (DynamicObject)this.getModel().getValue("expenseitem", 0, 0);
        if (StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "D"}) && tripExpenseItem != null && StringUtils.equals((CharSequence)"1", (CharSequence)tripExpenseItem.getString("attribute")) && StringUtils.equals((CharSequence)"1", (CharSequence)tripExpenseItem.getString("ctrltype")) && index != null && (index == -1 || this.getView().getParentView().getModel().getValue("trip2to", index.intValue(), 0) == null) && this.getModel().getValue("orientryamount") != null) {
            this.getModel().beginInit();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Boolean isOpenHighSeasonStd = dataEntity.getBoolean("isopentripstd") && dataEntity.getBoolean("tripstandcon") && dataEntity.getBoolean("isopenhighseasontripstd");
            BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)isOpenHighSeasonStd, (DynamicObject)((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0)));
            this.getModel().setValue("orientryamount", (Object)oriMaxStdAmount, 0);
            this.refreshEntryAmount(this.getModel(), "orientryamount", "entryamount", "exchangerate", 0);
            AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)0, (int)-1, (boolean)false);
            BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", 0, -1);
            OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)0, (int)-1, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0, (String)"orientryappamount");
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        Object company = this.getView().getParentView().getModel().getValue("company");
        if (billStatus != null && StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            this.setCostCompanyEnable(company, 0);
        }
        if (StringUtils.equals((CharSequence)SystemParamterUtil.getTripReimDateSelectRange((Long)ErCommonUtils.getPk((Object)this.getView().getParentView().getModel().getValue("company"))), (CharSequence)"0")) {
            DateEdit tripStartDate = (DateEdit)this.getControl("trip2startdate");
            DateEdit tripEndDate = (DateEdit)this.getControl("trip2enddate");
            LocalDate now = LocalDate.now();
            tripStartDate.setMaxDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
            tripEndDate.setMaxDate(ErCommonUtils.getDateFromLocalDate((LocalDate)now));
        }
        if ((costorgusemodeObj = this.getModel().getValue("costorgusemode")) instanceof String) {
            CardEntry entry;
            String costOrgUseMode = (String)costorgusemodeObj;
            int costCompanyshowType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
            if ((costCompanyshowType == 1 || costCompanyshowType == 3) && (StringUtils.equals((CharSequence)costOrgUseMode, (CharSequence)"1") || StringUtils.equals((CharSequence)costOrgUseMode, (CharSequence)"2")) && (entry = (CardEntry)this.getControl("entryentity")) != null) {
                entry.setChildVisible(false, 0, new String[]{"travelcostcenter"});
            }
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        IDataModel model = this.getModel();
        ErMobWorkFlowOtherViewEditUtils.setWorkFlowEditView((IFormView)this.getView(), (Map)mapCustomParam, (IDataModel)model, (int)3);
    }

    private void setCostCompanyEnable(Object company, int index) {
        String enableCostCompanyEdit = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"enablecostcompanyedit");
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)enableCostCompanyEdit)) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"travelcostcompany"});
        } else {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"travelcostcompany"});
        }
    }

    private void hideField(String fieldName) {
        CardEntry accountCard = (CardEntry)this.getControl("entryentity");
        int accountEntrySize = this.getModel().getEntryRowCount("entryentity");
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            if (!StringUtils.isBlank((CharSequence)((String)this.getModel().getValue(fieldName, rowIndex)))) continue;
            accountCard.setChildVisible(false, rowIndex, new String[]{fieldName});
        }
    }

    protected void initHeadFieldValue() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel pModel = parentView.getModel();
            this.setValue(pModel, "currency", "iscurrency", "company", "org", "billstatus", "isopentripstd", "isopenhighseasontripstd", "tripstandcon", "isnoctrltripvhcctrlv", "istravelers", "ismulwayto", "travelerssamestd", "ismultiexpitem", "costdept", "costcompany", "headhappendate", "headexpenseitem", "itemamountedit", "bizdate", "costorgusemode", "automapinvoice");
        }
    }

    private void setValue(IDataModel pModel, String ... fields) {
        for (String field : fields) {
            if (pModel.getProperty(field) == null) continue;
            this.getModel().setValue(field, pModel.getValue(field));
        }
    }

    protected void initEntryData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer index = (Integer)formShowParameter.getCustomParam("index");
        if (index != null && index != -1) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                this.getModel().beginInit();
                DynamicObjectCollection entryColl = ((DynamicObject)parentView.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
                int newRowIndex = MobileEntryUtil.addEntryToModel(this.getModel(), "entryentity", (DynamicObject)entryColl.get(index.intValue()), true);
                if (this.getModel().getValue("travelcostcompany") == null) {
                    this.getModel().setValue("travelcostcompany", this.getModel().getValue("costcompany"), newRowIndex);
                }
                if (this.getModel().getValue("travelcostdept") == null) {
                    this.getModel().setValue("travelcostdept", this.getModel().getValue("costdept"), newRowIndex);
                }
                if (this.getModel().getValue("travelhappendate") == null) {
                    this.getModel().setValue("travelhappendate", this.getModel().getValue("headhappendate"), newRowIndex);
                }
                if (this.getModel().getValue("travelexpenseitem") == null) {
                    Boolean ismultiexpite = false;
                    if (this.getModel().getProperty("ismultiexpitem") != null) {
                        ismultiexpite = (Boolean)this.getModel().getValue("ismultiexpitem");
                    }
                    if (!ismultiexpite.booleanValue()) {
                        this.getModel().setValue("travelexpenseitem", this.getModel().getValue("headexpenseitem"), newRowIndex);
                    }
                    Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("headexpenseitem")), (DynamicObject)((DynamicObject)this.getModel().getValue("costdept")), (IDataModel)this.getModel());
                    this.getModel().setValue("travelquotactldept", (Object)quotaCtrlDeptId, newRowIndex);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity", newRowIndex);
            }
        } else {
            this.initEntryRow(0);
        }
        if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.fillTripValue();
        }
    }

    private void fillTripValue() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColl) {
                DynamicObject hadValueEntry;
                DynamicObject expenseitem;
                if (!this.bothnull(entry, fields) || (expenseitem = entry.getDynamicObject("expenseitem")) != null && ErTripExpenseItemConstant.Attribute.getOtherLst().contains(expenseitem.get("attribute")) || (hadValueEntry = this.getHadValueEntry(parentView)) == null) continue;
                this.copyvalue(entry, hadValueEntry, fields);
            }
        }
    }

    private boolean bothnull(DynamicObject entry, String ... fields) {
        boolean bothnull = true;
        for (String field : fields) {
            boolean isnull = false;
            Object value = entry.get(field);
            if (value == null) {
                isnull = true;
            } else if (value instanceof Integer && (Integer)value == 0) {
                isnull = true;
            } else if (value instanceof Long && ((Long)value).compareTo(0L) == 0) {
                isnull = true;
            } else if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                isnull = true;
            } else if (value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
                isnull = true;
            }
            bothnull = bothnull && isnull;
        }
        return bothnull;
    }

    private void copyvalue(DynamicObject entry, DynamicObject hadValueEntry, String ... fields) {
        for (String field : fields) {
            entry.set(field, hadValueEntry.get(field));
        }
    }

    protected DynamicObject getHadValueEntry(IFormView parentView) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer index = (Integer)formShowParameter.getCustomParam("index");
        DynamicObjectCollection parentColl = ((DynamicObject)parentView.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        if (index == null || index == -1) {
            index = parentColl.size() - 1;
        }
        for (int i = index.intValue(); i >= 0; --i) {
            DynamicObject entry = (DynamicObject)parentColl.get(i);
            if (entry.getBigDecimal("orientryamount").compareTo(BigDecimal.ZERO) <= 0 || entry.get("trip2enddate") == null || entry.get("trip2to") == null) continue;
            return entry;
        }
        return null;
    }

    private void initEntryRow(int i) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        this.getModel().setValue("entrycurrency", currency == null ? null : currency.getPkValue(), i);
        this.getModel().setValue("exchangerate", (Object)BigDecimal.ONE, i);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("expenseitem", formShowParameter.getCustomParam("tripexpenseitem"), i);
        this.getModel().setValue("travelcostcompany", this.getModel().getValue("costcompany"), i);
        this.getModel().setValue("travelcostdept", this.getModel().getValue("costdept"), i);
        this.getModel().setValue("travelhappendate", this.getModel().getValue("headhappendate"), i);
        this.getModel().setValue("travelexpenseitem", this.getModel().getValue("headexpenseitem"), i);
        Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("headexpenseitem")), (DynamicObject)((DynamicObject)this.getModel().getValue("costdept")), (IDataModel)this.getModel());
        this.getModel().setValue("travelquotactldept", (Object)quotaCtrlDeptId, i);
        DynamicObject expenseItem = (DynamicObject)this.getModel().getValue("expenseitem", i);
        this.refreshTaxOfItem(i, expenseItem);
        this.getModel().setValue("itemfrom", (Object)ItemFrom.Manual.getValue());
        this.initTravels(i);
    }

    protected void initTravels(int rowIndex) {
        Object applier = this.getView().getParentView().getModel().getValue("applier");
        this.getModel().setValue("trip2travelers", (Object)new Long[]{ErCommonUtils.getPk((Object)applier)}, rowIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BAR_SAVE.equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (this.requiredProps(entryEntity)) {
                return;
            }
            IFormView parentView = this.getView().getParentView();
            DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
            DynamicObjectCollection parentEntry = ((DynamicObject)parentDataEntity.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
            FormShowParameter param = this.getView().getFormShowParameter();
            Integer rowIndex = (Integer)param.getCustomParam("index");
            int rowNum = 0;
            if (rowIndex != null && rowIndex != -1) {
                int index;
                rowNum = index = ((Integer)param.getCustomParam("index")).intValue();
                parentView.getModel().setValue("expenseitem", this.getModel().getValue("expenseitem", 0), index, 0);
                parentView.getModel().setValue("trip2startdate", this.getModel().getValue("trip2startdate", 0), index, 0);
                parentView.getModel().setValue("trip2enddate", this.getModel().getValue("trip2enddate", 0), index, 0);
                parentView.getModel().setValue("caldaycount", this.getModel().getValue("caldaycount", 0), index, 0);
                parentView.getModel().setValue("highseasondaycount", this.getModel().getValue("highseasondaycount", 0), index, 0);
                if (index == 0) {
                    parentView.getModel().beginInit();
                    parentView.getModel().setValue("headexpenseitem", this.getModel().getValue("travelexpenseitem", 0), index, 0);
                    parentView.getModel().endInit();
                }
                EntryCopyUtil.copyDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(0)), (DynamicObject)((DynamicObject)parentEntry.get(index)), (Set)Sets.newHashSet((Object[])new String[]{"seq", "expenseitem", "trip2startdate", "trip2enddate", "highseasondaycount", "caldaycount"}));
            } else {
                EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)parentEntry, (DynamicObjectCollection)entryEntity);
                rowIndex = parentEntry.size() - 1;
                ((DynamicObject)parentEntry.get(rowIndex.intValue())).set("seq", (Object)parentEntry.size());
                parentView.getModel().setValue("expenseitem", this.getModel().getValue("expenseitem", 0), rowIndex.intValue(), 0);
                parentView.getModel().setValue("highseasondaycount", this.getModel().getValue("highseasondaycount", 0), rowIndex.intValue(), 0);
                if (rowIndex == 0) {
                    parentView.getModel().beginInit();
                    parentView.getModel().setValue("headexpenseitem", this.getModel().getValue("travelexpenseitem", 0), rowIndex.intValue(), 0);
                    parentView.getModel().endInit();
                }
                rowNum = rowIndex;
            }
            BigDecimal val = (BigDecimal)this.getModel().getValue("exchangerate", 0);
            parentView.getModel().setValue("exchangerate", (Object)val.add(new BigDecimal("0.01")), rowNum, 0);
            parentView.getModel().setValue("exchangerate", (Object)val, rowNum, 0);
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("index", rowIndex);
            this.getView().returnDataToParent((Object)map);
            this.getView().sendFormAction(parentView);
            ActionLocalCache.get().put(CreateAssignOtherNoEnum.TRIPSTD_GRID_MOB.getVal(), (Object)true);
            parentView.updateView();
            this.getView().close();
        }
    }

    private boolean requiredProps(DynamicObjectCollection entrys) {
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
            if (expenseitem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5dee\u65c5\u9879\u76ee\u201d\u3002", (String)"TripReimburseNewSecondViewMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return true;
            }
            DynamicObject bill = this.getModel().getDataEntity();
            Long companyId = (Long)bill.getDynamicObject("company").getPkValue();
            boolean enableTripStandard = SystemParamterUtil.isEnableTripStandard((Long)companyId);
            boolean isVehicle = this.vehicleAttibute(expenseitem);
            boolean isOther = this.otherAttibute(expenseitem);
            if (entry.get("trip2from") == null && isVehicle) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u51fa\u53d1\u5730\u201d\u3002", (String)"TripReimburseNewSecondViewMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (entry.get("trip2to") == null && !isOther) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u76ee\u7684\u5730\u201d\u3002", (String)"TripReimburseNewSecondViewMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!(entry.get("trip2startdate") != null && entry.get("trip2enddate") != null || isOther)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u884c\u7a0b\u671f\u95f4\u201d\u3002", (String)"TripReimburseNewSecondViewMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (entry.get("trip2travelers") != null && ((MulBasedataDynamicObjectCollection)entry.get("trip2travelers")).size() != 0 || isOther) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u51fa\u5dee\u4eba\u201d\u3002", (String)"TripReimburseNewSecondViewMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "trip2travelers": {
                DynamicObjectCollection travelers = (DynamicObjectCollection)valueSet[0].getNewValue();
                model.setValue("trip2travelerscount", (Object)(travelers == null ? 0 : travelers.size()), rowIndex);
                break;
            }
            case "trip2startdate": {
                Date startDate = (Date)valueSet[0].getNewValue();
                Date endDate = (Date)this.getModel().getValue("trip2enddate", rowIndex);
                this.setTripDays(startDate, endDate, rowIndex);
                break;
            }
            case "trip2enddate": {
                Date endDate = (Date)valueSet[0].getNewValue();
                Date startDate = (Date)this.getModel().getValue("trip2startdate", rowIndex);
                this.setTripDays(startDate, endDate, rowIndex);
                break;
            }
            case "airportconstructionfee": 
            case "taxrate": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)true);
                break;
            }
            case "orientryamount": {
                AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)newValue), (String)"entryamount", (String)"exchangerate", (String)"detailquotetype", (int)rowIndex, (int)parentRowIndex);
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentRowIndex);
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0, (String)"orientryappamount");
                break;
            }
            case "exchangerate": {
                this.refreshEntryAmount(model, "orientryamount", "entryamount", "exchangerate", rowIndex);
                break;
            }
            case "taxamount": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false, (String)propName);
                break;
            }
            case "offset": {
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentRowIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0, (String)propName);
                break;
            }
            case "entrycurrency": {
                DynamicObject currency = (DynamicObject)valueSet[0].getNewValue();
                if (currency == null) {
                    model.setValue("entrycurrency", valueSet[0].getOldValue());
                    return;
                }
                Long orcCurrencyId = (Long)currency.getPkValue();
                Object company = this.getView().getParentView().getModel().getValue("company");
                Object costcompany = this.getView().getParentView().getModel().getValue("costcompany");
                Object bizdate = this.getView().getParentView().getModel().getValue("bizdate");
                Map exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costcompany, (Long)orcCurrencyId, (Long)((Long)this.getModel().getValue("currency_Id")), (Object)bizdate);
                String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                model.setValue("detailquotetype", (Object)detailQuoteType);
                model.setValue("exchangerate", (Object)exchangeRate);
                break;
            }
            case "expenseitem": {
                boolean invoiceOffset;
                List invoiceEntry;
                String itemFrom;
                if (valueSet[0].getNewValue() == null) {
                    model.setValue("expenseitem", valueSet[0].getOldValue(), valueSet[0].getRowIndex());
                    break;
                }
                DynamicObject expenseItemDO = (DynamicObject)valueSet[0].getNewValue();
                IFormView parentView = this.getView().getParentView();
                IDataModel parentModel = parentView.getModel();
                DynamicObject parentDataEntity = parentModel.getDataEntity(true);
                DynamicObjectCollection parentEntry = ((DynamicObject)parentDataEntity.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
                FormShowParameter param = this.getView().getFormShowParameter();
                Integer pRowIndex = (Integer)param.getCustomParam("index");
                if (pRowIndex == null || pRowIndex == -1) {
                    pRowIndex = parentEntry.size() - 1;
                }
                if (StringUtils.equals((CharSequence)(itemFrom = valueSet[0].getDataEntity().getString("itemfrom")), (CharSequence)ItemFrom.Manual.getValue())) {
                    this.refreshTaxOfItem(rowIndex, expenseItemDO);
                    break;
                }
                if (!StringUtils.equals((CharSequence)itemFrom, (CharSequence)ItemFrom.InvoiceCloud.getValue())) break;
                IDataModel pModel = this.getView().getParentView().getModel();
                boolean itemOffset = expenseItemDO.getBoolean("isoffset");
                boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)parentView.getModel());
                if (pRowIndex == null || pRowIndex == -1) break;
                DynamicObject itemEntry = (DynamicObject)parentEntry.get(pRowIndex.intValue());
                Long entryId = ErCommonUtils.getPk((Object)itemEntry);
                if (((Boolean)pModel.getValue("automapinvoice")).booleanValue()) {
                    invoiceEntry = InvoiceUtils.getAutoInvoiceItemByItemId((IDataModel)pModel, (Long)entryId);
                    invoiceOffset = InvoiceOffsetUtils.isInvoiceOffset((Collection)invoiceEntry);
                } else {
                    invoiceEntry = InvoiceUtils.getNonAutoInvoiceItemByItemId((IDataModel)pModel, (Long)entryId);
                    invoiceOffset = InvoiceOffsetUtils.isInvoiceOffset((Collection)invoiceEntry);
                }
                invoiceOffset = invoiceOffset && isOrgOffset;
                logger.info("rowIndex:" + rowIndex + ", invoiceOffset:" + invoiceOffset);
                boolean isOffset = itemOffset && invoiceOffset;
                this.getModel().setValue("offset", (Object)isOffset, rowIndex);
                break;
            }
            case "deductibletax": {
                BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex);
                if (OffsetUtils.checkDeductibletax((BigDecimal)taxAmount, (BigDecimal)((BigDecimal)newValue))) break;
                this.getModel().setValue("deductibletax", oldValue, rowIndex);
            }
        }
    }

    private void refreshTaxOfItem(int rowIndex, DynamicObject expenseItemDO) {
        IDataModel model = this.getModel();
        if (this.getView() == null) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)parentModel);
        Long companyId = ErCommonUtils.getPk((Object)parentModel.getValue("company"));
        BigDecimal taxRate = expenseItemDO.getBigDecimal("taxrate");
        boolean itemOffset = expenseItemDO.getBoolean("isoffset");
        model.setValue("taxrate", (Object)taxRate, rowIndex);
        Boolean offsetOfExpense = SystemParamterUtil.manuallyaddexpenseoffset((Long)companyId);
        offsetOfExpense = offsetOfExpense != false && isOrgOffset;
        if (offsetOfExpense.booleanValue()) {
            model.setValue("offset", (Object)itemOffset, rowIndex);
        } else {
            model.setValue("offset", (Object)Boolean.FALSE, rowIndex);
        }
    }

    protected void setTripDays(Date startDate, Date endDate, int rowIndex) {
        this.getModel().setValue("daycount", (Object)CommonServiceHelper.calcDays((Date)startDate, (Date)endDate), rowIndex, 0);
    }

    private void refreshEntryAmount(IDataModel model, String oriAmountField, String amountField, String exchangeRateField, int index) {
        BigDecimal oriAmount = (BigDecimal)model.getValue(oriAmountField);
        BigDecimal exchangeRate = (BigDecimal)model.getValue(exchangeRateField);
        if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        String detailquotetype = (String)model.getValue("detailquotetype", index);
        BigDecimal amount = BigDecimal.ZERO;
        amount = "0".equals(detailquotetype) ? oriAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), 5) : oriAmount.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), 5);
        model.setValue(amountField, (Object)amount, index);
    }

    private boolean vehicleAttibute(DynamicObject expenseitem) {
        return ErTripExpenseItemConstant.Attribute.getVehicleLst().contains(expenseitem.get("attribute"));
    }

    protected boolean otherAttibute(DynamicObject expenseitem) {
        return ErTripExpenseItemConstant.Attribute.getOtherLst().contains(expenseitem.get("attribute"));
    }

    protected boolean subsidyAttribute(DynamicObject expenseitem) {
        return ErTripExpenseItemConstant.Attribute.getSubsidyLst().contains(expenseitem.get("attribute"));
    }
}

