/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.dao.factory.ErTripReqBillDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.CarTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class TripReqSelectPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static Log logger = LogFactory.getLog(TripReqSelectPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.showData();
    }

    private void showData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List bills = (List)parameter.getCustomParams().get("bills");
        if (bills == null) {
            logger.info("bills is null");
            return;
        }
        if (bills.isEmpty()) {
            logger.info("bills is empty");
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int size = bills.size();
        model.batchCreateNewEntryRow("entryentity", size);
        for (int idx = 0; idx < size; ++idx) {
            model.setValue("billid", ((Map)bills.get(idx)).get("id"), idx);
            model.setValue("billNo", ((Map)bills.get(idx)).get("billNo"), idx);
            model.setValue("title", ((Map)bills.get(idx)).get("title"), idx);
            model.setValue("info", ((Map)bills.get(idx)).get("info"), idx);
            model.setValue("infol", (Object)TripCommonUtil.convertToDate((String)((Map)bills.get(idx)).get("infol").toString()), idx);
            model.setValue("fromCity", ((Map)bills.get(idx)).get("fromCity"), idx);
            model.setValue("toCity", ((Map)bills.get(idx)).get("toCity"), idx);
            model.setValue("fromDate", ((Map)bills.get(idx)).get("fromDate"), idx);
            model.setValue("fromDatel", ((Map)bills.get(idx)).get("fromDatel"), idx);
            model.setValue("toDate", ((Map)bills.get(idx)).get("toDate"), idx);
            model.setValue("toDatel", ((Map)bills.get(idx)).get("toDatel"), idx);
        }
    }

    public static List<Map<String, Object>> getData(String number) {
        return TripReqSelectPlugin.getData(number, false);
    }

    public static List<Map<String, Object>> getData() {
        QFilter qFilter = TripReqSelectPlugin.getFilter("");
        DynamicObject[] queryDatas = ErTripReqBillDaoFactory.getInstance().query(qFilter, "rstartdate desc");
        logger.info("TripReqSelectPlugin getFilter query value is:" + qFilter.toString());
        if (queryDatas == null || queryDatas.length == 0) {
            return new ArrayList<Map<String, Object>>(2);
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(queryDatas.length);
        int len = queryDatas.length;
        for (int i = 0; i < len; ++i) {
            DynamicObjectCollection tripentrys;
            HashMap<String, Object> m = new HashMap<String, Object>(8);
            DynamicObject queryData = queryDatas[i];
            Long applierIdId = queryData.getDynamicObject("applier").getLong("id");
            Boolean isNoApprovabook = CommonServiceHelper.noApprovaWhiteList((Long)applierIdId, (String)"1");
            if (!isNoApprovabook.booleanValue() && "B".equals(queryData.getString("billstatus"))) continue;
            m.put("id", queryData.get("id"));
            m.put("billNo", queryData.get("billNo"));
            m.put("title", queryData.get("description"));
            Date rstartdate = queryData.getDate("rstartdate");
            logger.info("TripReqSelectPlugin queryid:" + queryData.get("id") + "--querybillno:" + queryData.get("billNo") + "startDate value is:" + rstartdate + "startDate value is togetString:" + queryData.get("rstartdate"));
            SimpleDateFormat df = new SimpleDateFormat("MM-dd");
            if (rstartdate != null) {
                String format = df.format(rstartdate);
                m.put("info", format);
                m.put("fromDate", format);
                m.put("fromDatel", rstartdate);
            }
            m.put("fromCity", queryData.getString("rfrom"));
            m.put("toCity", queryData.getString("rfirstto"));
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date rfirstenddate = queryData.getDate("rfirstenddate");
            if (rfirstenddate == null && (tripentrys = queryData.getDynamicObjectCollection("tripentry")) != null && !tripentrys.isEmpty()) {
                DynamicObject tripentry = (DynamicObject)tripentrys.get(0);
                rfirstenddate = tripentry.getDate("enddate");
                queryData.set("rfirstenddate", (Object)rfirstenddate);
            }
            m.put("toDate", df.format(rfirstenddate));
            m.put("toDatel", rfirstenddate);
            ret.add(m);
        }
        return ret;
    }

    private static QFilter getFilter() {
        Object[] paramObj1 = new Object[]{"B", "E"};
        QFilter qFilter = QFilter.of((String)"(billstatus=? or billstatus=?)", (Object[])paramObj1);
        qFilter = qFilter.and("isloan", "=", (Object)Boolean.FALSE);
        return qFilter;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataModel model = ((CardEntry)evt.getSource()).getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String key = (String)parameter.getCustomParams().get("key");
        Long billId = Long.valueOf((String)model.getValue("billid"));
        Map paraMap = TripCommonUtil.getBusinessSectionInfo((Long)billId);
        paraMap.put("key", key);
        paraMap.put("isPC", Boolean.FALSE);
        paraMap.put("formId", "er_externalsystem");
        paraMap.put("formName", ResManager.loadKDString((String)"\u5546\u65c5", (String)"TripReqSelectPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        paraMap.put("formType", "5");
        TripCommonUtil.openTripPage((IFormView)this.getView(), (Map)paraMap);
    }

    public static List<Map<String, Object>> getData(String number, boolean isCar) {
        QFilter qFilter = TripReqSelectPlugin.getFilter(number);
        DynamicObject[] queryDatas = ErTripReqBillDaoFactory.getInstance().query(qFilter, "rstartdate desc");
        logger.info("TripReqSelectPlugin getFilter query value is:" + qFilter.toString());
        if (queryDatas == null || queryDatas.length == 0) {
            return new ArrayList<Map<String, Object>>(2);
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(queryDatas.length);
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("vehicletype", "=", (Object)CarTypeEnum.TRAVEL.getCode());
        QFilter qC = new QFilter("server", "=", (Object)number);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype,datenum", (QFilter[])new QFilter[]{qA, qB, qC});
        int len = queryDatas.length;
        for (int i = 0; i < len; ++i) {
            Long applierId;
            Boolean isNoApprovabook;
            HashMap<String, Object> m = new HashMap<String, Object>(8);
            DynamicObject queryData = queryDatas[i];
            DynamicObject applier = queryData.getDynamicObject("applier");
            if (applier == null || !(isNoApprovabook = Boolean.valueOf(CommonServiceHelper.noApprovaWhiteList((Long)(applierId = Long.valueOf(applier.getLong("id"))), (String)"1"))).booleanValue() && "B".equals(queryData.getString("billstatus"))) continue;
            m.put("id", queryData.get("id"));
            m.put("billNo", queryData.get("billNo"));
            m.put("title", queryData.get("description"));
            Date rstartdate = queryData.getDate("rstartdate");
            logger.info("TripReqSelectPlugin queryid:" + queryData.get("id") + "--querybillno:" + queryData.get("billNo") + "startDate value is:" + rstartdate + "startDate value is togetString:" + queryData.get("rstartdate"));
            SimpleDateFormat df = new SimpleDateFormat("MM-dd");
            if (rstartdate != null) {
                String format = df.format(rstartdate);
                m.put("info", format);
                m.put("infol", rstartdate);
                m.put("fromDate", format);
                m.put("fromDatel", rstartdate);
            }
            m.put("fromCity", queryData.getString("rfrom"));
            m.put("toCity", queryData.getString("rfirstto"));
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date rfirstenddate = queryData.getDate("rfirstenddate");
            DynamicObjectCollection tripentrys = queryData.getDynamicObjectCollection("tripentry");
            List<Object> dates = new ArrayList(tripentrys.size() * 2);
            if (!tripentrys.isEmpty()) {
                dates = tripentrys.stream().map(v -> v.getDate("startdate")).collect(Collectors.toList());
                dates.addAll(tripentrys.stream().map(v -> v.getDate("enddate")).collect(Collectors.toList()));
                if (rfirstenddate == null) {
                    DynamicObject tripentry = (DynamicObject)tripentrys.get(0);
                    rfirstenddate = tripentry.getDate("enddate");
                    queryData.set("rfirstenddate", (Object)rfirstenddate);
                }
            }
            if (isCar) {
                if (null != dynamicObject && null != dynamicObject.get("datenum")) {
                    int datenum = dynamicObject.getInt("datenum");
                    Date date = new Date();
                    Date sdate = TripCommonUtil.addDayByDate((Date)((Date)Collections.min(dates)), (int)(-datenum));
                    Date edate = TripCommonUtil.addDayByDate((Date)((Date)Collections.max(dates)), (int)datenum);
                    try {
                        date = df.parse(df.format(date));
                        sdate = df.parse(df.format(sdate));
                        edate = df.parse(df.format(edate));
                    }
                    catch (ParseException e) {
                        logger.info("\u89e3\u6790\u65f6\u95f4\u9519\u8bef" + e.getMessage());
                    }
                    if (sdate.getTime() > date.getTime() || edate.getTime() < date.getTime()) {
                        logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u9009\u62e9\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u65f6\u95f4\u4e0d\u5728\u5728\u9009\u62e9\u8303\u56f4\u5185\uff1a{} {},dates:{}", new Object[]{sdate, edate, dates});
                        continue;
                    }
                }
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u9009\u62e9\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u65f6\u95f4\u5728\u9009\u62e9\u8303\u56f4\u5185\uff1adates:{}", dates);
            }
            if (null != rfirstenddate) {
                m.put("toDate", df.format(rfirstenddate));
                m.put("toDatel", rfirstenddate);
            }
            ret.add(m);
        }
        return ret;
    }

    private static QFilter getFilter(String serverNum) {
        Object[] paramObj;
        QFilter qFilter = TripReqSelectPlugin.getFilter();
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        boolean paramValue = TripSyncConfigUtil.getBoolean((String)"Reservation_ personnel_range");
        String queryStr = "";
        if (paramValue) {
            DynamicObjectCollection reqBillIds = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("projectower.fbasedataid", "=", (Object)userId)});
            DynamicObjectCollection reqBillIdArr = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("multitravelers.fbasedataid", "=", (Object)userId)});
            HashSet<Long> billIds = new HashSet<Long>(reqBillIds.size() + reqBillIdArr.size());
            for (DynamicObject reqBillId : reqBillIds) {
                billIds.add((Long)reqBillId.get("id"));
            }
            for (DynamicObject reqBillId : reqBillIdArr) {
                billIds.add((Long)reqBillId.get("id"));
            }
            if (CollectionUtils.isNotEmpty(billIds)) {
                queryStr = "id in (" + StringUtils.join(billIds, (String)",") + ")";
            }
        }
        if (Supplier.XIECHENG.name().equals(serverNum)) {
            boolean isdoc = TripSyncConfigUtil.getBoolean((String)"ctrip_reqbill_DocumentMaker");
            if (isdoc) {
                paramObj = new Object[]{"er_tripreqbill", userId, userId};
                qFilter = StringUtils.isEmpty((CharSequence)queryStr) ? qFilter.and(QFilter.of((String)"formid=? and (applier=? or creator=?)", (Object[])paramObj)) : qFilter.and(QFilter.of((String)("formid=? and (applier=? or creator=? or " + queryStr + ")"), (Object[])paramObj));
            } else {
                paramObj = new Object[]{"er_tripreqbill", userId};
                qFilter = StringUtils.isEmpty((CharSequence)queryStr) ? qFilter.and(QFilter.of((String)"formid=? and (applier=? )", (Object[])paramObj)) : qFilter.and(QFilter.of((String)("formid=? and (applier=? or " + queryStr + ")"), (Object[])paramObj));
            }
        } else if (Supplier.CHAILVYIHAO.name().equals(serverNum)) {
            paramObj = new Object[]{"er_tripreqbill", userId, userId};
            qFilter = StringUtils.isEmpty((CharSequence)queryStr) ? qFilter.and(QFilter.of((String)"formid=? and (applier=? or creator=?)", (Object[])paramObj)) : qFilter.and(QFilter.of((String)("formid=? and (applier=? or creator=? or " + queryStr + ")"), (Object[])paramObj));
        } else {
            paramObj = new Object[]{"er_tripreqbill", userId};
            qFilter = StringUtils.isEmpty((CharSequence)queryStr) ? qFilter.and(QFilter.of((String)"formid=? and (applier=? )", (Object[])paramObj)) : qFilter.and(QFilter.of((String)("formid=? and (applier=? or " + queryStr + ")"), (Object[])paramObj));
        }
        return qFilter;
    }
}

