/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.externalsystem.Base64UrlParameters;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang.StringUtils;

public class TripTimeLineMobileEdit
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(TripTimeLineMobileEdit.class);
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();
    protected static final Map<String, MainPageModel> dailyControlMap = new HashMap<String, MainPageModel>();

    public void initialize() {
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
        IFormView view = this.getView();
        Long currentUser = this.getCurrentUser();
        if (this.getTripReqBillCount(currentUser) > 0) {
            view.setVisible(Boolean.valueOf(false), new String[]{"norecordflex"});
            view.setVisible(Boolean.valueOf(true), new String[]{"timelineflex"});
            this.setHtmlContent(currentUser);
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"timelineflex"});
            view.setVisible(Boolean.valueOf(true), new String[]{"norecordflex"});
        }
    }

    private void setHtmlContent(Long currentUser) {
        RequestContext requestContext = RequestContext.get();
        String clientFullContextPath = requestContext.getClientFullContextPath();
        String base64_host_url = new Base64UrlParameters().encodeUrl(clientFullContextPath);
        String url = clientFullContextPath + "timeline/timeline.html?name=" + currentUser + "&hosturl=" + base64_host_url;
        String contentStr = this.getContentStr(url);
        Html htmlap = (Html)this.getControl("htmlap");
        htmlap.setConent(contentStr);
    }

    public void click(EventObject evt) {
        FormModel formModel = null;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean result = this.isDailyExpense(this.getView());
        MainPageModel mainPageModel = null;
        mainPageModel = result ? dailyControlMap.get(key) : controlMap.get(key);
        if (mainPageModel != null) {
            formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue(), mainPageModel.getCustomParam());
        }
        if (formModel == null) {
            return;
        }
        ShowPageUtils.showPage(formModel, (AbstractFormPlugin)this);
    }

    private boolean isDailyExpense(IFormView formView) {
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((String)parentView.getEntityId(), (String)"er_mainpage_daily")) {
            return true;
        }
        return this.isDailyExpense(parentView);
    }

    private String getContentStr(String url) {
        String resultStr = "<div style='width:100%;height:auto; overflow: scroll; -webkit-overflow-scrolling: touch;'><iframe name='iframe1' id='iframe1' style='width:100%;height:100%;border:none;' src='" + url + "' ></iframe></div>";
        return resultStr;
    }

    private Long getCurrentUser() throws NumberFormatException {
        RequestContext requestContext = RequestContext.get();
        return Long.valueOf(requestContext.getUserId());
    }

    private int getTripReqBillCount(Long currentUser) {
        int result = 0;
        try {
            IErDao erDao = ErDaoFactory.getInstance((String)"er_tripreqbill");
            QFilter[] qFilters = new QFilter[]{new QFilter("applier_Id", "=", (Object)currentUser), new QFilter("billstatus", "in", (Object)new String[]{"E", "F", "G", "I"})};
            DynamicObject[] dynamicObjects = erDao.query(qFilters);
            result = dynamicObjects.length;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u51fa\u5dee\u7533\u8bf7\u5355\u9519\u8bef\uff1a%s", (String)"TripTimeLineMobileEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (("er_addNew_dialog".equalsIgnoreCase(actionId) || "er_addNew_dialog_daily".equalsIgnoreCase(actionId)) && e.getReturnData() != null) {
            FormModel formModel = (FormModel)e.getReturnData();
            if (formModel == null) {
                return;
            }
            String formId = formModel.getFormId();
            if (StringUtils.isEmpty((String)formId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripTimeLineMobileEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter viewFormShowParameter = this.getView().getFormShowParameter();
            viewFormShowParameter.setAppId("18XD+/5EDN8X");
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        }
    }

    static {
        controlMap.put("buttonswitch", new MainPageModel("er_trip_report", ResManager.loadKDString((String)"\u8db3\u8ff9", (String)"TripTimeLineMobileEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("buttonshare", new MainPageModel("er_tripshare", ResManager.loadKDString((String)"\u5206\u4eab", (String)"TripTimeLineMobileEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "13"));
        controlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TripTimeLineMobileEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
        dailyControlMap.put("buttonswitch", new MainPageModel("er_trip_report", ResManager.loadKDString((String)"\u8db3\u8ff9", (String)"TripTimeLineMobileEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        dailyControlMap.put("buttonshare", new MainPageModel("er_tripshare", ResManager.loadKDString((String)"\u5206\u4eab", (String)"TripTimeLineMobileEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "13"));
        dailyControlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog_daily", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TripTimeLineMobileEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
    }
}

