/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.overtime.TripOrderBillOvertimeHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;

public class UnComfrimOrdersList
extends AbstractMobFormPlugin
implements RowClickEventListener,
TabSelectListener {
    private static Log logger = LogFactory.getLog(UnComfrimOrdersList.class);
    protected static final String OVERDUE_TAB = "overduetab";
    protected static final String TODOTAB = "todotab";
    protected static final String DIDTAB = "didtab";
    protected Set<String> overdueOaBillNumSet = new HashSet<String>();
    protected Set<String> unReimburseOaBillNumSet = new HashSet<String>();
    protected Set<String> reimburseOaBillNumSet = new HashSet<String>();

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl("TabAp");
        tab.addTabSelectListener((TabSelectListener)this);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("unconfrimentity");
        grid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"labelap_view", "labelap_reimburse"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Tab tab = (Tab)this.getControl("TabAp");
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map.size() == 0 || map.get("isOverdue") != null) {
            this.initDefault(this.overdueOaBillNumSet, false);
        } else {
            tab.activeTab(TODOTAB);
        }
    }

    private void initIsReimburseReqBillNo() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map.size() == 0 || map.get("isRealTime") == null) {
            return;
        }
        Long userId = CommonServiceHelper.getCurrentUserID();
        DynamicObjectCollection allOrderObjs = CommonServiceHelper.getTripOrderObj((Long)userId, (String)"er_allorderbill");
        List<DynamicObject> tripPlaneOrderObjs = allOrderObjs.stream().filter(allOrderObj -> allOrderObj.getString("orderformid").equalsIgnoreCase("er_planebill")).collect(Collectors.toList());
        List<DynamicObject> tripHotelOrderObjs = allOrderObjs.stream().filter(allOrderObj -> allOrderObj.getString("orderformid").equalsIgnoreCase("er_hotelbill")).collect(Collectors.toList());
        List<DynamicObject> carOrderObjs = allOrderObjs.stream().filter(allOrderObj -> allOrderObj.getString("orderformid").equalsIgnoreCase("er_vehiclebill")).collect(Collectors.toList());
        this.geReimburseOaBillNumberSet(tripPlaneOrderObjs);
        this.geReimburseOaBillNumberSet(tripHotelOrderObjs);
        this.geReimburseOaBillNumberSet(carOrderObjs);
        List overtimeOrderBills = new TripOrderBillOvertimeHelper().getOrderToRemind(userId.longValue());
        this.overdueOaBillNumSet.addAll(overtimeOrderBills.stream().map(v -> v.getString("oabillnum")).collect(Collectors.toSet()));
    }

    private void geReimburseOaBillNumberSet(List<DynamicObject> tripOrderObjs) {
        if (tripOrderObjs != null && tripOrderObjs.size() > 0) {
            for (DynamicObject tripOrderObj : tripOrderObjs) {
                String oaBillNum;
                boolean isReimburse = tripOrderObj.getBoolean("isReimburse");
                if (!isReimburse && tripOrderObj.getBigDecimal("totalamount") != null && tripOrderObj.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) != 0) {
                    oaBillNum = tripOrderObj.getString("oaBillNum");
                    this.unReimburseOaBillNumSet.add(oaBillNum);
                    continue;
                }
                oaBillNum = tripOrderObj.getString("oaBillNum");
                this.reimburseOaBillNumSet.add(oaBillNum);
            }
        }
    }

    private void fillEntryEntityData(IDataModel model, Set<String> OaBillNumSet, boolean isReimburse) {
        if (OaBillNumSet.size() > 0) {
            DynamicObject[] reqTripInfos;
            logger.info("\u8fdb\u5165\u9875\u7b7e:fillEntryEntityData0:" + System.currentTimeMillis());
            model.beginInit();
            DynamicObject[] orderCols = CommonServiceHelper.getTripOrderByNumber(OaBillNumSet, (boolean)isReimburse);
            Map<String, List<DynamicObject>> oaBillMap = Arrays.stream(orderCols).collect(Collectors.groupingBy(d -> d.getString("oabillnum")));
            model.batchCreateNewEntryRow("unconfrimentity", OaBillNumSet.size());
            logger.info("\u8fdb\u5165\u9875\u7b7e:fillEntryEntityData2:" + System.currentTimeMillis());
            int rowIndex = 0;
            IErDao tripDao = ErDaoFactory.getInstance((String)"er_tripreqbill");
            for (DynamicObject reqTripInfo : reqTripInfos = tripDao.query("id,description,currency,applier,bizdate,amount,billno", new QFilter("billno", "in", OaBillNumSet))) {
                List<DynamicObject> oaBillOrderList;
                if (reqTripInfo == null) continue;
                Long reqTripId = (Long)reqTripInfo.getPkValue();
                String description = reqTripInfo.getString("description");
                DynamicObject currency = reqTripInfo.getDynamicObject("currency");
                DynamicObject applier = reqTripInfo.getDynamicObject("applier");
                Date bizdate = reqTripInfo.getDate("bizdate");
                String billNo = reqTripInfo.getString("billno");
                model.setValue("reqtripid", (Object)reqTripId, rowIndex);
                model.setValue("description", (Object)description, rowIndex);
                model.setValue("applier", (Object)ErCommonUtils.getPk((Object)applier), rowIndex);
                model.setValue("currency", (Object)ErCommonUtils.getPk((Object)currency), rowIndex);
                model.setValue("bizdate", (Object)bizdate, rowIndex);
                model.setValue("isreimburse", (Object)isReimburse, rowIndex);
                int planeCount = 0;
                int hotelCount = 0;
                int carCount = 0;
                BigDecimal amount = BigDecimal.ZERO;
                if (oaBillMap != null && oaBillMap.size() > 0 && (oaBillOrderList = oaBillMap.get(billNo)) != null && oaBillOrderList.size() > 0) {
                    block11: for (int i = 0; i < oaBillOrderList.size(); ++i) {
                        String orderformid;
                        DynamicObject oaBillOrder = oaBillOrderList.get(i);
                        BigDecimal totalamount = oaBillOrder.getBigDecimal("totalamount");
                        amount = amount.add(totalamount);
                        switch (orderformid = oaBillOrder.getString("orderformid")) {
                            case "er_planebill": {
                                ++planeCount;
                                continue block11;
                            }
                            case "er_hotelbill": {
                                ++hotelCount;
                                continue block11;
                            }
                            case "er_vehiclebill": {
                                ++carCount;
                            }
                        }
                    }
                }
                model.setValue("plane_count", (Object)planeCount, rowIndex);
                model.setValue("hotel_count", (Object)hotelCount, rowIndex);
                model.setValue("car_count", (Object)carCount, rowIndex);
                model.setValue("billNo", (Object)billNo, rowIndex);
                model.setValue("amount", (Object)amount, rowIndex);
                ++rowIndex;
            }
        }
        model.endInit();
        this.getView().updateView("unconfrimentity");
        logger.info("\u8fdb\u5165\u9875\u7b7e:fillEntryEntityData1:" + System.currentTimeMillis());
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        IDataModel model = this.getModel();
        model.deleteEntryData("unconfrimentity");
        this.getView().updateView("unconfrimentity");
        switch (tabKey) {
            case "overduetab": {
                this.initDefault(this.overdueOaBillNumSet, false);
                break;
            }
            case "todotab": {
                this.initDefault(this.unReimburseOaBillNumSet, false);
                break;
            }
            case "didtab": {
                this.initDefault(this.reimburseOaBillNumSet, true);
            }
        }
    }

    private void initDefault(Set<String> oaBillNumSet, boolean isReimburse) {
        logger.info("\u8fdb\u5165\u9875\u7b7e:initDefault\u5f00\u59cb:" + System.currentTimeMillis());
        this.initIsReimburseReqBillNo();
        if (oaBillNumSet.size() > 0) {
            this.fillEntryEntityData(this.getModel(), oaBillNumSet, isReimburse);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexinfo"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"unconfrimentity"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexinfo"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unconfrimentity"});
        }
        logger.info("\u8fdb\u5165\u9875\u7b7e:initDefault\u7ed3\u675f:" + System.currentTimeMillis());
    }

    public void entryRowClick(RowClickEvent rowClickEvent) {
        this.ChoooseEntryRow();
    }

    private void ChoooseEntryRow() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("unconfrimentity");
        int index = grid.getEntryState().getFocusRow();
        DynamicObject selectEntry = this.getModel().getEntryRowEntity("unconfrimentity", index);
        if (selectEntry == null) {
            return;
        }
        String description = selectEntry.getString("description");
        DynamicObject applier = selectEntry.getDynamicObject("applier");
        boolean isReimburse = selectEntry.getBoolean("isReimburse");
        long applierId = 0L;
        if (applier != null) {
            applierId = (Long)applier.getPkValue();
        }
        String billNo = selectEntry.getString("billno");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_unconfirmbillinfo");
        if (isReimburse) {
            paramMap.put("formName", ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u8ba2\u5355", (String)"UnComfrimOrdersList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            paramMap.put("formName", ResManager.loadKDString((String)"\u5f85\u62a5\u9500\u8ba2\u5355", (String)"UnComfrimOrdersList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        paramMap.put("formType", "5");
        paramMap.put("needCallBack", Boolean.TRUE);
        HashMap<String, Object> mapCustomParam = new HashMap<String, Object>();
        mapCustomParam.put("billNo", billNo);
        mapCustomParam.put("currencyId", String.valueOf("01"));
        mapCustomParam.put("applierId", String.valueOf(applierId));
        mapCustomParam.put("description", description);
        mapCustomParam.put("isReimburse", isReimburse);
        paramMap.put("customParam", mapCustomParam);
        ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
    }
}

