/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.ConvertReport;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class UnConfimOrderInfo
extends AbstractMobFormPlugin {
    private static final Log logger = LogFactory.getLog(UnConfimOrderInfo.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btn_reimburse", "btn_later"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        if (mapCustomParam.size() == 0 || mapCustomParam.get("isReimburse") == null || mapCustomParam.get("billNo") == null || mapCustomParam.get("applierId") == null || mapCustomParam.get("description") == null) {
            return;
        }
        String billNo = (String)mapCustomParam.get("billNo");
        String applierId = (String)mapCustomParam.get("applierId");
        String currencyId = (String)mapCustomParam.get("currencyId");
        String description = (String)mapCustomParam.get("description");
        boolean isReimburse = (Boolean)mapCustomParam.get("isReimburse");
        Map billMap = CoreBaseBillServiceHelper.createNewData((Long)Long.valueOf(applierId));
        IDataModel model = this.getModel();
        model.setValue("isreimburse", (Object)isReimburse);
        model.setValue("applier", (Object)Long.valueOf(applierId));
        model.setValue("billno", (Object)billNo);
        model.setValue("description", (Object)description);
        model.setValue("costcompany", (Object)ErCommonUtils.getPk(billMap.get("costcompany")));
        model.setValue("costdept", (Object)ErCommonUtils.getPk(billMap.get("costdept")));
        this.initOrderFormPage(billNo, Long.valueOf(currencyId), isReimburse);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        source.getView().getFormShowParameter().setAppId("tra");
        switch (key) {
            case "btn_reimburse": {
                String billNo = (String)this.getModel().getValue("billno");
                if (StringUtils.isBlank((CharSequence)billNo.trim())) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u624b\u52a8\u5173\u8054\u7533\u8bf7\u5355\u540e\u518d\u8fdb\u884c\u62a5\u9500\u3002", (String)"UnConfimOrderInfo_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject tripreqbillInfo = BusinessDataServiceHelper.loadSingle((String)"er_tripreqbill", (String)"billno,company,isloan,istravelers,tripentry.id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
                if (BillRelateUtils.existReimburse((DynamicObject)tripreqbillInfo, (IFormView)this.getView())) {
                    evt.setCancel(true);
                    return;
                }
                ArrayList<DynamicObject> reqBillList = new ArrayList<DynamicObject>();
                reqBillList.add(tripreqbillInfo);
                String warningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStrByReq(reqBillList);
                if (!StringUtils.isNotBlank((CharSequence)warningStr)) break;
                evt.setCancel(true);
                this.getView().showTipNotification(warningStr);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "btn_later": {
                this.getView().close();
                break;
            }
            case "btn_reimburse": {
                String billNo = (String)model.getValue("billno");
                CommonServiceHelper.changeReqBillInfo((IDataModel)model, (String)billNo);
                IErDao dao = ErDaoFactory.getInstance((String)"er_tripreqbill");
                DynamicObject Obj = dao.queryOne("id", new QFilter("billno", "=", (Object)billNo));
                Long billId = Obj.getLong("id");
                ListSelectedRow listSelectedRow = new ListSelectedRow((Object)billId);
                this.doPush(listSelectedRow);
            }
        }
    }

    private void doPush(ListSelectedRow listSelectedRow) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("er_tripreqbill");
        pushArgs.setTargetEntityNumber("er_tripreimbursebill");
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        list.add(listSelectedRow);
        pushArgs.setSelectedRows(list);
        pushArgs.setBuildConvReport(true);
        Push.addPushByBillOption((IFormView)this.getView(), (AbstractConvertServiceArgs)pushArgs);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (convertResult.isSuccess() && convertResult.getCachePageIds().size() != 0) {
            if (convertResult.getCachePageIds().size() == 1) {
                this.showTargetBill(this.getView(), listSelectedRow, convertResult, false);
            } else {
                if (this.getView() instanceof MobileBillView) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u4e00\u6b21\u4e0b\u63a8\u751f\u6210\u591a\u5f20\u76ee\u6807\u5355\uff0c\u8bf7\u5230PC\u7aef\u64cd\u4f5c\u3002", (String)"UnConfimOrderInfo_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
            }
        } else {
            if (this.getView() instanceof MobileListView) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884cpush\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u6267\u884c\u6761\u4ef6\u6210\u7acb\uff01", (String)"UnConfimOrderInfo_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getView() instanceof MobileFormView) {
                List reports = convertResult.getReports();
                if (reports.size() > 0) {
                    logger.info("reports.size()" + ((ConvertReport)reports.get(0)).getMessage());
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u5931\u8d25: %s", (String)"UnConfimOrderInfo_3", (String)"fi-er-formplugin", (Object[])new Object[0]), ((ConvertReport)reports.get(0)).getFailMessage()));
                    return;
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u5931\u8d25: %s", (String)"UnConfimOrderInfo_3", (String)"fi-er-formplugin", (Object[])new Object[0]), convertResult.getMessage()));
                return;
            }
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertResult);
        }
    }

    private void showTargetBill(IFormView view, ListSelectedRow listSelectedRow, ConvertOperationResult convertResult, boolean showReport) {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((String)convertResult.getSourceEntityNumber(), (String)"company", (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue())});
        DynamicObject company = sourceBill.getDynamicObject("company");
        String formId = !StringUtils.equalsIgnoreCase((CharSequence)"card", (CharSequence)SystemParamterUtil.getTripReimburseType((Long)ErCommonUtils.getPk((Object)company))) ? "er_tripreim_grid_mb" : "er_tripreimbursebill_mob";
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId("18XD+/5EDN8X");
        showParameter.setHasRight(true);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
        showParameter.getCustomParams().put("showreport", String.valueOf(showReport));
        ((BillShowParameter)showParameter).setCachePageId((String)convertResult.getCachePageIds().get(0));
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("ConvertOperationResult", resultJson);
        view.showForm((FormShowParameter)showParameter);
    }

    private void initOrderFormPage(String oaBillNum, Long currencyId, boolean isReimburse) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("er_triporderinfo_m");
        showParameter.setParentFormId("er_unconfirmbillinfo");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flex_triporder");
        showParameter.setStatus(OperationStatus.VIEW);
        HashMap<String, Object> orderInfoMap = new HashMap<String, Object>();
        orderInfoMap.put("billNo", oaBillNum);
        orderInfoMap.put("currencyId", currencyId);
        orderInfoMap.put("isReimburse", isReimburse);
        showParameter.setCustomParams(orderInfoMap);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

