/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile.tripstandard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceProxy;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.common.type.SubsidiesDayParamEnum;
import kd.fi.er.formplugin.web.tripstandard.BeforeMulSeatgradeF7SelectListener;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class TripDetailStdCtrlForCardStylePlugin
extends AbstractMobBillPlugIn {
    protected static final String TRIPSTD_SHOWSTR = "tripstdshowstr";
    protected static final String HIGH_SEASON_TRIPSTD_SHOWSTR = "highseasontripstdshow";
    protected static final String TRIPEXP_ATTRIBUTE = "attribute";
    private static String EXPENSE_ITEM_SUBSIDY = "1";
    protected static final String EXPENSE_ITEM_ACCOMMODATION = "5";
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};
    protected static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "imagestddesc"});
        BasedataEdit mulSeatGrade = (BasedataEdit)this.getView().getControl("mulseatgrade");
        if (mulSeatGrade != null) {
            mulSeatGrade.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeMulSeatgradeF7SelectListener(null, "expenseitem"));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObject dataEntity;
        ControlMethodEnum ctrlMethod;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        boolean isCancer = false;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btn_save") && (ctrlMethod = ControlMethodEnum.getContrlMethodEnumByValue((String)(dataEntity = this.getModel().getDataEntity()).getString("controlmethod"))) != null && dataEntity.getBoolean("isopentripstd") && "1".equals(dataEntity.getString("isover"))) {
            DynamicObject tripExpItem = dataEntity.getDynamicObject("expenseitem");
            switch (ctrlMethod) {
                case STRICT_CONTROL: {
                    if (tripExpItem == null) break;
                    String attribute = tripExpItem.getString(TRIPEXP_ATTRIBUTE);
                    if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u62a5\u9500\u91d1\u989d\u3002", (String)"TripDetailStdCtrlForCardStylePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        isCancer = true;
                        break;
                    }
                    if (!Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5ea7\u4f4d\u7b49\u7ea7\u3002", (String)"TripDetailStdCtrlForCardStylePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    isCancer = true;
                    break;
                }
                case DESC_CONTROL: {
                    String stdOverDesc = dataEntity.getString("overdesc");
                    if (!StringUtils.isEmpty((CharSequence)stdOverDesc)) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u586b\u5199\u8d85\u6807\u8bf4\u660e\u3002", (String)"TripDetailStdCtrlForCardStylePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    isCancer = true;
                }
            }
        }
        evt.setCancel(isCancer);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject tripExpenseItem;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (this.isControlEntryStd(dataEntity) && (tripExpenseItem = dataEntity.getDynamicObject("expenseitem")) != null) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            this.setTripStdShowInfo(dataEntity, attribute);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propName) {
            case "expenseitem": {
                this.getModel().beginInit();
                PlaneSeatUtil.refreshSeatGradeByTripExpItemChange((IFormView)this.getView(), (Object)oldValue, (Object)newValue, (int)-1);
                this.updateCalDayCount();
                this.getView().updateView("mulseatgrade");
                this.getView().updateView("caldaycount");
                this.getModel().endInit();
                this.getModel().setValue("highseasondaycount", (Object)this.getHighSeasonDaysByPage());
                this.entryPropertyUpdateStd();
                break;
            }
            case "entrycurrency": {
                this.entryPropertyUpdateStd();
                break;
            }
            case "triparea": {
                this.entryPropertyUpdateStd();
                break;
            }
            case "trip2travelers": {
                this.entryPropertyUpdateStd();
                break;
            }
            case "caldaycount": {
                boolean caldaycountchange;
                ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
                BigDecimal calDayCount = this.calDayCount();
                if (((BigDecimal)newValue).compareTo(calDayCount) > 0 && !(caldaycountchange = SystemParamterUtil.isCalDayCountChange((Long)this.getCompanyId()))) {
                    this.getModel().setValue("caldaycount", oldValue);
                    return;
                }
                if (this.CompareCaldayAndHighSeasonDay()) {
                    this.getModel().beginInit();
                    this.getModel().setValue("highseasondaycount", (Object)this.getHighSeasonDaysByPage());
                    this.getModel().endInit();
                    this.getView().updateView("highseasondaycount");
                }
                boolean flag = this.calculateAllowanceAndSet();
                if (this.validateIsOverMaxCalDayCount(newValue) || flag) break;
                this.checkEntryStdIsOver();
                break;
            }
            case "mulseatgrade": {
                this.entryPropertyUpdateStd();
                break;
            }
            case "orientryamount": {
                ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
                this.checkEntryStdIsOver();
                break;
            }
            case "isover": {
                if ("0".equals(newValue)) {
                    this.getModel().setValue("overdesc", (Object)"");
                }
            }
            case "highseasondaycount": {
                if (this.CompareCaldayAndHighSeasonDay()) {
                    this.getModel().beginInit();
                    this.getModel().setValue("highseasondaycount", oldValue);
                    this.getModel().endInit();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65fa\u5b63\u5929\u6570\u4e0d\u5f97\u8d85\u8fc7\u6807\u51c6\u5929\u6570\u3002", (String)"TripDetailStdCtrlForCardStylePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                if (this.isOpenHighSeasonStd() && this.calculateAllowanceAndSet()) break;
                this.checkEntryStdIsOver();
            }
        }
    }

    private boolean CompareCaldayAndHighSeasonDay() {
        BigDecimal caldayCount = (BigDecimal)this.getModel().getValue("caldaycount");
        BigDecimal highSeasonDayCount = (BigDecimal)this.getModel().getValue("highseasondaycount");
        return highSeasonDayCount.compareTo(caldayCount) > 0;
    }

    private boolean validateIsOverMaxCalDayCount(Object newValue) {
        int dayCount;
        int maxDayCount;
        DynamicObject dataEntity;
        DynamicObject tripExpItem;
        boolean isOverMax = false;
        Long companyId = this.getCompanyId();
        SubsidiesDayParamEnum subsidiesDaysCalculationType = SystemParamterUtil.getSubsidiesDaysCalculationType((long)companyId);
        boolean caldaycountchange = SystemParamterUtil.isCalDayCountChange((Long)companyId);
        if (subsidiesDaysCalculationType == SubsidiesDayParamEnum.ADD_ONE_CONTROL && !caldaycountchange && (tripExpItem = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObject("expenseitem")) != null && tripExpItem.getString(TRIPEXP_ATTRIBUTE).equals(EXPENSE_ITEM_SUBSIDY) && ((BigDecimal)newValue).compareTo(BigDecimal.valueOf(maxDayCount = (dayCount = dataEntity.getInt("daycount")) + 1)) > 0) {
            isOverMax = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u4e3a\u8865\u52a9\u7684\u5dee\u65c5\u660e\u7ec6\u6807\u51c6\u5929\u6570\u4e0d\u5141\u8bb8\u6539\u5927\u3002", (String)"TripDetailStdCtrlForCardStylePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.updateCalDayCount(dayCount);
        }
        return isOverMax;
    }

    private void entryPropertyUpdateStd() {
        boolean isOpenTripStd = this.isOpenTripStd();
        if (!isOpenTripStd) {
            return;
        }
        IErTripStdService tripStdService = new ErTripStdServiceProxy((IErTripStdService)new ErTripStdServiceImp(), this.getModel().getDataEntity()).getInstance();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (this.isControlEntryStd(dataEntity)) {
            this.entryPropertyUpdateStd(tripStdService, dataEntity);
        }
    }

    private void entryPropertyUpdateStd(IErTripStdService tripStdService, DynamicObject entry) {
        Long companyId = this.getCompanyId();
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem == null) {
            return;
        }
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        String billstatus = entry.getString("billstatus");
        if (!ErBillStatusEnum.A.name().equals(billstatus) && !ErBillStatusEnum.D.name().equals(billstatus)) {
            this.setTripStdShowInfo(entry, attribute);
            return;
        }
        Set userSet = entry.getDynamicObjectCollection("trip2travelers").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (userSet.isEmpty()) {
            return;
        }
        List<Long> userList = userSet.stream().collect(Collectors.toList());
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
            ControlMethodEnum tripStandCtrTypeEnum = SystemParamterUtil.getTripStandardControlLevel((long)companyId);
            String mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)companyId);
            this.updateAccdAndAllowanceStd(userList, tripStandCtrTypeEnum, mulTraStdCtrType, tripStdService, entry, tripExpenseItem);
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) {
            ControlMethodEnum tripStandCtrTypeEnum = SystemParamterUtil.getVehicleStdControlLevel((long)companyId);
            this.updateTripVehicStd(userList, companyId, tripStandCtrTypeEnum, attribute, entry);
        } else {
            TripStandardUtils.resetStdDetail((IDataModel)this.getModel(), (int)-1, (int)-1);
        }
        this.checkEntryStdIsOver(entry, attribute);
    }

    private void updateAccdAndAllowanceStd(List<Long> userIds, ControlMethodEnum controlMethodEnum, String mulTraStdCtrType, IErTripStdService tripStdService, DynamicObject entry, DynamicObject tripExpenseItem) {
        IDataModel model = this.getModel();
        model.setValue("controlmethod", (Object)controlMethodEnum.getValue());
        if (entry.getBoolean("isovervhcstd")) {
            model.setValue("isovervhcstd", (Object)Boolean.FALSE);
        }
        DynamicObject entryCurrency = this.getEntryCurrency(entry);
        DynamicObject tripArea = entry.getDynamicObject("triparea");
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, (AbstractFormPlugin)this, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)entry.getDynamicObject("expenseitem"), this.getExtMap(entry, -1, -1));
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        BigDecimal tripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getStandardamount();
        BigDecimal highAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getHighSeasonStandardamount();
        Boolean userOutStdCtrl = tripStdDetail == null ? Boolean.FALSE : tripStdDetail.getUserOutStdCtrl();
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        if (EXPENSE_ITEM_ACCOMMODATION.equals(attribute) && "max".equals(mulTraStdCtrType)) {
            tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
            highAmount = highAmount.multiply(BigDecimal.valueOf(userIds.size()));
        }
        model.setValue("tripstandardamount", (Object)tripSTDAmount);
        model.setValue("hightripstandardamount", (Object)highAmount);
        BigDecimal caldaycount = entry.getBigDecimal("caldaycount");
        String ctrltype = tripExpenseItem.getString("ctrltype");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)this.getModel().getDataEntity());
        if (!userOutStdCtrl.booleanValue() && (StringUtils.equals((CharSequence)ctrltype, (CharSequence)"1") || StringUtils.equals((CharSequence)ctrltype, (CharSequence)"3")) && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attribute)) {
            this.getModel().setValue("orientryamount", (Object)oriMaxStdAmount);
        }
        model.setValue("useroutstdctrl", (Object)userOutStdCtrl);
        if (entry.getBoolean("isovervhcstd")) {
            model.setValue("isovervhcstd", (Object)Boolean.FALSE);
        }
        TripStandardUtils.setStdDetail((IDataModel)this.getModel(), (TripStandardDetail)tripStdDetail, (int)-1, (int)-1);
    }

    protected DynamicObject getEntryCurrency(DynamicObject entry) {
        return entry.getDynamicObject("entrycurrency");
    }

    private void updateTripVehicStd(List<Long> userList, Long companyId, ControlMethodEnum tripStandCtrTypeEnum, String attribute, DynamicObject entry) {
        IDataModel model = this.getModel();
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE);
        }
        DynamicObjectCollection stdSeatGradeColl = entry.getDynamicObjectCollection("stdseatgrade");
        stdSeatGradeColl.clear();
        HashMap map = this.getExtMap(entry, -1, -1);
        map = map == null ? new HashMap(4) : map;
        Map seatGradeStd = TripStandardUtils.getVhcSeatGradeStd(userList, (Long)companyId, (String)attribute, (IPageCache)this.getPageCache(), (AbstractFormPlugin)this, map);
        if (!seatGradeStd.isEmpty()) {
            for (Map.Entry seatGrade : seatGradeStd.entrySet()) {
                DynamicObject entrySeatGrade = stdSeatGradeColl.addNew();
                entrySeatGrade.set("fbasedataid", seatGrade.getValue());
            }
        }
        model.setValue("controlmethod", (Object)tripStandCtrTypeEnum.getValue());
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE);
        }
        TripStandardUtils.setStdDetail((IDataModel)this.getModel(), map, (int)-1, (int)-1);
    }

    protected Map<String, Object> getExtMap(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        return TripStandardUtils.buildExtMap((IFormView)this.getView(), (DynamicObject)entry, (int)parentEntryIndex, (int)curEntryIndex);
    }

    protected boolean checkEntryStdIsOver() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject tripExpenseItem = dataEntity.getDynamicObject("expenseitem");
        if (tripExpenseItem != null && (this.isOpenAccdAndAllowanceStd() || this.isOpenVehicStd())) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            return this.checkEntryStdIsOver(dataEntity, attribute);
        }
        return false;
    }

    protected boolean checkEntryStdIsOver(DynamicObject entry, String attribute) {
        boolean isOverStd = false;
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) && this.isOpenAccdAndAllowanceStd()) {
            BigDecimal oriEntryAmount = entry.getBigDecimal("orientryamount");
            BigDecimal tripSTDAmount = entry.getBigDecimal("tripstandardamount");
            BigDecimal caldaycount = entry.getBigDecimal("caldaycount");
            boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
            boolean tripStdNeedOnlySumCheck = SystemParamterUtil.getTripStdNeedOnlySumCheck((long)this.getCompanyId());
            BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
            if (!userOutStdCtrl && oriEntryAmount.compareTo(oriMaxStdAmount) > 0 && !tripStdNeedOnlySumCheck) {
                this.getModel().setValue("tripstdsumupover", (Object)Boolean.TRUE);
                isOverStd = true;
            } else {
                if (tripStdNeedOnlySumCheck && this.getView().getParentView().getModel().getEntryEntity("tripentry").size() > 0) {
                    isOverStd = this.checkSumGroupStdIsOver(this.getModel().getDataEntity(), ((DynamicObject)this.getView().getParentView().getModel().getEntryEntity("tripentry").get(0)).getDynamicObjectCollection("entryentity"), "expenseitem", "entrycurrency");
                }
                this.getModel().setValue("tripstdsumupover", (Object)Boolean.FALSE);
            }
            if (userOutStdCtrl) {
                TripStandardUtils.resetStdDetail((IDataModel)this.getModel(), (int)-1, (int)-1);
            }
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && this.isOpenVehicStd()) {
            DynamicObjectCollection entrySeatGrade = entry.getDynamicObjectCollection("mulseatgrade");
            DynamicObjectCollection seatGradeStd = entry.getDynamicObjectCollection("stdseatgrade");
            isOverStd = TripStandardUtils.isOverVhcStd((DynamicObjectCollection)entrySeatGrade, (DynamicObjectCollection)seatGradeStd);
            this.getModel().setValue("isovervhcstd", (Object)isOverStd);
        }
        String isOver = isOverStd ? "1" : "0";
        this.getModel().setValue("isover", (Object)isOver);
        this.setTripStdShowInfo(entry, attribute);
        return isOverStd;
    }

    private TripStandardDetail getSumGroupStd(List<Long> userIds, DynamicObject entryObject, String mulTraStdCtrType) {
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        DynamicObject entryCurrency = entryObject.getDynamicObject("entrycurrency");
        DynamicObject tripArea = entryObject.getDynamicObject("triparea");
        DynamicObject expenseItem = entryObject.getDynamicObject("expenseitem");
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, (AbstractFormPlugin)this, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)expenseItem, this.getExtMap(entryObject, -1, -1));
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        return tripStdDetail;
    }

    private boolean isHaveProperty(DynamicObject entryObject, String ... groupPrppertyName) {
        if (ArrayUtils.isEmpty((Object[])groupPrppertyName)) {
            return false;
        }
        boolean isHave = true;
        DataEntityPropertyCollection propertyCollection = entryObject.getDataEntityType().getProperties();
        for (int i = 0; i < groupPrppertyName.length; ++i) {
            isHave = isHave && propertyCollection.containsKey((Object)groupPrppertyName[i]);
        }
        return isHave;
    }

    private boolean checkSumGroupStdIsOver(DynamicObject entryObject, DynamicObjectCollection entryColl, String ... groupPrppertyName) {
        boolean isOver = false;
        if (entryObject == null || entryColl == null || entryColl.isEmpty() || ArrayUtils.isEmpty((Object[])groupPrppertyName) || !this.isHaveProperty(entryObject, groupPrppertyName)) {
            return isOver;
        }
        DynamicObjectCollection collection = new DynamicObjectCollection();
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        for (int i = 0; i < entryColl.size(); ++i) {
            if (i == index) continue;
            collection.add(entryColl.get(i));
        }
        Map<String, List<DynamicObject>> sumGroupEntry = collection.stream().filter(entry -> this.isHaveProperty((DynamicObject)entry, groupPrppertyName)).collect(Collectors.groupingBy(entry -> TripStandardUtils.fetchGroupKey((DynamicObject)entry, (String[])groupPrppertyName)));
        List entryOfGroup = sumGroupEntry.getOrDefault(TripStandardUtils.fetchGroupKey((DynamicObject)entryObject, (String[])groupPrppertyName), new ArrayList());
        BigDecimal sumStdAmount = BigDecimal.ZERO;
        BigDecimal sumReimAmount = entryObject.getBigDecimal("orientryamount");
        DynamicObject tripExp = entryObject.getDynamicObject("expenseitem");
        if (tripExp != null) {
            String mulTraStdCtrType;
            BigDecimal daycount = BigDecimal.valueOf(entryObject.getInt("daycount"));
            String attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE);
            if (StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attributeType)) {
                daycount = this.getCalDayCount();
            }
            BigDecimal highSeasonDays = BigDecimal.valueOf(entryObject.getInt("highseasondaycount"));
            DynamicObjectCollection travelers = ((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("travelers");
            List<Long> userIds = travelers.stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toList());
            TripStandardDetail tripStdDetail = this.getSumGroupStd(userIds, entryObject, mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)this.getCompanyId()));
            if (tripStdDetail != null) {
                BigDecimal tripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getStandardamount();
                BigDecimal highSeasonTripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getHighSeasonStandardamount();
                String attribute = entryObject.getDynamicObject("expenseitem").getString(TRIPEXP_ATTRIBUTE);
                if (EXPENSE_ITEM_ACCOMMODATION.equals(attribute) && "max".equals(mulTraStdCtrType)) {
                    tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                    highSeasonTripSTDAmount = highSeasonTripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                }
                sumStdAmount = sumStdAmount.add(tripSTDAmount.multiply(daycount.subtract(highSeasonDays))).add(highSeasonTripSTDAmount.multiply(highSeasonDays));
            }
            if (!entryOfGroup.isEmpty()) {
                for (DynamicObject entry2 : entryOfGroup) {
                    sumReimAmount = sumReimAmount.add(entry2.getBigDecimal("orientryamount"));
                }
            }
            if (sumReimAmount.compareTo(sumStdAmount) > 0) {
                isOver = true;
            }
        }
        return isOver;
    }

    private void setTripStdShowInfo(DynamicObject entry, String attribute) {
        this.getModel().setValue(TRIPSTD_SHOWSTR, (Object)TripStandardUtils.getTripStdShowInfoByDetailEntry((DynamicObject)entry, (String)attribute));
        this.getModel().setValue(HIGH_SEASON_TRIPSTD_SHOWSTR, (Object)TripStandardUtils.getTripStdShowInfoByDetailEntry(null, (DynamicObject)entry, (String)attribute, (String)"hightripstandardamount"));
    }

    private void updateCalDayCount() {
        DynamicObject detailEntry = this.getModel().getDataEntity(true);
        int dayCount = detailEntry.getInt("daycount");
        this.updateCalDayCount(dayCount);
    }

    private void updateCalDayCount(int dayCount) {
        BigDecimal oldCalDayCount;
        String attributeType;
        if (!this.isOpenTripStd()) {
            return;
        }
        DynamicObject detailEntry = this.getModel().getDataEntity(true);
        DynamicObject tripExp = detailEntry.getDynamicObject("expenseitem");
        BigDecimal caldaycount = new BigDecimal(dayCount);
        if (tripExp != null && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)(attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE)))) {
            caldaycount = this.getCalDayCount();
        }
        if ((oldCalDayCount = detailEntry.getBigDecimal("caldaycount")).compareTo(caldaycount) != 0) {
            this.getModel().setValue("caldaycount", (Object)caldaycount);
        }
    }

    private boolean isOpenTripStd() {
        return this.getModel().getDataEntity(true).getBoolean("isopentripstd");
    }

    private Long getCompanyId() {
        DynamicObject company = this.getModel().getDataEntity(true).getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : (Long)company.getPkValue();
        return companyId;
    }

    private boolean isControlEntryStd(DynamicObject entry) {
        boolean isNeed = true;
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem != null) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            isNeed = Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) ? isNeed && this.isOpenAccdAndAllowanceStd() : (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) ? isNeed && this.isOpenVehicStd() : false);
            if (!Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
                entry.set("highseasondaycount", (Object)BigDecimal.ZERO);
            }
        }
        if (!isNeed) {
            this.clearEntryStd(entry);
        }
        return isNeed;
    }

    protected boolean isOpenAccdAndAllowanceStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return dataEntity.getBoolean("isopentripstd") && dataEntity.getBoolean("tripstandcon");
    }

    protected boolean isOpenHighSeasonStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return this.isOpenAccdAndAllowanceStd() && dataEntity.getBoolean("isopenhighseasontripstd");
    }

    protected boolean isOpenVehicStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return dataEntity.getBoolean("isopentripstd") && dataEntity.getBoolean("isnoctrltripvhcctrlv");
    }

    private void clearEntryStd(DynamicObject entry) {
        DynamicObjectCollection seatGrade;
        IDataModel model = this.getModel();
        if (entry.getBoolean("isovervhcstd")) {
            model.setValue("isovervhcstd", (Object)Boolean.FALSE);
        }
        if (entry.getBigDecimal("tripstandardamount").compareTo(BigDecimal.ZERO) > 0) {
            model.setValue("tripstandardamount", (Object)BigDecimal.ZERO);
        }
        if (entry.getBigDecimal("hightripstandardamount").compareTo(BigDecimal.ZERO) > 0) {
            model.setValue("hightripstandardamount", (Object)BigDecimal.ZERO);
        }
        if ((seatGrade = entry.getDynamicObjectCollection("stdseatgrade")) != null && seatGrade.size() > 0) {
            model.setValue("stdseatgrade", null);
        }
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE);
        }
        if (entry.getBoolean("isover")) {
            model.setValue("isover", (Object)"0");
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString(TRIPSTD_SHOWSTR))) {
            model.setValue(TRIPSTD_SHOWSTR, null);
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString(HIGH_SEASON_TRIPSTD_SHOWSTR))) {
            model.setValue(HIGH_SEASON_TRIPSTD_SHOWSTR, null);
        }
    }

    protected boolean calculateAllowanceAndSet() {
        DynamicObject entry = this.getModel().getDataEntity(true);
        if (!this.isOpenAccdAndAllowanceStd()) {
            return false;
        }
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem == null) {
            return false;
        }
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        String ctrltype = tripExpenseItem.getString("ctrltype");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
        Boolean isDeleteEntry = (Boolean)ActionLocalCache.get().getDefaultIfNull("isDeleteEntryEntity", (Object)false);
        if ((StringUtils.equals((CharSequence)ctrltype, (CharSequence)"1") || StringUtils.equals((CharSequence)ctrltype, (CharSequence)"3") && !isDeleteEntry.booleanValue()) && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attribute) && !userOutStdCtrl && oriMaxStdAmount.compareTo((BigDecimal)this.getModel().getValue("orientryamount")) != 0) {
            this.getModel().setValue("orientryamount", (Object)oriMaxStdAmount);
            this.getModel().beginInit();
            BigDecimal caldaycount = entry.getBigDecimal("caldaycount");
            this.getModel().setValue("caldaycount", (Object)caldaycount);
            this.getModel().endInit();
            return true;
        }
        return false;
    }

    private BigDecimal getCalDayCount() {
        int cardIndex;
        Date begin = (Date)this.getView().getParentView().getModel().getValue("startdate", 0);
        Date end = (Date)this.getView().getParentView().getModel().getValue("enddate", 0);
        if (begin == null || end == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal dayCount = BigDecimal.valueOf(CommonServiceHelper.calcDays((Date)begin, (Date)end));
        DynamicObjectCollection mainPageTripEntry = this.getView().getParentView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        DynamicObjectCollection tripEntry = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        Integer index = (Integer)this.getView().getParentView().getFormShowParameter().getCustomParam("index");
        int n = cardIndex = index == null ? mainPageTripEntry.size() : index.intValue();
        if (!this.isOpenTripDateControl()) {
            return dayCount.add(TripHighSeasonStandardUtil.getDelayDay((Long)this.getCompanyId()));
        }
        DynamicObject expenseItem = (DynamicObject)this.getModel().getValue("expenseitem", 0, 0);
        if (expenseItem == null || !StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)expenseItem.getString(TRIPEXP_ATTRIBUTE))) {
            return dayCount;
        }
        if (cardIndex == 0) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)this.getCompanyId()).add(dayCount);
        }
        Date preTripEndDay = ((DynamicObject)mainPageTripEntry.get(cardIndex - 1)).getDate("enddate");
        Date curTripStartDay = ((DynamicObject)tripEntry.get(0)).getDate("startdate");
        if (preTripEndDay != null && curTripStartDay != null && preTripEndDay.getTime() != curTripStartDay.getTime()) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)this.getCompanyId()).add(dayCount);
        }
        return dayCount;
    }

    private BigDecimal getHighSeasonDaysByPage() {
        Date begin = (Date)this.getView().getParentView().getModel().getValue("startdate", 0);
        Date end = (Date)this.getView().getParentView().getModel().getValue("enddate", 0);
        DynamicObject expenseItem = (DynamicObject)this.getModel().getValue("expenseitem");
        DynamicObject tripArea = (DynamicObject)this.getModel().getValue("triparea");
        if (begin == null || end == null || expenseItem == null || tripArea == null || end.before(begin)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection tripEntry = this.getView().getParentView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        Integer parentIndex = (Integer)this.getView().getParentView().getFormShowParameter().getCustomParam("index");
        Integer preIndex = parentIndex != null && parentIndex != -1 ? parentIndex - 1 : tripEntry.size() - 1;
        OptionalInt preRowIndexOp = IntStream.range(0, tripEntry.size()).filter(idx -> idx == preIndex).findFirst();
        Date preRowEndDate = preRowIndexOp.isPresent() ? ((DynamicObject)tripEntry.get(preRowIndexOp.getAsInt())).getDate("enddate") : null;
        return TripHighSeasonStandardUtil.getHighSeasonDays((Long)this.getCompanyId(), (Date)preRowEndDate, (Date)begin, (Date)end, (DynamicObject)tripArea, (DynamicObject)expenseItem, (boolean)this.isOpenTripDateControl());
    }

    private boolean isOpenTripDateControl() {
        return SystemParamterUtil.isOpenTripDateControl((Long)this.getCompanyId()) && ((Boolean)this.getView().getParentView().getModel().getValue("istravelers") == false || (Boolean)this.getView().getParentView().getModel().getValue("istravelers") != false && (Boolean)this.getView().getParentView().getModel().getValue("travelerssamestd") != false) && (Boolean)this.getView().getParentView().getModel().getValue("isopentripstd") != false;
    }

    private BigDecimal calDayCount() {
        String attributeType;
        DynamicObject tripExp;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int dayCount = dataEntity.getInt("daycount");
        BigDecimal calDayCount = new BigDecimal(dayCount);
        boolean isOpenAccdAndAllowanceStd = this.isOpenAccdAndAllowanceStd();
        if (isOpenAccdAndAllowanceStd && (tripExp = dataEntity.getDynamicObject("expenseitem")) != null && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)(attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE)))) {
            BigDecimal delayDay = TripHighSeasonStandardUtil.getDelayDay((Long)ErCommonUtils.getPk((Object)dataEntity.getDynamicObject("company")));
            calDayCount = calDayCount.add(delayDay);
        }
        return calDayCount;
    }
}

