/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile.tripstandard;

import java.util.Arrays;
import java.util.EventObject;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.formplugin.web.tripstandard.AbstractTripStdCtrlForCardStylePlugin;
import org.apache.commons.lang3.StringUtils;

public class TripEntryStdCtrlForCardStylePlugin
extends AbstractTripStdCtrlForCardStylePlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save"});
    }

    @Override
    protected void setTripStdShowInfo(DynamicObject entry, String attribute, int parentEntryIndex, int curEntryIndex) {
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String orgType = ErCommonUtils.getTripAreaOrgType();
        IDataModel model = this.getModel();
        if (model.getValue(orgType) == null) {
            model.setValue(orgType, this.getView().getParentView().getModel().getValue(orgType));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        boolean isCancer = false;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btn_save")) {
            DynamicObjectCollection tripEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
            IDataModel pModel = this.getView().getParentView().getModel();
            if (SystemParamterUtil.isOpenTripDateControl((Long)this.getCompanyId()) && !((Boolean)pModel.getValue("istravelers")).booleanValue() && ((Boolean)pModel.getValue("isopentripstd")).booleanValue()) {
                DynamicObjectCollection mainPageTripEntry = pModel.getDataEntity(true).getDynamicObjectCollection("tripentry");
                Integer cusParamIndex = (Integer)this.getView().getFormShowParameter().getCustomParams().get("index");
                Integer index = cusParamIndex != null ? cusParamIndex.intValue() : mainPageTripEntry.size();
                String errSeq = IntStream.range(0, mainPageTripEntry.size()).filter(idx -> index == idx + 1 && ((DynamicObject)tripEntryColl.get(0)).getDate("startdate").getTime() < ((DynamicObject)mainPageTripEntry.get(idx)).getDate("enddate").getTime()).mapToObj(idx -> ((DynamicObject)mainPageTripEntry.get(idx)).getString("seq")).collect(Collectors.joining(","));
                if (errSeq != null && !StringUtils.isBlank((CharSequence)errSeq)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f00\u542f\u4e86\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u3002\u5f53\u524d\u884c\u7a0b\u884c\u548c\u7b2c%s\u884c\u884c\u7a0b\u65f6\u95f4\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TripEntryStdCtrlForCardStylePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), errSeq));
                    evt.setCancel(true);
                    return;
                }
            }
            for (int tripIndex = 0; tripIndex < tripEntryColl.size(); ++tripIndex) {
                DynamicObject tripEntry = (DynamicObject)tripEntryColl.get(tripIndex);
                DynamicObjectCollection detailEntryColl = tripEntry.getDynamicObjectCollection("entryentity");
                block5: for (int detailIndex = 0; detailIndex < detailEntryColl.size(); ++detailIndex) {
                    DynamicObject detailEntry = (DynamicObject)detailEntryColl.get(detailIndex);
                    ControlMethodEnum ctrlMethod = ControlMethodEnum.getContrlMethodEnumByValue((String)detailEntry.getString("controlmethod"));
                    if (!"1".equals(detailEntry.getString("isover")) || ctrlMethod == null) continue;
                    DynamicObject tripExpItem = detailEntry.getDynamicObject("expenseitem");
                    switch (ctrlMethod) {
                        case STRICT_CONTROL: {
                            if (tripExpItem == null) break;
                            String attribute = tripExpItem.getString("attribute");
                            if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u62a5\u9500\u91d1\u989d\u3002", (String)"TripEntryStdCtrlForCardStylePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                                isCancer = true;
                                break;
                            }
                            if (!Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) break block5;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5ea7\u4f4d\u7b49\u7ea7\u3002", (String)"TripEntryStdCtrlForCardStylePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            isCancer = true;
                            break;
                        }
                        case DESC_CONTROL: {
                            String stdOverDesc = detailEntry.getString("overdesc");
                            if (!StringUtils.isEmpty((CharSequence)stdOverDesc)) break;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u586b\u5199\u8d85\u6807\u8bf4\u660e\u3002", (String)"TripEntryStdCtrlForCardStylePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            isCancer = true;
                        }
                    }
                    break;
                }
                if (!isCancer) continue;
                evt.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entityName = e.getEntryProp().getName();
        if ("entryentity".equals(entityName)) {
            this.setTripOver();
        }
    }
}

