/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.paramsetting;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.url.UrlService;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.enums.BillSettingControlFieldEnum;
import kd.fi.er.formplugin.invoicecloud.mergerule.CompareTypeEnum;
import kd.fi.er.formplugin.invoicecloud.mergerule.ShowUserDefineFilterCustomParaBO;
import kd.fi.er.formplugin.invoicecloud.mergerule.UserDefineFilterReturnBO;
import kd.fi.er.model.FormModel;

public class ReimburseTypeSetting
extends AbstractFormPlugin {
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDNUMBER = "fieldnumber";
    private static final String LOCKCONDITION = "lockcondition";
    private MainEntityType billMainType = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELDNAME, LOCKCONDITION, "imageap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject entityNumber = (DynamicObject)this.getModel().getValue("group");
        if (entityNumber != null && BillSettingControlFieldEnum.STANDARD_TYPE.getValue().equals(entityNumber.getString("controlfield"))) {
            BasedataEdit bizitem = (BasedataEdit)this.getControl("bizitem");
            bizitem.setMustInput(true);
        } else if (entityNumber != null && BillSettingControlFieldEnum.REIMBURSE_TYPE.getValue().equals(entityNumber.getString("controlfield"))) {
            ComboEdit bizitem = (ComboEdit)this.getControl("reimbursetype");
            bizitem.setMustInput(true);
        }
    }

    private void setReimburseTypeCombo() {
        if (this.getBillMainType() != null) {
            ComboProp property = (ComboProp)this.getBillMainType().getProperty("reimbursetype");
            ComboEdit comboEdit = (ComboEdit)this.getControl("reimbursetype");
            if (property != null && comboEdit != null) {
                List valueItems = property.getComboItems();
                ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)valueItems.size());
                for (ValueMapItem item : valueItems) {
                    ComboItem comboitem = new ComboItem();
                    comboitem.setCaption(item.getName());
                    comboitem.setValue(item.getValue());
                    comboitem.setItemVisible(item.isItemVisible());
                    comboItems.add(comboitem);
                }
                comboEdit.setComboItems((List)comboItems);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setReimburseTypeCombo();
        String val = (String)this.getModel().getValue("picturefield");
        this.setImageUrl(val);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject dynamicObject;
        super.propertyChanged(e);
        if ("hidden".equals(e.getProperty().getName()) && Boolean.TRUE.equals(e.getChangeSet()[0].getNewValue()) && this.getBillMainType() != null) {
            String fieldkey = (String)this.getModel().getValue(FIELDNUMBER, e.getChangeSet()[0].getRowIndex());
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)this.getBillMainType().getAllFields().get(BillSettingRuleUtil.getRealFieldName((String)fieldkey));
            if (iDataEntityProperty instanceof FieldProp && ((FieldProp)iDataEntityProperty).isMustInput() || iDataEntityProperty instanceof BasedataProp && ((BasedataProp)iDataEntityProperty).isMustInput()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0a\u5df2\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u7684\u5b57\u6bb5\uff0c\u4e0d\u652f\u6301\u9690\u85cf\u3002", (String)"ReimburseTypeSetting_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("hidden", (Object)false, e.getChangeSet()[0].getRowIndex());
            }
        } else if (LOCKCONDITION.equals(e.getProperty().getName()) && StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) {
            this.getModel().setValue("lockconditionjson", (Object)"", e.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("lockconditionexpr", (Object)"", e.getChangeSet()[0].getRowIndex());
        } else if ("bizitem".equals(e.getProperty().getName()) && (dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            String num = dynamicObject.getString("number");
            this.getModel().setValue("reimbursetype", (Object)num);
        }
        if ("lockconditionjson".equals(e.getProperty().getName()) || "lockconditionexpr".equals(e.getProperty().getName())) {
            int index = e.getChangeSet()[0].getRowIndex();
            String val = (String)e.getChangeSet()[0].getNewValue();
            this.subStr(e.getProperty().getName(), val, index);
            this.getModel().setValue(e.getProperty().getName() + "_tag", (Object)val, index);
        }
    }

    private void subStr(String property, String val, int i) {
        if (StringUtils.isNotEmpty((CharSequence)val) && val.length() > 255) {
            this.getModel().beginInit();
            this.getModel().setValue(property, (Object)val.substring(0, 255), i);
            this.getModel().endInit();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (FIELDNAME.equals(key)) {
            DynamicObject entityNumber = (DynamicObject)this.getModel().getValue("group");
            if (entityNumber != null) {
                this.showSelectFieldForm(FIELDNAME, entityNumber.getString("number"));
            }
        } else if (LOCKCONDITION.equals(key)) {
            this.showEditRulePage();
        } else if ("imageap".equals(((Control)evt.getSource()).getKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ide_pictureselector");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setParentFormId(this.getView().getEntityId());
            showParameter.setHasRight(true);
            String bizappid = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
            showParameter.setCustomParam("bizappid", (Object)bizappid);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ide_pictureselector");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private void showEditRulePage() {
        String entityName;
        String string = entityName = this.getBillMainType() == null ? null : this.getBillMainType().getName();
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String fieldnumber = (String)this.getModel().getValue(FIELDNUMBER, rowIndex);
        List<String> fields = this.getFields(entityType, fieldnumber);
        HashMap<String, String> customParam = new HashMap<String, String>();
        ShowUserDefineFilterCustomParaBO param = new ShowUserDefineFilterCustomParaBO();
        param.setEntityName(entityName);
        param.setFilterValue((String)this.getModel().getValue("lockconditionjson_tag", rowIndex));
        param.setFields(fields);
        customParam.put("showUserDefineFilterCustomParaBO", JSON.toJSONString((Object)param));
        FormModel formModel = new FormModel("er_userdefinerule", "", "14", true, customParam);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, LOCKCONDITION);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this, (CloseCallBack)callBack);
    }

    private List<String> getFields(MainEntityType entityType, String fieldnumber) {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)128);
        fields.addAll(entityType.getFields().keySet());
        String entryName = fieldnumber.split("\\.")[0];
        DynamicProperty property = entityType.getProperty(entryName);
        if (property instanceof EntryProp) {
            fields.addAll(((EntityType)entityType.getAllEntities().get(entryName)).getFields().keySet());
        }
        return fields;
    }

    private void showSelectFieldForm(String sourceCtrlKey, String entitynumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("er_selectfield");
        showParameter.getCustomParams().put("entitynumber", entitynumber);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("treeBuildOption.IncludeBDRefProp", (Object)false);
        showParameter.setCustomParam("treeBuildOption.IncludePKField", (Object)false);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        if (FIELDNAME.equals(closedCallBackEvent.getActionId())) {
            String type;
            String fieldnumber;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && this.notExist(fieldnumber = returnData.toString()) && (type = this.checkFieldType(fieldnumber)) != null) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue(FIELDNUMBER, (Object)fieldnumber, rowIndex);
                this.getModel().setValue("fieldtype", (Object)type, rowIndex);
                String returnPropName = returnData.toString();
                String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)this.getBillMainType(), (String)returnPropName.substring(returnPropName.lastIndexOf(".") + 1));
                this.getModel().setValue(FIELDNAME, (Object)fieldCaption, rowIndex);
                if ("entry".equals(type)) {
                    this.getModel().setValue("diyname", null, rowIndex);
                }
            }
        } else if (LOCKCONDITION.equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                UserDefineFilterReturnBO returnBO = (UserDefineFilterReturnBO)JSON.parseObject((String)returnData.toString(), UserDefineFilterReturnBO.class);
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)returnBO.getFilterConJson(), FilterCondition.class);
                OutValue errorMsg = new OutValue();
                String js = ReimburseTypeSetting.translateFilterToJs(errorMsg, filterCondition);
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)errorMsg.get()))) {
                    this.getView().showErrorNotification((String)errorMsg.get());
                    return;
                }
                this.getModel().setValue("lockconditionexpr", (Object)js, rowIndex);
                if (filterCondition.getFilterRow().isEmpty() || StringUtils.isBlank((CharSequence)js)) {
                    this.getModel().setValue(LOCKCONDITION, (Object)"", rowIndex);
                    this.getModel().setValue("lockconditionjson", (Object)"", rowIndex);
                } else {
                    this.getModel().setValue(LOCKCONDITION, (Object)returnBO.getDesc(), rowIndex);
                    this.getModel().setValue("lockconditionjson", (Object)returnBO.getFilterConJson(), rowIndex);
                }
            }
        } else if ("ide_pictureselector".equals(closedCallBackEvent.getActionId()) && (map = (Map)closedCallBackEvent.getReturnData()) != null) {
            String val = (String)map.get("value");
            this.getModel().setValue("picturefield", (Object)val);
            this.setImageUrl(val);
        }
    }

    private void setImageUrl(String val) {
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            Image image = (Image)this.getControl("imageap");
            if (image == null) {
                return;
            }
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            image.setUrl(rootUrl + val);
        }
    }

    private String checkFieldType(String fieldnumber) {
        if (this.getBillMainType() != null) {
            String propertyName = BillSettingRuleUtil.getRealFieldName((String)fieldnumber);
            IDataEntityProperty property = (IDataEntityProperty)this.getBillMainType().getAllFields().get(propertyName);
            if (property instanceof EntryProp) {
                return "entry";
            }
            if (property instanceof IFieldHandle) {
                return "field";
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u4e0d\u652f\u6301\u9009\u62e9\u3002", (String)"ReimburseTypeSetting_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        return null;
    }

    private boolean notExist(String fieldnumber) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            if (!fieldnumber.equals(this.getModel().getValue(FIELDNUMBER, rowIndex))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u5df2\u5b58\u5728", (String)"ReimburseTypeSetting_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public MainEntityType getBillMainType() {
        String tgtEntityNumber;
        DynamicObject entityNumber;
        if (this.billMainType == null && (entityNumber = (DynamicObject)this.getModel().getValue("group")) != null && StringUtils.isNotBlank((CharSequence)(tgtEntityNumber = entityNumber.getString("number")))) {
            this.billMainType = EntityMetadataCache.getDataEntityType((String)tgtEntityNumber);
        }
        return this.billMainType;
    }

    public static String translateFilterToJs(OutValue errorMsg, FilterCondition filterCondition) {
        StringBuilder jsExpressSb = new StringBuilder();
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow filterRow : filterRows) {
            String compareType = filterRow.getCompareType();
            if (CompareTypeEnum.isNotSupportType(compareType)) {
                errorMsg.set((Object)ResManager.loadKDString((String)"\u4e0d\u80fd\u5305\u62ec\u201c\u672c\u5468\u3001\u4e0a\u5468\u3001\u4e0b\u5468\u3001\u672c\u6708\u3001\u4e0a\u6708\u3001\u4e0b\u6708\u3001\u8fc7\u53bb\u4e09\u4e2a\u6708\u3001\u672a\u6765\u4e09\u4e2a\u6708\u3001\u672c\u5b63\u5ea6\u3001\u4e0a\u5b63\u5ea6\u3001\u4e0b\u5b63\u5ea6\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ReimburseTypeSetting_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                jsExpressSb.setLength(0);
                break;
            }
            if (!CompareTypeEnum.containById(compareType)) continue;
            String varName = filterRow.getFieldName();
            String value = "";
            List values = filterRow.getValue();
            value = values.size() == 1 ? "'" + ((FilterValue)values.get(0)).getValue().toString() + "'" : values.stream().map(val -> "'" + ((FilterValue)values.get(0)).getValue().toString() + "'").collect(Collectors.joining(","));
            CompareTypeEnum compare = CompareTypeEnum.of(compareType);
            String js = compare.getJs(varName, value);
            String logic = filterRow.getLogic();
            String logicSymbol = logic.equals("1") ? "||" : "&& ";
            jsExpressSb.append(filterRow.getLeftBracket());
            jsExpressSb.append(js);
            jsExpressSb.append(filterRow.getRightBracket());
            jsExpressSb.append(" ");
            jsExpressSb.append(logicSymbol);
        }
        String jsExpress = "";
        if (jsExpressSb.length() > 0) {
            jsExpress = jsExpressSb.substring(0, jsExpressSb.length() - 3);
        }
        return jsExpress;
    }
}

