/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeProjectF7SelectListener;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class BaseExpesePoolBillPlugin
extends AbstractBillPlugIn {
    private final Set<String> vehicleset = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"2", "3", "4", "7"}));

    public void registerListener(EventObject e) {
        this.setProjectF7Filter();
        this.costDeptF7Filter();
        this.costCompanyFilter();
        this.costExpenseitemeditT7Filter();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getView().getModel();
        Long currentUserID = 0L;
        RequestContext requestContext = RequestContext.get();
        currentUserID = Long.valueOf(requestContext.getUserId());
        Map billMap = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        billMap.put("targetbillcurrency", billMap.get("currency"));
        this.getModel().setValue("exchangerate", (Object)BigDecimal.ONE);
        CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
        CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
        model.setValue("billtypefield", (Object)this.getBillTypeId());
        model.setValue("formid", (Object)this.getFormid());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName = e.getProperty().getName()) {
            case "costdept": {
                if (propValue == null) {
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("costdept", ((DynamicObject)propValue).getPkValue());
                }
                this.costDeptChange((DynamicObject)propValue);
                break;
            }
            case "costcompany": {
                DynamicObject bdproject;
                if (propValue == null) {
                    this.getModel().setValue("targetbillcurrency", valueSet[0].getOldValue());
                    break;
                }
                DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Long)ErCommonUtils.getPk((Object)propValue));
                this.getModel().setValue("targetbillcurrency", (Object)currency);
                DynamicObject costcompany = (DynamicObject)this.getModel().getValue("costcompany");
                Long costcompanyPkValue = (Long)costcompany.getPkValue();
                DynamicObject expenseitemedit = (DynamicObject)this.getModel().getValue("expenseitemedit");
                if (null != expenseitemedit) {
                    Long expenseitemeditPkValue = (Long)expenseitemedit.getPkValue();
                    QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costcompanyPkValue);
                    QFilter[] andQFilter = new QFilter[]{baseDataFilter, QFilter.of((String)"id=?", (Object[])new Object[]{expenseitemeditPkValue})};
                    boolean exists = QueryServiceHelper.exists((String)"er_expenseitemedit", (QFilter[])andQFilter);
                    if (!exists) {
                        this.getModel().setValue("expenseitemedit", null);
                    }
                }
                if (null == (bdproject = (DynamicObject)this.getModel().getValue("bdproject"))) break;
                Long bdprojectPkValue = (Long)bdproject.getPkValue();
                QFilter bdProjectFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", (Long)costcompanyPkValue);
                QFilter[] bdProjectAndQFilter = new QFilter[]{bdProjectFilter, QFilter.of((String)"id=?", (Object[])new Object[]{bdprojectPkValue})};
                boolean bdProjectExists = QueryServiceHelper.exists((String)"bd_project", (QFilter[])bdProjectAndQFilter);
                if (bdProjectExists) break;
                this.getModel().setValue("bdproject", null);
                break;
            }
            case "currency": {
                this.changeExchangeRate((DynamicObject)propValue, null);
                break;
            }
            case "targetbillcurrency": {
                this.changeExchangeRate(null, (DynamicObject)propValue);
                break;
            }
            case "expenseitem": {
                this.refreshTripDate();
                this.refreshSeatGrade(propValue);
                break;
            }
            case "startdate": {
                this.refreshTripDate();
                break;
            }
            case "tripcheckindate": {
                this.refreshTripDate();
                break;
            }
            case "tripdeparturedate": {
                this.refreshTripDate();
            }
        }
    }

    private String getBillTypeId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object billTypeId = this.getBillTypeIdByLayOutForm(formShowParameter.getFormId());
        if (billTypeId != null) {
            return billTypeId.toString();
        }
        return null;
    }

    private String getFormid() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fromid = formShowParameter.getFormId();
        if ("er_expense_recordbill".equals(fromid)) {
            return "er_expense_recordbill";
        }
        if ("er_trip_recordbill".equals(fromid)) {
            return "er_trip_recordbill";
        }
        if ("er_expense_recordbill_mob".equals(fromid)) {
            return "er_expense_recordbill";
        }
        if ("er_trip_recordbill_mob".equals(fromid)) {
            return "er_trip_recordbill";
        }
        return null;
    }

    private void changeExchangeRate(DynamicObject originCurrency, DynamicObject standardCurrency) {
        DynamicObject tempOriginCurrency = originCurrency == null ? (DynamicObject)this.getModel().getValue("currency") : originCurrency;
        DynamicObject tempStandardCurrency = standardCurrency == null ? (DynamicObject)this.getModel().getValue("targetbillcurrency") : standardCurrency;
        DynamicObject companyI = (DynamicObject)this.getModel().getValue("company");
        BigDecimal exchangeRate = CommonServiceHelper.getExchangeRateFromSysParams((Long)ErCommonUtils.getPk((Object)tempOriginCurrency), (Long)ErCommonUtils.getPk((Object)tempStandardCurrency), (Long)ErCommonUtils.getPk((Object)companyI), (Object)this.getModel());
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
    }

    private Object getBillTypeIdByLayOutForm(String formId) {
        List pks;
        QFilter qFilter = null;
        if ("er_expense_recordbill".equals(formId)) {
            qFilter = new QFilter("number", "=", (Object)"er_expensepool_recordbill_BT_S");
        } else if ("er_trip_recordbill".equals(formId)) {
            qFilter = new QFilter("number", "=", (Object)"er_trip_recordbill_BT_S");
        } else if ("er_expense_recordbill_mob".equals(formId)) {
            qFilter = new QFilter("number", "=", (Object)"er_expensepool_recordbill_BT_S");
        } else if ("er_trip_recordbill_mob".equals(formId)) {
            qFilter = new QFilter("number", "=", (Object)"er_trip_recordbill_BT_S");
        }
        if (qFilter != null && !(pks = QueryServiceHelper.queryPrimaryKeys((String)"bos_billtype", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1)).isEmpty()) {
            return pks.get(0);
        }
        return null;
    }

    private void costDeptChange(DynamicObject costDept) {
        if (costDept == null) {
            return;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("company");
        CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
        this.getModel().setValue("costcompany", (Object)costCompanyId);
    }

    private void setProjectF7Filter() {
        BasedataEdit projectF7 = (BasedataEdit)this.getControl("bdproject");
        if (projectF7 != null) {
            projectF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeProjectF7SelectListener((Long)((DynamicObject)this.getModel().getValue("applier")).getPkValue(), (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
        }
    }

    private void costDeptF7Filter() {
        IDataModel costdeptScope = this.getModel();
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(costdeptScope);
        if (costDeptF7 != null) {
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    private void costCompanyFilter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        Object costDept = this.getModel().getValue("costdept");
        Object company = this.getModel().getValue("company");
        if (costCompanyF7 != null && costDept != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    private void costExpenseitemeditT7Filter() {
        BasedataEdit costExpenseitemeditF7 = (BasedataEdit)this.getControl("expenseitemedit");
        BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
        if (costExpenseitemeditF7 != null) {
            costExpenseitemeditF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    private void refreshTripDate() {
        if (!ErEntityTypeUtils.isTripRecordBill((String)this.getView().getEntityId())) {
            return;
        }
        DynamicObject tripItem = (DynamicObject)this.getModel().getValue("expenseitem");
        if (tripItem == null) {
            return;
        }
        Date startDate = null;
        Date endDate = null;
        String attribute = tripItem.getString("attribute");
        if (this.getVehicleset().contains(attribute)) {
            endDate = startDate = (Date)this.getModel().getValue("startdate");
        } else if (StringUtils.equals((String)attribute, (String)"5")) {
            startDate = (Date)this.getModel().getValue("tripcheckindate");
            endDate = (Date)this.getModel().getValue("tripdeparturedate");
        } else {
            endDate = startDate = (Date)this.getModel().getValue("happendate");
        }
        if (startDate != null && endDate != null) {
            String start = DateFormatUtils.format((Date)startDate, (String)"yyyy/MM/dd");
            String end = DateFormatUtils.format((Date)endDate, (String)"yyyy/MM/dd");
            String tripDate = start + "-" + end;
            this.getModel().setValue("tripdateareatext", (Object)tripDate);
        }
    }

    protected Set<String> getVehicleset() {
        return this.vehicleset;
    }

    private void refreshSeatGrade(Object propValue) {
        Set invoiceList;
        DynamicObject tripItem = (DynamicObject)propValue;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expItemSeatGrade = dataEntity.getDynamicObjectCollection("tripmulseatgrade");
        if (tripItem == null) {
            model.setValue("tripmulseatgrade", null);
            return;
        }
        String attribute = tripItem.getString("attribute");
        if (!(StringUtils.equals((String)"2", (String)attribute) || StringUtils.equals((String)"4", (String)attribute) || StringUtils.equals((String)"7", (String)attribute))) {
            model.setValue("tripmulseatgrade", null);
            return;
        }
        if (expItemSeatGrade.isEmpty() && !(invoiceList = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> StringUtils.isNotBlank((String)invoiceEntry.getString("seatgrade"))).map(invoiceEntry -> invoiceEntry.getString("seatgrade")).collect(Collectors.toSet())).isEmpty()) {
            DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute((String)attribute, invoiceList);
            if (seatGradeArr != null && seatGradeArr.length > 0) {
                Label tripMulseatgradeLabe;
                Object[] seats = Arrays.stream(seatGradeArr).map(seat -> seat.getPkValue()).toArray();
                Object[] name = Arrays.stream(seatGradeArr).map(seat -> seat.get("name")).toArray();
                model.setValue("tripmulseatgrade", (Object)seats);
                if (name.length > 0 && (tripMulseatgradeLabe = (Label)this.getControl("tripmulseatgrade_labe")) != null) {
                    tripMulseatgradeLabe.setText(name[0].toString());
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"tripmulseatgrade_labe"});
                }
            } else {
                model.setValue("tripmulseatgrade", null);
            }
        }
    }
}

