/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.FieldEdit;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.daily.web.util.ShowUserInfoUtils;
import kd.fi.er.formplugin.pool.BaseExpesePoolBillPlugin;
import org.apache.commons.lang.StringUtils;

public class ExpensePoolBillPlugIn
extends BaseExpesePoolBillPlugin {
    private static final String TOTALTICKETMOUNTLABEL = "totalticketmountlabel";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ShowUserInfoUtils.initUserInfo((IDataModel)model, (IFormView)view);
        if (this.invoiceCloudEnabled()) {
            view.setVisible(Boolean.valueOf(true), new String[]{"invoice_entry_container"});
            view.setVisible(Boolean.valueOf(true), new String[]{"selectinvoiceallinone"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"invoice_entry_container"});
            view.setVisible(Boolean.valueOf(false), new String[]{"selectinvoiceallinone"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object propOldValue = valueSet[0].getOldValue();
        IDataModel dataModel = this.getModel();
        switch (propName = e.getProperty().getName()) {
            case "taxamount": {
                this.whenTaxAmountChanged();
                break;
            }
            case "expenseamount": 
            case "taxrate": 
            case "airportconstructionfee": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "expenseitemedit": {
                if (dataModel.getValue("expenseitemedit") != null) break;
                dataModel.setValue("expenseitemedit", null);
                break;
            }
            case "expenseitem": {
                DynamicObject expenseitems = (DynamicObject)dataModel.getValue("expenseitem");
                if (expenseitems == null) break;
                String attribute = expenseitems.getString("attribute");
                if (!"2".equals(attribute)) {
                    dataModel.setValue("airportconstructionfee", (Object)BigDecimal.ZERO);
                }
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "tripto": 
            case "tripcityfield": {
                DynamicObject to = (DynamicObject)propValue;
                if (to == null) break;
                Long toCityId = (Long)to.getPkValue();
                MainEntityType dataEntityType = dataModel.getDataEntityType();
                String orgProp = ((BasedataProp)dataEntityType.getProperty("triparea")).getOrgProp();
                ErCommonUtils.getPk((Object)dataModel.getValue(orgProp));
                ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(toCityId, ErCommonUtils.getPk((Object)dataModel.getValue(orgProp)));
                if (tripArea == null) break;
                dataModel.setValue("triparea", tripArea.getPkValue());
                break;
            }
            case "vehicle": {
                this.getModel().setValue("tripmulseatgrade", null);
                break;
            }
            case "currency": {
                if (dataModel.getValue("currency") != null || propOldValue == null) break;
                dataModel.setValue("currency", propOldValue);
                break;
            }
            case "tripcheckindate": {
                Date tripdeparturedate;
                if (dataModel.getValue("tripcheckindate") == null && propOldValue != null) {
                    dataModel.setValue("tripcheckindate", propOldValue);
                    break;
                }
                Date tripcheckindate = (Date)dataModel.getValue("tripcheckindate");
                if (this.belongCalendar(tripcheckindate, tripdeparturedate = (Date)dataModel.getValue("tripdeparturedate"))) break;
                String message = ResManager.loadKDString((String)"\u5165\u4f4f\u65f6\u95f4\u4e0d\u5f97\u665a\u4e8e\u79bb\u5e97\u65f6\u95f4\u3002", (String)"ExpensePoolBillPlugIn_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                FieldTip timeTip = new FieldTip(FieldTip.FieldTipType.Info, "tripcheckindate", message);
                this.getView().showFieldTip(timeTip);
                dataModel.setValue("tripcheckindate", (Object)"");
                break;
            }
            case "tripdeparturedate": {
                Date tripdeparturedate;
                if (dataModel.getValue("tripdeparturedate") == null && propOldValue != null) {
                    dataModel.setValue("tripdeparturedate", propOldValue);
                    break;
                }
                Date tripcheckindate = (Date)dataModel.getValue("tripcheckindate");
                if (this.belongCalendar(tripcheckindate, tripdeparturedate = (Date)dataModel.getValue("tripdeparturedate"))) break;
                String message = ResManager.loadKDString((String)"\u79bb\u5e97\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u5165\u4f4f\u65f6\u95f4\u3002", (String)"ExpensePoolBillPlugIn_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                FieldTip timeTip = new FieldTip(FieldTip.FieldTipType.Info, "tripdeparturedate", message);
                this.getView().showFieldTip(timeTip);
                dataModel.setValue("tripdeparturedate", (Object)"");
            }
        }
    }

    public boolean belongCalendar(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            return true;
        }
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return !begin.after(end);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (StringUtils.equals((String)"invoiceentry", (String)e.getEntryProp().getName())) {
            IDataModel model = this.getModel();
            this.showPayAmount(model, (Label)this.getControl("totalencashamountlabel"), (Label)this.getControl(TOTALTICKETMOUNTLABEL));
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
            StringBuilder invoicenoSb = new StringBuilder();
            StringBuilder invoicelinkSb = new StringBuilder();
            if (!invoiceHeadEntryDOs.isEmpty()) {
                for (DynamicObject invoiceentry : invoiceHeadEntryDOs) {
                    invoicelinkSb.append(invoiceentry.get("invoicecode")).append(",");
                    invoicenoSb.append(invoiceentry.get("invoiceno")).append(",");
                }
                invoicelinkSb.deleteCharAt(invoicelinkSb.lastIndexOf(","));
                invoicenoSb.deleteCharAt(invoicenoSb.lastIndexOf(","));
            } else {
                model.setValue("taxrate", null);
            }
            model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)invoicelinkSb.toString()));
            model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedLenStr((String)invoicenoSb.toString(), (int)129));
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
    }

    private void showPayAmount(IDataModel dataModel, Label encashamountlabel, Label totalticketmountlabel) {
        DynamicObjectCollection collection = dataModel.getEntryEntity("invoiceentry");
        BigDecimal sumtotal = BigDecimal.ZERO;
        for (DynamicObject o : collection) {
            sumtotal = sumtotal.add(o.getBigDecimal("totalamount"));
        }
        int ticket = collection.size();
        totalticketmountlabel.setText(String.valueOf(ticket));
        String currencySign = "";
        int amountPrecition = 4;
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
        }
        String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)sumtotal, (int)amountPrecition);
        encashamountlabel.setText(amountStr);
    }

    private void whenTaxAmountChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmountAppOri = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal taxAmount = (BigDecimal)dataModel.getValue("taxamount");
        BigDecimal noTaxAmount = expenseAmountAppOri.subtract(taxAmount);
        dataModel.beginInit();
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        dataModel.endInit();
        this.getView().updateView("orientryamount");
    }

    private void whenTaxRateOrExpenseAppAmoutChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal expenseTaxrate = (BigDecimal)dataModel.getValue("taxrate");
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)dataModel.getValue("currency");
        int precision = expenseCurrencyDO.getInt("amtprecision");
        BigDecimal airportConstructionAmount = (BigDecimal)dataModel.getValue("airportconstructionfee");
        BigDecimal taxAmount = expenseAmount.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        BigDecimal noTaxAmount = expenseAmount.subtract(taxAmount);
        dataModel.setValue("taxamount", (Object)taxAmount);
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        this.getView().updateView("taxamount");
        this.getView().updateView("orientryamount");
    }

    protected void proxyamtchange(int rowIndex, IDataModel dataModel) {
        if (dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null) {
            BigDecimal oriproxyamt = (BigDecimal)dataModel.getValue("proxyamt", rowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)oriproxyamt, (String)"curproxyamt", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
        }
    }

    private boolean invoiceCloudEnabled() {
        Object org = this.getModel().getValue("costcompany");
        long orgid = 0L;
        if (org == null) {
            return true;
        }
        orgid = ((DynamicObject)org).getLong("id");
        boolean invoiceCloudEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)orgid);
        return invoiceCloudEnabled;
    }

    private void changeMustInput(DynamicObject expenseItem) {
        String attribute;
        switch (attribute = expenseItem.getString("attribute")) {
            case "2": 
            case "3": 
            case "4": 
            case "7": {
                this.setFieldMustInput("startdate", "tripfrom", "tripto");
                this.setFieldNotMustInput("tripcheckindate", "tripdeparturedate", "tripcityfield");
                break;
            }
            case "5": {
                this.setFieldMustInput("tripcheckindate", "tripdeparturedate", "tripcityfield");
                this.setFieldNotMustInput("startdate", "tripfrom", "tripto");
                break;
            }
            default: {
                this.setFieldNotMustInput("startdate", "tripfrom", "tripto", "tripcheckindate", "tripdeparturedate", "tripcityfield");
            }
        }
    }

    private void setFieldMustInput(String ... mustInputField) {
        Arrays.stream(mustInputField).forEach(field -> ((FieldEdit)this.getView().getControl(field)).setMustInput(true));
    }

    private void setFieldNotMustInput(String ... notMustInput) {
        Arrays.stream(notMustInput).forEach(field -> ((FieldEdit)this.getView().getControl(field)).setMustInput(false));
    }
}

