/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.pool.reim.util.ReimBotpUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import org.apache.commons.lang3.StringUtils;

public class AbstractReimPoolToReimburseBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(AbstractReimPoolToReimburseBotpPlugin.class);
    private static final Set<String> NOTNEEDMAPFIELD = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"costcompany", "costdept"}));

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject bill = e.getTargetDataEntity();
        DynamicObjectCollection itemColl = bill.getDynamicObjectCollection("expenseentryentity");
        Set srcRecordId = itemColl.stream().map(item -> item.getLong("wbsrcbillid")).collect(Collectors.toSet());
        QFilter qfId = new QFilter("id", "not in", srcRecordId);
        QFilter qFilter = e.getPlugFilter();
        if (qFilter == null) {
            qFilter = qfId;
        } else {
            qFilter.and(qfId);
        }
        String filter = ErStdConfig.getRecordPoolDrawFilter();
        if (StringUtils.equals((CharSequence)filter, (CharSequence)"1")) {
            DynamicObject currency = bill.getDynamicObject("currency");
            qFilter.and(new QFilter("targetbillcurrency", "=", (Object)ErCommonUtils.getPk((Object)currency)));
        } else if (StringUtils.equals((CharSequence)filter, (CharSequence)"2")) {
            DynamicObject costcompany = bill.getDynamicObject("costcompany");
            qFilter.and(new QFilter("costcompany", "=", (Object)ErCommonUtils.getPk((Object)costcompany)));
        }
        QFilter qfCreator = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        qFilter.and(qfCreator);
        e.setPlugFilter(qFilter);
        this.printLogger("qFilter\uff1a" + qFilter);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] itemRows = e.getTargetExtDataEntitySet().FindByEntityKey("expenseentryentity");
        this.printLogger("generate expense data\uff1a" + itemRows.length);
        Set mapFieldSet = this.getRule().getFieldMapPolicy().getFieldMaps().stream().map(item -> item.getTargetFieldKey()).collect(Collectors.toSet());
        ReimBotpUtils.handleHead(NOTNEEDMAPFIELD, (ExtendedDataEntity[])e.getTargetExtDataEntitySet().FindByEntityKey(this.getTargetNumber()), mapFieldSet);
        Map<Long, Set<Long>> targetCostDeptPkIds = this.getTargetCostDeptPkId(e.getTargetExtDataEntitySet());
        Map costDeptIdAndItemIdsMap = ReimBotpUtils.getCostAllowUseItemIds((String)this.getTargetNumber(), targetCostDeptPkIds);
        for (int i = 0; i < itemRows.length; ++i) {
            DynamicObject entrycostdept = itemRows[i].getDataEntity().getDynamicObject("entrycostdept");
            if (entrycostdept == null) continue;
            Set expenseItemIds = (Set)costDeptIdAndItemIdsMap.get(entrycostdept.getPkValue());
            List extItem = ReimBotpUtils.expenseOfWriteOffApply((DynamicObject)itemRows[i].getDataEntity());
            expenseItemIds.addAll(extItem);
            this.printLogger("costdept\uff1a" + targetCostDeptPkIds + "\uff0cexpenseitem\uff1a" + expenseItemIds);
            DynamicObject expenseItem = itemRows[i].getDataEntity().getDynamicObject("expenseitem");
            if (expenseItem == null || expenseItemIds.contains(expenseItem.getPkValue())) continue;
            itemRows[i].getDataEntity().set("expenseitem", null);
        }
        this.refreshInvoiceEntry(e.getTargetExtDataEntitySet());
    }

    protected void refreshInvoiceEntry(ExtendedDataEntitySet dataEntitySet) {
        Set mapFieldSet = this.getRule().getFieldMapPolicy().getFieldMaps().stream().map(item -> item.getTargetFieldKey()).collect(Collectors.toSet());
        ExtendedDataEntity[] extendedDataEntities = dataEntitySet.FindByEntityKey(this.getTargetNumber());
        this.setAndGetSelectedRowEntryId(extendedDataEntities);
        ExtendedDataEntity[] targetItemEntrys = dataEntitySet.FindByEntityKey("expenseentryentity");
        if (targetItemEntrys == null || targetItemEntrys.length == 0) {
            return;
        }
        this.setAndGetSelectedRowEntryId(targetItemEntrys);
        Set convertItemIds = Arrays.stream(targetItemEntrys).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        HashMap sItemIdAndTItemId = Maps.newHashMapWithExpectedSize((int)targetItemEntrys.length);
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            DynamicObject currency = targetBill.getDynamicObject("currency");
            DynamicObject company = targetBill.getDynamicObject("company");
            if (currency == null || !mapFieldSet.contains("currency")) {
                currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Long)ErCommonUtils.getPk((Object)company));
                targetBill.set("currency", (Object)currency);
            }
            this.printLogger("basecurrency: " + currency);
            DynamicObjectCollection expenseEntry = targetBill.getDynamicObjectCollection("expenseentryentity");
            Set allCurrencyIds = expenseEntry.stream().map(item -> ErCommonUtils.getPk((Object)item.get("entrycurrency"))).collect(Collectors.toSet());
            if (allCurrencyIds.size() > 1) {
                targetBill.set("iscurrency", (Object)true);
            } else if (allCurrencyIds.size() == 1 && !mapFieldSet.contains("iscurrency")) {
                Long entryId = (Long)allCurrencyIds.stream().findFirst().get();
                Long currencyId = ErCommonUtils.getPk((Object)currency);
                if (Longs.compare((long)currencyId, (long)entryId) != 0) {
                    targetBill.set("iscurrency", (Object)true);
                }
            }
            DynamicObjectCollection itemEntity = targetBill.getDynamicObjectCollection("expenseentryentity");
            for (int j = 0; j < itemEntity.size(); ++j) {
                String invoiceNo;
                DynamicObject item2 = (DynamicObject)itemEntity.get(j);
                Long tarEntryid = (Long)item2.getPkValue();
                if (!convertItemIds.contains(tarEntryid)) continue;
                Long srcBillid = item2.getLong("wbsrcbillid");
                item2.set("wbsrcbilltype", (Object)this.getSrcMainType().getName());
                sItemIdAndTItemId.put(srcBillid, tarEntryid);
                if (!mapFieldSet.contains("exchangerate")) {
                    DynamicObject entryCurrency = item2.getDynamicObject("entrycurrency");
                    BigDecimal exchangeRate = CommonServiceHelper.getExchangeRateFromSysParams((Long)ErCommonUtils.getPk((Object)entryCurrency), (Long)ErCommonUtils.getPk((Object)currency), (Long)ErCommonUtils.getPk((Object)company), (Object)targetBill);
                    this.printLogger("currency\uff1a" + entryCurrency + " , taxrate\uff1a" + exchangeRate);
                    item2.set("exchangerate", (Object)exchangeRate);
                }
                if (!StringUtils.isNotBlank((CharSequence)(invoiceNo = item2.getString("invoiceno_entry")))) continue;
                item2.set("itemfrom", (Object)ItemFrom.InvoiceCloud.getValue());
            }
            ExtendedDataEntity[] targetInvoiceEntry = dataEntitySet.FindByEntityKey("invoiceentry");
            this.setAndGetSelectedRowEntryId(targetInvoiceEntry);
            Set convertInviceIds = Arrays.stream(targetInvoiceEntry).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
            this.printLogger("generate invoice data\uff1a" + targetInvoiceEntry.length);
            if (targetInvoiceEntry == null || targetInvoiceEntry.length == 0) continue;
            DynamicObjectCollection invoiceEntry = targetBill.getDynamicObjectCollection("invoiceentry");
            ExtendedDataEntity[] targetInvoiceItemEntry = dataEntitySet.FindByEntityKey("invoiceitementry");
            this.setAndGetSelectedRowEntryId(targetInvoiceItemEntry);
            Set convertInviceItemIds = Arrays.stream(targetInvoiceItemEntry).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
            HashMap sInvocieIdAndTInvocieId = Maps.newHashMapWithExpectedSize((int)targetInvoiceEntry.length);
            for (DynamicObject invoice : invoiceEntry) {
                Long tarEntryid = (Long)invoice.getPkValue();
                if (!convertInviceIds.contains(tarEntryid)) continue;
                Long srcEntryid = invoice.getLong("invoicesrcentryid");
                invoice.set("invoicesrcbilltype", (Object)this.getSrcMainType().getName());
                sInvocieIdAndTInvocieId.put(srcEntryid, tarEntryid);
            }
            DynamicObjectCollection invoiceItemEntry = targetBill.getDynamicObjectCollection("invoiceitementry");
            for (DynamicObject invoiceItem : invoiceItemEntry) {
                if (!convertInviceItemIds.contains(invoiceItem.getPkValue())) continue;
                Long itemId = invoiceItem.getLong("itementryid");
                Long targetItemEntryId = (Long)sItemIdAndTItemId.get(itemId);
                invoiceItem.set("itementryid", (Object)targetItemEntryId);
                Long invoiceId = invoiceItem.getLong("invoiceheadentryid");
                Long targetInvoiceEntryId = (Long)sInvocieIdAndTInvocieId.get(invoiceId);
                invoiceItem.set("invoiceheadentryid", (Object)targetInvoiceEntryId);
            }
            this.printLogger("expenseEntityMap: " + sItemIdAndTItemId + " , invoiceEntryMapid\uff1a" + sInvocieIdAndTInvocieId);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTargetNumber());
        ExtendedDataEntity[] targetItemEntrys = e.getTargetExtDataEntitySet().FindByEntityKey("expenseentryentity");
        if (targetItemEntrys == null || targetItemEntrys.length == 0) {
            return;
        }
        Set convertItemIds = Arrays.stream(targetItemEntrys).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        ExtendedDataEntity[] targetInvoiceEntry = e.getTargetExtDataEntitySet().FindByEntityKey("invoiceentry");
        if (targetInvoiceEntry == null || targetInvoiceEntry.length == 0) {
            return;
        }
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            Map invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo((DynamicObject)targetBill);
            DynamicObjectCollection invoiceEntry = targetBill.getDynamicObjectCollection("invoiceentry");
            DynamicObjectCollection itemEntity = targetBill.getDynamicObjectCollection("expenseentryentity");
            for (int j = 0; j < itemEntity.size(); ++j) {
                Set invoiceIds;
                DynamicObject item2 = (DynamicObject)itemEntity.get(j);
                Long tarEntryid = (Long)item2.getPkValue();
                if (!convertItemIds.contains(tarEntryid) || (invoiceIds = (Set)invoiceItemMap.get(tarEntryid)) == null) continue;
                String type = invoiceEntry.stream().filter(itemTemp -> invoiceIds.contains(ErCommonUtils.getPk((Object)itemTemp))).findFirst().get().getString("invoicetype");
                item2.set("invoicetypeitem", (Object)type);
                InvoiceOffsetUtils.refreshItemsOffset((DynamicObject)targetBill, (BillExpenseInfoFildKeyType)BillExpenseInfoFildKeyType.DailyReimburse, (int)j, (int)0);
            }
        }
    }

    private void setAndGetSelectedRowEntryId(ExtendedDataEntity[] itemRows) {
        if (itemRows == null || itemRows.length == 0) {
            return;
        }
        long[] ids = ORM.create().genLongIds(itemRows[0].getDataEntity().getDataEntityType(), itemRows.length);
        for (int i = 0; i < itemRows.length; ++i) {
            Long pkid = (Long)itemRows[i].getDataEntity().getPkValue();
            if (pkid != null && pkid != 0L) continue;
            itemRows[i].setValue("id", (Object)ids[i]);
        }
    }

    protected String getTargetNumber() {
        return this.getTgtMainType().getName();
    }

    protected Map<Long, Set<Long>> getTargetCostDeptPkId(ExtendedDataEntitySet dataEntitySet) {
        ExtendedDataEntity[] extendedDataEntities = dataEntitySet.FindByEntityKey(this.getTargetNumber());
        ExtendedDataEntity[] itemRows = dataEntitySet.FindByEntityKey("expenseentryentity");
        HashMap targetCostDeptPkIds = Maps.newHashMapWithExpectedSize((int)itemRows.length);
        if (itemRows == null || itemRows.length == 0) {
            return targetCostDeptPkIds;
        }
        Set convertItemIds = Arrays.stream(itemRows).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        boolean isDraw = ConvertOpType.Draw == this.getOpType();
        boolean isPush = ConvertOpType.Push == this.getOpType();
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            DynamicObject company = targetBill.getDynamicObject("company");
            if (company == null) {
                logger.info("\u4e0b\u6e38\u5355\u636e\u5355\u5934\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a");
                return targetCostDeptPkIds;
            }
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            DynamicObjectCollection entityColl = targetBill.getDynamicObjectCollection("expenseentryentity");
            if (isDraw && showType == 1) {
                DynamicObject costcompany = targetBill.getDynamicObject("costcompany");
                DynamicObject costdept = targetBill.getDynamicObject("costdept");
                for (DynamicObject entity : entityColl) {
                    if (!convertItemIds.contains(ErCommonUtils.getPk((Object)entity))) continue;
                    entity.set("entrycostdept", (Object)costdept);
                    entity.set("entrycostcompany", (Object)costcompany);
                }
            }
            if (isPush || isDraw && showType == 2) {
                DynamicObject entrycostcompany = ((DynamicObject)entityColl.get(0)).getDynamicObject("entrycostcompany");
                DynamicObject entrycostdept = ((DynamicObject)entityColl.get(0)).getDynamicObject("entrycostdept");
                targetBill.set("costdept", (Object)entrycostdept);
                targetBill.set("costcompany", (Object)entrycostcompany);
            }
            for (DynamicObject entity : entityColl) {
                Long entryCompanyId = ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycostcompany"));
                Long entryCostDeptId = ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycostdept"));
                Set deptSet = (Set)targetCostDeptPkIds.get(entryCompanyId);
                if (deptSet == null) {
                    deptSet = Sets.newHashSetWithExpectedSize((int)entityColl.size());
                    targetCostDeptPkIds.put(entryCompanyId, deptSet);
                }
                deptSet.add(entryCostDeptId);
            }
        }
        return targetCostDeptPkIds;
    }

    protected void printLogger(String info) {
        String fmt = "operationType\uff1a%s, sourcebill\uff1a%s, targetbill\uff1a%s, botpRuleId:%s, information\uff1a";
        logger.info(String.format(fmt, this.getOpType(), this.getSrcMainType().getName(), this.getTgtMainType().getName(), this.getRule().getId(), info));
    }
}

