/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.mobile;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.pool.BaseExpesePoolBillPlugin;
import kd.fi.er.formplugin.pool.mobile.OpenFormUtil;
import org.apache.commons.lang.StringUtils;

public class ExpensePoolBillMobPlugIn
extends BaseExpesePoolBillPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        MenuItem mbaritemap1 = (MenuItem)this.getControl("mbaritemap1");
        if (customParams != null && customParams.get("css") != null) {
            String css = customParams.get("css").toString();
            mbaritemap1.setCustomeStyles(css);
            this.setControlColor(this.getView(), "mbaritemap1", "#5099f2", "#FFFFFF");
            this.setControlColor(this.getView(), "bar_save", "#FAFAFA", "#636466");
        } else {
            this.setControlColor(this.getView(), "bar_save", "#5099f2", "#FFFFFF");
        }
    }

    public void afterBindData(EventObject e) {
        BasedataEdit expenseitem;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company != null) {
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            model.setDataChanged(dataChanged);
            if (showType == 1) {
                BasedataEdit costdept = (BasedataEdit)this.getControl("costdept");
                costdept.setMustInput(true);
                BasedataEdit costcompany = (BasedataEdit)this.getControl("costcompany");
                costcompany.setMustInput(true);
            }
            this.getModel().getDataEntity().getDataEntityState().isPushChanged();
            model.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"writeoffapply");
        }
        this.showTripInfo();
        String viewName = this.getView().getFormShowParameter().getFormId();
        if ("er_trip_recordbill_mob".equals(viewName) && (expenseitem = (BasedataEdit)this.getView().getControl("expenseitem")) != null) {
            expenseitem.setMustInput(true);
        }
        this.showInvoiceLabelAmount(this.getModel(), (Label)this.getControl("amount_label"));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"amount_label", "mbaritemap1", "bar_save", "mbaritemap"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "amount_label": {
                OpenFormUtil.openMobileDynamicPage(this.getView(), ResManager.loadKDString((String)"\u91d1\u989d\u4fe1\u606f", (String)"ExpensePoolBillMobPlugIn_9", (String)"fi-er-formplugin", (Object[])new Object[0]), "er_expense_info_mb", ShowType.Floating, null, new CloseCallBack((IFormPlugin)this, "er_expense_recordbill"));
                break;
            }
            case "bar_save": {
                this.setControlColor(this.getView(), "bar_save", "#5099f2", "#FFFFFF");
                this.setControlColor(this.getView(), "mbaritemap1", "#FAFAFA", "#636466");
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Control && org.apache.commons.lang3.StringUtils.equals((CharSequence)((Control)source).getKey(), (CharSequence)"mbaritemap")) {
            this.getView().returnDataToParent((Object)"showMyExpense");
        }
    }

    private void setControlColor(IFormView view, String key, String backColor, String foreColor) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isBlank((String)foreColor)) {
            map.put("fc", foreColor);
        }
        if (!StringUtils.isBlank((String)backColor)) {
            map.put("bc", backColor);
        }
        view.updateControlMetadata(key, map);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IDataModel dataModel = this.getModel();
        switch (actionId) {
            case "er_expense_recordbill": {
                Map returnData = (Map)e.getReturnData();
                if (returnData == null) break;
                dataModel.setValue("expenseamount", returnData.get("expenseamount"));
                dataModel.setValue("taxrate", returnData.get("taxrate"));
                dataModel.setValue("taxamount", returnData.get("taxamount"));
                dataModel.setValue("happendate", returnData.get("happendate"));
                dataModel.setValue("currency", returnData.get("currency"));
                dataModel.setValue("airportconstructionfee", returnData.get("airportconstructionfee"));
                this.showInvoiceLabelAmount(this.getModel(), (Label)this.getControl("amount_label"));
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel dataModel = this.getModel();
        switch (propName = e.getProperty().getName()) {
            case "taxamount": {
                this.whenTaxAmountChanged();
                break;
            }
            case "expenseamount": {
                this.showInvoiceLabelAmount(this.getModel(), (Label)this.getControl("amount_label"));
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "taxrate": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "expenseitemedit": {
                if (dataModel.getValue("expenseitemedit") != null) break;
                dataModel.setValue("expenseitemedit", null);
                break;
            }
            case "tripto": {
                DynamicObject to = (DynamicObject)propValue;
                if (to == null) break;
                Long toCityId = (Long)to.getPkValue();
                MainEntityType dataEntityType = dataModel.getDataEntityType();
                String orgProp = ((BasedataProp)dataEntityType.getProperty("triparea")).getOrgProp();
                ErCommonUtils.getPk((Object)dataModel.getValue(orgProp));
                ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(toCityId, ErCommonUtils.getPk((Object)dataModel.getValue(orgProp)));
                if (tripArea == null) break;
                dataModel.setValue("triparea", tripArea.getPkValue());
            }
        }
    }

    private void whenTaxAmountChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmountAppOri = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal taxAmount = (BigDecimal)dataModel.getValue("taxamount");
        BigDecimal noTaxAmount = expenseAmountAppOri.subtract(taxAmount);
        dataModel.beginInit();
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        dataModel.endInit();
        this.getView().updateView("orientryamount");
    }

    private void whenTaxRateOrExpenseAppAmoutChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal expenseTaxrate = (BigDecimal)dataModel.getValue("taxrate");
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)dataModel.getValue("currency");
        int precision = expenseCurrencyDO.getInt("amtprecision");
        BigDecimal airportConstructionAmount = (BigDecimal)dataModel.getValue("airportconstructionfee");
        BigDecimal taxAmount = expenseAmount.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        BigDecimal noTaxAmount = expenseAmount.subtract(taxAmount);
        dataModel.setValue("taxamount", (Object)taxAmount);
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        this.getView().updateView("taxamount");
        this.getView().updateView("orientryamount");
    }

    protected void proxyamtchange(int rowIndex, IDataModel dataModel) {
        if (dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null) {
            BigDecimal oriproxyamt = (BigDecimal)dataModel.getValue("proxyamt", rowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)oriproxyamt, (String)"curproxyamt", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
        }
    }

    public static void initUserInfo(IDataModel model, IFormView view) {
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        if (applier == null) {
            RequestContext requestContext = RequestContext.get();
            Long currentUserID = Long.valueOf(requestContext.getUserId());
            Map billMap = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
            CoreBaseBillServiceHelper.extService((IFormView)view, (Map)billMap);
            CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
            if (model.getValue("currency") == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"ExpensePoolBillMobPlugIn_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (model.getValue("company") == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpensePoolBillMobPlugIn_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            applier = (DynamicObject)model.getValue("applier");
        }
    }

    private void showInvoiceLabelAmount(IDataModel dataModel, Label totalencashamountlabel) {
        String currencySign = "";
        int amountPrecition = 4;
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
        }
        String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)dataModel.getDataEntity().getBigDecimal("expenseamount"), (int)amountPrecition);
        totalencashamountlabel.setText(amountStr);
    }

    protected void refreshBaseInfoLabel(String propName, Object propValue) {
        String propStr = null;
        if (propValue instanceof DynamicObject) {
            ILocaleString name = ((DynamicObject)propValue).getLocaleString("name");
            propStr = name.getLocaleValue();
        } else if (propValue instanceof String) {
            propStr = (String)propValue;
        }
        Label propControl = (Label)this.getControl(propName + "V");
        if (propControl != null) {
            propControl.setText(propStr);
        }
    }

    private void showTripInfo() {
        IDataModel model = this.getModel();
        String formid = (String)model.getValue("formid");
        Boolean isTrip = StringUtils.equals((String)formid, (String)"er_trip_recordbill");
        if (!isTrip.booleanValue()) {
            return;
        }
        this.showTripInfoLbl();
        this.showVehicleLbl();
        this.showFromToLbl();
        this.showDateLbl();
        this.showAreaLbl();
    }

    private void showTripInfoLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"tripcityfield", "tripfrom", "tripto", "trippassenger", "startdate", "tripcheckindate", "tripdeparturedate", "triparea", "tripmulseatgrade"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"trip_info_card_flex"});
    }

    private void showVehicleLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"vehicle"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"vehicle"});
    }

    private void showFromToLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"tripcityfield", "tripfrom", "tripto"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"fromto_labe"});
    }

    private void showDateLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"trippassenger", "startdate", "tripcheckindate", "tripdeparturedate"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"trip_datetime_labe"});
    }

    private void showAreaLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"triparea", "tripmulseatgrade"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"tripmulseatgrade_labe"});
    }

    private Boolean isNotNull(IDataModel model, Set<String> checkKeySet) {
        Boolean isNotNull = Boolean.FALSE;
        for (String key : checkKeySet) {
            Object value = model.getValue(key);
            if (value == null) continue;
            if (value instanceof DynamicObjectCollection) {
                if (((DynamicObjectCollection)value).isEmpty()) continue;
                isNotNull = Boolean.TRUE;
                continue;
            }
            if (value instanceof String) {
                if (StringUtils.isBlank((String)((String)value)) || StringUtils.equals((String)key, (String)"vehicle") && StringUtils.equals((String)((String)value), (String)"0")) continue;
                isNotNull = Boolean.TRUE;
                continue;
            }
            isNotNull = Boolean.TRUE;
        }
        return isNotNull;
    }
}

