/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.mobile;

import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;

@KSObject
public class OpenFormUtil {
    private OpenFormUtil() {
    }

    public static void openDynamicPage(IFormView currView, String title, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(pageKey);
        if (!StringUtils.isBlank((CharSequence)title)) {
            fsp.setCaption(title);
        }
        if (paramMap != null) {
            fsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.getOpenStyle().setShowType(showType);
        currView.showForm(fsp);
    }

    public static void openBasePage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, String targetKey, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        bsp.getOpenStyle().setTargetKey(targetKey);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public static void openListPage(IFormView currView, String pageKey, ShowType showType, Map<String, Object> paramMap, QFilter qFilter, CloseCallBack closeCallBack) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(pageKey);
        lsp.getOpenStyle().setShowType(showType);
        lsp.getListFilterParameter().setFilter(qFilter);
        if (paramMap != null) {
            lsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            lsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)lsp);
    }

    public static void openMobileDynamicPage(IFormView currView, String title, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        MobileBillShowParameter fsp = new MobileBillShowParameter();
        fsp.setHasRight(true);
        fsp.setFormId(pageKey);
        if (!StringUtils.isBlank((CharSequence)title)) {
            fsp.setCaption(title);
        }
        if (paramMap != null) {
            fsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.getOpenStyle().setShowType(showType);
        currView.showForm((FormShowParameter)fsp);
    }

    public static void openMobileFormPage(IFormView currView, String title, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        MobileFormShowParameter fsp = new MobileFormShowParameter();
        fsp.setHasRight(true);
        fsp.setFormId(pageKey);
        if (!StringUtils.isBlank((CharSequence)title)) {
            fsp.setCaption(title);
        }
        if (paramMap != null) {
            fsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.getOpenStyle().setShowType(showType);
        currView.showForm((FormShowParameter)fsp);
    }
}

