/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.print;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.fi.er.formplugin.daily.web.workflow.ErDailyWorkFlowService;

public class ErEASWorkflowPrintPlugin
extends AbstractPrintPlugin {
    private static final Map<String, String> mappingField = new HashMap<String, String>();
    private static Log logger = LogFactory.getLog(ErEASWorkflowPrintPlugin.class);

    public void afterLoadData(AfterLoadDataEvent evt) {
        WorkflowDataSource workflowDataSource;
        List easApprovalRecordItems;
        List<DataRowSet> easApproveItemDataSets;
        super.afterLoadData(evt);
        List billDataRows = evt.getDataRowSets();
        PrtDataSource dataSource = evt.getDataSource();
        String dsName = dataSource.getDsName();
        if (billDataRows.size() == 0 && dsName.contains("workflow.approveline") && dataSource instanceof WorkflowDataSource && (easApproveItemDataSets = this.buildEASApproveItemDataSet(easApprovalRecordItems = ErDailyWorkFlowService.getEASApprovalRecordItems((String)(workflowDataSource = (WorkflowDataSource)dataSource).getFormId(), (Object)workflowDataSource.getBusinessKey()), dataSource.getQueryField())) != null) {
            billDataRows.addAll(easApproveItemDataSets);
        }
    }

    private List<DataRowSet> buildEASApproveItemDataSet(List<Map<String, Object>> easApprovalRecordItems, List<String> queryFields) {
        if (easApprovalRecordItems == null || easApprovalRecordItems.size() == 0) {
            return null;
        }
        logger.info("ErEASWorkflowPrintPlugin>>>\u83b7\u53d6\u5230EAS\u5ba1\u6279\u4fe1\u606f\uff1a" + easApprovalRecordItems);
        logger.info("ErEASWorkflowPrintPlugin>>>\u6253\u5370\u6a21\u677f\u4e0a\u5206\u5f55\u7684\u5b57\u6bb5\u4e3a\uff1a" + queryFields);
        ArrayList<DataRowSet> dataRowSets = new ArrayList<DataRowSet>();
        for (Map<String, Object> easApprovalRecordItem : easApprovalRecordItems) {
            Object children = easApprovalRecordItem.get("children");
            if (children instanceof Map) {
                logger.info("ErEASWorkflowPrintPlugin>>>children\u7684\u6570\u636e\u7ed3\u6784\uff1aMap");
                dataRowSets.add(this.getDataSetByMap(queryFields, easApprovalRecordItem, (Map)children));
                continue;
            }
            if (children instanceof List) {
                logger.info("ErEASWorkflowPrintPlugin>>>children\u7684\u6570\u636e\u7ed3\u6784\uff1aList");
                List childrenList = (List)children;
                ArrayList<DataRowSet> dataRowSetList = new ArrayList<DataRowSet>(12);
                for (Map childrenMap : childrenList) {
                    dataRowSetList.add(this.getDataSetByMap(queryFields, easApprovalRecordItem, childrenMap));
                }
                dataRowSets.addAll(dataRowSetList);
                continue;
            }
            dataRowSets.add(this.getDataSetByMap(queryFields, easApprovalRecordItem, null));
            logger.info("ErEASWorkflowPrintPlugin>>>children\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u7ed3\u6784\uff1a" + children.getClass());
        }
        return dataRowSets;
    }

    private DataRowSet getDataSetByMap(List<String> queryFields, Map<String, Object> easApprovalRecordItem, Map<String, Object> childrenMap) {
        DataRowSet dataRowSet = new DataRowSet();
        for (String queryField : queryFields) {
            String mapping = mappingField.get(queryField);
            Object fieldVale = easApprovalRecordItem.get(mapping);
            if (fieldVale == null && childrenMap != null) {
                fieldVale = childrenMap.get(mapping);
            }
            logger.info("ErEASWorkflowPrintPlugin>>>\u6253\u5370\u5206\u5f55key:" + queryField + "->\u5bf9\u5e94EAS map\u7684key:" + mapping + "->\u83b7\u53d6\u7684\u503c\uff1a" + fieldVale);
            this.setDataSetIfAbsent(dataRowSet, queryField, fieldVale);
        }
        return dataRowSet;
    }

    private void setDataSetIfAbsent(DataRowSet dataSet, String fieldKey, Object field) {
        if (field instanceof String) {
            dataSet.put(fieldKey, (Field)new TextField((String)field));
        }
        if (field instanceof Date) {
            dataSet.put(fieldKey, (Field)new TextField(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)field)));
        }
    }

    static {
        mappingField.put("activityName", "aactdefname");
        mappingField.put("resultName", "resultName");
        mappingField.put("message", "message");
        mappingField.put("assignee", "userName");
        mappingField.put("time", "time");
    }
}

