/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.basedata;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ProjectTypeSettingPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"editbilltype"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("bar_save".equals(evt.getItemKey())) {
            DynamicObject[] projectTypes;
            DynamicObjectCollection erprojecttype = (DynamicObjectCollection)this.getModel().getValue("erprojecttype");
            List erprojecttypeids = erprojecttype.stream().map(e -> (Long)e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            DynamicObjectCollection currRelBills = (DynamicObjectCollection)this.getModel().getValue("erprojecttyperelbill");
            for (DynamicObject projectType : projectTypes = BusinessDataServiceHelper.load((String)"er_projecttype", (String)"id,relbill", (QFilter[])new QFilter[]{new QFilter("id", "in", erprojecttypeids)})) {
                DynamicObjectCollection dbRelBills = projectType.getDynamicObjectCollection("relbill");
                dbRelBills.clear();
                for (DynamicObject currRelBill : currRelBills) {
                    DynamicObject currRelBillId = currRelBill.getDynamicObject("fbasedataid");
                    DynamicObject dynamicObject = (DynamicObject)dbRelBills.getDynamicObjectType().createInstance();
                    dynamicObject.set("fbasedataid", (Object)currRelBillId);
                    dynamicObject.set("fbasedataid_id", currRelBillId.getPkValue());
                    dbRelBills.add((Object)dynamicObject);
                }
                projectType.set("relbill", (Object)dbRelBills);
            }
            SaveServiceHelper.save((DynamicObject[])projectTypes);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ProjectTypeSettingPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else if ("bar_refresh".equals(evt.getItemKey())) {
            this.initErProjectType();
            this.initErProjectTypeRelBill();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "editbilltype": {
                this.openEditBillType();
                break;
            }
        }
    }

    private void openEditBillType() {
        ListShowParameter formShowParameter;
        ListShowParameter listShowParameter = formShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("er_billtype");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u7c7b\u578b", (String)"ProjectTypeSettingPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "actionIdErProjectTypeSetting"));
        formShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("actionIdErProjectTypeSetting".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.initErProjectType();
            this.initErProjectTypeRelBill();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initErProjectType();
        this.initErProjectTypeRelBill();
        this.getView().updateView("erprojecttype");
        this.getView().updateView("erprojecttyperelbill");
    }

    private void initErProjectType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List projectTypeIds = (List)formShowParameter.getCustomParam("pkIds");
        DynamicObject[] projectTypes = BusinessDataServiceHelper.load((String)"er_projecttype", (String)"id,name,number,relbill,relbill.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)projectTypeIds)});
        HashSet relBillPkIds = new HashSet(16);
        if (projectTypes != null) {
            for (DynamicObject projectType : projectTypes) {
                DynamicObjectCollection relbills = (DynamicObjectCollection)projectType.get("relbill");
                Set relbillids = relbills.stream().map(a -> (Long)a.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                relBillPkIds.addAll(relbillids);
            }
        }
        this.getModel().setValue("erprojecttype", (Object)projectTypeIds.toArray());
        this.getModel().setValue("erprojecttyperelbill", (Object)relBillPkIds.toArray());
    }

    private void initErProjectTypeRelBill() {
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)"er_billtype", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        this.getModel().deleteEntryData("billtypeentry");
        DynamicObjectCollection relbills = (DynamicObjectCollection)this.getModel().getValue("erprojecttyperelbill");
        List relbillids = relbills.stream().map(e -> (Long)e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        this.getModel().beginInit();
        for (DynamicObject billType : billTypes) {
            int rowIndex = this.getModel().createNewEntryRow("billtypeentry");
            this.getModel().setValue("billtypenumber", billType.get("id"), rowIndex);
            this.getModel().setValue("billtypename", billType.get("id"), rowIndex);
            if (!relbillids.contains(billType.get("id"))) continue;
            this.getModel().setValue("setrelate", (Object)true, rowIndex);
        }
        this.getModel().endInit();
        EntryGrid entry = (EntryGrid)this.getControl("billtypeentry");
        entry.setPageIndex(1);
        this.getView().updateView("billtypeentry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (propName) {
            case "setrelate": {
                int billtypeentryindex = model.getEntryCurrentRowIndex("billtypeentry");
                DynamicObject billtypeentry = model.getEntryRowEntity("billtypeentry", billtypeentryindex);
                DynamicObjectCollection relbills = (DynamicObjectCollection)this.getModel().getValue("erprojecttyperelbill");
                Set relbillids = relbills.stream().map(a -> (Long)a.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                Long currbilltypeid = (Long)billtypeentry.get("billtypenumber.id");
                if (Boolean.TRUE.equals(newValue)) {
                    relbillids.add(currbilltypeid);
                } else {
                    relbillids.remove(currbilltypeid);
                }
                model.setValue("erprojecttyperelbill", (Object)relbillids.toArray());
                break;
            }
        }
    }
}

