/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.applypay;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import org.apache.commons.lang3.StringUtils;

public class ApplyPayMobEdit
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String IS_DELETING = "is_deleting";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"applypay_expense_delete", "applypay_expense_done"});
        AbstractGrid accountGrid = (AbstractGrid)this.getView().getControl("accountentry");
        accountGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"flexpublicreimbillno_mob"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "applypay_expense_delete": {
                this.accountDeletePageRule(true);
                this.updateExpLabel();
                break;
            }
            case "applypay_expense_done": {
                this.accountDeletePageRule(false);
                this.updateExpLabel();
                break;
            }
            case "flexpublicreimbillno_mob": {
                String publicreimbillno = (String)this.getModel().getValue("publicreimbillno");
                QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)publicreimbillno)};
                DynamicObject publicreimBill = QueryServiceHelper.queryOne((String)"er_publicreimbursebill", (String)"id", (QFilter[])filters);
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("FormId", "er_publicreimbursebill_mob");
                customParam.put("Status", BillOperationStatus.VIEW.getValue());
                customParam.put("hiddenmtoolbarap", Boolean.TRUE.toString());
                customParam.put("isDrawPreViewBill", Boolean.TRUE);
                customParam.put("billId", publicreimBill.getLong("id"));
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                formShowParameter.setCustomParams(customParam);
                formShowParameter.setFormId("er_dlbill_tabap_inh");
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)"er_publicreimbursebill_mob").getCaption().getLocaleValue());
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.accountDeletePageRule(this.isDeleting());
        CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        this.updateExpLabel();
        Container invoiceAdvContainer = (Container)this.getControl("flexpanelap2");
        invoiceAdvContainer.setCollapse(true);
    }

    private boolean isDeleting() {
        IPageCache pageCache = this.getPageCache();
        String status = pageCache.get(IS_DELETING);
        return Boolean.parseBoolean(status);
    }

    private void updateExpLabel() {
        IFormView formView = this.getView();
        Label expenseAmount = (Label)formView.getControl("label_exp_count");
        expenseAmount.setText(String.valueOf(this.getModel().getEntryEntity("expenseentryentity").size()));
        formView.updateView("label_exp_count");
    }

    private void accountDeletePageRule(boolean delete) {
        if (delete) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"applypay_expense_done"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applypay_expense_delete"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applypay_expense_done"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"applypay_expense_delete"});
        }
        this.changeDeteleAcctStatus(delete);
        CardEntry accountCard = (CardEntry)this.getControl("expenseentryentity");
        int accountEntrySize = this.getModel().getEntryRowCount("expenseentryentity");
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            accountCard.setChildVisible(delete, rowIndex, new String[]{"image_expense_delete1"});
        }
    }

    private void changeDeteleAcctStatus(boolean status) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put(IS_DELETING, String.valueOf(status));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnData;
        IDataModel model = this.getModel();
        String actionId = event.getActionId();
        if (!StringUtils.equals((CharSequence)actionId, (CharSequence)"er_applypayrecentry_mb") || (returnData = (ListSelectedRowCollection)event.getReturnData()).size() > 0) {
            // empty if block
        }
    }
}

