/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.contract;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.component.ApprovalRecord;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.field.writeoffmoney.ContractProjectWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.WriteOffFields;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import org.apache.commons.lang.StringUtils;

public class ContractBillMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String INVOICE_ATTACH_TOOLBAR = "invoicecloudtoolbar";
    private static Log logger = LogFactory.getLog(ContractBillMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_contractpart_add", "label_sign_delete", "label_sign_done", "image_sign_delete", "btn_plan_add", "btn_contractitem_add", "label_item_delete", "label_item_done", "btn_contractproject_add", "label_project_delete", "label_project_done", "label_exp_delete", "label_exp_done", "relationconpanelapl", "flex_addcontractpart", "addcontractpart"});
        AbstractGrid expenseGrid = (AbstractGrid)this.getView().getControl("expenseentryentity");
        expenseGrid.addRowClickListener((RowClickEventListener)this);
        AbstractGrid contractpartGrid = (AbstractGrid)this.getView().getControl("contractpartyentry");
        contractpartGrid.addRowClickListener((RowClickEventListener)this);
        AbstractGrid contractitemGrid = (AbstractGrid)this.getView().getControl("termentry");
        contractitemGrid.addRowClickListener((RowClickEventListener)this);
        AbstractGrid contractprojectGrid = (AbstractGrid)this.getView().getControl("projectentryentity");
        contractprojectGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ContractUtil.setCurrency((IDataModel)this.getModel());
        ContractUtil.setDefaultParty((IFormView)this.getView());
        ContractUtil.setWriteOffType((IDataModel)this.getModel());
        if (this.getModel().getEntryRowCount("expenseentryentity") > 0) {
            this.getModel().deleteEntryData("expenseentryentity");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        if (formView.getParentView() != null) {
            String billPageId = formView.getPageId();
            IPageCache parentPageCache = (IPageCache)formView.getParentView().getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
        }
        ContractUtil.refreshHeadContacts((IFormView)formView, (EventObject)e);
        ContractUtil.controlEndDate((IDataModel)dataModel, (Object)dataModel.getValue("startdate"), (DateEdit)((DateEdit)this.getControl("enddate")));
        ContractUtil.controlEndDate((IDataModel)dataModel, (Object)dataModel.getValue("signdate"), (DateEdit)((DateEdit)this.getControl("changedate")));
        ContractUtil.setMobFrameworkcontractChange((IDataModel)dataModel, (IFormView)formView, (Boolean)((Boolean)dataModel.getValue("frameworkcontract")));
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        CommonViewControlUtil.setAmountToLabel(dataModel, formView, "expenseentryentity", "currexpenseamount", "label_exp_amount", currency);
        CommonViewControlUtil.setAmountToLabel(dataModel, formView, "projectentryentity", "projectwriteoffamount", "label_project_amount", currency);
        ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"contractpartyentry", (Boolean)false);
        ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"termentry", (Boolean)false);
        ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (Boolean)false);
        Long company = (Long)((DynamicObject)dataModel.getValue("company")).getPkValue();
        if (company == null || company.compareTo(0L) == 0) {
            company = RequestContext.get().getOrgId();
        }
        String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)company, (String)"budgeMsgControl");
        ContractUtil.setBudgetShow((IDataModel)dataModel, (IFormView)formView, (boolean)BudgetCommonUtil.isShowBudget(formView.getEntityId(), company), (String)budgeMsgValue, (int)-1);
        ContractUtil.setFirstFiledLockAndVisible((String)((String)dataModel.getValue("detailtype")), (String)((String)dataModel.getValue("changetype")), (IDataModel)dataModel, (IFormView)formView);
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (this.getModel().getValue("company") == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ExpenseEntryMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getModel().getValue("costcompany") == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ExpenseEntryMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "label_sign_delete": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"contractpartyentry", (Boolean)true);
                break;
            }
            case "label_sign_done": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"contractpartyentry", (Boolean)false);
                break;
            }
            case "btn_contractpart_add": 
            case "flex_addcontractpart": 
            case "addcontractpart": {
                ContractUtil.addContractPartByHand((IDataModel)dataModel, (IFormView)formView, (AbstractFormPlugin)this, (int)-1, (String)"er_contractpart_mb");
                break;
            }
            case "label_item_delete": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"termentry", (Boolean)true);
                break;
            }
            case "label_item_done": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"termentry", (Boolean)false);
                break;
            }
            case "btn_contractitem_add": {
                ContractUtil.addContractPartByHand((IDataModel)dataModel, (IFormView)formView, (AbstractFormPlugin)this, (int)-1, (String)"er_contractitem_mb");
                break;
            }
            case "label_project_delete": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (Boolean)true);
                break;
            }
            case "label_project_done": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (Boolean)false);
                break;
            }
            case "btn_contractproject_add": {
                DynamicObjectCollection partycoll = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("contractpartyentry");
                Set collect = partycoll.stream().filter(v -> v.getDynamicObject("contractparty") != null).collect(Collectors.toSet());
                if (collect.size() == 0 && ContractUtil.isFilterBySup((IDataModel)dataModel)) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b7e\u7ea6\u65b9\u540d\u79f0\u3002", (String)"ContractBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    if (evt instanceof BeforeClickEvent) {
                        ((BeforeClickEvent)evt).setCancel(true);
                    }
                    return;
                }
                ContractUtil.addContractPartByHand((IDataModel)dataModel, (IFormView)formView, (AbstractFormPlugin)this, (int)-1, (String)"er_projectfromcontract_mb");
                break;
            }
            case "label_exp_delete": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity", (Boolean)true);
                break;
            }
            case "label_exp_done": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity", (Boolean)false);
                break;
            }
            case "btn_plan_add": {
                if ("biztype_changebill".equals((String)dataModel.getValue("detailtype"))) {
                    ContractUtil.addContractPartByHand((IDataModel)dataModel, (IFormView)formView, (AbstractFormPlugin)this, (int)-1, (String)"er_contractplan_change_mb");
                    break;
                }
                ContractUtil.addContractPartByHand((IDataModel)dataModel, (IFormView)formView, (AbstractFormPlugin)this, (int)-1, (String)"er_contractplan_mb");
                break;
            }
            case "relationconpanelapl": {
                ContractUtil.addContractPartByHand((IDataModel)dataModel, (IFormView)formView, (AbstractFormPlugin)this, (int)-1, (String)"er_draw_concontract_mb");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        Object[] parma = new Object[]{formView, closedCallBackEvent.getReturnData()};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_BEFORECLOSEDCALLBACK, (Object[])new Object[]{ContractBillMobPlugin.class, closedCallBackEvent.getActionId(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if ("er_contractpart_mb".equalsIgnoreCase(actionId) && boo.booleanValue()) {
            formView.updateView("contractpartyentry");
            ContractUtil.deleteProjectEntry(null, (IDataModel)this.getModel());
            ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"contractpartyentry", (Boolean)false);
        } else if ("er_contractitem_mb".equalsIgnoreCase(actionId) && boo.booleanValue()) {
            formView.updateView("termentry");
            ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"termentry", (Boolean)false);
        } else if ("er_projectfromcontract_mb".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String botpId = "1463763069426522112";
            ContractUtil.callRleAfterClosedCallBack((IDataModel)dataModel, (IFormView)formView, (ListSelectedRowCollection)selectBill, (String)"er_applyprojectbill", (String)botpId, (String)"er_projectfromcontract_mb");
        } else if ("er_contract_project_entry".equalsIgnoreCase(actionId)) {
            ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (Boolean)false);
            formView.updateView("projectentryentity");
            ContractUtil.setAmountToLabel((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (String)"projectwriteoffamount", (String)"label_project_amount", (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
        } else if (("er_contractplan_mb".equalsIgnoreCase(actionId) || "er_contractplan_change_mb".equalsIgnoreCase(actionId)) && boo.booleanValue()) {
            ContractUtil.calBillSumAmount((IDataModel)dataModel, (IFormView)formView);
            formView.updateView("expenseentryentity");
            ContractUtil.setAmountToLabel((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity", (String)"currexpenseamount", (String)"label_exp_amount", (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
            ContractUtil.setAmountToLabel((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (String)"projectwriteoffamount", (String)"label_project_amount", (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
            ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity", (Boolean)false);
            Long company = (Long)((DynamicObject)dataModel.getValue("company")).getPkValue();
            if (company == null || company.compareTo(0L) == 0) {
                company = RequestContext.get().getOrgId();
            }
            String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)company, (String)"budgeMsgControl");
            ContractUtil.setBudgetShow((IDataModel)dataModel, (IFormView)formView, (boolean)BudgetCommonUtil.isShowBudget(formView.getEntityId(), company), (String)budgeMsgValue, (int)-1);
            ContractUtil.setFirstFiledLockAndVisible((String)((String)dataModel.getValue("detailtype")), (String)((String)dataModel.getValue("changetype")), (IDataModel)dataModel, (IFormView)formView);
            formView.updateView("costcompany");
            this.showIfInvoiceAttachToolbar();
        } else if ("er_draw_concontract_mb".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String botpId = "1443529768774768640";
            ContractUtil.callRleAfterClosedCallBack((IDataModel)dataModel, (IFormView)formView, (ListSelectedRowCollection)selectBill, (String)"er_contractbill", (String)botpId, (String)"er_draw_concontract_mb");
        }
        ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AFTERCLOSEDCALLBACK, (Object[])new Object[]{ContractBillMobPlugin.class, closedCallBackEvent.getActionId(), Boolean.FALSE, parma});
    }

    private void showIfInvoiceAttachToolbar() {
        boolean enable = (Boolean)this.getModel().getValue("isenableinvoice");
        this.getView().setVisible(Boolean.valueOf(enable), new String[]{INVOICE_ATTACH_TOOLBAR, "attachflexleft", "attachflexright"});
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        int[] rowIndexs = e.getRowIndexs();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (entryName) {
            case "expenseentryentity": {
                if (((Boolean)model.getValue("frameworkcontract")).booleanValue()) {
                    return;
                }
                if (!model.getValue("detailtype").equals("biztype_changebill") || !model.getValue("itemfrom", rowIndexs[0]).equals("1")) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u5206\u5f55\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContractBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ContractUtil.setWriteOffType((IDataModel)this.getModel());
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        String key = source.getEntryKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "contractpartyentry": {
                ContractUtil.setAndGetSelectedRowEntryId((IDataModel)model, (IFormView)view, (String)"contractpartyentry");
                ContractUtil.addContractPartByHand((IDataModel)model, (IFormView)view, (AbstractFormPlugin)this, (int)evt.getRow(), (String)"er_contractpart_mb");
                break;
            }
            case "termentry": {
                ContractUtil.setAndGetSelectedRowEntryId((IDataModel)model, (IFormView)view, (String)"termentry");
                ContractUtil.addContractPartByHand((IDataModel)model, (IFormView)view, (AbstractFormPlugin)this, (int)evt.getRow(), (String)"er_contractitem_mb");
                break;
            }
            case "projectentryentity": {
                ContractUtil.setAndGetSelectedRowEntryId((IDataModel)model, (IFormView)view, (String)"projectentryentity");
                ContractUtil.addContractPartByHand((IDataModel)model, (IFormView)view, (AbstractFormPlugin)this, (int)evt.getRow(), (String)"er_contract_project_entry");
                break;
            }
            case "expenseentryentity": {
                ContractUtil.setAndGetSelectedRowEntryId((IDataModel)model, (IFormView)view, (String)"expenseentryentity");
                if ("biztype_changebill".equals((String)model.getValue("detailtype"))) {
                    ContractUtil.addContractPartByHand((IDataModel)model, (IFormView)view, (AbstractFormPlugin)this, (int)evt.getRow(), (String)"er_contractplan_change_mb");
                    break;
                }
                ContractUtil.addContractPartByHand((IDataModel)model, (IFormView)view, (AbstractFormPlugin)this, (int)evt.getRow(), (String)"er_contractplan_mb");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object newValue = valueSet[0].getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal paypercent = BigDecimal.ZERO;
        BigDecimal expenseamount = BigDecimal.ZERO;
        String writeType = (String)model.getValue("writeofftype");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        switch (propName) {
            case "startdate": {
                ContractUtil.controlEndDate((IDataModel)model, (Object)newValue, (DateEdit)((DateEdit)this.getControl("enddate")));
                break;
            }
            case "frameworkcontract": {
                ContractUtil.setMobFrameworkcontractChange((IDataModel)model, (IFormView)view, (Boolean)((Boolean)newValue));
                break;
            }
            case "contractsconn": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                model.deleteEntryData("contractrelation");
                break;
            }
            case "contractamount": {
                ContractUtil.refreshWriteOffAmount((IDataModel)model, (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                ContractUtil.refreshOriginalAmount((IDataModel)model, (IFormView)view);
                break;
            }
            case "signdate": {
                if (newValue == null) break;
                model.setValue("bizdate", newValue);
                break;
            }
            case "paybyrata": {
                model.setValue("prorataamount", (Object)BigDecimal.ZERO);
                model.setValue("proratataxamount", (Object)BigDecimal.ZERO);
                DynamicObjectCollection entryEntitys = model.getEntryEntity("expenseentryentity");
                if (entryEntitys.size() == 0) {
                    return;
                }
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    model.setValue("paypercent", (Object)BigDecimal.ZERO, i);
                }
                break;
            }
            case "paypercent": {
                int entryPrecision = ((DynamicObject)model.getValue("contractcurrency")).getInt("amtprecision");
                paypercent = (BigDecimal)newValue;
                BigDecimal prorataamount = (BigDecimal)model.getValue("prorataamount");
                expenseamount = prorataamount.multiply(paypercent).divide(BigDecimal.valueOf(100L), entryPrecision, RoundingMode.HALF_EVEN);
                model.setValue("expenseamount", (Object)expenseamount, rowIndex);
                break;
            }
            case "prorataamount": {
                DynamicObjectCollection entryEntity = model.getEntryEntity("expenseentryentity");
                if (entryEntity.size() == 0) {
                    return;
                }
                int precision = ((DynamicObject)model.getValue("contractcurrency")).getInt("amtprecision");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    paypercent = (BigDecimal)((DynamicObject)entryEntity.get(i)).get("paypercent");
                    expenseamount = ((BigDecimal)model.getValue("prorataamount")).multiply(paypercent).divide(BigDecimal.valueOf(100L), precision, RoundingMode.HALF_EVEN);
                    model.setValue("expenseamount", (Object)expenseamount, i);
                }
                break;
            }
            case "iscurrency": {
                model.setValue("contractcurrency", model.getValue("currency"));
                break;
            }
            case "projectwriteoffamount": {
                if (writeType.equals("2")) {
                    ContractUtil.changeOriWriteOffAmount((BigDecimal)((BigDecimal)newValue), (int)rowIndex, (IDataModel)model);
                }
                CommonViewControlUtil.setAmountToLabel(model, view, "projectentryentity", "projectwriteoffamount", "label_project_amount", currency);
                break;
            }
            case "expnotpayamount": {
                model.setValue("notpayamount", (Object)AmountUtils.getEntryAmount((IDataModel)model, (String)"expenseentryentity", (String)"expnotpayamount"));
                break;
            }
            case "oriprojectwriteoffamount": {
                ContractUtil.refreshWriteOffCurrAmount((IDataModel)model, (int)rowIndex, (IFormView)view);
                break;
            }
            case "expenseamount": {
                ContractUtil.refreshWriteOffAmount((IDataModel)model, (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                model.setValue("oriexpnotpayamount", newValue, rowIndex);
                break;
            }
            case "billtaxamount": {
                ContractUtil.refreshOriginalAmount((IDataModel)model, (IFormView)view);
                break;
            }
            case "currexpenseamount": {
                model.setValue("expnotpayamount", newValue, rowIndex);
                ContractUtil.refreshWriteOffAmount((IDataModel)model, (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                CommonViewControlUtil.setAmountToLabel(model, view, "expenseentryentity", "currexpenseamount", "label_exp_amount", currency);
                break;
            }
            case "orinotpayamount": {
                model.setValue("notpayamount", (Object)AmountUtils.getCurrencyAmount((BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)model.getValue("changerate")), (int)currency.getInt("amtprecision"), (String)((String)model.getValue("quotetype"))));
                break;
            }
            case "changedate": {
                Date signdate = (Date)model.getValue("signdate");
                Date changedate = (Date)newValue;
                if (signdate == null || changedate == null || !changedate.before(signdate)) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7b7e\u8ba2\u65e5\u671f\u3002", (String)"ContractUtil_38", (String)"fi-er-business", (Object[])new Object[0]));
                break;
            }
            case "currency": {
                ContractUtil.setAmountToLabel((IDataModel)model, (IFormView)view, (String)"expenseentryentity", (String)"currexpenseamount", (String)"label_exp_amount", (DynamicObject)((DynamicObject)model.getValue("currency")));
                ContractUtil.setAmountToLabel((IDataModel)model, (IFormView)view, (String)"projectentryentity", (String)"projectwriteoffamount", (String)"label_project_amount", (DynamicObject)((DynamicObject)model.getValue("currency")));
                break;
            }
            case "contractparty": {
                ContractUtil.setTel((IDataModel)model, (int)rowIndex);
                ContractUtil.deleteProjectEntry((Object)valueSet[0].getOldValue(), (IDataModel)model);
                view.updateView("partb");
                break;
            }
            case "partytype": {
                ContractUtil.clearTel((IDataModel)model, (int)rowIndex);
                ContractUtil.deleteProjectEntry((Object)valueSet[0].getOldValue(), (IDataModel)model);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        switch (entryName) {
            case "projectentryentity": {
                ContractUtil.refreshWriteOffAmount((IDataModel)dataModel, (WriteOffFields)ContractProjectWriteOffFields.getInstance());
                CommonViewControlUtil.setAmountToLabel(dataModel, formView, "projectentryentity", "projectwriteoffamount", "label_project_amount", currency);
                if (dataModel.getEntryRowCount("projectentryentity") != 0) break;
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (Boolean)false);
                break;
            }
            case "expenseentryentity": {
                ContractUtil.calBillSumAmount((IDataModel)dataModel, (IFormView)formView);
                ContractUtil.setAmountToLabel((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity", (String)"currexpenseamount", (String)"label_exp_amount", (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
                ContractUtil.setAmountToLabel((IDataModel)dataModel, (IFormView)formView, (String)"projectentryentity", (String)"projectwriteoffamount", (String)"label_project_amount", (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
                if (dataModel.getEntryRowCount("expenseentryentity") != 0) break;
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)formView, (String)"expenseentryentity", (Boolean)false);
                break;
            }
            case "contractpartyentry": {
                ContractUtil.deleteProjectEntry(null, (IDataModel)this.getModel());
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        switch (entryName) {
            case "projectentryentity": {
                ContractUtil.contractPageRules((IDataModel)dataModel, (IFormView)view, (String)"projectentryentity", (Boolean)false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        switch (operateKey) {
            case "save": {
                ContractUtil.calBillSumAmount((IDataModel)dataModel, (IFormView)view);
                ContractUtil.contractPaybyrataCheckAmount((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "submit": {
                ContractUtil.calBillSumAmount((IDataModel)dataModel, (IFormView)view);
                ContractUtil.contractPaybyrataCheckAmount((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        switch (key) {
            case "submit": {
                BillShowParameter billShowParameter;
                if (parentView != null) {
                    view.getParentView().close();
                    view.sendFormAction(view.getParentView());
                }
                if ((billShowParameter = (BillShowParameter)view.getFormShowParameter()) == null || billShowParameter.getBillStatus().getValue() != BillOperationStatus.ADDNEW.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.SUBMIT.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.EDIT.getValue()) break;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("formId", view.getEntityId());
                paramMap.put("templateId", "bos_moblist");
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("need_refresh", "Y");
                paramMap.put("customParam", customParam);
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "copy": {
                if (!StringUtils.equalsIgnoreCase((String)parentView.getEntityId(), (String)"er_dlbill_tabap")) break;
                ApprovalRecord approvalRecord = (ApprovalRecord)parentView.getControl("approvalrecordap");
                approvalRecord.setArData(null);
                parentView.updateView("approvalrecordap");
                view.sendFormAction(parentView);
            }
        }
    }
}

