/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.estimate;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.pub.CostestimateBillUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class CostEstimateBillEdit
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(CostEstimateBillEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("er_costestimateassetbill".equals(this.getView().getFormShowParameter().getFormId())) {
            this.getModel().setValue("detailtype", (Object)"biztype_applyassetbill");
        }
    }

    private boolean isContract() {
        return StringUtils.endsWithIgnoreCase((CharSequence)this.getModel().getValue("relatedbiz").toString(), (CharSequence)"biztype_contract");
    }

    private boolean checkIsContractPush() {
        return this.getModel().getEntryEntity("expenseentryentity").size() > 0 && "er_contractbill".equals(((DynamicObject)this.getModel().getEntryEntity("expenseentryentity").get(0)).get("wbsrcbilltype"));
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        this.viewControlByAppId();
        String relationcontract = "0";
        if (this.getModel().getValue("company") != null) {
            relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
        }
        model.setValue("relationcontract", (Object)relationcontract);
        String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
        if ("2".equals(applyprojectbillRelated)) {
            model.setValue("isonway", (Object)true);
        } else {
            model.setValue("isonway", (Object)false);
        }
        String relatedbiz = (String)model.getValue("relatedbiz");
        if ("1".equals(relationcontract) && !"biztype_other".equals(relatedbiz)) {
            model.setValue("frameworkcontract", (Object)true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"frameworkcontract"});
        } else {
            model.setValue("frameworkcontract", (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"frameworkcontract"});
        }
        Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
        if (frameworkcontract.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap_contract"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap_contract"});
        }
        String detailType = (String)model.getValue("detailtype");
        boolean isPush = model.getDataEntity().getDataEntityState().isPushChanged();
        boolean contract = this.isContract();
        boolean isCotractPush = (Boolean)model.getValue("ispush");
        if (this.isContract() && isCotractPush) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_contract"});
        }
        if (contract && this.checkIsContractPush() && isCotractPush) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"relatedbiz"});
        } else {
            String billStatus = (String)model.getValue("billstatus");
            if ((ErBillStatusEnum.A.toString().equalsIgnoreCase(billStatus) || ErBillStatusEnum.D.toString().equalsIgnoreCase(billStatus)) && isPush && (detailType.equalsIgnoreCase("biztype_applybill") || contract)) {
                DynamicObjectCollection entryExps = model.getEntryEntity("expenseentryentity");
                if (entryExps != null && !entryExps.isEmpty()) {
                    Object costCompany = model.getValue("costcompany");
                    Object costDept = model.getValue("costdept");
                    int size = entryExps.size();
                    for (int i = 0; i < size; ++i) {
                        DynamicObject entryExp = (DynamicObject)entryExps.get(i);
                        if (contract && !isCotractPush && !"1".equals(relationcontract)) {
                            model.setValue("entrycostcompany", costCompany, i);
                            model.setValue("entrycostdept", costDept, i);
                            DynamicObject entrycurrency = entryExp.getDynamicObject("entrycurrency");
                            Map quoteTypeAndExchangeRate = AmountChangeUtil.refreshEnrtyExchangeRate((IDataModel)model, (IFormView)this.getView(), (DynamicObject)entrycurrency);
                            model.setValue("entrycurrency", (Object)entrycurrency, i);
                            model.setValue("expquotetype", quoteTypeAndExchangeRate.get("quoteType"), i);
                            model.setValue("exchangerate", quoteTypeAndExchangeRate.get("exchangeRate"), i);
                        }
                        BigDecimal expenseamount = entryExp.getBigDecimal("expenseamount");
                        model.setValue("expenseamount", (Object)BigDecimal.ZERO, i);
                        model.setValue("expenseamount", (Object)expenseamount, i);
                    }
                }
            } else if (isPush && detailType.equalsIgnoreCase("biztype_applyassetbill")) {
                DynamicObjectCollection entryExps = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                int index = 0;
                for (DynamicObject entry : entryExps) {
                    BigDecimal expenseamount = entry.getBigDecimal("expenseamount");
                    model.setValue("expenseamount", (Object)BigDecimal.ZERO, index);
                    model.setValue("expenseamount", (Object)expenseamount, index);
                    ++index;
                }
            }
        }
        if (!"biztype_other".equals(relatedbiz) && !isCotractPush && "1".equals(relationcontract)) {
            CostestimateBillUtil.refreshExpenseContractInfo((IDataModel)model);
        }
        model.setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] dataSet = e.getChangeSet();
        Object newData = dataSet[0].getNewValue();
        Object oldData = dataSet[0].getOldValue();
        int rowIndex = dataSet[0].getRowIndex();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "relatedbiz": {
                if (!"biztype_other".equals(newData)) {
                    dataModel.setValue("iscurrency", (Object)true);
                    String relationcontract = (String)this.getModel().getValue("relationcontract");
                    if ("1".equals(relationcontract)) {
                        dataModel.setValue("frameworkcontract", (Object)true);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"frameworkcontract"});
                    } else {
                        dataModel.setValue("frameworkcontract", (Object)false);
                        this.getView().setVisible(Boolean.FALSE, new String[]{"frameworkcontract"});
                    }
                } else {
                    dataModel.setValue("frameworkcontract", (Object)false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"frameworkcontract"});
                }
                Boolean frameworkcontract = (Boolean)dataModel.getValue("frameworkcontract");
                if (frameworkcontract.booleanValue()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"advconap_contract"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advconap_contract"});
                }
                dataModel.deleteEntryData("expenseentryentity");
                dataModel.deleteEntryData("contractentry");
                break;
            }
            case "entrywlunit": {
                CostestimateBillUtil.refreshContractEntry((IDataModel)dataModel);
                CostestimateBillUtil.writeOffContract((IDataModel)dataModel);
                String relationcontract = (String)dataModel.getValue("relationcontract");
                String relatedbiz = (String)dataModel.getValue("relatedbiz");
                boolean ispush = (Boolean)dataModel.getValue("ispush");
                if (ispush || "biztype_other".equals(relatedbiz) || !"1".equals(relationcontract)) break;
                dataModel.setValue("entrycontractno", (Object)"", rowIndex);
                dataModel.setValue("entrycontractname", (Object)"", rowIndex);
                DynamicObject entrywlunit = (DynamicObject)dataModel.getValue("entrywlunit", rowIndex);
                if (entrywlunit == null) break;
                DynamicObjectCollection contractEntry = dataModel.getEntryEntity("contractentry");
                for (DynamicObject contract : contractEntry) {
                    DynamicObject wlunit = contract.getDynamicObject("contractpartb");
                    if (wlunit == null || entrywlunit == null || wlunit.getPkValue() != entrywlunit.getPkValue()) continue;
                    String contractcode = contract.getString("contractcode");
                    String contractname = contract.getString("contractname");
                    dataModel.setValue("entrycontractno", (Object)contractcode, rowIndex);
                    dataModel.setValue("entrycontractname", (Object)contractname, rowIndex);
                }
                break;
            }
            case "relationcontract": {
                if (oldData == null || newData == null) break;
                dataModel.deleteEntryData("expenseentryentity");
                dataModel.deleteEntryData("contractentry");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "drawframcontract": {
                if (this.checkWlUnit()) break;
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            case "save": {
                CostestimateBillUtil.writeOffContract((IDataModel)model);
                break;
            }
            case "submit": {
                CostestimateBillUtil.writeOffContract((IDataModel)model);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        if ("expenseentryentity".equalsIgnoreCase(e.getEntryProp().getName())) {
            CostestimateBillUtil.refreshContractEntry((IDataModel)model);
            CostestimateBillUtil.writeOffContract((IDataModel)model);
        } else if ("contractentry".equalsIgnoreCase(e.getEntryProp().getName())) {
            String relationcontract = (String)model.getValue("relationcontract");
            String relatedbiz = (String)model.getValue("relatedbiz");
            boolean ispush = (Boolean)model.getValue("ispush");
            if (!ispush && !"biztype_other".equals(relatedbiz) && "1".equals(relationcontract)) {
                DynamicObjectCollection expenseEntry = model.getEntryEntity("expenseentryentity");
                if (expenseEntry != null && expenseEntry.size() > 0) {
                    for (int i = 0; i < expenseEntry.size(); ++i) {
                        model.setValue("entrycontractno", (Object)"", i);
                        model.setValue("entrycontractname", (Object)"", i);
                    }
                }
                CostestimateBillUtil.refreshExpenseContractInfo((IDataModel)model);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    protected void viewControlByAppId() {
        IFormView view = this.getView();
        String appId = view.getFormShowParameter().getAppId();
        if (StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)"cexp") || StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)"em")) {
            view.setVisible(Boolean.TRUE, new String[]{"frameworkcontract"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"frameworkcontract"});
        }
    }

    private boolean checkWlUnit() {
        IDataModel model = this.getModel();
        EntryGrid expenseEntryGrid = (EntryGrid)this.getControl("expenseentryentity");
        int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
        List selectedExpenseEntryRows = Arrays.stream(selectedExpenseEntryRowsArr).boxed().collect(Collectors.toList());
        if (selectedExpenseEntryRows == null || selectedExpenseEntryRows.size() < 1) {
            log.info("\u8bf7\u5148\u9009\u62e91\u884c\u6682\u4f30\u660e\u7ec6");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e91\u884c\u6682\u4f30\u660e\u7ec6\u3002", (String)"CostEstimateContractPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection expenseEntity = model.getEntryEntity("expenseentryentity");
        List collect = selectedExpenseEntryRows.stream().map(it -> (DynamicObject)expenseEntity.get(it.intValue())).collect(Collectors.toList());
        if (collect != null && collect.size() > 0) {
            for (DynamicObject dynamicObject : collect) {
                if (dynamicObject.getDynamicObject("entrywlunit") != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u6682\u4f30\u660e\u7ec6\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"CostEstimateContractPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (collect != null && collect.stream().map(it -> it.get("entrywlunit")).distinct().count() > 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u6682\u4f30\u660e\u7ec6\u5b58\u5728\u4e0d\u76f8\u540c\u7684\u5f80\u6765\u5355\u4f4d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostEstimateContractPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

