/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.prepay;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.field.writeoffmoney.PrePayContractWriteOffFields;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.mobile.util.model.KeyVisibleControl;
import kd.fi.er.formplugin.daily.web.util.TempEncashAmountUtils;
import org.apache.commons.lang3.StringUtils;

public class PrePayMobEdit
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static String BILLPAYERTYPE = "billpayertype";
    private static String PAYER_FLEX = "payer_flex";
    private static final String projectFromId = "er_draw_project_mb";
    private static final String contractFromId = "er_draw_contractitem_mb";
    private static final String reimcontractFromId = "er_draw_contract_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_project_add", "btn_contract_add", "btn_reimcontract_add", "btn_concontract_add", "label_conract_delete", "label_contract_done"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        IDataModel model = this.getModel();
        DynamicObjectCollection expCollection = model.getEntryEntity("expenseentryentity");
        Long[] entrySourceIds = null;
        if (expCollection != null) {
            entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong("wbsrcentryid")).distinct().toArray(Long[]::new);
        }
        if ("btn_project_add".equals(key)) {
            if (this.isFilterSup() && this.getModel().getValue("billpayerid") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PrePayMobEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                if (evt instanceof BeforeClickEvent) {
                    ((BeforeClickEvent)evt).setCancel(true);
                }
                return;
            }
            showParameter.setFormId(projectFromId);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_project_bill"));
            showParameter.setAppId("1GARA29DA8+R");
            customParam.put("entrySourceIds", Arrays.stream(entrySourceIds).toArray());
            customParam.put("sourceFormid", "projectBill");
            customParam.put("costCompany", ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany")));
            customParam.put("company", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
            customParam.put("applierId", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
            customParam.put("formId", this.getView().getEntityId());
            customParam.put("billpayerid", ErCommonUtils.getPk((Object)this.getModel().getValue("billpayerid")));
            customParam.put("billpayertype", this.getModel().getValue("billpayertype"));
            QFilter ruleFilter = new QFilter("currency", "=", (Object)ErCommonUtils.getPk((Object)model.getValue("currency")));
            customParam.put("customFilterStr", ruleFilter.toSerializedString());
            showParameter.setCustomParams(customParam);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("btn_contract_add".equals(key)) {
            DynamicObject applier = (DynamicObject)model.getValue("billpayerid");
            if (this.isFilterSup() && applier == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PrePayMobEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setFormId(contractFromId);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_contract_bill"));
            showParameter.setAppId("1GARA29DA8+R");
            customParam.put("entrySourceIds", Arrays.stream(entrySourceIds).toArray());
            customParam.put("sourceFormid", "contractBill");
            customParam.put("costCompany", ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany")));
            customParam.put("company", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
            if (applier != null) {
                customParam.put("applierid", applier.get("number"));
            }
            QFilter botpFilter = new QFilter("unpaidamt", ">", (Object)0);
            botpFilter = botpFilter.and("contract.contractstatus.number", "in", (Object)"04");
            customParam.put("customFilterStr", botpFilter.toSerializedString());
            showParameter.setCustomParams(customParam);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("label_conract_delete".equals(key)) {
            CommonViewControlUtil.contractPageRule(model, this.getView(), Boolean.TRUE);
        } else if ("label_contract_done".equals(key)) {
            CommonViewControlUtil.contractPageRule(model, this.getView(), Boolean.FALSE);
        } else if ("btn_reimcontract_add".equals(key) || "btn_concontract_add".equals(key)) {
            DynamicObjectCollection contractCollection = model.getEntryEntity("contractentry");
            Long[] sourceIds = null;
            DynamicObject billpayer = (DynamicObject)model.getValue("billpayerid");
            if (billpayer == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"PrePayMobEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setFormId(reimcontractFromId);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setAppId("1GARA29DA8+R");
            if ("btn_concontract_add".equals(key)) {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_concontract_bill"));
                customParam.put("frameworkcontract", Boolean.TRUE);
            } else {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_reimcontract_bill"));
                customParam.put("frameworkcontract", Boolean.FALSE);
            }
            if (contractCollection != null) {
                entrySourceIds = (Long[])contractCollection.stream().map(row -> row.getLong("contractsrcentryid")).distinct().toArray(Long[]::new);
                sourceIds = (Long[])contractCollection.stream().map(row -> row.getLong("contractsid")).distinct().toArray(Long[]::new);
            }
            customParam.put("entrySourceIds", Arrays.stream(entrySourceIds).toArray());
            customParam.put("sourceIds", Arrays.stream(sourceIds).toArray());
            customParam.put("sourceFormid", "reimcontractBill");
            customParam.put("costCompany", ErCommonUtils.getPk((Object)model.getValue("costcompany")));
            customParam.put("company", ErCommonUtils.getPk((Object)model.getValue("company")));
            customParam.put("applier", ErCommonUtils.getPk((Object)model.getValue("applier")));
            customParam.put("billpayer", ErCommonUtils.getPk((Object)billpayer));
            showParameter.setCustomParams(customParam);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean isFilterSup() {
        Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        return SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView thisview = this.getView();
        IDataModel model = this.getModel();
        thisview.setEnable(Boolean.TRUE, new String[]{BILLPAYERTYPE, PAYER_FLEX});
        KeyVisibleControl control = new KeyVisibleControl(thisview);
        CardEntry accountCard = (CardEntry)thisview.getControl("contractentry");
        int accountEntrySize = model.getEntryRowCount("contractentry");
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            String writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)model.getValue("company")), (String)"er010");
            if ("1".equals(writeOffType)) {
                accountCard.setChildVisible(true, rowIndex, new String[]{"contractwriteoff"});
                accountCard.setChildVisible(false, rowIndex, new String[]{"contractcurrwriteoff"});
                continue;
            }
            accountCard.setChildVisible(true, rowIndex, new String[]{"contractcurrwriteoff"});
            accountCard.setChildVisible(false, rowIndex, new String[]{"contractwriteoff"});
        }
        control.refreshView();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (Objects.equals(billStatus, String.valueOf(BillOperationStatus.ADDNEW.getValue()))) {
            String billpayertype = (String)model.getValue("billpayertype");
            DynamicObjectCollection accountColl = model.getEntryEntity("accountentry");
            for (DynamicObject account : accountColl) {
                account.set("payertype", (Object)billpayertype);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        IDataModel model = this.getModel();
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_project_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            this.callRleAfterClosedCallBack(model, selectBill, "er_applyprojectbill", "1114510235038403584", "select_project_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_contract_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            this.callRleAfterClosedCallBack(model, selectBill, "pmbs_contractpayitem", "1173155604500446208", "select_contract_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_concontract_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            this.callRleAfterClosedCallBack(model, selectBill, "er_contractbill", "1615846206339334144", "select_concontract_bill");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_reimcontract_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            this.callRleAfterClosedCallBack(model, selectBill, "er_contractbill", "1615871755120066560", "select_reimcontract_bill");
        }
    }

    private void callRleAfterClosedCallBack(IDataModel model, ListSelectedRowCollection selectBill, String entityNumber, String RuleId, String actionId) {
        if (selectBill == null || selectBill.isEmpty()) {
            return;
        }
        DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)entityNumber, (String)model.getDataEntityType().getName(), (IFormView)this.getView(), (ListSelectedRowCollection)selectBill, (String)RuleId);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)4);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (result.isSuccess()) {
            BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, (List)resultList, (BillEntityType)((BillEntityType)model.getDataEntityType()));
        }
        for (DynamicObject bill : resultList) {
            if (actionId.equals("select_contract_bill")) {
                bill.getDynamicObjectCollection("expenseentryentity").stream().forEach(dynamicobject -> {
                    BigDecimal exchangerate = (BigDecimal)dynamicobject.get("exchangerate");
                    if (exchangerate.compareTo(BigDecimal.ZERO) == 0) {
                        dynamicobject.set("exchangerate", (Object)new BigDecimal("1"));
                    }
                    int amtprecision = ((DynamicObject)dynamicobject.get("entrycurrency")).getInt("amtprecision");
                    BigDecimal expenseamount = ((BigDecimal)dynamicobject.get("expenseamount")).multiply((BigDecimal)dynamicobject.get("exchangerate")).setScale(amtprecision, 4);
                    dynamicobject.set("currexpenseamount", (Object)expenseamount);
                    dynamicobject.set("expeapprovecurramount", (Object)expenseamount);
                });
            }
            ((IBillModel)model).push((Object)bill);
        }
        this.getView().updateView();
        int count = model.getEntryRowCount("accountentry");
        if (count == 0) {
            model.createNewEntryRow("accountentry");
        }
        TempEncashAmountUtils.loan_refreshReceiveAmount((IDataModel)model);
        TempEncashAmountUtils.loan_getEncashedAmount((IDataModel)model);
        CommonViewControlUtil.expensePageRules(model, this.getView());
        CommonViewControlUtil.setExpenseAmount(model, this.getView());
        if ("select_concontract_bill".equals(actionId) || "select_reimcontract_bill".equals(actionId) || "select_project_bill".equals(actionId)) {
            PublicBillUtil.setExpContactInfo((IDataModel)model, (IFormView)this.getView());
            PublicBillUtil.calPreContractMoney((IDataModel)model, (PrePayContractWriteOffFields)PrePayContractWriteOffFields.getInstance());
            String writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)model.getValue("company")), (String)"er010");
            if ("1".equals(writeOffType) && model.getEntryRowCount("contractentry") > 0) {
                DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
                for (int i = 0; i < contracts.size(); ++i) {
                    PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)model, (BigDecimal)((DynamicObject)contracts.get(i)).getBigDecimal("contractwriteoff"), (int)i);
                }
            }
            PublicBillUtil.updateContractWriteoffView((IDataModel)model, (IFormView)this.getView());
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        String name = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (name) {
            case "expenseentryentity": {
                CommonViewControlUtil.setExpenseAmount(model, view);
                break;
            }
            case "contractentry": {
                int contractEntrySize = model.getEntryRowCount("contractentry");
                if (contractEntrySize != 0) break;
                CommonViewControlUtil.contractPageRule(model, view, Boolean.FALSE);
                break;
            }
        }
    }
}

