/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.bill.publicreim;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.publicbiz.bill.publicreim.AbsPublicReimAssetBillEdit;
import org.apache.commons.lang.StringUtils;

public class PublicReimAssetBillEdit
extends AbsPublicReimAssetBillEdit {
    protected static Log logger = LogFactory.getLog(PublicReimAssetBillEdit.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        OperationStatus status = e.getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            Object pkId = ((BillShowParameter)e.getSource()).getPkId();
            if (pkId == null) {
                return;
            }
            try {
                String formId = e.getFormShowParameter().getFormId();
                DynamicObject upLookBill = QueryServiceHelper.queryOne((String)formId, (String)"reimbursetype", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
                String reimburseType = upLookBill.getString("reimbursetype");
                if (StringUtils.equalsIgnoreCase((String)reimburseType, (String)"asset")) {
                    BillShowParameter billShowParameter = (BillShowParameter)e.getFormShowParameter();
                    billShowParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u62a5\u8d26\u5355", (String)"PublicReimAssetBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception exception) {
                logger.error("\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u5bf9\u516c\u62a5\u9500\u5355\uff0c\u5176pk\u4e3a\uff1a" + pkId);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap31"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("importasset")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
            if (CollectionUtils.isEmpty((Collection)invoiceEntry)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u53d1\u7968\u3002", (String)"PublicReimAssetBillEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            int[] selectRows = this.getAssetSelectedRows();
            if (selectRows == null || selectRows.length < 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u8d44\u4ea7\u4fe1\u606f\u5206\u5f55\u540e\uff0c\u518d\u5bfc\u5165\u8d44\u4ea7\u4fe1\u606f\u3002", (String)"PublicReimAssetBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (selectRows.length == 1) {
                int rowIndex = selectRows[0];
                boolean isImport = this.isImportEntry(rowIndex);
                if (isImport) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u91cd\u590d\u5bfc\u5165\uff0c\u8bf7\u65b0\u589e\u8d44\u4ea7\u4fe1\u606f\u5206\u5f55\u884c\u540e\u518d\u5bfc\u5165\u3002", (String)"PublicReimAssetBillEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                HashMap customParams = new HashMap();
                formShowParameter.setCustomParams(customParams);
                formShowParameter.setFormId("er_publicbillimportasset");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "IMPORT_ASSET_CLOSE_CALL_BACK"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u591a\u884c\u5bfc\u5165\u8d44\u4ea7\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u5206\u5f55\u540e\uff0c\u518d\u5bfc\u5165\u8d44\u4ea7\u4fe1\u606f\u3002", (String)"PublicReimAssetBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private int[] getAssetSelectedRows() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("assetentry");
        int[] selectRows = entryGrid.getSelectRows();
        return selectRows;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("IMPORT_ASSET_CLOSE_CALL_BACK".equals(actionId)) {
            Collection collection = (Collection)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return;
            }
            int[] selectedRows = this.getAssetSelectedRows();
            if (selectedRows == null || selectedRows.length < 1) {
                return;
            }
            int rowIndex = selectedRows[0];
            Iterator iterator = collection.iterator();
            Long firstRowId = (Long)iterator.next();
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection invoiceItemEntry = dataEntity.getDynamicObjectCollection("invoiceitementry");
            Map<Long, DynamicObject> invoiceItemMap = invoiceItemEntry.stream().filter(e -> collection.contains(e.getLong("id"))).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            DynamicObject firstInvoiceItem = invoiceItemMap.get(firstRowId);
            Set<String> nullFields = this.getNullFields(rowIndex);
            HashMap result = Maps.newHashMapWithExpectedSize((int)importAssetFields.size());
            BigDecimal taxAmountTotal = BigDecimal.ZERO;
            BigDecimal excludedAmount = BigDecimal.ZERO;
            HashSet taxRates = Sets.newHashSetWithExpectedSize((int)2);
            for (DynamicObject dynamicObject : invoiceItemMap.values()) {
                taxAmountTotal = taxAmountTotal.add(dynamicObject.getBigDecimal("invoiceitemtaxamout"));
                excludedAmount = excludedAmount.add(dynamicObject.getBigDecimal("excludeamount"));
                taxRates.add(dynamicObject.getBigDecimal("invoiceitemtaxrate"));
            }
            for (String string : nullFields) {
                if (string.equalsIgnoreCase("asset_name") && firstInvoiceItem != null) {
                    result.put("asset_name", firstInvoiceItem.get("goodsname"));
                }
                if (string.equalsIgnoreCase("asset_model") && firstInvoiceItem != null) {
                    result.put("asset_model", firstInvoiceItem.get("specmodel"));
                }
                if (string.equalsIgnoreCase("asset_unit") && firstInvoiceItem != null) {
                    Object unit = firstInvoiceItem.get("unit");
                    if (StringUtils.isNotBlank((String)((String)unit))) {
                        unit = (unit = this.queryUnit((String)unit)) == null ? unit : ((DynamicObject)unit).get("id");
                    }
                    result.put("asset_unit", unit);
                }
                if (string.equalsIgnoreCase("assettaxrate") && taxRates.size() == 1) {
                    result.put("assettaxrate", taxRates.iterator().next());
                }
                if (string.equalsIgnoreCase("assettaxamount")) {
                    result.put("assettaxamount", taxAmountTotal);
                }
                if (string.equalsIgnoreCase("asset_quantity")) {
                    result.put("asset_quantity", BigDecimal.ONE);
                }
                if (string.equalsIgnoreCase("assetpricewithouttax")) {
                    result.put("assetpricewithouttax", excludedAmount);
                }
                if (!string.equalsIgnoreCase("asset_isspecialinvoice")) continue;
                Set invoiceInfoIds = invoiceItemMap.values().stream().map(e -> e.getLong("invoiceheadentryid")).collect(Collectors.toSet());
                DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
                Set types = invoiceEntry.stream().filter(e -> invoiceInfoIds.contains(e.getLong("id"))).map(e -> e.getString("invoicetype")).collect(Collectors.toSet());
                Set set = InvoiceTypeUtils.loadSpecialInvoiceTypes();
                boolean allMatch = types.stream().allMatch(e -> set.contains(e));
                result.put("asset_isspecialinvoice", allMatch);
            }
            for (Map.Entry entry : result.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                model.setValue(key, value, rowIndex);
            }
            DynamicObjectCollection assetEntry = dataEntity.getDynamicObjectCollection("assetentry");
            Long l = (Long)((DynamicObject)assetEntry.get(rowIndex)).get("id");
            for (Long invoiceItemId : invoiceItemMap.keySet()) {
                int index = model.createNewEntryRow("assetandinvoiceitem");
                model.setValue("assetdetailid", (Object)l, index);
                model.setValue("invoiceitementryid", (Object)invoiceItemId, index);
            }
        }
    }

    private boolean isImportEntry(int rowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection assets = dataEntity.getDynamicObjectCollection("assetentry");
        if (rowIndex >= assets.size()) {
            throw new IndexOutOfBoundsException(String.format("index : %d", rowIndex));
        }
        DynamicObject selectedRow = (DynamicObject)assets.get(rowIndex);
        Long assetEntryId = selectedRow.getLong("id");
        Set set = dataEntity.getDynamicObjectCollection("assetandinvoiceitem").stream().filter(e -> e.getLong("assetdetailid") == assetEntryId.longValue()).collect(Collectors.toSet());
        return set.size() != 0;
    }

    private Set<String> getNullFields(int rowIndex) {
        HashSet nullFields = Sets.newHashSetWithExpectedSize((int)importAssetFields.size());
        nullFields.add("asset_quantity");
        nullFields.add("asset_isspecialinvoice");
        for (String field : importAssetFields) {
            Object value = this.getModel().getValue(field, rowIndex);
            if (value == null) {
                nullFields.add(field);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((String)((String)value))) {
                nullFields.add(field);
            }
            if (!(value instanceof BigDecimal) || BigDecimal.ZERO.compareTo((BigDecimal)value) != 0) continue;
            nullFields.add(field);
        }
        return nullFields;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel model = this.getModel();
        String property = e.getEntryProp().getName();
        int[] rowIndexes = e.getRowIndexs();
        HashSet ids = Sets.newHashSetWithExpectedSize((int)rowIndexes.length);
        DynamicObject dataEntity = model.getDataEntity(true);
        if (property.equals("assetentry")) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("assetentry");
            for (int index : rowIndexes) {
                DynamicObject row = (DynamicObject)collection.get(index);
                Long assetEntryId = row.getLong("id");
                ids.add(assetEntryId);
            }
            this.deleteAssetInvoiceItemRelationship(ids, "assetdetailid");
        } else if (property.equals("invoiceitementry")) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("invoiceitementry");
            for (int index : rowIndexes) {
                DynamicObject row = (DynamicObject)collection.get(index);
                Long assetEntryId = row.getLong("id");
                ids.add(assetEntryId);
            }
            this.deleteAssetInvoiceItemRelationship(ids, "invoiceitementryid");
        }
    }

    private void deleteAssetInvoiceItemRelationship(Collection<Long> collection, String id) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection reCollection = dataEntity.getDynamicObjectCollection("assetandinvoiceitem");
        ArrayList needDelIndexes = Lists.newArrayList();
        for (int i = 0; i < reCollection.size(); ++i) {
            DynamicObject relation = (DynamicObject)reCollection.get(i);
            Long assetEntryId = relation.getLong(id);
            if (!collection.contains(assetEntryId)) continue;
            needDelIndexes.add(i);
        }
        model.deleteEntryRows("assetandinvoiceitem", needDelIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    private DynamicObject queryUnit(String name) {
        QFilter filter = QFilter.of((String)"enable='1'", (Object[])new Object[0]);
        filter.and(new QFilter("name", "=", (Object)name));
        DynamicObject data = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"id", (QFilter[])filter.toArray());
        return data;
    }

    @Override
    void showIfImportAssetItem() {
        boolean isNewAsset;
        Object costCompany = this.getModel().getValue("costcompany");
        if (costCompany == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\u3002", (String)"PublicReimAssetBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isInvoiceEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)ErCommonUtils.getPk((Object)costCompany));
        boolean isAssetReimburse = this.isAssetReimburse();
        Object assetType = this.getModel().getValue("assettype");
        boolean bl = isNewAsset = assetType != null && ((String)assetType).equals("newasset");
        if (isInvoiceEnabled && isAssetReimburse && isNewAsset) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"importasset"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"importasset"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.propertyChange(e);
    }
}

