/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.push;

import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ProjOrContToPubReimBotpPlugin
extends AbstractConvertPlugIn {
    protected DynamicObject[] prepayBills = null;
    private EntryType offEntryType;
    protected DynamicObject[] loanBills = null;

    protected static String getPrepayBillSelectedFields() {
        return String.join((CharSequence)",", "id", "billno", "applier", "description", "bizdate", "billstatus", "currency", "costcompany", "costdept", "expenseentryentity.entrycostdept", "expenseentryentity.entrycostcompany", "expenseentryentity.id", "expenseentryentity.expenseitem", "expenseentryentity.entryprojectno", "expenseentryentity.entrycontractno", "expenseentryentity.entrycurrency", "expenseentryentity.exchangerate", "expenseentryentity.orgiexpebalanceamount", "expenseentryentity.expebalanceamount", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid", "expenseentryentity.expquotetype", "billpayertype", "billpayerid");
    }

    protected static String getloanBillSelectedFields() {
        return String.join((CharSequence)",", "id", "description", "currency.id", "billno", "applier", "bizdate", "billstatus", "costcompany", "costdept", "expenseentryentity.id", "expenseentryentity.entrycostdept", "expenseentryentity.entrycostcompany", "expenseentryentity.expenseitem", "expenseentryentity.entrycurrency", "expenseentryentity.exchangerate", "expenseentryentity.orgiexpebalanceamount", "expenseentryentity.expebalanceamount", "expenseentryentity.sourceentryid", "expenseentryentity.sourcebillid", "expenseentryentity.expquotetype", "expenseentryentity.applyprojectno");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        List selectedRows = e.getSourceRows();
        List pkLists = selectedRows.stream().map(l -> l.get("id")).collect(Collectors.toList());
        this.prepayBills = BusinessDataServiceHelper.load((String)"er_prepaybill", (String)ProjOrContToPubReimBotpPlugin.getPrepayBillSelectedFields(), (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbillid", "in", pkLists)});
        this.loanBills = BusinessDataServiceHelper.load((String)"er_dailyloanbill", (String)ProjOrContToPubReimBotpPlugin.getloanBillSelectedFields(), (QFilter[])new QFilter[]{new QFilter("expenseentryentity.sourcebillid", "in", pkLists)});
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        super.afterCreateLink(e);
        ExtendedDataEntity[] expDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey("expenseentryentity");
        this.buildWfEntrysByPrepay(expDataEntities, this.prepayBills);
        this.buildWfEntrysByLoan(expDataEntities, this.loanBills);
    }

    private void buildWfEntrysByPrepay(ExtendedDataEntity[] entitiesData, DynamicObject[] prepayBills) {
        this.buildWfEntrys(entitiesData, prepayBills, "er_prepaybill");
    }

    private void buildWfEntrysByLoan(ExtendedDataEntity[] entitiesData, DynamicObject[] loanBills) {
        this.buildWfEntrys(entitiesData, loanBills, "er_dailyloanbill");
    }

    private void buildWfEntrys(ExtendedDataEntity[] entitiesData, DynamicObject[] loanBills, String loanBillFormId) {
        if (entitiesData == null || entitiesData.length < 1 || loanBills == null || loanBills.length < 1) {
            return;
        }
        this.offEntryType = (EntryType)this.getTgtMainType().getAllEntities().get("writeoffmoney");
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> mapSourceIdToPublicBills = new HashMap<Long, DynamicObject>();
        for (ExtendedDataEntity entity : entitiesData) {
            DynamicObjectCollection linkRows = entity.getDataEntity().getDynamicObjectCollection("expenseentryentity_lk");
            for (DynamicObject linkRow : linkRows) {
                Long sourceId = linkRow.getLong("expenseentryentity_lk_sid");
                if (sourceId == null || sourceId.compareTo(Long.valueOf("0")) == 0) continue;
                sourceIds.add(sourceId);
                mapSourceIdToPublicBills.put(sourceId, (DynamicObject)entity.getDataEntity().getParent());
            }
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)this.getSrcMainType().getName(), (String)"expenseentryentity", (Long[])sourceIds.toArray(new Long[sourceIds.size()]));
        Long loanBillTableId = EntityMetadataCache.loadTableDefine((String)loanBillFormId, (String)"expenseentryentity").getTableId();
        TreeMap<Long, DynamicObject> publicreimBillEntryRows = new TreeMap<Long, DynamicObject>();
        for (BFRow targetRow : targetRows) {
            Long sourceEntryId;
            DynamicObject publicReimBill;
            if (loanBillTableId.compareTo(targetRow.getId().getTableId()) != 0 || (publicReimBill = (DynamicObject)mapSourceIdToPublicBills.get(sourceEntryId = targetRow.getSId().getEntryId())) == null) continue;
            Long targetEntryId = targetRow.getId().getEntryId();
            publicreimBillEntryRows.put(targetEntryId, publicReimBill);
        }
        for (DynamicObject srcBill : loanBills) {
            String billstatus = srcBill.getString("billstatus");
            if (!"G".equals(billstatus)) continue;
            DynamicObjectCollection loanBillEntrys = srcBill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject loanBillEntry : loanBillEntrys) {
                BigDecimal iexpebalanceAmount;
                Long srcOfTgtBillExpenseId = (Long)loanBillEntry.getPkValue();
                DynamicObject publicReimburseBill = (DynamicObject)publicreimBillEntryRows.get(srcOfTgtBillExpenseId);
                if (publicReimburseBill == null || (iexpebalanceAmount = loanBillEntry.getBigDecimal("orgiexpebalanceamount")) == null || iexpebalanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject billPayer = publicReimburseBill.getDynamicObject("billpayerid");
                if ("er_prepaybill".equals(loanBillFormId) && billPayer != null) {
                    Object billPayerId = billPayer.getPkValue();
                    DynamicObject prepayBillPayer = srcBill.getDynamicObject("billpayerid");
                    if (prepayBillPayer == null || !prepayBillPayer.getPkValue().equals(billPayerId)) continue;
                }
                DynamicObjectCollection offRows = publicReimburseBill.getDynamicObjectCollection("writeoffmoney");
                DynamicObject offRow = this.createWriteOffLoanRow(loanBillEntry, loanBillTableId, loanBillFormId);
                offRow.set("seq", (Object)(offRows.size() + 1));
                offRows.add((Object)offRow);
            }
        }
        this.clearDrawOffRows(publicreimBillEntryRows);
    }

    private DynamicObject createWriteOffLoanRow(DynamicObject loanBillEntry, Long loanBillTableId, String entityName) {
        DynamicObject entryRow = new DynamicObject((DynamicObjectType)this.offEntryType);
        DynamicObject loanBill = (DynamicObject)loanBillEntry.getParent();
        String billno = loanBill.getString("billno");
        DynamicObject sourceentrycostdept = loanBillEntry.getDynamicObject("entrycostdept");
        DynamicObject sourceentrycostcompany = loanBillEntry.getDynamicObject("entrycostcompany");
        String applierName = loanBill.getDynamicObject("applier").getString("name");
        Date projApplyDate = loanBill.getDate("bizdate");
        String projDescription = loanBill.getString("description");
        DynamicObject projCurrency = loanBillEntry.getDynamicObject("entrycurrency");
        DynamicObject projExpenseitem = loanBillEntry.getDynamicObject("expenseitem");
        BigDecimal exchangerate = loanBillEntry.getBigDecimal("exchangerate");
        BigDecimal orgiExpeBalanceAmount = loanBillEntry.getBigDecimal("orgiexpebalanceamount");
        BigDecimal curExpeBalanceAmount = loanBillEntry.getBigDecimal("expebalanceamount");
        String expquotetype = loanBillEntry.getString("expquotetype");
        long wbsrcentryid = 0L;
        String projectNo = "";
        if (entityName.equalsIgnoreCase("er_dailyloanbill")) {
            wbsrcentryid = loanBillEntry.getLong("sourceentryid");
            entryRow.set("srcbilltype", (Object)"er_dailyloanbill");
            projectNo = loanBillEntry.getString("applyprojectno");
        } else {
            wbsrcentryid = loanBillEntry.getLong("wbsrcentryid");
            entryRow.set("srcbilltype", (Object)"er_prepaybill");
            String headwltype = loanBill.getString("billpayertype");
            DynamicObject headwlunit = loanBill.getDynamicObject("billpayerid");
            entryRow.set("srcentrywltype", (Object)headwltype);
            entryRow.set("srcentrywlunit", (Object)headwlunit);
            projectNo = loanBillEntry.getString("entryprojectno");
            entryRow.set("loancontractno", (Object)loanBillEntry.getString("entrycontractno"));
        }
        entryRow.set("sourceentrycostdept", (Object)sourceentrycostdept);
        entryRow.set("sourceentrycostcompany", (Object)sourceentrycostcompany);
        entryRow.set("loanbillnov1", (Object)billno);
        entryRow.set("loanperson", (Object)applierName);
        entryRow.set("loanapplydatev1", (Object)projApplyDate);
        entryRow.set("loandescriptionv1", (Object)projDescription);
        entryRow.set("loancurrency", (Object)projCurrency);
        entryRow.set("loanexchangerate", (Object)exchangerate);
        entryRow.set("loanamount", (Object)orgiExpeBalanceAmount);
        entryRow.set("currloanamount", (Object)curExpeBalanceAmount);
        entryRow.set("accloanamount", (Object)orgiExpeBalanceAmount);
        entryRow.set("curraccloanamount", (Object)curExpeBalanceAmount);
        entryRow.set("sourcebillid", loanBill.getPkValue());
        entryRow.set("sourceentryid", loanBillEntry.getPkValue());
        entryRow.set("sourcesign", (Object)1);
        entryRow.set("sourceexpenseitem", (Object)projExpenseitem);
        entryRow.set("srcofsrcentryid", (Object)wbsrcentryid);
        entryRow.set("writeoffquotetype", (Object)expquotetype);
        entryRow.set("loanprojectno", (Object)projectNo);
        DynamicObjectCollection offLinkRows = entryRow.getDynamicObjectCollection("writeoffmoney_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("writeoffmoney_lk_stableid", (Object)loanBillTableId);
        offLinkRow.set("writeoffmoney_lk_sbillid", loanBill.getPkValue());
        offLinkRow.set("writeoffmoney_lk_sid", loanBillEntry.getPkValue());
        offLinkRows.add((Object)offLinkRow);
        return entryRow;
    }

    protected void clearDrawOffRows(Map<Long, DynamicObject> reimburseBillEntryRows) {
        Collection<DynamicObject> reimburseBills = reimburseBillEntryRows.values();
        ArrayListMultimap drawMap = ArrayListMultimap.create();
        ArrayListMultimap pushMap = ArrayListMultimap.create();
        for (DynamicObject reimburseBill : reimburseBills) {
            drawMap.clear();
            pushMap.clear();
            DynamicObjectCollection offRows = reimburseBill.getDynamicObjectCollection("writeoffmoney");
            for (DynamicObject next : offRows) {
                if (!next.getBoolean("sourcesign")) {
                    drawMap.put((Object)next.getString("sourcebillid"), (Object)next);
                    continue;
                }
                pushMap.put((Object)next.getString("sourcebillid"), (Object)next);
            }
            Set drawSet = drawMap.keySet();
            Set pushSet = pushMap.keySet();
            drawSet.retainAll(pushSet);
            Iterator iterator = offRows.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (!drawSet.contains(next.get("sourcebillid")) || next.getBoolean("sourcesign")) continue;
                iterator.remove();
            }
        }
    }
}

