/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.up;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.model.EntityInfo;

public class UpDrawContract
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(UpDrawContract.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        IFormView view = this.getView();
        IFormView pView = view.getParentView();
        if (pView == null) {
            return;
        }
        String entityId = pView.getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"oribalanceamount", "balanceamount"});
            view.setVisible(Boolean.valueOf(false), new String[]{"oricanloanamount", "billcanloanamount"});
        } else if (ErEntityTypeUtils.isCostEstimateBill((String)entityId)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"balanceamount", "billcanloanamount", "notpayamount"});
        } else if (ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"oribalanceamount", "balanceamount"});
            view.setVisible(Boolean.valueOf(true), new String[]{"oricanloanamount", "billcanloanamount"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        Long partb;
        super.setFilter(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IDataModel pModel = parentView.getModel();
        DynamicObject applier = (DynamicObject)pModel.getValue("applier");
        Boolean contractdeadlinecontrol = ErStdConfig.getContractDeadlineControl();
        String formId = parentView.getEntityId();
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (!contractdeadlinecontrol.booleanValue()) {
            Date now = TripCommonUtil.strToDate((String)TripCommonUtil.DateToStr((Date)new Date()), (String)"yyyy-MM-dd");
            filter.and("enddate", ">=", (Object)now);
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)formId)) {
            partb = 0L;
            Boolean frameworkcontract = (Boolean)pModel.getValue("frameworkcontract");
            DynamicObject billpayer = (DynamicObject)pModel.getValue("billpayerid");
            if (billpayer != null) {
                partb = (Long)billpayer.getPkValue();
            }
            filter.and("contractpartyentry.contractparty", "=", (Object)partb);
            String entrysourceId = "";
            String finalId = "";
            if (!frameworkcontract.booleanValue()) {
                filter.and("balanceamount", ">", (Object)BigDecimal.ZERO);
                QFilter qFilter = this.getOnWayLoanBillFilter();
                if (qFilter != null) {
                    filter.and(qFilter);
                }
                entrysourceId = "contractsrcentryid";
                finalId = "expenseentryentity.id";
            } else {
                entrysourceId = "contractsid";
                finalId = "id";
            }
            String detailtype = (String)pModel.getValue("detailtype");
            DynamicObjectCollection expenseentryentity = pModel.getEntryEntity("expenseentryentity");
            Set<Object> expcurrency = new HashSet();
            if (!frameworkcontract.booleanValue() && "biztype_project".equals(detailtype) && expenseentryentity.size() > 0 && (expcurrency = expenseentryentity.stream().map(p -> (Long)((DynamicObject)p.get("entrycurrency")).getPkValue()).collect(Collectors.toSet())).size() > 0) {
                filter.and("contractcurrency.id", "in", expcurrency);
            }
            String finalEntrysourceId = entrysourceId;
            Long[] entrySourceIds = null;
            DynamicObjectCollection expCollection = pModel.getDataEntity(true).getDynamicObjectCollection("contractentry");
            if (expCollection != null) {
                entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong(finalEntrysourceId)).distinct().toArray(Long[]::new);
            }
            filter.and(finalId, "not in", entrySourceIds);
        } else if (ErEntityTypeUtils.isCostEstimateBill((String)formId)) {
            DynamicObject selectedExpense;
            partb = 0L;
            Boolean frameworkcontract = (Boolean)pModel.getValue("frameworkcontract");
            DynamicObject billpayer = null;
            EntryGrid expenseEntryGrid = (EntryGrid)parentView.getControl("expenseentryentity");
            DynamicObjectCollection expenseEntity = pModel.getEntryEntity("expenseentryentity");
            int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
            if (selectedExpenseEntryRowsArr != null && selectedExpenseEntryRowsArr.length > 0 && expenseEntity != null && expenseEntity.size() > 0 && (selectedExpense = (DynamicObject)expenseEntity.get(selectedExpenseEntryRowsArr[0])) != null) {
                billpayer = selectedExpense.getDynamicObject("entrywlunit");
            }
            if (billpayer != null) {
                partb = (Long)billpayer.getPkValue();
            }
            if (partb != 0L) {
                filter.and("partb", "=", (Object)partb).or("partanew", "=", (Object)partb);
            }
            String entrysourceId = "";
            String finalId = "";
            if (frameworkcontract.booleanValue()) {
                entrysourceId = "contractsid";
                finalId = "id";
            }
            String finalEntrysourceId = entrysourceId;
            Long[] entrySourceIds = null;
            DynamicObjectCollection expCollection = pModel.getEntryEntity("contractentry");
            if (expCollection != null) {
                entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong(finalEntrysourceId)).distinct().toArray(Long[]::new);
            }
            filter.and(finalId, "not in", entrySourceIds);
        } else if (ErEntityTypeUtils.isPrePayBill((String)formId)) {
            partb = 0L;
            Boolean frameworkcontract = (Boolean)pModel.getValue("frameworkcontract");
            DynamicObject billpayer = (DynamicObject)pModel.getValue("billpayerid");
            if (billpayer != null) {
                partb = (Long)billpayer.getPkValue();
            }
            filter.and("contractpartyentry.contractparty", "=", (Object)partb);
            String entrysourceId = "";
            String finalId = "";
            if (!frameworkcontract.booleanValue()) {
                QFilter qFilter = this.getOnWayLoanBillFilter();
                if (qFilter != null) {
                    filter.and(qFilter);
                }
                entrysourceId = "contractsrcentryid";
                finalId = "expenseentryentity.id";
            } else {
                entrysourceId = "contractsid";
                finalId = "id";
            }
            String finalEntrysourceId = entrysourceId;
            Long[] entrySourceIds = null;
            DynamicObjectCollection expCollection = pModel.getEntryEntity("contractentry");
            if (expCollection != null) {
                entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong(finalEntrysourceId)).distinct().toArray(Long[]::new);
            }
            filter.and(finalId, "not in", entrySourceIds);
        }
        QFilter qFilter = PublicUpBillUtil.getPublicUpBillQfilter((Long)ErCommonUtils.getPk((Object)applier), (Long)ErCommonUtils.getPk((Object)pModel.getValue("company")), (Long)ErCommonUtils.getPk((Object)pModel.getValue("costcompany")), (String)"costcompany");
        Optional.ofNullable(qFilter).ifPresent(arg_0 -> ((QFilter)filter).and(arg_0));
        log.info("-----filter-----", (Object)filter.toString());
        e.setSpecialDataPermQFilter(null);
        e.addCustomQFilter(filter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    private QFilter getOnWayLoanBillFilter() {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.wbsrcentryid", "expenseentryentity.wbsrcbillid");
        DynamicObject[] conBills = BusinessDataServiceHelper.load((String)"er_contractbill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcentryid", ">", (Object)0)});
        String OnWayCondition = "A,B,C,D";
        List collect = Arrays.stream(conBills).filter(loanBillOnWay -> OnWayCondition.contains(loanBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).distinct().collect(Collectors.toList());
        QFilter filter = null;
        if (!collect.isEmpty()) {
            filter = new QFilter("expenseentryentity.id", "not in", collect);
        }
        return filter;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            BillList list;
            ListSelectedRowCollection listSelectedRowCollection;
            Set billIdcollect;
            IFormView pView = this.getView().getParentView();
            if (pView != null && (ErEntityTypeUtils.isPublicReimburseBill((String)pView.getEntityId()) || ErEntityTypeUtils.isPrePayBill((String)pView.getEntityId()))) {
                BillList list2 = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection listSelectedRowCollection2 = list2.getSelectedRows();
                Long[] billsId = (Long[])listSelectedRowCollection2.stream().map(b -> (Long)b.getPrimaryKeyValue()).toArray(Long[]::new);
                if (!"2".equals(ErStdConfig.getApplyprojectbillRelated())) {
                    String OnWayCondition;
                    EntityInfo prepayInfo = new EntityInfo.Builder().entityName("er_prepaybill").entryName("expenseentryentity").sourceName("wbsrcbillid").build();
                    if (ContractUtil.getProjectHasOnWayBills((Long[])billsId, (EntityInfo)prepayInfo, (String)(OnWayCondition = "B,C,E,F")).size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u6b63\u5728\u9884\u4ed8\u7684\u6b3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u5173\u8054\u3002", (String)"PrePayBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    prepayInfo = new EntityInfo.Builder().entityName("er_prepaybill").entryName("contractentry").sourceName("contractsid").build();
                    if (ContractUtil.getProjectHasOnWayBills((Long[])billsId, (EntityInfo)prepayInfo, (String)OnWayCondition).size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u6b63\u5728\u9884\u4ed8\u7684\u6b3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u5173\u8054\u3002", (String)"PrePayBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    if (ErEntityTypeUtils.isPrePayBill((String)pView.getEntityId())) {
                        prepayInfo = new EntityInfo.Builder().entityName("er_publicreimbursebill").entryName("expenseentryentity").sourceName("wbsrcbillid").build();
                        if (ContractUtil.getProjectHasOnWayBills((Long[])billsId, (EntityInfo)prepayInfo, (String)OnWayCondition).size() > 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u6b63\u5728\u62a5\u9500\u7684\u6b3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u5173\u8054\u3002", (String)"PrePayBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            evt.setCancel(true);
                            return;
                        }
                        prepayInfo = new EntityInfo.Builder().entityName("er_publicreimbursebill").entryName("contractentry").sourceName("contractsid").build();
                        if (ContractUtil.getProjectHasOnWayBills((Long[])billsId, (EntityInfo)prepayInfo, (String)OnWayCondition).size() > 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u6b63\u5728\u62a5\u9500\u7684\u6b3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u5173\u8054\u3002", (String)"PrePayBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            evt.setCancel(true);
                            return;
                        }
                    }
                }
                Set billnocollect = listSelectedRowCollection2.stream().map(b -> (Long)b.getPrimaryKeyValue()).collect(Collectors.toSet());
                Set pbillnocollect = pView.getModel().getEntryEntity("contractentry").stream().map(b -> (Long)b.get("contractsid")).collect(Collectors.toSet());
                List entryidcollect = listSelectedRowCollection2.stream().map(b -> (Long)b.getEntryPrimaryKeyValue()).collect(Collectors.toList());
                billnocollect.addAll(pbillnocollect);
                if (billnocollect.size() != 1 || billnocollect.size() == 1 && entryidcollect.size() == 1 && entryidcollect.get(0) == null) {
                    pView.getModel().beginInit();
                    pView.getModel().deleteEntryData("contractentry");
                    pView.getModel().endInit();
                }
            } else if (pView != null && ErEntityTypeUtils.isCostEstimateBill((String)pView.getEntityId()) && (billIdcollect = (listSelectedRowCollection = (list = (BillList)this.getControl("billlistap")).getSelectedRows()).stream().map(b -> (Long)b.getPrimaryKeyValue()).collect(Collectors.toSet())) != null && billIdcollect.size() > 0) {
                ArrayList itemList = Lists.newArrayList();
                DynamicObjectCollection contractList = pView.getModel().getEntryEntity("contractentry");
                ArrayList deleteRows = Lists.newArrayList();
                for (Long billId : billIdcollect) {
                    DynamicObject wlUnit;
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"er_contractbill");
                    if (dynamicObject == null || (wlUnit = dynamicObject.getDynamicObject("partb")) == null) continue;
                    itemList.add((Long)wlUnit.getPkValue());
                }
                for (int i2 = 0; i2 < contractList.size(); ++i2) {
                    if (!itemList.contains(((DynamicObject)((DynamicObject)contractList.get(i2)).get("contractpartb")).getPkValue())) continue;
                    deleteRows.add(i2);
                }
                if (!deleteRows.isEmpty() && contractList != null && contractList.size() > 0) {
                    pView.getModel().beginInit();
                    pView.getModel().deleteEntryRows("contractentry", deleteRows.stream().mapToInt(i -> i).toArray());
                    pView.getModel().endInit();
                }
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }
}

