/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.botp.up;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class UpDrawContractToExpList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String formId = parentView.getEntityId();
            IDataModel parentModel = parentView.getModel();
            DynamicObjectCollection expCollection = null;
            Long payerId = null;
            Long currency = null;
            String entrysourceId = null;
            QFilter bizQfilter = new QFilter("1", "=", (Object)1);
            if (parentModel == null) {
                return;
            }
            Long costCompany = ErCommonUtils.getPk((Object)parentModel.getValue("costcompany"));
            Long company = ErCommonUtils.getPk((Object)parentModel.getValue("company"));
            currency = ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
            if (ErEntityTypeUtils.isPublicReimburseBill((String)formId)) {
                entrysourceId = "wbsrcbillid";
                expCollection = parentModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                payerId = ErCommonUtils.getPk((Object)parentModel.getValue("billpayerid"));
                if (payerId != null) {
                    bizQfilter.and("supplier", "in", (Object)payerId);
                }
            } else if (ErEntityTypeUtils.isPrePayBill((String)formId)) {
                entrysourceId = "wbsrcentryid";
                expCollection = parentModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                payerId = ErCommonUtils.getPk((Object)parentModel.getValue("billpayerid"));
                if (payerId != null) {
                    bizQfilter.and("supplier", "in", (Object)payerId);
                }
            } else if (ErEntityTypeUtils.isCostEstimateBill((String)formId)) {
                entrysourceId = "wbsrcbillid";
                expCollection = parentModel.getEntryEntity("expenseentryentity");
                Object costcompany = parentModel.getValue("costcompany");
                bizQfilter.and("contract.fiaccountorg.id", "=", (Object)ErCommonUtils.getPk((Object)costcompany));
                if (currency != null) {
                    bizQfilter.and("currency", "=", (Object)currency);
                }
            }
            this.filterBySourceIds(e, expCollection, entrysourceId, bizQfilter);
        }
    }

    protected void filterBySourceIds(SetFilterEvent e, DynamicObjectCollection expCollection, String entrysourceId, QFilter bizQfilter) {
        String finalEntrysourceId = entrysourceId;
        Long[] entrySourceIds = null;
        if (expCollection != null) {
            entrySourceIds = (Long[])expCollection.stream().map(row -> row.getLong(finalEntrysourceId)).distinct().toArray(Long[]::new);
        }
        QFilter finalQfilter = new QFilter("id", "not in", entrySourceIds);
        finalQfilter.and(bizQfilter);
        e.addCustomQFilter(finalQfilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel model = parentView.getModel();
        String entityId = parentView.getEntityId();
        BillList source = (BillList)args.getSource();
        String bindEntity = source.getEntityType().getName();
        this.putCacheEntityId(bindEntity);
        if (entityId.equals("botp_convertop") && ErEntityTypeUtils.isPrePayBill((String)parentView.getFormShowParameter().getParentFormId()) || ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"reimbursableamt", "reimbursedcomamt", "payway.name", "status", "enable", "creator.name", "payplanentryid"});
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            DynamicObject payer = model.getDataEntity().getDynamicObject("billpayerid");
            ContractToExpCollListDataProvider contractToExpCollListDataProvider = new ContractToExpCollListDataProvider(view, payer);
            args.setListDataProvider((IListDataProvider)contractToExpCollListDataProvider);
        }
        if (ErEntityTypeUtils.isCostEstimateBill((String)entityId)) {
            ContractToExpCollListDataProvider contractToExpCollListDataProvider = new ContractToExpCollListDataProvider(view);
            args.setListDataProvider((IListDataProvider)contractToExpCollListDataProvider);
        }
    }

    private void putCacheEntityId(String bindEntity) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("bindEntityId", bindEntity);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            boolean isSame;
            IListView view = (IListView)this.getView();
            IPageCache pageCache = view.getPageCache();
            String bindEntityId = pageCache.get("bindEntityId");
            if (bindEntityId == null) {
                return;
            }
            ListSelectedRowCollection lists = view.getSelectedRows();
            Long[] enttyIds = null;
            if (lists != null) {
                enttyIds = (Long[])lists.stream().map(row -> row.getPrimaryKeyValue()).distinct().toArray(Long[]::new);
            }
            QFilter entryQfilter = new QFilter("id", "in", enttyIds);
            DynamicObjectCollection wlunits = QueryServiceHelper.query((String)bindEntityId, (String)"supplier", (QFilter[])new QFilter[]{entryQfilter});
            boolean bl = isSame = wlunits.stream().map(row -> row.get(0)).distinct().count() == 1L;
            if (!isSame) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UpDrawContractToExpList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (wlunits.size() > 0 && null != view.getParentView().getModel().getProperty("billpayertype")) {
                view.getParentView().getModel().setValue("billpayertype", (Object)"bd_supplier");
                ErCommonUtils.setDealUnit((IFormView)view.getParentView(), (Long)((Long)((DynamicObject)wlunits.get(0)).get(0)));
            }
        }
    }

    private static class ContractToExpCollListDataProvider
    extends ListDataProvider {
        IFormView view;
        DynamicObject payer;

        ContractToExpCollListDataProvider(IFormView view) {
            this.view = view;
            this.payer = new DynamicObject();
        }

        ContractToExpCollListDataProvider(IFormView view, DynamicObject payer) {
            this.view = view;
            this.payer = payer;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection collection = super.getData(start, limit);
            IFormView parentView = this.view.getParentView();
            boolean isFilterSup = this.isFilterSup(parentView);
            String entityId = parentView.getEntityId();
            if (this.payer == null && isFilterSup) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u3002", (String)"UpDrawContractToExpList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (ErEntityTypeUtils.isCostEstimateBill((String)entityId)) {
                this.removeOnWayPrepayBills(collection);
            }
            return collection;
        }

        private boolean isFilterSup(IFormView parentView) {
            Long company = ErCommonUtils.getPk((Object)parentView.getModel().getValue("company"));
            return SystemParamterUtil.getIsPublicUpFilterBySupplier((Long)company);
        }

        private void removeOnWayPrepayBills(DynamicObjectCollection collection) {
            Long[] billsId = (Long[])collection.stream().map(b -> (Long)b.getPkValue()).toArray(Long[]::new);
            String selectedProperties = String.join((CharSequence)",", "id", "billstatus", "expenseentryentity.id", "expenseentryentity.wbsrcbillid", "expenseentryentity.wbsrcentryid");
            DynamicObject[] prepayBills = BusinessDataServiceHelper.load((String)"er_prepaybill", (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("expenseentryentity.wbsrcbillid", "in", (Object)billsId)});
            String OnWayCondition = "A,B,C,D,E,F";
            List collect = Arrays.stream(prepayBills).filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection("expenseentryentity").stream().map(OnWayBillEntry -> OnWayBillEntry.getLong("wbsrcentryid"))).collect(Collectors.toList());
            collection.removeIf(bill -> collect.contains((Long)bill.getPkValue()));
        }
    }
}

