/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;

public class ErExpenseDetailListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid abstractGrid = (AbstractGrid)this.getView().getControl("billlistap");
        abstractGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        boolean fromReport = Boolean.parseBoolean((String)map.get("fromReport"));
        for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!fromReport && "currency.name".equalsIgnoreCase(fieldName)) {
                commonFilterColumn.setDefaultValue("1");
            }
            if (!fromReport || !Arrays.asList("company.name", "bizdate").contains(fieldName)) continue;
            commonFilterColumn.setDefaultValue(null);
        }
    }

    public void setFilter(SetFilterEvent e) {
        String appId;
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map != null && Boolean.parseBoolean((String)map.get("fromReport")) && (appId = this.getView().getFormShowParameter().getAppId()) != null) {
            List companyIds = ErPermissionServiceHelper.getOrgListWithQueryPerm((String)appId, (String)"er_expense_detail_query");
            String permissionField = MetadataServiceHelper.getDataEntityType((String)"er_expense_detail_query").getPermissionControlType().getDataDimensionField();
            if (companyIds != null && companyIds.size() > 0) {
                e.getQFilters().add(new QFilter(permissionField, "in", (Object)companyIds));
                if (e.getMainOrgQFilter() != null) {
                    e.getMainOrgQFilter().__setProperty(permissionField);
                    e.getMainOrgQFilter().__setValue((Object)companyIds);
                }
            }
        }
        e.getQFilters().add(new QFilter("billstatus", "in", Arrays.asList("B", "C", "E", "F", "G", "I")));
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc) {
            String number;
            DynamicObject dynamicObject;
            ColumnDesc columnDesc = (ColumnDesc)e.getSource();
            if (Arrays.asList("company.name", "org.name", "costcompany.name", "costdept.name").contains(columnDesc.getKey()) && (dynamicObject = e.getRowData().getDynamicObject(columnDesc.getKey().substring(0, columnDesc.getKey().indexOf(".")))) != null && dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"number") && (number = dynamicObject.getString("number")) != null) {
                e.setFormatValue((Object)(number + e.getFormatValue()));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "billno": {
                ListSelectedRow row = ((BillListHyperLinkClickEvent)event).getCurrentRow();
                if (row == null) {
                    BillList billList = (BillList)event.getSource();
                    ListSelectedRow listSelectedRow = row = billList.getSelectedRows().size() > 0 ? billList.getSelectedRows().get(0) : null;
                }
                if (row == null) {
                    return;
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())};
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)((ListView)this.getView()).getBillFormId(), (String)"billid, billtype", (QFilter[])qFilters);
                if (dynamicObject == null) {
                    return;
                }
                this.showBill(dynamicObject.getString("billtype"), dynamicObject.getLong("billid"));
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.setCancel(true);
    }

    private void showBill(String formId, Object pk) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(formId);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(pk);
        HashMap<String, String> customMap = new HashMap<String, String>(4);
        customMap.put("hiddenTbmain", "true");
        showParameter.setCustomParams(customMap);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map != null && Boolean.parseBoolean((String)map.get("fromReport"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
        }
    }
}

