/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report;

import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.fi.er.common.ShowPageUtils;

public class ErReportManageListPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String TABAP = "tabap";

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        this.shiftTab(TabAndMetaDataId.LOAN);
    }

    private void shiftTab(TabAndMetaDataId tabAndMetaDataId) {
        String billFormId = tabAndMetaDataId.getValue();
        String targetKey = tabAndMetaDataId.getKey();
        String pageIdCache = this.getPageCache().get(billFormId);
        if (pageIdCache != null && !pageIdCache.isEmpty()) {
            IFormView view = SessionManager.getCurrent().getView(pageIdCache);
            this.getView().sendFormAction(view);
        } else {
            ListShowParameter listFormShowParameter = ShowPageUtils.createListFormShowParameter((String)"bos_list", (String)targetKey, (String)billFormId, (ShowType)ShowType.InContainer, null);
            this.getView().showForm((FormShowParameter)listFormShowParameter);
            this.getPageCache().put(billFormId, listFormShowParameter.getPageId());
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String selectKey = tabSelectEvent.getTabKey();
        if (TabAndMetaDataId.LOAN.getKey().equals(selectKey)) {
            this.shiftTab(TabAndMetaDataId.LOAN);
        }
        if (TabAndMetaDataId.REIMBURSE.getKey().equals(selectKey)) {
            this.shiftTab(TabAndMetaDataId.REIMBURSE);
        }
    }

    static enum TabAndMetaDataId {
        LOAN("loantab", "er_loanbill_ds"),
        REIMBURSE("reimtab", "er_reimbursebill_ds");

        private String key;
        private String value;

        private TabAndMetaDataId(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

