/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.report.mb.board.dept.reim;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractMobFormPlugin;

public class DeptAnalysisFilterPagePlugin
extends AbstractMobFormPlugin {
    private static final String SAVEBTN = "savebtn";
    private static final String RESETBTN = "resetbtn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"allstatus_select", "allstatus_unselect", "inprocess_select", "inprocess_unselect", "done_select", "done_unselect", SAVEBTN, RESETBTN});
        this.addClickListeners(new String[]{"allbill_select", "allbill_unselect", "dailyreim_select", "dailyreim_unselect", "tripreim_select", "tripreim_unselect", "pubreim_select", "pubreim_unselect"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initFilterPage();
    }

    private void initFilterPage() {
        this.translateData(this.getView().getParentView(), this.getView());
        this.getView().updateView();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (key.endsWith("select")) {
            switch (key) {
                case "allstatus_select": 
                case "allstatus_unselect": {
                    this.clickAssiant(false, "allstatus_checked", "allstatus_checked", "inprocess_checked", "done_checked");
                    break;
                }
                case "inprocess_select": 
                case "inprocess_unselect": {
                    this.clickAssiant(false, "inprocess_checked", "allstatus_checked", "inprocess_checked", "done_checked");
                    break;
                }
                case "done_select": 
                case "done_unselect": {
                    this.clickAssiant(false, "done_checked", "allstatus_checked", "inprocess_checked", "done_checked");
                    break;
                }
                case "allbill_select": 
                case "allbill_unselect": {
                    this.clickAssiant(true, "allbilltype_checked", "allbilltype_checked", "dailyreim_checked", "tripreim_checked", "pubreim_checked");
                    break;
                }
                case "dailyreim_select": 
                case "dailyreim_unselect": {
                    this.clickAssiant(true, "dailyreim_checked", "allbilltype_checked", "dailyreim_checked", "tripreim_checked", "pubreim_checked");
                    break;
                }
                case "tripreim_select": 
                case "tripreim_unselect": {
                    this.clickAssiant(true, "tripreim_checked", "allbilltype_checked", "dailyreim_checked", "tripreim_checked", "pubreim_checked");
                    break;
                }
                case "pubreim_select": 
                case "pubreim_unselect": {
                    this.clickAssiant(true, "pubreim_checked", "allbilltype_checked", "dailyreim_checked", "tripreim_checked", "pubreim_checked");
                    break;
                }
            }
        } else if (SAVEBTN.equals(key)) {
            this.translateData(this.getView(), this.getView().getParentView());
            this.getView().close();
        } else if (RESETBTN.equals(key)) {
            this.clickAssiant(false, "allstatus_checked", "allstatus_checked", "inprocess_checked", "done_checked");
            this.clickAssiant(true, "allbilltype_checked", "allbilltype_checked", "dailyreim_checked", "tripreim_checked", "pubreim_checked");
            this.getModel().setValue("expenseitemval", null);
            this.getModel().setValue("tripexpenseitemval", null);
            this.getModel().setValue("projectval", null);
        }
    }

    private void clickAssiant(boolean multi, String curClick, String all, String ... others) {
        block3: {
            block2: {
                this.getModel().setValue(curClick, (Object)true);
                if (!curClick.equals(all)) break block2;
                for (String other : others) {
                    this.getModel().setValue(other, (Object)false);
                }
                break block3;
            }
            this.getModel().setValue(all, (Object)false);
            if (multi) break block3;
            for (String other : others) {
                if (curClick.equals(other)) continue;
                this.getModel().setValue(other, (Object)false);
            }
        }
    }

    private void translateData(IFormView srcView, IFormView tarView) {
        if (srcView != null && tarView != null) {
            DynamicObject dataEntity = srcView.getModel().getDataEntity();
            IDataModel pModel = tarView.getModel();
            DataEntityPropertyCollection pProperties = pModel.getDataEntity().getDataEntityType().getProperties();
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            pModel.beginInit();
            for (IDataEntityProperty property : properties) {
                IDataEntityProperty pProperty = (IDataEntityProperty)pProperties.get((Object)property.getName());
                if (pProperty == null) continue;
                pModel.setValue(pProperty.getName(), property.getValueFast((Object)dataEntity));
            }
            pModel.endInit();
        }
    }
}

