/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.stakeholderchange.plugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class ErStakeHoldersChangeBtnListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ErStakeHoldersChangeBtnListPlugin.class);
    private static final String CHANGE_STAKEHOLDER_FLOW = "changestakeholderflow";
    private static final String CHANGE_PROJECT_OWNER = "changedprojectower";
    private static final String BATCH_ADDPROJECT_OWER = "batchaddprojectower";
    private static final String STAKEHOLDERS_CHANGE = "stakeholderschange";

    public void afterBindData(EventObject e) {
        Long companyId = RequestContext.get().getOrgId();
        String stakeHoldersChange = (String)ErCommonUtils.getEMParameter((long)companyId, (String)STAKEHOLDERS_CHANGE);
        logger.info("\u5e72\u7cfb\u4eba\u53d8\u66f4\u6d41\u7a0b\u53c2\u6570:" + stakeHoldersChange);
        if (stakeHoldersChange == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHANGE_STAKEHOLDER_FLOW});
            this.getView().setVisible(Boolean.TRUE, new String[]{CHANGE_PROJECT_OWNER, BATCH_ADDPROJECT_OWER});
            return;
        }
        switch (stakeHoldersChange) {
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{CHANGE_PROJECT_OWNER, BATCH_ADDPROJECT_OWER});
                this.getView().setVisible(Boolean.TRUE, new String[]{CHANGE_STAKEHOLDER_FLOW});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.FALSE, new String[]{CHANGE_STAKEHOLDER_FLOW});
                this.getView().setVisible(Boolean.TRUE, new String[]{CHANGE_PROJECT_OWNER, BATCH_ADDPROJECT_OWER});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        block3 : switch (operateKey = source.getOperateKey()) {
            case "pushstakeholders": {
                IListView listView = (IListView)this.getView();
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                String billFormId = ((ListView)listView).getEntityTypeId();
                for (int i = 0; i < selectedRows.size(); ++i) {
                    ListSelectedRow listSelectedRow = selectedRows.get(i);
                    Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
                    Map targetBills = BFTrackerServiceHelper.findTargetBills((String)billFormId, (Long[])new Long[]{primaryKeyValue});
                    if (targetBills.size() == 0 || !this.judgeTargetBillStatus(targetBills)) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5355\u636e\u5df2\u5b58\u5728\u53d8\u66f4\u7533\u8bf7\u6d41\u7a0b\uff0c\u8bf7\u7b49\u6d41\u7a0b\u7ed3\u675f\u540e\u518d\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ErStakeHoldersChangeBillPlugin_03", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break block3;
                }
                break;
            }
        }
    }

    private boolean judgeTargetBillStatus(Map<String, HashSet<Long>> targetBills) {
        if (!targetBills.containsKey("er_stakeholderchangebill")) {
            return false;
        }
        String cancelPushBillStatus = "A,B,C,D";
        HashSet<Long> billIds = targetBills.get("er_stakeholderchangebill");
        DynamicObjectCollection billData = QueryServiceHelper.query((String)"er_stakeholderchangebill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        for (int i = 0; i < billData.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)billData.get(i);
            String billStatus = dynamicObject.getString("billstatus");
            if (!cancelPushBillStatus.contains(billStatus)) continue;
            return true;
        }
        return false;
    }
}

