/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.stakeholderchange.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.stakeholderchange.util.ErStakeHolderChangeBillUtil;
import org.apache.commons.lang3.StringUtils;

public class ErStakeHoldersRelateBillListNewPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String CONFIRM_BTN = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ENTRY_NAME = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM_BTN, BTN_CANCEL});
    }

    public void afterBindData(EventObject e) {
        int updateParam;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        HashMap<String, Boolean> ismul = new HashMap<String, Boolean>(1);
        int n = updateParam = formShowParameter.getCustomParam("update") == null ? -1 : (Integer)formShowParameter.getCustomParam("update");
        if (updateParam == 0) {
            ismul.put("ismul", true);
        } else if (updateParam == 1) {
            ismul.put("ismul", false);
        }
        this.getView().updateControlMetadata(ENTRY_NAME, ismul);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String entryId = customParams.get("entryId").toString();
        DynamicObjectCollection collection = this.getCollection();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        IDataModel model = this.getModel();
        int[] rowIndexes = model.batchCreateNewEntryRow(ENTRY_NAME, collection.size());
        HashMap billEntryIdAndBillIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int rowIndex : rowIndexes) {
            List<Long> oriBillIds;
            DynamicObject dynamicObject = (DynamicObject)collection.get(rowIndex);
            Object oribillid = dynamicObject.get("id");
            if (oribillid == null) continue;
            if (billEntryIdAndBillIdMap.containsKey(entryId)) {
                oriBillIds = (List)billEntryIdAndBillIdMap.get(entryId);
                oriBillIds.add(Long.parseLong(oribillid.toString()));
                continue;
            }
            oriBillIds = Lists.newArrayListWithCapacity((int)16);
            oriBillIds.add(Long.parseLong(oribillid.toString()));
            billEntryIdAndBillIdMap.put(entryId, oriBillIds);
        }
        Map<Long, DynamicObjectCollection> resultMap = ErStakeHolderChangeBillUtil.dealProjectOwner(billEntryIdAndBillIdMap);
        for (int rowIndex : rowIndexes) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(rowIndex);
            long id = dynamicObject.getLong("id");
            model.setValue("billno", dynamicObject.get("billno"), rowIndex);
            model.setValue("bizdate", dynamicObject.get("bizdate"), rowIndex);
            model.setValue("description", dynamicObject.get("description"), rowIndex);
            if (resultMap.containsKey(id)) {
                model.setValue("projectower", (Object)resultMap.get(id), rowIndex);
            }
            model.setValue("id", dynamicObject.get("id"), rowIndex);
            model.setValue("applier", dynamicObject.get("applier"), rowIndex);
            model.setValue("projectname", dynamicObject.get("projectname"), rowIndex);
        }
    }

    private DynamicObjectCollection getCollection() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String entryId = customParams.get("entryId").toString();
        Object currentUserId = customParams.get("currentUserId");
        DynamicObjectCollection load = QueryServiceHelper.query((String)entryId, (String)"id,projectower,billstatus", (QFilter[])new QFilter[]{new QFilter("projectower.fbasedataid", "=", currentUserId)});
        ArrayList<Long> ids = new ArrayList<Long>();
        if (load != null) {
            for (int i = 0; i < load.size(); ++i) {
                ids.add(ErCommonUtils.getPk((Object)((DynamicObject)load.get(i)).get("id")));
            }
        }
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)8);
        List billNos = (List)formShowParameter.getCustomParam("billNos");
        if (CollectionUtils.isNotEmpty((Collection)billNos)) {
            QFilter qFilter = new QFilter("billno", "not in", (Object)billNos);
            qFilters.add(qFilter);
        }
        ArrayList billStatus = Lists.newArrayListWithCapacity((int)2);
        billStatus.add("H");
        billStatus.add("I");
        QFilter filter = new QFilter("creator", "=", currentUserId).or(new QFilter("applier", "=", currentUserId)).or(new QFilter("id", "in", ids)).and("billstatus", "not in", (Object)billStatus);
        qFilters.add(filter);
        DynamicObjectCollection billData = QueryServiceHelper.query((String)entryId, (String)"id,billno,bizdate,description,projectower,applier,projectower as  projectname", (QFilter[])qFilters.toArray(new QFilter[0]));
        ErStakeHolderChangeBillUtil.dealProjectOwner(billData, entryId);
        return billData;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        IFormView parentView = view.getParentView();
        switch (key) {
            case "btn_ok": {
                int[] selectRows = ((EntryGrid)this.getControl(ENTRY_NAME)).getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    view.close();
                    break;
                }
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                DynamicObjectCollection allData = model.getEntryEntity(ENTRY_NAME);
                for (int i = 0; i < selectRows.length; ++i) {
                    dynamicObjects.add(allData.get(selectRows[i]));
                }
                this.setParentData(dynamicObjects, parentView);
                view.sendFormAction(parentView);
                view.close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }

    private void setParentData(DynamicObjectCollection dynamicObjectCollection, IFormView parentView) {
        IDataModel model = parentView.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("changeentryentity");
        Integer currentRowIndex = (Integer)formShowParameter.getCustomParam("currentRowIndex");
        int updateIndex = (Integer)formShowParameter.getCustomParam("update");
        String entryId = formShowParameter.getCustomParam("entryId").toString();
        DynamicObject currentRow = (DynamicObject)dynamicObjects.get(currentRowIndex.intValue());
        HashMap billEntryIdAndBillIdMap = Maps.newHashMapWithExpectedSize((int)16);
        int size = dynamicObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            List<Long> oriBillIds;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Object oribillid = dynamicObject.get("id");
            if (oribillid == null) continue;
            if (billEntryIdAndBillIdMap.containsKey(entryId)) {
                oriBillIds = (List)billEntryIdAndBillIdMap.get(entryId);
                oriBillIds.add(Long.parseLong(oribillid.toString()));
                continue;
            }
            oriBillIds = Lists.newArrayListWithCapacity((int)16);
            oriBillIds.add(Long.parseLong(oribillid.toString()));
            billEntryIdAndBillIdMap.put(entryId, oriBillIds);
        }
        Map<Long, DynamicObjectCollection> resultMap = ErStakeHolderChangeBillUtil.dealProjectOwner(billEntryIdAndBillIdMap);
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Object oriBillId = currentRow.get("oribillid");
            if (!Objects.isNull(oriBillId) && StringUtils.isNotEmpty((CharSequence)oriBillId.toString())) {
                DynamicObjectCollection tmpDatas = resultMap.get(dynamicObject.getLong("id"));
                String projectUserName = ErStakeHolderChangeBillUtil.dealUserName(tmpDatas);
                dynamicObject.set("projectname", (Object)projectUserName);
                if (Objects.isNull(currentRow.get("oribillno")) || StringUtils.equals((CharSequence)"", (CharSequence)currentRow.getString("oribillno")) || updateIndex == 1) {
                    ErStakeHolderChangeBillUtil.setDataByIndex(model, currentRowIndex, dynamicObject, entryId);
                    model.setValue("stakeholderafter", (Object)(tmpDatas == null ? "" : (tmpDatas.size() == 0 ? "" : tmpDatas)), currentRowIndex.intValue());
                    continue;
                }
                int newRowIndex = model.createNewEntryRow("changeentryentity");
                ErStakeHolderChangeBillUtil.setDataByIndex(model, newRowIndex, dynamicObject, entryId);
                model.setValue("stakeholderafter", (Object)(tmpDatas == null ? "" : (tmpDatas.size() == 0 ? "" : tmpDatas)), newRowIndex);
                continue;
            }
            Long pk = dynamicObject.getLong("id");
            DynamicObjectCollection tmpDatas = resultMap.get(pk);
            String projectUserName = ErStakeHolderChangeBillUtil.dealUserName(tmpDatas);
            dynamicObject.set("projectname", (Object)projectUserName);
            if (Objects.isNull(currentRow.get("oribillno")) || StringUtils.equals((CharSequence)"", (CharSequence)currentRow.getString("oribillno")) || updateIndex == 1) {
                ErStakeHolderChangeBillUtil.setDataByIndex(model, currentRowIndex, dynamicObject, entryId);
                if (resultMap.containsKey(pk)) {
                    model.setValue("stakeholderafter", (Object)tmpDatas, currentRowIndex.intValue());
                    continue;
                }
                model.setValue("stakeholderafter", (Object)"", currentRowIndex.intValue());
                continue;
            }
            int newRowIndex = model.createNewEntryRow("changeentryentity");
            ErStakeHolderChangeBillUtil.setDataByIndex(model, newRowIndex, dynamicObject, entryId);
            if (resultMap.containsKey(pk)) {
                model.setValue("stakeholderafter", (Object)tmpDatas, newRowIndex);
                continue;
            }
            model.setValue("stakeholderafter", (Object)"", newRowIndex);
        }
    }
}

