/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.autoopened;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripUserGrantUtils;
import org.apache.commons.lang3.StringUtils;

public class TripAutoOpenedListPlugin
extends AbstractListPlugin {
    private static final String OPENED_BTN = "tripopened";
    private static final String SYNC_ADMIN_USER = "syncadmin";
    private static final Log logger = LogFactory.getLog(TripAutoOpenedListPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{OPENED_BTN});
        this.addItemClickListeners(new String[]{SYNC_ADMIN_USER});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)OPENED_BTN, (CharSequence)itemKey)) {
            try {
                ListView view = (ListView)this.getView();
                ListSelectedRowCollection selectedRows = view.getSelectedRows();
                if (selectedRows.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u670d\u52a1\u5546\u540c\u65f6\u5f00\u901a\uff0c\u8bf7\u8c03\u6574\u3002", (String)"TripAutoOpenedListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = this.getDbData(selectedRows);
                if (dynamicObject == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u65e0\u6cd5\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u5c1d\u8bd5\u3002", (String)"TripAutoOpenedListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (dynamicObject.getInt("openedstatus") == 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5546\u5df2\u5f00\u901a\uff0c\u65e0\u9700\u91cd\u590d\u5f00\u901a\u3002", (String)"TripAutoOpenedListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                String server = dynamicObject.getString("servers");
                HashMap params = Maps.newHashMapWithExpectedSize((int)1);
                params.put("porttype", "pull");
                Object invokeResult = TripCommonUtil.invoke((String)server, (String)"er_biz_info", null, null, (Map)params);
                if (invokeResult instanceof List) {
                    List ls = (List)invokeResult;
                    Map result = (Map)ls.get(0);
                    if (null == result || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) {
                        dynamicObject.set("openedstatus", (Object)2);
                    } else {
                        boolean exists;
                        JSONObject jsonObject;
                        int errorCode;
                        ArrayList resultData;
                        Object data;
                        Boolean finalResult = Boolean.FALSE;
                        if (Supplier.XIECHENG.name().equals(server) && (data = result.get("data")) != null && CollectionUtils.isNotEmpty((Collection)(resultData = (ArrayList)data)) && (errorCode = (jsonObject = (JSONObject)resultData.get(0)).getIntValue("ErrorCode")) == 0) {
                            finalResult = Boolean.TRUE;
                        }
                        if ((exists = QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)server)})) && finalResult.booleanValue()) {
                            dynamicObject.set("openedstatus", (Object)1);
                            dynamicObject.set("billstatus", (Object)"B");
                        } else {
                            dynamicObject.set("openedstatus", (Object)2);
                        }
                    }
                }
                dynamicObject.set("synctraceid", (Object)RequestContext.get().getTraceId());
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"TripAutoOpenedListPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u81ea\u52a9\u5f00\u901a,\u5f00\u901a\u670d\u52a1\u5546\u5931\u8d25:", (Throwable)e);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)SYNC_ADMIN_USER)) {
            try {
                ListView view = (ListView)this.getView();
                ListSelectedRowCollection selectedRows = view.getSelectedRows();
                DynamicObject dynamicObject = this.getDbData(selectedRows);
                if (dynamicObject == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u65e0\u6cd5\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u5c1d\u8bd5\u3002", (String)"TripAutoOpenedListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                int openedstatus = dynamicObject.getInt("openedstatus");
                if (openedstatus != 1) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5546\u672a\u5f00\u901a\u6216\u8005\u5f00\u901a\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5f00\u901a\u540e\u518d\u8fdb\u884c\u540c\u6b65\u3002", (String)"TripAutoOpenedListPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                int syncadminstatus = dynamicObject.getInt("syncadminstatus");
                if (syncadminstatus == 1) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5df2\u540c\u6b65\uff0c\u8bf7\u52ff\u91cd\u590d\u540c\u6b65\u3002", (String)"TripAutoOpenedListPlugin_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map standtripname = TripCommonUtil.getStandtripname();
                String servers = dynamicObject.getString("servers");
                if (StringUtils.isEmpty((CharSequence)servers)) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"TripAutoOpenedListPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                String tripServiceName = (String)standtripname.get(servers);
                ITripService iTripService = TripServiceFactory.getTripService((String)tripServiceName);
                if (iTripService == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u5546\u7684\u5b9e\u4f8b\u5316\u5904\u7406\u7c7b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TripAutoOpenedListPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap params = Maps.newHashMapWithExpectedSize((int)1);
                Object tripadminuser = dynamicObject.get("tripadminuser");
                if (tripadminuser == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u7ba1\u7406\u5458\uff0c\u8bf7\u67e5\u770b\u914d\u7f6e\u3002", (String)"TripAutoOpenedListPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long pk = ErCommonUtils.getPk((Object)tripadminuser);
                if (pk == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u7ba1\u7406\u5458\uff0c\u8bf7\u67e5\u770b\u914d\u7f6e\u3002", (String)"TripAutoOpenedListPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.grantAdminUser(servers, pk);
                ArrayList list = Lists.newArrayListWithCapacity((int)1);
                list.add(pk);
                params.put("userList", list);
                String resultCode = iTripService.synUserToTrip(new Object[]{params});
                dynamicObject.set("syncusertraceid", (Object)RequestContext.get().getTraceId());
                if (StringUtils.equals((CharSequence)"200", (CharSequence)resultCode)) {
                    dynamicObject.set("syncadminstatus", (Object)1);
                } else {
                    dynamicObject.set("syncadminstatus", (Object)2);
                }
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"TripAutoOpenedListPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
            catch (Exception e) {
                logger.error("\u81ea\u52a9\u5f00\u901a,\u540c\u6b65\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void grantAdminUser(String server, Long userPk) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"er_trip_usergrant");
        DynamicObjectCollection servers = TripUserGrantUtils.getServers((String)server);
        if (CollectionUtils.isEmpty((Collection)servers)) {
            logger.info("\u5546\u65c5\u81ea\u52a9\u5f00\u901a,\u670d\u52a1\u5546\u6682\u672a\u5f00\u542f\u6388\u6743,\u4e0d\u9700\u6388\u6743");
            return;
        }
        DynamicObject userDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userPk)});
        if (userDO == null) {
            logger.info("\u5546\u65c5\u81ea\u52a9\u5f00\u901a,\u65e0\u6cd5\u67e5\u8be2\u5230\u4eba\u5458,\u4e0d\u8fdb\u884c\u6388\u6743\u6dfb\u52a0");
            return;
        }
        RequestContext context = RequestContext.get();
        DynamicObject waitAddDynamicObject = new DynamicObject((DynamicObjectType)entityType);
        DynamicObject dynamicObject = (DynamicObject)servers.get(0);
        waitAddDynamicObject.set("grantusername", (Object)userDO.getString("name"));
        waitAddDynamicObject.set("grantservers", (Object)server);
        waitAddDynamicObject.set("grant", (Object)"1");
        waitAddDynamicObject.set("grantuserno", (Object)userDO.getString("number"));
        waitAddDynamicObject.set("grantcontent_tag", (Object)dynamicObject.getString("authroziedcontent_tag"));
        waitAddDynamicObject.set("grantip", (Object)context.getLoginIP());
        waitAddDynamicObject.set("granttime", (Object)new Date());
        waitAddDynamicObject.set("grantmodel", (Object)context.getClient());
        waitAddDynamicObject.set("grantuser", (Object)context.getCurrUserId());
        DynamicObject grantUserDO = QueryServiceHelper.queryOne((String)"er_trip_usergrant", (String)"id", (QFilter[])new QFilter[]{new QFilter("grantuserno", "=", (Object)userDO.getString("number"))});
        if (grantUserDO == null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{waitAddDynamicObject});
        } else {
            waitAddDynamicObject.set("id", (Object)grantUserDO.getLong("id"));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{waitAddDynamicObject});
        }
    }

    private DynamicObject getDbData(ListSelectedRowCollection selectedRows) {
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        return BusinessDataServiceHelper.loadSingleFromCache((String)"er_autoopened", (String)"id,servers,companynum,companyname,approvaltype,tripadminuser,orderstatusaddr,channelid,channelkeys,openedstatus,syncadminstatus,enableservers,billstatus,synctraceid,syncusertraceid", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
    }

    public void packageData(PackageDataEvent e) {
        try {
            String colKey = e.getColKey();
            DynamicObject rowData = e.getRowData();
            switch (colKey) {
                case "tripcityrefresh": 
                case "billingsetting": 
                case "tripctlsetting": 
                case "tripparamsetting": 
                case "sysparam": 
                case "grantcontent": {
                    e.setFormatValue((Object)ResManager.loadKDString((String)"\u8bbe\u7f6e", (String)"TripAutoOpenedListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "enableservers": {
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_autoopened", (String)"enableservers", (QFilter[])new QFilter[]{new QFilter("id", "=", rowData.getPkValue())});
                    int enableServerStatus = dynamicObject.getInt("enableservers");
                    if (enableServerStatus == 0) {
                        e.setFormatValue((Object)ResManager.loadKDString((String)"\u542f\u7528", (String)"TripAutoOpenedListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (enableServerStatus == 1) {
                        e.setFormatValue((Object)ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"TripAutoOpenedListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (enableServerStatus != 2) break;
                    boolean exists = QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("number", "=", (Object)rowData.getString("servers"))});
                    if (exists) {
                        e.setFormatValue((Object)ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"TripAutoOpenedListPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        e.setNoLinkKey(Collections.singletonList("enableservers"));
                        break;
                    }
                    e.setFormatValue((Object)ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"TripAutoOpenedListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "openedstatus": {
                    int openedstatus = rowData.getInt("openedstatus");
                    if (openedstatus != 0) break;
                    e.setNoLinkKey(Collections.singletonList("openedstatus"));
                    break;
                }
                case "syncadminstatus": {
                    int syncadminstatus = rowData.getInt("syncadminstatus");
                    if (syncadminstatus != 0) break;
                    e.setNoLinkKey(Collections.singletonList("syncadminstatus"));
                }
            }
        }
        catch (Exception ex) {
            logger.error("packageData error", (Throwable)ex);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            return;
        }
        String formId = "";
        boolean openList = Boolean.TRUE;
        IFormView view = this.getView();
        IFormView mainView = view.getMainView();
        DynamicObject dbData = this.getData(args);
        switch (fieldName) {
            case "tripcityrefresh": {
                formId = "er_city";
                break;
            }
            case "billingsetting": {
                formId = "er_invoicesetting";
                break;
            }
            case "tripctlsetting": {
                formId = "er_tripcontrolsettings";
                break;
            }
            case "tripparamsetting": {
                formId = "er_tripsync_setting";
                break;
            }
            case "sysparam": {
                formId = "er_loancheckparam";
                openList = Boolean.FALSE;
                String appId = AppMetadataCache.getAppInfo((String)"18XR3MJ0W0ET").getAppId();
                if (null != mainView.getViewNoPlugin(appId + mainView.getPageId())) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("view", this.getView());
                    TripAutoOpenedListPlugin.activatePage(appId + mainView.getPageId(), this.getView(), hashMap);
                } else {
                    OpenPageUtils.openApp((String)appId, null, null, (IFormView)this.getView());
                }
                AppMenuInfo appMenuInfo1 = AppMetadataCache.getAppMenuInfo((String)"18XR3MJ0W0ET", (String)"1646402983019152384");
                if (appMenuInfo1 == null || !appMenuInfo1.getFormId().equals("bos_param_console")) break;
                HashMap map = Maps.newHashMapWithExpectedSize((int)7);
                map.put("view", this.getView());
                map.put("formnumber", appMenuInfo1.getFormId());
                map.put("parametertype", appMenuInfo1.getParamType());
                map.put("parameter", appMenuInfo1.getParams());
                map.put("menuname", appMenuInfo1.getName());
                map.put("openType", appMenuInfo1.getOpenType());
                map.put("permItem", appMenuInfo1.getPermission());
                OpenPageUtils.openApp((String)appId, (String)appMenuInfo1.getId(), (Map)map, (IFormView)this.getView());
                break;
            }
            case "grantcontent": {
                formId = "er_biz_info";
                openList = Boolean.FALSE;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)Supplier.XIECHENG.name())});
                if (dynamicObject != null) {
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setPkId(dynamicObject.get("id"));
                    billShowParameter.setFormId(formId);
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    billShowParameter.setPageId(mainView.getPageId() + formId);
                    billShowParameter.getOpenStyle().setTargetKey("authroziedcontent");
                    view.showForm((FormShowParameter)billShowParameter);
                    break;
                }
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u65e0\u6cd5\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5546\u8bbe\u7f6e\u4e2d\u5bf9\u5e94\u670d\u52a1\u5546\u662f\u5426\u5b58\u5728\u3002", (String)"TripAutoOpenedListPlugin_16", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            case "enableservers": {
                if (dbData == null) {
                    return;
                }
                DynamicObject openedData = BusinessDataServiceHelper.loadSingleFromCache((String)"er_autoopened", (String)"id,servers,companynum,companyname,approvaltype,tripadminuser,orderstatusaddr,channelid,channelkeys,openedstatus,syncadminstatus,enableservers,billstatus,synctraceid,syncusertraceid", (QFilter[])new QFilter[]{new QFilter("id", "=", dbData.get("id"))});
                try {
                    int statusValue = dbData.getInt("openedstatus");
                    args.setCancel(true);
                    if (statusValue != 1) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5546\u672a\u5f00\u901a\u6216\u8005\u5f00\u901a\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5f00\u901a\u540e\u518d\u8fdb\u884c\u542f\u7528\u670d\u52a1\u5546\u3002", (String)"TripAutoOpenedListPlugin_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String servers = dbData.getString("servers");
                    if (StringUtils.isEmpty((CharSequence)servers)) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"TripAutoOpenedListPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject serverData = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)servers)});
                    if (serverData == null) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u65e0\u6cd5\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5546\u8bbe\u7f6e\u4e2d\u5bf9\u5e94\u670d\u52a1\u5546\u662f\u5426\u5b58\u5728\u3002", (String)"TripAutoOpenedListPlugin_16", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    openedData.set("enableservers", (Object)"2");
                    serverData.set("enable", (Object)"1");
                    SaveServiceHelper.update((DynamicObject)serverData);
                    SaveServiceHelper.update((DynamicObject)openedData);
                }
                catch (Exception e) {
                    openedData.set("enableservers", (Object)"1");
                    SaveServiceHelper.update((DynamicObject)openedData);
                    logger.error("\u542f\u7528\u670d\u52a1\u5546\u62a5\u9519", (Throwable)e);
                }
                view.invokeOperation("refresh");
                break;
            }
            case "syncadminstatus": {
                formId = "er_trip_log";
                openList = Boolean.FALSE;
                if (dbData == null) {
                    return;
                }
                this.openLogView(formId, mainView, dbData, "syncusertraceid");
                break;
            }
            case "openedstatus": {
                formId = "er_trip_log";
                openList = Boolean.FALSE;
                if (dbData == null) {
                    return;
                }
                this.openLogView(formId, mainView, dbData, "synctraceid");
            }
        }
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return;
        }
        args.setCancel(true);
        if (openList) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(formId);
            parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setPageId(mainView.getPageId() + formId);
            view.showForm((FormShowParameter)parameter);
        }
    }

    private void openLogView(String formId, IFormView mainView, DynamicObject dbData, String synctraceid) {
        DynamicObject dataLog = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("traceid", "=", (Object)dbData.getString(synctraceid))});
        if (dataLog != null) {
            BillShowParameter logShowParameter = new BillShowParameter();
            logShowParameter.setPkId(dataLog.get("id"));
            logShowParameter.setFormId(formId);
            logShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            logShowParameter.setPageId(mainView.getPageId() + dataLog.get("id"));
            this.getView().showForm((FormShowParameter)logShowParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u8be2\u5230\u65e5\u5fd7\u6570\u636e\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5df2\u88ab\u6e05\u7406\u3002", (String)"TripAutoOpenedListPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getData(HyperLinkClickArgs args) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            args.setCancel(true);
            return null;
        }
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject data = QueryServiceHelper.queryOne((String)"er_autoopened", (String)"id,servers,companynum,companyname,approvaltype,tripadminuser,orderstatusaddr,channelid,channelkeys,openedstatus,syncadminstatus,enableservers,billstatus,synctraceid,syncusertraceid", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        if (data == null) {
            args.setCancel(true);
            return null;
        }
        return data;
    }

    public static void activatePage(String pageID, IFormView view, Map<String, Object> map) {
        IFormView childView = view.getViewNoPlugin(pageID);
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)map.get("customparameters");
                childView.getFormShowParameter().getCustomParams().remove("messageId");
                childView.getFormShowParameter().getCustomParams().remove("tabType");
                childView.getFormShowParameter().getCustomParams().remove("openPage");
                if (customparameters != null) {
                    if (customparameters.get("messageId") != null) {
                        childView.getFormShowParameter().setCustomParam("messageId", customparameters.get("messageId"));
                    }
                    if (customparameters.get("tabType") != null) {
                        childView.getFormShowParameter().setCustomParam("tabType", customparameters.get("tabType"));
                    }
                    if (customparameters.get("openPage") != null) {
                        childView.getFormShowParameter().setCustomParam("openPage", customparameters.get("openPage"));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55\u3002", (String)"TripAutoOpenedListPlugin_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }
}

