/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.checking;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;

public class ErSettlementDialogPlugin
extends AbstractFormPlugin {
    private static final Map<String, String> orderAndSettleMapping = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        BasedataEdit allOrderBase = (BasedataEdit)this.getControl("allorderbase");
        final FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        allOrderBase.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                JSONArray orderIds = (JSONArray)formShowParameter.getCustomParam("orders");
                if (orderIds != null && orderIds.size() > 0) {
                    Long orderId = orderIds.getLong(0);
                    String formId = (String)formShowParameter.getCustomParam("formId");
                    IErDao settlementOrdersDao = ErDaoFactory.getInstance((String)formId);
                    DynamicObject settlementOrder = settlementOrdersDao.queryOne("id, ordernum", new QFilter("id", "=", (Object)orderId));
                    String orderNum = settlementOrder.getString("ordernum");
                    orderNum = orderNum.split("-")[0];
                    ListShowParameter f7ShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                    ListFilterParameter listFilterParameter = new ListFilterParameter();
                    List qFilters = listFilterParameter.getQFilters();
                    qFilters.add(new QFilter("ordernum", "like", (Object)(orderNum + "%")).and(new QFilter("isreconciliation", "=", (Object)false)));
                    f7ShowParameter.setListFilterParameter(listFilterParameter);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (null != customParams.get("orders") && null != customParams.get("formId")) {
            JSONArray settleOrdersArray = (JSONArray)customParams.get("orders");
            List settleOrders = JSONArray.parseArray((String)settleOrdersArray.toJSONString(), Long.class);
            String formId = (String)customParams.get("formId");
            IErDao settlementOrdersDao = ErDaoFactory.getInstance((String)formId);
            DataSet rows = settlementOrdersDao.queryDataSet("kd.fi.er.formplugin.trip.checking.ErSettlementDialogPlugin.afterBindData", "ordernum", new QFilter[]{new QFilter("id", "in", (Object)settleOrders)});
            if (null != rows) {
                Iterator iterator = rows.iterator();
                HashSet<String> ordernums = new HashSet<String>(8);
                while (iterator.hasNext()) {
                    Row next = (Row)iterator.next();
                    String ordernum = next.getString("ordernum");
                    ordernums.add(ordernum);
                }
                IErDao alldao = ErDaoFactory.getInstance((String)"er_allorderbill");
                DataSet orders = alldao.queryDataSet("kd.fi.er.formplugin.trip.checking.ErSettlementDialogPlugin.afterBindData", "id,ordernum,orderformid,isreconciliation", new QFilter[]{new QFilter("ordernum", "in", ordernums)});
                if (null != orders) {
                    iterator = orders.iterator();
                    ordernums = new HashSet(8);
                    Long id = 0L;
                    while (iterator.hasNext()) {
                        Row next = (Row)iterator.next();
                        String ordernum = next.getString("ordernum");
                        id = next.getLong("id");
                        ordernums.add(ordernum);
                    }
                    if (!ordernums.isEmpty()) {
                        this.getModel().setValue("isrelated", (Object)true);
                        this.getModel().setValue("allorderbase_id", (Object)id);
                        this.getModel().setValue("allorderbase", (Object)id);
                        view.setEnable(Boolean.valueOf(false), new String[]{"isrelated"});
                        Boolean show = (Boolean)customParams.get("show");
                        if (!show.booleanValue()) {
                            view.setVisible(Boolean.FALSE, new String[]{"allorderbase"});
                        }
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean show = (Boolean)customParams.get("show");
        if (show == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"ErSettlementDialogPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("show", (Object)show);
        view.setVisible(show, new String[]{"applycompany", "expcompany", "isrelated"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control button = (Control)evt.getSource();
        String buttonName = button.getKey();
        IFormView view = this.getView();
        if ("btnok".equals(buttonName)) {
            Set orderIds;
            HashMap amountMapping;
            IDataModel model = this.getModel();
            String reason = (String)model.getValue("reason");
            if (StringUtils.isEmpty((String)reason)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u539f\u56e0", (String)"ErSettlementDialogPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Boolean show = (Boolean)customParams.get("show");
            if (show == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"ErSettlementDialogPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONArray settleOrdersArray = (JSONArray)customParams.get("orders");
            List settleOrders = JSONArray.parseArray((String)settleOrdersArray.toJSONString(), Long.class);
            String formId = (String)customParams.get("formId");
            IErDao settlementOrdersDao = ErDaoFactory.getInstance((String)formId);
            IErDao allSettlementOrdersDao = ErDaoFactory.getInstance((String)"er_allcheckingbill");
            IErDao oriOrdersDao = ErDaoFactory.getInstance((String)orderAndSettleMapping.get(formId));
            IErDao allOrderDao = ErDaoFactory.getInstance((String)"er_allorderbill");
            HashSet checkingbillNums = new HashSet();
            DynamicObject[] settlementOrders = null;
            DynamicObject[] allSettlementOrders = null;
            DynamicObject[] oriOrders = null;
            DynamicObject[] allOrders = null;
            String type = (String)customParams.get("type");
            if ("3".equals(type)) {
                settlementOrders = settlementOrdersDao.query("id, totalamount, allorderbase, balanceremark, isbalance, ordertype, isreconciliation, checkingbillnum", new QFilter("id", "in", (Object)settleOrders));
                amountMapping = new HashMap();
                Stream.of(settlementOrders).forEach(settlement -> {
                    DynamicObject orderDyn = settlement.getDynamicObject("allorderbase");
                    if (orderDyn != null) {
                        amountMapping.put(orderDyn.getLong("id"), settlement.getBigDecimal("totalamount"));
                    }
                    checkingbillNums.add(settlement.getString("checkingbillnum"));
                });
                allSettlementOrders = allSettlementOrdersDao.query(new QFilter("checkingid", "in", settleOrders.stream().map(String::valueOf).collect(Collectors.toSet())));
                orderIds = amountMapping.keySet();
                oriOrders = oriOrdersDao.query("id, totalamount, isverified, isconfirm, isreimburse, isapprove, isreconciliation", new QFilter("id", "in", orderIds));
                allOrders = allOrderDao.query("id, totalamount, orderid, isverified, isconfirm, isreimburse, isapprove, isreconciliation", new QFilter("orderid", "in", orderIds.stream().map(String::valueOf).collect(Collectors.toSet())));
                Stream.of(settlementOrders).forEach(settlement -> {
                    settlement.set("isbalance", (Object)"3");
                    settlement.set("isreconciliation", (Object)true);
                    settlement.set("balanceremark", (Object)reason);
                });
                Stream.of(allSettlementOrders).forEach(allSettle -> {
                    allSettle.set("isreconciliation", (Object)false);
                    allSettle.set("isbalance", (Object)"3");
                });
                Stream.of(oriOrders).forEach(order -> {
                    order.set("isverified", (Object)false);
                    order.set("isconfirm", (Object)false);
                    order.set("isreimburse", (Object)false);
                    order.set("isapprove", (Object)false);
                    order.set("isreconciliation", (Object)false);
                });
                Stream.of(allOrders).forEach(allOrder -> {
                    allOrder.set("isverified", (Object)false);
                    allOrder.set("isconfirm", (Object)false);
                    allOrder.set("isreimburse", (Object)false);
                    allOrder.set("isapprove", (Object)false);
                    allOrder.set("isreconciliation", (Object)false);
                });
            } else if ("4".equals(type)) {
                if (!((Boolean)model.getValue("show")).booleanValue()) {
                    settlementOrders = settlementOrdersDao.query("id, totalamount, allorderbase, balanceremark,isbalance,ordertype,isreconciliation", new QFilter("id", "in", (Object)settleOrders));
                    amountMapping = new HashMap();
                    Stream.of(settlementOrders).forEach(settlement -> {
                        DynamicObject orderDyn = settlement.getDynamicObject("allorderbase");
                        if (orderDyn != null) {
                            amountMapping.put(orderDyn.getLong("id"), settlement.getBigDecimal("totalamount"));
                        }
                    });
                    allSettlementOrders = allSettlementOrdersDao.query(new QFilter("checkingid", "in", settleOrders.stream().map(v -> String.valueOf(v)).collect(Collectors.toSet())));
                    orderIds = amountMapping.keySet();
                    allOrders = allOrderDao.query("id, totalamount, orderid,isreconciliation", new QFilter("id", "in", orderIds));
                    HashSet oriOrderIds = new HashSet();
                    Stream.of(allOrders).forEach(oriOrder -> oriOrderIds.add(oriOrder.getLong("orderid")));
                    oriOrders = oriOrdersDao.query("id, totalamount,isreconciliation", new QFilter("id", "in", oriOrderIds));
                    Stream.of(settlementOrders).forEach(settlement -> {
                        settlement.set("balanceremark", (Object)reason);
                        settlement.set("isbalance", (Object)"1");
                        settlement.set("ordertype", (Object)"C");
                        settlement.set("isreconciliation", (Object)true);
                    });
                    Stream.of(allSettlementOrders).forEach(allSettlement -> {
                        allSettlement.set("isbalance", (Object)"1");
                        allSettlement.set("isreconciliation", (Object)true);
                    });
                    HashMap amountAllOrderMapping = new HashMap();
                    Stream.of(allOrders).forEach(allOrder -> {
                        BigDecimal amount = (BigDecimal)amountMapping.get(allOrder.getLong("id"));
                        allOrder.set("totalamount", (Object)amount);
                        allOrder.set("isreconciliation", (Object)true);
                        amountAllOrderMapping.put(allOrder.getLong("orderid"), amount);
                    });
                    Stream.of(oriOrders).forEach(order -> {
                        order.set("totalamount", amountAllOrderMapping.get(order.getLong("id")));
                        order.set("isreconciliation", (Object)true);
                    });
                } else {
                    DynamicObject applyCompany = (DynamicObject)model.getValue("applycompany");
                    DynamicObject expCompany = (DynamicObject)model.getValue("expcompany");
                    DynamicObject allOrderBase = (DynamicObject)model.getValue("allorderbase");
                    boolean isRelated = (Boolean)model.getValue("isrelated");
                    if (isRelated) {
                        if (allOrderBase == null) {
                            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5173\u8054\u7684\u8ba2\u5355\u3002", (String)"ErSettlementDialogPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        settlementOrders = settlementOrdersDao.query("id, totalamount, allorderbase, balanceremark,isbalance,ordertype", new QFilter("id", "in", (Object)settleOrders));
                        HashMap amountMapping2 = new HashMap();
                        Stream.of(settlementOrders).forEach(settlement -> {
                            settlement.set("allorderbase", (Object)allOrderBase);
                            DynamicObject orderDyn = settlement.getDynamicObject("allorderbase");
                            if (orderDyn != null) {
                                amountMapping2.put(orderDyn.getLong("id"), settlement.getBigDecimal("totalamount"));
                            }
                        });
                        allSettlementOrders = allSettlementOrdersDao.query(new QFilter("checkingid", "in", settleOrders.stream().map(v -> String.valueOf(v)).collect(Collectors.toSet())));
                        Set orderIds2 = amountMapping2.keySet();
                        allOrders = allOrderDao.query("id, totalamount, orderid", new QFilter("id", "in", orderIds2));
                        HashSet oriOrderIds = new HashSet();
                        Stream.of(allOrders).forEach(oriOrder -> oriOrderIds.add(oriOrder.getLong("orderid")));
                        oriOrders = oriOrdersDao.query("id, totalamount", new QFilter("id", "in", oriOrderIds));
                        Stream.of(settlementOrders).forEach(settlement -> {
                            settlement.set("balanceremark", (Object)reason);
                            settlement.set("isbalance", (Object)"1");
                            settlement.set("ordertype", (Object)"C");
                        });
                        Stream.of(allSettlementOrders).forEach(allSettlement -> allSettlement.set("isbalance", (Object)"1"));
                        HashMap amountAllOrderMapping = new HashMap();
                        Stream.of(allOrders).forEach(allOrder -> {
                            BigDecimal amount = (BigDecimal)amountMapping2.get(allOrder.getLong("id"));
                            allOrder.set("totalamount", (Object)amount);
                            amountAllOrderMapping.put(allOrder.getLong("orderid"), amount);
                        });
                        Stream.of(oriOrders).forEach(order -> order.set("totalamount", amountAllOrderMapping.get(order.getLong("id"))));
                    } else {
                        settlementOrders = settlementOrdersDao.query(new QFilter("id", "in", (Object)settleOrders));
                        allSettlementOrders = allSettlementOrdersDao.query(new QFilter("checkingid", "in", settleOrders.stream().map(v -> String.valueOf(v)).collect(Collectors.toSet())));
                        Map<String, DynamicObject> allSettlementOrdersMapping = Stream.of(allSettlementOrders).collect(Collectors.toMap(v -> v.getString("checkingid"), v -> v));
                        long[] ids = DBServiceHelper.genLongIds((String)("t_" + orderAndSettleMapping.get(formId)), (int)settlementOrders.length);
                        long[] allCheckingIds = DBServiceHelper.genLongIds((String)"t_er_allcheckingbill", (int)settlementOrders.length);
                        oriOrders = new DynamicObject[settlementOrders.length];
                        allOrders = new DynamicObject[settlementOrders.length];
                        for (int i = 0; i < settlementOrders.length; ++i) {
                            DynamicObject settleOrder = settlementOrders[i];
                            settleOrder.set("settlemain", (Object)expCompany);
                            settleOrder.set("company", (Object)applyCompany);
                            settleOrder.set("balanceremark", (Object)reason);
                            settleOrder.set("isbalance", (Object)"1");
                            settleOrder.set("ordertype", (Object)"C");
                            settleOrder.set("isreconciliation", (Object)true);
                            this.setValueByDynamic(settleOrder, allSettlementOrdersMapping.get(settleOrder.getPkValue() + ""));
                            DynamicObject orderDyn = oriOrdersDao.getEmptyDynamicObject();
                            this.setValueByDynamic(settleOrder, orderDyn);
                            orderDyn.set("expcommitcomnum", (Object)expCompany);
                            orderDyn.set("company", (Object)applyCompany);
                            if (orderDyn.containsProperty("isverified")) {
                                orderDyn.set("isverified", (Object)true);
                            }
                            orderDyn.set("isconfirm", (Object)false);
                            orderDyn.set("isreimburse", (Object)false);
                            orderDyn.set("isapprove", (Object)false);
                            orderDyn.set("isreconciliation", (Object)true);
                            if (orderDyn.containsProperty("needbilling")) {
                                orderDyn.set("needbilling", (Object)true);
                            }
                            orderDyn.set("id", (Object)ids[i]);
                            oriOrders[i] = orderDyn;
                            DynamicObject allOrder2 = allOrderDao.getEmptyDynamicObject();
                            allOrder2.set("orderformid", (Object)orderAndSettleMapping.get(formId));
                            allOrder2.set("orderid", (Object)ids[i]);
                            allOrder2.set("id", (Object)allCheckingIds[i]);
                            this.setValueByDynamic(orderDyn, allOrder2);
                            allOrders[i] = allOrder2;
                            settleOrder.set("allorderbase", (Object)allCheckingIds[i]);
                        }
                    }
                }
            }
            boolean isBalance = !settlementOrdersDao.isExist(new QFilter("checkingbillnum", "in", checkingbillNums).and(new QFilter("isbalance", "=", (Object)"2")));
            DynamicObject[] checkingbills = null;
            if (isBalance) {
                IErDao checkingbillDao = ErDaoFactory.getInstance((String)"er_checkingbill");
                for (DynamicObject checkingbill : checkingbills = checkingbillDao.query(new QFilter("billnum", "in", checkingbillNums))) {
                    checkingbill.set("result", (Object)1);
                }
            }
            DynamicObject[] dynamicObjectArray = null;
            try (TXHandle handle = TX.requiresNew();){
                try {
                    if (settlementOrders != null) {
                        SaveServiceHelper.save((DynamicObject[])settlementOrders);
                    }
                    if (allSettlementOrders != null) {
                        SaveServiceHelper.save((DynamicObject[])allSettlementOrders);
                    }
                    if (oriOrders != null) {
                        SaveServiceHelper.save(oriOrders);
                    }
                    if (allOrders != null) {
                        SaveServiceHelper.save(allOrders);
                    }
                    if (checkingbills != null) {
                        SaveServiceHelper.save((DynamicObject[])checkingbills);
                    }
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
            catch (Throwable object) {
                dynamicObjectArray = object;
                throw object;
            }
            view.returnDataToParent((Object)String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"ErSettlementDialogPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), this.getView().getFormShowParameter().getCaption()));
        }
        view.close();
    }

    private void setValueByDynamic(DynamicObject orderDyn, DynamicObject allOrder) {
        DataEntityPropertyCollection orderProperties = orderDyn.getDataEntityType().getProperties();
        DataEntityPropertyCollection allOrderProperties = allOrder.getDynamicObjectType().getProperties();
        for (IDataEntityProperty orderProperty : orderProperties) {
            String orderPropName = orderProperty.getName();
            if ("id".equals(orderPropName) || allOrderProperties.get((Object)orderPropName) == null) continue;
            allOrder.set(orderPropName, orderDyn.get(orderPropName));
        }
    }

    static {
        orderAndSettleMapping.put("er_planecheckingbill", "er_planebill");
        orderAndSettleMapping.put("er_hotelcheckingbill", "er_hotelbill");
        orderAndSettleMapping.put("er_vehiclecheckingbill", "er_vehiclebill");
        orderAndSettleMapping.put("er_traincheckingbill", "er_trainbill");
        orderAndSettleMapping.put("er_mealcheckingbill", "er_mealbill");
    }
}

