/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.checking;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.invoice.GenerateInvoiceAssistantNew;
import kd.fi.er.business.servicehelper.pay.GeneratePayAssistant;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripInvoiceUtils;
import kd.fi.er.common.CarTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.formplugin.daily.ShowCompanyListPlugin;
import kd.fi.er.formplugin.trip.util.BatchEditUtil;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;

public class HotelAndPlaneCheckingBillList
extends ShowCompanyListPlugin {
    private static Log logger = LogFactory.getLog(HotelAndPlaneCheckingBillList.class);

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void setFilter(SetFilterEvent e) {
        IFormView view;
        FormShowParameter showParameter;
        String checknum;
        super.setFilter(e);
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null) {
            Object mainOrgValue = mainOrgQFilter.getValue();
            String cp = mainOrgQFilter.getCP();
            mainOrgQFilter.or(new QFilter("company", cp, mainOrgValue));
        }
        if (null != (checknum = (String)(showParameter = (view = this.getView()).getFormShowParameter()).getCustomParam("checkingbillnum")) && StringUtils.isNotBlank((CharSequence)checknum)) {
            ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
            customQFilters.add(new QFilter("checkingbillnum", "=", (Object)checknum));
            e.setCustomQFilters(customQFilters);
        }
        e.setOrderBy("happenddate desc,ordernum desc");
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        Map cusMap = this.getView().getFormShowParameter().getCustomParams();
        Boolean isViewCheckingbill = (Boolean)cusMap.get("isViewCheckingbill");
        if (isViewCheckingbill != null && isViewCheckingbill.booleanValue()) {
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                String fieldName = commonFilterColumn.getFieldName();
                if (!"settlemain.number".equalsIgnoreCase(fieldName)) continue;
                commonFilterColumn.setDefaultValue(null);
            }
        }
    }

    public void afterBindData(EventObject e) {
        int paramValue;
        super.afterBindData(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        if ("kdem".equals(appid)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pushpay", "baritemap", "createvar"});
        }
        if ((paramValue = TripSyncConfigUtil.getIntValue((String)"Ctrip_Billing_method", (int)1)) == 1 || paramValue == 2) {
            BillList list = (BillList)this.getControl("billlistap");
            list.getView().setVisible(Boolean.FALSE, new String[]{"subbatchno"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("oabillnum".equals(fieldName)) {
            DynamicObject reqbill;
            DynamicObject bill;
            DynamicObject settle;
            args.setCancel(true);
            ListView listView = (ListView)this.getView();
            ListSelectedRow currentRow = listView.getCurrentSelectedRowInfo();
            long pk = (Long)currentRow.getPrimaryKeyValue();
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String selectFields = "oabillnum,oabillformid";
            if ("er_vehiclecheckingbill".equals(listShowParameter.getBillFormId())) {
                selectFields = selectFields + ",vehicletype";
            }
            if ((settle = QueryServiceHelper.queryOne((String)listShowParameter.getBillFormId(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pk)})) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"HotelAndPlaneCheckingBillList_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String reqBillNo = settle.getString("oabillnum");
            if (StringUtils.isBlank((CharSequence)reqBillNo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"HotelAndPlaneCheckingBillList_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String oabillformid = settle.getString("oabillformid");
            if (StringUtils.isNotBlank((CharSequence)oabillformid) && (bill = QueryServiceHelper.queryOne((String)oabillformid, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqBillNo)})) != null) {
                this.openLinkedForm(bill.getLong("id"), oabillformid);
                return;
            }
            if ("er_vehiclecheckingbill".equals(listShowParameter.getBillFormId())) {
                if (CarTypeEnum.TRAVEL.getCode().equals(settle.getString("vehicletype"))) {
                    reqbill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqBillNo)});
                    if (reqbill == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"HotelAndPlaneCheckingBillList_19", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    this.openLinkedForm(reqbill.getLong("id"), "er_tripreqbill");
                } else {
                    reqbill = QueryServiceHelper.queryOne((String)"er_dailyvehiclebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqBillNo)});
                    if (reqbill == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u8f66\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"HotelAndPlaneCheckingBillList_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    this.openLinkedForm(reqbill.getLong("id"), "er_dailyvehiclebill");
                }
            } else if ("er_mealcheckingbill".equals(listShowParameter.getBillFormId())) {
                reqbill = QueryServiceHelper.queryOne((String)"er_mealapplication_bill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqBillNo)});
                if (reqbill == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u9910\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"HotelAndPlaneCheckingBillList_21", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.openLinkedForm(reqbill.getLong("id"), "er_mealapplication_bill");
            } else {
                reqbill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqBillNo)});
                if (reqbill == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"HotelAndPlaneCheckingBillList_19", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.openLinkedForm(reqbill.getLong("id"), "er_tripreqbill");
            }
        } else if ("allorderbase_ordernum".equals(fieldName)) {
            args.setCancel(true);
            ListView listView = (ListView)this.getView();
            ListSelectedRow currentRow = listView.getCurrentSelectedRowInfo();
            long pk = (Long)currentRow.getPrimaryKeyValue();
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            DynamicObject settle = QueryServiceHelper.queryOne((String)listShowParameter.getBillFormId(), (String)"allorderbase.ordernum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pk)});
            String formId = "er_planebill";
            if (listShowParameter.getBillFormId().equals("er_hotelcheckingbill")) {
                formId = "er_hotelbill";
            } else if (listShowParameter.getBillFormId().equals("er_vehiclecheckingbill")) {
                formId = "er_vehiclebill";
            } else if (listShowParameter.getBillFormId().equals("er_traincheckingbill")) {
                formId = "er_trainbill";
            } else if (listShowParameter.getBillFormId().equals("er_mealcheckingbill")) {
                formId = "er_mealbill";
            }
            DynamicObject order = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "=", (Object)settle.getString("allorderbase.ordernum"))});
            if (order != null) {
                this.openLinkedForm(order.getLong("id"), formId);
            } else {
                listView.showErrorNotification(ResManager.loadKDString((String)"\u8ba2\u5355\u5173\u8054\u6570\u636e\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HotelAndPlaneCheckingBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        } else if ("allorderbase_reimbursenum".equals(fieldName)) {
            args.setCancel(true);
            ListView listView = (ListView)this.getView();
            ListSelectedRow currentRow = listView.getCurrentSelectedRowInfo();
            long pk = (Long)currentRow.getPrimaryKeyValue();
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            DynamicObject settle = QueryServiceHelper.queryOne((String)listShowParameter.getBillFormId(), (String)"allorderbase.reimbursenum,allorderbase.reimbillformid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pk)});
            String reimbillformid = settle.getString("allorderbase.reimbillformid");
            if (StringUtils.isNotBlank((CharSequence)reimbillformid)) {
                DynamicObject reimbursebill = QueryServiceHelper.queryOne((String)reimbillformid, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)settle.getString("allorderbase.reimbursenum"))});
                if (null != reimbursebill) {
                    this.openLinkedForm(reimbursebill.getLong("id"), reimbillformid);
                }
            } else {
                DynamicObject reimbursebill = QueryServiceHelper.queryOne((String)"er_tripreimbursebill", (String)"id,billkind", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)settle.getString("allorderbase.reimbursenum"))});
                if (null != reimbursebill) {
                    this.openLinkedForm(reimbursebill.getLong("id"), 1 == reimbursebill.getInt("billkind") ? "er_tripreimbill_grid" : "er_tripreimbursebill");
                }
            }
        }
    }

    private void openLinkedForm(Object pkValue, String formId) {
        IFormView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(formId);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void handleBalance(boolean flag, String title, String type) {
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection selectedRowCollection = listView.getSelectedRows();
        if (selectedRowCollection.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"HotelAndPlaneCheckingBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)"4", (CharSequence)type) && selectedRowCollection.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u7f6e\u5e73\u529f\u80fd\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u4ec5\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u7f6e\u5e73\u3002", (String)"HotelAndPlaneCheckingBillList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        HashSet<Long> orderIds = new HashSet<Long>();
        String formId = listShowParameter.getBillFormId();
        selectedRowCollection.forEach(order -> orderIds.add(Long.valueOf(order.getPrimaryKeyValue() + "")));
        String[] result = this.validate(orderIds, formId);
        if (Boolean.parseBoolean(result[0])) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCaption(title);
            formShowParameter.setFormId("er_settlementdialog");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "settlement"));
            formShowParameter.setParentPageId(this.getView().getPageId());
            HashMap<String, Object> rows = new HashMap<String, Object>();
            flag = flag ? Boolean.parseBoolean(result[1]) : flag;
            rows.put("orders", orderIds);
            rows.put("show", flag);
            rows.put("formId", listShowParameter.getBillFormId());
            rows.put("type", type);
            formShowParameter.setCustomParams(rows);
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showTipNotification(result[2]);
        }
    }

    private String[] validate(Set<Long> orderIds, String formId) {
        String[] result = new String[3];
        IErDao dao = ErDaoFactory.getInstance((String)formId);
        DynamicObject[] settleOrders = dao.query("id, ordernum,allorderbase, isbalance", new QFilter("id", "in", orderIds));
        HashSet<String> valida = new HashSet<String>(2);
        HashSet<String> ordernums = new HashSet<String>(8);
        boolean typeValidate = true;
        for (DynamicObject settleOrder : settleOrders) {
            DynamicObject orderDyn = settleOrder.getDynamicObject("allorderbase");
            String orderNum = null;
            if (orderDyn != null) {
                orderNum = orderDyn.getString("ordernum");
            }
            String isBalance = settleOrder.getString("isbalance");
            if (kd.bos.util.StringUtils.isEmpty((String)orderNum)) {
                valida.add(Boolean.TRUE.toString());
            } else {
                valida.add(Boolean.FALSE.toString());
            }
            String ordernum = settleOrder.getString("ordernum");
            ordernums.add(ordernum);
            if ("2".equals(isBalance)) continue;
            typeValidate = false;
            break;
        }
        if (!typeValidate) {
            result[0] = "false";
            result[2] = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u672a\u5bf9\u5e73\u7684\u7ed3\u7b97\u5355\u8fdb\u884c\u8c03\u6574\u3002", (String)"HotelAndPlaneCheckingBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
        } else if (valida.size() != 1) {
            result[0] = "false";
            result[2] = ResManager.loadKDString((String)"\u7f6e\u5e73\u53ea\u5141\u8bb8\u9009\u62e9\u7c7b\u578b\u4e3a\u6ca1\u6709\u5bf9\u5e94\u8ba2\u5355\u6216\u8005\u91d1\u989d\u4e0d\u5e73\u3002", (String)"HotelAndPlaneCheckingBillList_6", (String)"fi-er-formplugin", (Object[])new Object[0]);
        } else {
            result[0] = "true";
            result[1] = valida.toArray(new String[1])[0];
        }
        if (result[0].equals("true")) {
            IErDao alldao = ErDaoFactory.getInstance((String)"er_allorderbill");
            DataSet order = alldao.queryDataSet("kd.fi.er.formplugin.trip.checking.HotelAndPlaneCheckingBillList.validate", "ordernum,orderformid,isreconciliation", new QFilter[]{new QFilter("ordernum", "in", ordernums)});
            if (null != order) {
                for (Row row : order) {
                    if (!row.getBoolean("isreconciliation").booleanValue()) continue;
                    result[0] = "false";
                    result[2] = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u8ba2\u5355\u53f7\u7684\u8ba2\u5355\u6570\u636e\uff0c\u5e76\u4e14\u5df2\u5bf9\u8d26\u3002\u8bf7\u6838\u67e5\u7cfb\u7edf\u662f\u5426\u5b58\u5728\u5f02\u5e38\u7684\u8ba2\u5355\u6216\u8005\u7ed3\u7b97\u5355\u6570\u636e\u3002", (String)"EM-E-442124", (String)"fi-er-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if ("settlement".equals(action)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (closedCallBackEvent.getReturnData() != null) {
                this.getView().showMessage(closedCallBackEvent.getReturnData().toString());
            }
            list.refresh();
        } else if ("er_batch_modify".equals(action) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            this.modifyData(selectedRows, returnData);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"HotelAndPlaneCheckingBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void createInvoiceOrderBill() {
        String finishedInvoiceApply = "1";
        String doingInvoiceApply = "2";
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        Object[] settleId = selectRows.getPrimaryKeyValues();
        if (settleId == null || settleId.length == 0) {
            return;
        }
        Set<Long> settleBillIdsWithoutInvoiceApply = this.filterSettleBill(settleId);
        Set settleBillIdsWithInvoiceApply = Arrays.stream(settleId).map(id -> (Long)id).filter(id -> !settleBillIdsWithoutInvoiceApply.contains(id)).collect(Collectors.toSet());
        LinkedList hasInvoceApplyMessages = Lists.newLinkedList();
        if (!settleBillIdsWithInvoiceApply.isEmpty()) {
            String orderNums;
            String entityName = listView.getListModel().getDataEntityType().getName();
            DynamicObjectCollection settleBillDOs = QueryServiceHelper.query((String)entityName, (String)"id, hasinvoice, ordernum,server", (QFilter[])new QFilter("id", "in", settleBillIdsWithInvoiceApply).toArray());
            Map<String, List<DynamicObject>> settleBillDOSByHasInvoice = settleBillDOs.stream().collect(Collectors.groupingBy(settleDO -> settleDO.getString("hasinvoice")));
            if (settleBillDOSByHasInvoice.get("2") != null) {
                orderNums = settleBillDOSByHasInvoice.get("2").stream().map(settleDO -> settleDO.getString("ordernum")).collect(Collectors.joining(","));
                hasInvoceApplyMessages.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7%s\uff1a\u6b63\u5728\u5f00\u7968\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"HotelAndPlaneCheckingBillList_13", (String)"fi-er-formplugin", (Object[])new Object[0]), orderNums));
            }
            if (settleBillDOSByHasInvoice.get("1") != null) {
                orderNums = settleBillDOSByHasInvoice.get("1").stream().map(settleDO -> settleDO.getString("ordernum")).collect(Collectors.joining(","));
                hasInvoceApplyMessages.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7\u201c%s\u201d\u5df2\u5b8c\u6210\u5f00\u7968\u3002", (String)"HotelAndPlaneCheckingBillList_14", (String)"fi-er-formplugin", (Object[])new Object[0]), orderNums));
            }
        }
        if (settleBillIdsWithoutInvoiceApply.isEmpty()) {
            if (!hasInvoceApplyMessages.isEmpty()) {
                listView.showMessage(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25", (String)"HotelAndPlaneCheckingBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]), StringUtils.join((Iterable)hasInvoceApplyMessages, (String)" "), MessageTypes.Default);
            }
            return;
        }
        List<DynamicObject> settleDynamicList = this.getTheSameBatchnoSettles(listView, settleBillIdsWithoutInvoiceApply);
        if (settleDynamicList == null || settleDynamicList.isEmpty()) {
            return;
        }
        DynamicObject[] settleDynamics = new DynamicObject[settleDynamicList.size()];
        GenerateInvoiceAssistantNew generaeInvoice = GenerateInvoiceAssistantNew.getInstance((DynamicObject[])settleDynamicList.toArray(settleDynamics));
        generaeInvoice.doExecute();
        OperationResult operationResult = generaeInvoice.getOperationResult();
        String hasInvoceApplyMessage = (hasInvoceApplyMessages.isEmpty() ? "" : StringUtils.join((Iterable)hasInvoceApplyMessages, (String)" ")) + " ";
        if (!operationResult.isSuccess()) {
            listView.showMessage(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25", (String)"HotelAndPlaneCheckingBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]), hasInvoceApplyMessage + operationResult.getMessage(), MessageTypes.Default);
        } else if (!StringUtils.isEmpty((CharSequence)operationResult.getMessage())) {
            listView.showMessage(hasInvoceApplyMessage + operationResult.getMessage());
            this.jumpInvoiceList(generaeInvoice.getJumpInvoiceFilter());
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002", (String)"HotelAndPlaneCheckingBillList_8", (String)"fi-er-formplugin", (Object[])new Object[0]), hasInvoceApplyMessage));
        }
    }

    private Set<Long> filterSettleBill(Object[] settleBillIds) {
        DynamicObjectCollection relationsDOs = QueryServiceHelper.query((String)"er_invoicesettle_rel", (String)"id,settleid", (QFilter[])new QFilter("settleid", "in", (Object)settleBillIds).toArray());
        if (relationsDOs == null || relationsDOs.size() == 0 || settleBillIds.length == 0) {
            return Arrays.stream(settleBillIds).map(id -> (Long)id).collect(Collectors.toSet());
        }
        Set hasInvoiceApplySettleBillIds = relationsDOs.stream().map(rel -> rel.getLong("settleid")).collect(Collectors.toSet());
        Set<Long> settleBillIdWithoutInvoiceApply = Arrays.stream(settleBillIds).map(id -> (Long)id).filter(settleBillId -> !hasInvoiceApplySettleBillIds.contains(settleBillId)).collect(Collectors.toSet());
        return settleBillIdWithoutInvoiceApply;
    }

    protected void jumpInvoiceList(GenerateInvoiceAssistantNew.JumpInvoiceFilter jumpInvoiceFilter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("er_invoiceorderbill");
        listShowParameter.setCustomParam("operationtype", (Object)jumpInvoiceFilter.getOpreateType());
        listShowParameter.setCustomParam("invoicedate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jumpInvoiceFilter.getDate()));
        listShowParameter.setCustomParam("expcommitcomnum.name", (Object)jumpInvoiceFilter.getCompanyIds());
        listShowParameter.setCustomParam("invoice", (Object)true);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "push_payhotel": 
            case "push_paycar": 
            case "push_payairplane": {
                IListView listView = (IListView)this.getView();
                ListSelectedRowCollection selectedIds = formOperate.getListSelectedData();
                if (null == selectedIds || selectedIds.isEmpty()) {
                    args.setCancel(true);
                    listView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"HotelAndPlaneCheckingBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet settleIds = new HashSet();
                selectedIds.forEach(settleOrder -> settleIds.add((Long)settleOrder.getPrimaryKeyValue()));
                IErDao erDao = ErDaoFactory.getInstance((String)formOperate.getEntityId());
                QFilter filter = new QFilter("id", "in", settleIds);
                DynamicObject[] selectedDatas = erDao.query(filter);
                GeneratePayAssistant generatePayAssistant = GeneratePayAssistant.getInstance((DynamicObject[])selectedDatas);
                generatePayAssistant.doExecute();
                OperationResult operationResult = generatePayAssistant.getOperationResult();
                if (!operationResult.isSuccess()) {
                    args.setCancel(true);
                    listView.showMessage(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25", (String)"HotelAndPlaneCheckingBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), operationResult.getMessage(), MessageTypes.Default);
                    break;
                }
                args.setCancel(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if (event.getOperationResult() != null && event.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "manualsetequal": {
                    this.handleBalance(true, ResManager.loadKDString((String)"\u5bf9\u8d26\u7f6e\u5e73", (String)"HotelAndPlaneCheckingBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "4");
                    break;
                }
                case "distory": {
                    this.handleBalance(false, ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"HotelAndPlaneCheckingBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "3");
                    break;
                }
                case "invoicapply": {
                    this.createInvoiceOrderBill();
                }
            }
        }
    }

    private List<DynamicObject> getTheSameBatchnoSettles(IListView listView, Set<Long> settleBillIds) {
        DynamicObject[] allSelectdynamicObject = BusinessDataServiceHelper.load((Object[])settleBillIds.toArray(new Long[settleBillIds.size()]), (DynamicObjectType)listView.getListModel().getDataEntityType());
        Map<String, List<DynamicObject>> allSelectGroupByServer = Stream.of(allSelectdynamicObject).collect(Collectors.groupingBy(v -> v.getString("server")));
        if (allSelectGroupByServer == null || allSelectGroupByServer.isEmpty()) {
            return null;
        }
        if (allSelectGroupByServer.size() > 1) {
            listView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u670d\u52a1\u5546\u7684\u7ed3\u7b97\u5355\u6570\u636e\u3002", (String)"HotelAndPlaneCheckingBillList_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return null;
        }
        List<Object> theSameBatchonDynamicObjects = new ArrayList<DynamicObject>();
        for (Map.Entry<String, List<DynamicObject>> serverSelect : allSelectGroupByServer.entrySet()) {
            List<DynamicObject> selectData = serverSelect.getValue();
            Map<String, List<DynamicObject>> selectDataGroupByBatchno = selectData.stream().collect(Collectors.groupingBy(v -> v.getString("batchno")));
            if (selectDataGroupByBatchno.size() > 1) {
                listView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u6279\u6b21\u7684\u7ed3\u7b97\u5355\u6570\u636e\u3002", (String)"HotelAndPlaneCheckingBillList_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return null;
            }
            for (Map.Entry<String, List<DynamicObject>> allSelectdynamicObjectEntry : selectDataGroupByBatchno.entrySet()) {
                String batchno = allSelectdynamicObjectEntry.getKey();
                List<DynamicObject> allSelectdynamicObjectList = allSelectdynamicObjectEntry.getValue();
                if (allSelectdynamicObjectList == null || allSelectdynamicObjectList.isEmpty()) continue;
                DynamicObject listSelectFirstDynamicObject = allSelectdynamicObjectList.get(0);
                String server = listSelectFirstDynamicObject.getString("server");
                if (StringUtils.equalsIgnoreCase((CharSequence)Supplier.CHAILVYIHAO.name(), (CharSequence)server) || StringUtils.equalsIgnoreCase((CharSequence)Supplier.DIDI.name(), (CharSequence)server)) {
                    StringBuilder confirmTips = new StringBuilder();
                    confirmTips.append(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u6b21\u53f7\u4e3a:%s\u7684\u7ed3\u7b97\u5355\uff0c\u9700\u8981\u5148\u786e\u8ba4\u5bf9\u5e94\u6708\u7ed3\u8d26\u5355\u3002", (String)"HotelAndPlaneCheckingBillList_12", (String)"fi-er-formplugin", (Object[])new Object[0]), batchno));
                    if (!this.isConfirmCheckingBill(batchno, confirmTips)) {
                        listView.showErrorNotification(confirmTips.toString());
                        return null;
                    }
                    QFilter filter = new QFilter("server", "=", (Object)server).and(new QFilter("batchno", "=", (Object)batchno));
                    theSameBatchonDynamicObjects = BusinessDataServiceHelper.loadFromCache((String)listView.getBillFormId(), (QFilter[])new QFilter[]{filter}).entrySet().stream().map(t -> (DynamicObject)t.getValue()).collect(Collectors.toList());
                    continue;
                }
                theSameBatchonDynamicObjects = Arrays.asList(allSelectdynamicObject);
            }
        }
        return theSameBatchonDynamicObjects;
    }

    private boolean isConfirmCheckingBill(String batchno, StringBuilder confirmTips) {
        if (StringUtils.isEmpty((CharSequence)batchno)) {
            return false;
        }
        boolean isConfirm = false;
        DynamicObject checkingBill = QueryServiceHelper.queryOne((String)"er_checkingbill", (String)"id,billnum,billstatusname", (QFilter[])new QFilter[]{new QFilter("billnum", "=", (Object)batchno)});
        if (checkingBill == null) {
            confirmTips.delete(0, confirmTips.length());
            confirmTips.append(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u6b21\u53f7\u4e3a:%s\u7684\u7ed3\u7b97\u5355\uff0c\u65e0\u5bf9\u5e94\u6708\u7ed3\u8d26\u5355\u65e0\u6cd5\u5f00\u7968\u3002", (String)"HotelAndPlaneCheckingBillList_16", (String)"fi-er-formplugin", (Object[])new Object[0]), batchno));
            return false;
        }
        String billStatus = checkingBill.getString("billstatusname");
        if (StringUtils.equals((CharSequence)"3", (CharSequence)billStatus)) {
            isConfirm = true;
        }
        return isConfirm;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        int selectedSize = selectedRows.size();
        switch (itemKey) {
            case "batchedit": {
                if (selectedSize == 0) {
                    return;
                }
                this.openBatchEditPage();
                break;
            }
            case "invoiceidentity": {
                long userId = RequestContext.get().getCurrUserId();
                long orgId = RequestContext.get().getOrgId();
                ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
                String entityId = param.getBillFormId();
                int i = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"10MYBGBYHXDU", (String)entityId, (String)"47162f66000000ac");
                if (i == 0) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u53d1\u7968\u8bc6\u522b\u201d\u6743\u9650(\u5373\u7ed3\u7b97\u5355\u7684\u201c\u5ba1\u6838\u201d\u6743\u9650)\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HotelAndPlaneCheckingBillList_28", (String)"fi-er-formplugin", (Object[])new Object[0]), param.getFormName()));
                    return;
                }
                if (!StringUtils.equalsAny((CharSequence)entityId, (CharSequence[])new CharSequence[]{"er_planecheckingbill", "er_traincheckingbill"})) {
                    return;
                }
                Set ids = selectedRows.stream().filter(obj -> obj.getPrimaryKeyValue() != null).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                DynamicObject[] datas = BusinessDataServiceHelper.load((String)entityId, (String)"id,ordernum,settlemain,kddownloadlink,downloadlink,serialno,invoiceidentityflag,identityerrormsg,allorderbase.ordernum,allorderbase.orderformid,formid,server", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                boolean present = Arrays.stream(datas).anyMatch(dynamicObject -> StringUtils.isEmpty((CharSequence)dynamicObject.getString("server")) || StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("server")) && !"CHAILVYIHAO".equals(dynamicObject.getString("server")));
                if (present) {
                    String tips = StringUtils.equals((CharSequence)entityId, (CharSequence)"er_planecheckingbill") ? ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5c06\u670d\u52a1\u5546\u4e3a\u201c\u5dee\u65c5\u58f9\u53f7\u201d\u7684\u673a\u7968\u7ed3\u7b97\u5355\u4e2d\u7684\u673a\u7968\u884c\u7a0b\u5355\u4e0a\u4f20\u81f3\u661f\u701a\u53d1\u7968\u4e91\u6216AWS\u8fdb\u884c\u53d1\u7968\u8bc6\u522b\u3002", (String)"HotelAndPlaneCheckingBillList_27", (String)"fi-er-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5c06\u670d\u52a1\u5546\u4e3a\u201c\u5dee\u65c5\u58f9\u53f7\u201d\u7684\u706b\u8f66\u7ed3\u7b97\u5355\u4e2d\u7684\u706b\u8f66\u7968\u4e0a\u4f20\u81f3\u661f\u701a\u53d1\u7968\u4e91\u6216AWS\u8fdb\u884c\u53d1\u7968\u8bc6\u522b\u3002", (String)"HotelAndPlaneCheckingBillList_29", (String)"fi-er-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    return;
                }
                long checkPassedCount = Arrays.stream(datas).filter(dynamicObject -> dynamicObject.get("invoiceidentityflag") != null && dynamicObject.getBoolean("invoiceidentityflag")).count();
                if (checkPassedCount == (long)datas.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u5355\u53d1\u7968\u5747\u5df2\u8bc6\u522b\u6210\u529f\u3002", (String)"HotelAndPlaneCheckingBillList_24", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set<DynamicObject> waitCheckDatas = Arrays.stream(datas).filter(dynamicObject -> dynamicObject.get("invoiceidentityflag") != null).collect(Collectors.toSet());
                long successCount = waitCheckDatas.stream().filter(dynamicObject -> dynamicObject.getBoolean("invoiceidentityflag")).count();
                int size = waitCheckDatas.size();
                try {
                    this.identifyInvoice(waitCheckDatas);
                    break;
                }
                catch (Exception e) {
                    logger.error("\u53d1\u7968\u8bc6\u522b\u5931\u8d25:", (Throwable)e);
                    waitCheckDatas.forEach(dynamicObject -> dynamicObject.set("identityerrormsg", (Object)TripInvoiceUtils.getSubStr((String)e.getMessage(), (int)2000)));
                    SaveServiceHelper.save((DynamicObject[])waitCheckDatas.toArray(new DynamicObject[waitCheckDatas.size()]));
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8bc6\u522b\u6210\u529f%1$s\u6761\uff1b\u5931\u8d25%2$s\u6761\u3002", (String)"HotelAndPlaneCheckingBillList_26", (String)"fi-er-formplugin", (Object[])new Object[0]), successCount, (long)size - successCount));
                }
            }
        }
    }

    private void openBatchEditPage() {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entityId = param.getBillFormId();
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put("entityId", entityId);
        FormModel formModel = new FormModel("er_batch_modify", ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c", (String)"TravelExpenseBillPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParamMap);
        formModel.setShowType(ShowType.Modal);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private void modifyData(ListSelectedRowCollection selectedRows, Map<String, Object> returnData) {
        Object modifyProp = returnData.get("key");
        Object modifyValue = returnData.get("value");
        String modifyPropStr = this.getSpecialFieldMap().containsKey(modifyProp.toString()) ? this.getSpecialFieldMap().get(modifyProp.toString()) : modifyProp.toString();
        boolean allOrderFlag = this.checkPropIsExist(modifyPropStr, "er_allorderbill");
        boolean allCheckingFlag = this.checkPropIsExist(modifyPropStr, "er_allcheckingbill");
        boolean orderBillFlag = this.checkPropIsExist(modifyPropStr, returnData.get("relatedEntityId").toString());
        for (ListSelectedRow selectedRow : selectedRows) {
            DynamicObject billRow = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)returnData.get("entityId").toString());
            BatchEditUtil.getOpAppLogInfo(returnData, modifyProp, modifyValue, billRow, this.getView());
            if (billRow == null) continue;
            billRow.set(modifyProp.toString(), modifyValue);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billRow});
            if (allOrderFlag && BatchEditUtil.checkIsModify(returnData.get("relatedEntityId").toString(), modifyPropStr, modifyValue.toString()) && billRow.getDynamicObject("allorderbase") != null) {
                DynamicObject allOrder = BusinessDataServiceHelper.loadSingle((String)"er_allorderbill", (String)("id," + modifyPropStr), (QFilter[])new QFilter[]{new QFilter("id", "=", billRow.getDynamicObject("allorderbase").getPkValue())});
                this.updateOtherTableData(modifyPropStr, modifyValue, allOrder);
            }
            if (orderBillFlag && BatchEditUtil.checkIsModify(returnData.get("relatedEntityId").toString(), modifyPropStr, modifyValue.toString()) && billRow.getDynamicObject("allorderbase") != null) {
                DynamicObject orderBill = BusinessDataServiceHelper.loadSingle((String)returnData.get("relatedEntityId").toString(), (String)("id,ordernum," + modifyPropStr), (QFilter[])new QFilter[]{new QFilter("ordernum", "=", (Object)billRow.getDynamicObject("allorderbase").getString("ordernum"))});
                this.updateOtherTableData(modifyPropStr, modifyValue, orderBill);
            }
            if (!allCheckingFlag) continue;
            DynamicObject allChecking = BusinessDataServiceHelper.loadSingle((String)"er_allcheckingbill", (String)("id," + modifyPropStr), (QFilter[])new QFilter[]{new QFilter("checkingid", "=", (Object)billRow.getPkValue().toString())});
            this.updateOtherTableData(modifyPropStr, modifyValue, allChecking);
        }
    }

    private Map<String, String> getSpecialFieldMap() {
        HashMap<String, String> specialFieldMap = new HashMap<String, String>(5);
        specialFieldMap.put("orderisinvoicerep", "needbilling");
        specialFieldMap.put("orderisrembureq", "isreimburse");
        specialFieldMap.put("bookeddatereq", "bookeddate");
        specialFieldMap.put("orderisapproverep", "isapprove");
        specialFieldMap.put("reimbursenum", "reimbursenum");
        return specialFieldMap;
    }

    private boolean checkPropIsExist(String prop, String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty property = mainEntityType.getProperty(prop);
        return property != null;
    }

    private void updateOtherTableData(Object modifyProp, Object modifyValue, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set(modifyProp.toString(), modifyValue);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!itemKey.equals("invoiceidentity")) {
            return;
        }
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        int selectedSize = selectedRows.size();
        if (selectedSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e(\u652f\u6301\u591a\u9009)\u3002", (String)"HotelAndPlaneCheckingBillList_23", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void identifyInvoice(Set<DynamicObject> waitCheckDatas) {
        DynamicObject dynamicObject2;
        if (CollectionUtils.isEmpty(waitCheckDatas)) {
            return;
        }
        IFormView view = this.getView();
        int size = waitCheckDatas.size();
        Set originSuccessData = waitCheckDatas.stream().filter(dynamicObject -> dynamicObject.getBoolean("invoiceidentityflag")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(originSuccessData)) {
            waitCheckDatas.removeAll(originSuccessData);
        }
        InvoiceService instanceService = InvoiceService.getInstanceService();
        Iterator<DynamicObject> iterator = waitCheckDatas.iterator();
        int successCount = 0;
        HashSet successDatas = Sets.newHashSetWithExpectedSize((int)16);
        HashSet failDatas = Sets.newHashSetWithExpectedSize((int)16);
        boolean enableXhInvoiceCloud = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        long startTime = System.currentTimeMillis();
        if (enableXhInvoiceCloud) {
            while (iterator.hasNext()) {
                dynamicObject2 = iterator.next();
                if (TripInvoiceUtils.checkingInvoiceIdentify((DynamicObject)dynamicObject2, (InvoiceService)instanceService).booleanValue()) {
                    successDatas.add(dynamicObject2);
                    ++successCount;
                    continue;
                }
                failDatas.add(dynamicObject2);
            }
        } else {
            dynamicObject2 = (DynamicObject)waitCheckDatas.stream().findFirst().get();
            String orderNum = dynamicObject2.getString("ordernum");
            long costCompany = 0L;
            Object settlemain = dynamicObject2.get("settlemain");
            if (settlemain != null) {
                costCompany = ErCommonUtils.getPk((Object)settlemain);
            }
            Object pkValue = dynamicObject2.get("id");
            String orderFormId = dynamicObject2.getString("formid");
            String bxdKey = orderFormId + pkValue;
            String userKey = "";
            try {
                userKey = APIHelper.getCommonUserKey((Long)costCompany, (String)bxdKey, (String)orderNum);
            }
            catch (InvoiceCloudException e) {
                logger.error("aws invoicecloud \u83b7\u53d6userkey error", (Throwable)e);
            }
            HashSet serialNos = Sets.newHashSetWithExpectedSize((int)16);
            while (iterator.hasNext()) {
                DynamicObject next = iterator.next();
                if (TripInvoiceUtils.checkInvoiceIdentifyByAws((DynamicObject)next, (String)userKey, (Set)serialNos)) {
                    successDatas.add(next);
                    ++successCount;
                    continue;
                }
                failDatas.add(next);
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("identify usedtime{}", (Object)(endTime - startTime));
        DynamicObject[] successOrderBills = null;
        if (CollectionUtils.isNotEmpty((Collection)successDatas)) {
            successOrderBills = TripInvoiceUtils.setOrderBill((Set)successDatas);
        }
        DynamicObject[] failOrderBills = null;
        if (CollectionUtils.isNotEmpty((Collection)failDatas)) {
            failOrderBills = TripInvoiceUtils.setOrderBill((Set)failDatas);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (successOrderBills != null) {
                    SaveServiceHelper.save((DynamicObject[])successOrderBills);
                }
                if (failOrderBills != null) {
                    SaveServiceHelper.save((DynamicObject[])failOrderBills);
                }
                SaveServiceHelper.save((DynamicObject[])waitCheckDatas.toArray(new DynamicObject[waitCheckDatas.size()]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("-1", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("-1", e.getMessage()), new Object[0]);
        }
        int failCount = size - successCount;
        if (successCount == 0) {
            failCount = waitCheckDatas.size();
        }
        if (size == successCount) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u5355\u7684\u53d1\u7968\u5747\u5df2\u8bc6\u522b\u6210\u529f\u3002", (String)"HotelAndPlaneCheckingBillList_25", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            successCount = Integer.sum(successCount, CollectionUtils.isEmpty(originSuccessData) ? 0 : originSuccessData.size());
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8bc6\u522b\u6210\u529f%1$s\u6761\uff1b\u5931\u8d25%2$s\u6761\u3002", (String)"HotelAndPlaneCheckingBillList_26", (String)"fi-er-formplugin", (Object[])new Object[0]), successCount, failCount));
        }
    }

    public void packageData(PackageDataEvent e) {
        try {
            DynamicObject datum = e.getRowData();
            Object totalamount = datum.get("allorderbase.totalamount");
            if (totalamount != null) {
                String colKey = e.getColKey();
                BigDecimal bigDecimal = new BigDecimal(totalamount.toString());
                if ("allorderbase.totalamount".equalsIgnoreCase(colKey) && bigDecimal.compareTo(ConvertUtil.getOrderAmountInit()) == 0) {
                    e.setFormatValue((Object)"-");
                }
            }
        }
        catch (Exception ex) {
            logger.error("packageData error", (Throwable)ex);
        }
    }
}

