/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.dailybiz;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.trip.dailybiz.AbsDeleteServiceFeeFormPlugin;
import kd.fi.er.formplugin.web.TripReimburseBillEdit;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class TripReimBillOrderEdit
extends AbsDeleteServiceFeeFormPlugin
implements UploadListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(TripReimburseBillEdit.class);
    private static final String MOVE_EXPENSE = "moveexpense";

    public void registerListener(EventObject e) {
        Control invoiceentryControl;
        super.registerListener(e);
        this.addClickListeners(new String[]{MOVE_EXPENSE, "copyentryrowentry"});
        Control entryentityControl = this.getControl("entryentity");
        if (entryentityControl != null) {
            ((EntryGrid)this.getControl("entryentity")).addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((invoiceentryControl = this.getControl("invoiceentry")) != null) {
            ((EntryGrid)this.getControl("invoiceentry")).addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((String)fieldName, (String)"ordernum")) {
            String ordernum = this.getModel().getValue("ordernum", event.getRowIndex()).toString();
            String orderformid = this.getModel().getValue("orderformid", event.getRowIndex()).toString();
            if (null != ordernum && !ordernum.trim().isEmpty()) {
                String[] orders = ordernum.split(",");
                String[] formids = orderformid.split(",");
                for (int i = 0; i < orders.length; ++i) {
                    String order = orders[i];
                    String formid = formids[i];
                    TripCommonUtil.openOrderBill((String)order, (String)formid, (IFormView)this.getView());
                }
            }
        } else if (StringUtils.equals((String)fieldName, (String)"invoiceno")) {
            String invoicefrom = this.getModel().getValue("invoicefrom", event.getRowIndex()).toString();
            if (ItemFrom.TripBusiness.getValue().equals(invoicefrom)) {
                String invoiceno = this.getModel().getValue("invoiceno", event.getRowIndex()).toString();
                this.openPlaneTicket(invoiceno);
            }
        } else if (StringUtils.equals((String)fieldName, (String)"invoiceno_entry")) {
            String invoicefrom = this.getModel().getValue("itemfrom", event.getRowIndex()).toString();
            if (ItemFrom.TripBusiness.getValue().equals(invoicefrom)) {
                String invoiceno = this.getModel().getValue("invoiceno_entry", event.getRowIndex()).toString();
                this.openPlaneTicket(invoiceno);
            }
        }
    }

    private void openPlaneTicket(String invoiceno) {
        DynamicObjectCollection planOrderBills = QueryServiceHelper.query((String)"er_planebill", (String)"ordernum,kddownloadlink,ticketnum", (QFilter[])new QFilter[]{new QFilter("ticketnum", "=", (Object)invoiceno)});
        if (planOrderBills != null && planOrderBills.size() > 0) {
            DynamicObject planOrderBill1 = (DynamicObject)planOrderBills.get(0);
            String kddownloadlink = planOrderBill1.getString("kddownloadlink");
            if (StringUtils.isEmpty((String)kddownloadlink) || StringUtils.isBlank((String)kddownloadlink)) {
                String tips = ResManager.loadKDString((String)"\u673a\u7968\u884c\u7a0b\u5355\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u8f7d", (String)"TripReimBillOrderEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                return;
            }
            this.getView().openUrl(kddownloadlink);
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "moveexpense": {
                this.openTripSection();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        switch (objectId = eventArgs.getObjectId()) {
            case "copyentryrowentry": {
                DynamicObjectCollection tripEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
                int tripRowIndex = tripEntries.size() - 1;
                DynamicObject tripEntry = (DynamicObject)tripEntries.get(tripRowIndex);
                DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
                boolean isCurrencyShowinTripentry = SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
                if (isCurrencyShowinTripentry) {
                    CardEntry grid = (CardEntry)this.getView().getControl("tripentry");
                    int[] selectRows = grid.getSelectRows();
                    BigDecimal tripExchangerate = ((DynamicObject)tripEntries.get(selectRows[0])).getBigDecimal("tripexchangerate");
                    if (tripExchangerate.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue("tripexchangerate", (Object)0, tripRowIndex);
                    } else {
                        this.getModel().beginInit();
                        this.getModel().setValue("tripexchangerate", (Object)0, tripRowIndex);
                        this.getModel().endInit();
                    }
                    this.getModel().setValue("tripexchangerate", (Object)tripExchangerate, tripRowIndex);
                }
                for (int i = 0; i < entrys.size(); ++i) {
                    Object orientryamount = ((DynamicObject)entrys.get(i)).get("orientryamount");
                    this.getModel().beginInit();
                    this.getModel().setValue("orientryamount", (Object)0, i, tripRowIndex);
                    this.getModel().endInit();
                    this.getModel().setValue("orientryamount", orientryamount, i, tripRowIndex);
                    this.getModel().setValue("invoiceno_entry", (Object)"", i, tripRowIndex);
                    this.getModel().setValue("itemfrom", (Object)0, i, tripRowIndex);
                    if (!isCurrencyShowinTripentry) {
                        BigDecimal exchangerate = ((DynamicObject)entrys.get(i)).getBigDecimal("exchangerate");
                        if (exchangerate.compareTo(BigDecimal.ZERO) == 0) {
                            this.getModel().setValue("exchangerate", (Object)0, i, tripRowIndex);
                        } else {
                            this.getModel().beginInit();
                            this.getModel().setValue("exchangerate", (Object)0, i, tripRowIndex);
                            this.getModel().endInit();
                        }
                        this.getModel().setValue("exchangerate", (Object)exchangerate, i, tripRowIndex);
                    }
                    DynamicObject expenseitem = ((DynamicObject)entrys.get(i)).getDynamicObject("expenseitem");
                    this.getModel().beginInit();
                    this.getModel().setValue("expenseitem", (Object)"", i, tripRowIndex);
                    this.getModel().endInit();
                    this.getModel().setValue("expenseitem", (Object)expenseitem, i, tripRowIndex);
                }
                AbstractGrid grid = (AbstractGrid)this.getView().getControl("tripentry");
                grid.selectRows(tripRowIndex);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject tripEntry;
        int tripRowIndex;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deletetripentry".equalsIgnoreCase(operateKey)) {
            tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            tripEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripRowIndex);
            if (tripEntry.getBoolean("isexistmonthly") && !ErStdConfig.getBoolean((String)"validate.cancel.monthentrydel")) {
                String tips = ResManager.loadKDString((String)"\u542b\u6709\u6708\u7ed3\u7684\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TripReimBillOrderEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equalsIgnoreCase((String)operateKey, (String)"copyentryrowentry")) {
            tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            tripEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripRowIndex);
            if (tripEntry.getBoolean("isexistmonthly")) {
                String tips = ResManager.loadKDString((String)"\u542b\u6709\u6708\u7ed3\u7684\u5206\u5f55\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"TripReimBillOrderEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(true);
                return;
            }
        }
    }

    private void openTripSection() {
        FormModel formModel1 = new FormModel("er_tripsection", ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f", (String)"TripReimBillOrderEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true);
        formModel1.setShowType(ShowType.Modal);
        HashMap customParam1 = new HashMap();
        int tripIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (tripIndex > -1 && entryIndex > -1) {
            DynamicObjectCollection tripEntrys = this.getModel().getEntryEntity("tripentry");
            ArrayList sectionObjects = new ArrayList();
            for (DynamicObject sectionObject : tripEntrys) {
                DynamicObject entrycostcompany;
                String from = sectionObject.getDynamicObject("from").getString("name");
                String to = sectionObject.getDynamicObject("to").getString("name");
                SimpleDateFormat format = new SimpleDateFormat("MM.dd");
                String startDate = format.format(sectionObject.getDate("startdate"));
                String endDate = format.format(sectionObject.getDate("enddate"));
                HashMap<String, String> paraMap = new HashMap<String, String>();
                DynamicObject entrycostdept = sectionObject.getDynamicObject("entrycostdept");
                if (entrycostdept != null) {
                    String costdept = entrycostdept.getString("name");
                    paraMap.put("entrycostdept", costdept);
                }
                if ((entrycostcompany = sectionObject.getDynamicObject("entrycostcompany")) != null) {
                    String costcompany = entrycostcompany.getString("name");
                    paraMap.put("entrycostcompany", costcompany);
                }
                paraMap.put("locationsection", from + "-" + to);
                paraMap.put("datesection", startDate + "-" + endDate);
                DynamicObjectCollection travelers = sectionObject.getDynamicObjectCollection("travelers");
                if (travelers != null) {
                    paraMap.put("travelers", (String)travelers);
                }
                sectionObjects.add(paraMap);
            }
            customParam1.put("tripentry", sectionObjects);
        }
        formModel1.setCustomParam(customParam1);
        formModel1.setCallBack(Boolean.TRUE);
        ShowPageUtils.showPage((FormModel)formModel1, (AbstractFormPlugin)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("er_tripsection".equals(actionId)) {
            int tripIndex;
            IDataModel model = this.getModel();
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            int toIndex = (Integer)returnData.get("toindex");
            if (toIndex == (tripIndex = model.getEntryCurrentRowIndex("tripentry"))) {
                return;
            }
            int entryIndex = model.getEntryCurrentRowIndex("entryentity");
            DynamicObject entry = model.getEntryRowEntity("entryentity", entryIndex);
            ArrayList<String> ordernumList = new ArrayList<String>();
            DynamicObject targetTripEntry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripIndex);
            try {
                model.beginInit();
                ordernumList.add(entry.getString("ordernum"));
                this.getView().getPageCache().put("deleteentryentityserviceentrys", JSON.toJSONString(ordernumList));
                model.endInit();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Object)e);
            }
            List oriOrderNums = Lists.newArrayListWithCapacity((int)16);
            try {
                model.beginInit();
                Map<String, Object> needDelData = this.getNeedDelData(entry, targetTripEntry, model.getDataEntity(true));
                ArrayList needRemoveIndex = Lists.newArrayListWithCapacity((int)2);
                needRemoveIndex.add(entryIndex);
                if (!needDelData.isEmpty()) {
                    int removeIndex = (Integer)needDelData.get("index");
                    oriOrderNums = (List)needDelData.get("orderNums");
                    if (removeIndex != -1) {
                        needRemoveIndex.add(removeIndex);
                    }
                }
                this.getView().getPageCache().put("deleteentryentitynocheckinvoiceentry", "true");
                Object indexArr = new int[needRemoveIndex.size()];
                for (int i = 0; i < needRemoveIndex.size(); ++i) {
                    indexArr[i] = (Integer)needRemoveIndex.get(i);
                }
                model.deleteEntryRows("entryentity", (int[])indexArr);
                model.endInit();
            }
            catch (Exception ex) {
                logger.error("\u5dee\u65c5\u62a5\u9500\u5355\u884c\u7a0b\u5206\u5f55\u79fb\u52a8\u8ba2\u5355\u62a5\u9519", (Object)e);
            }
            finally {
                this.getView().getPageCache().remove("deleteentryentitynocheckinvoiceentry");
            }
            Boolean isSettlementtype = false;
            DynamicObjectCollection entrys = model.getEntryEntity("entryentity");
            for (DynamicObject entryEntity : entrys) {
                if (null == entryEntity.get("settlementtype") || !"2".equals(entryEntity.get("settlementtype"))) continue;
                isSettlementtype = true;
                break;
            }
            model.setValue("isexistmonthly", (Object)isSettlementtype, tripIndex);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("tripentry");
            grid.selectRows(toIndex);
            model.setValue("isexistmonthly", (Object)true, toIndex);
            int newRowIndex = model.insertEntryRow("entryentity", 0);
            DataEntityPropertyCollection entryProps = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty property : entryProps) {
                String propertyName = property.getName();
                if (propertyName.equals("id") || propertyName.equals("seq") || entryProps.get((Object)propertyName) == null) continue;
                model.beginInit();
                logger.info("========>propertyName:{}", (Object)propertyName);
                model.setValue(propertyName, entry.get(propertyName), newRowIndex, toIndex);
                model.endInit();
            }
            DynamicObject newEntry = model.getEntryRowEntity("tripentry", toIndex);
            if (newEntry != null && entryProps.get((Object)"trip2to") != null && entryProps.get((Object)"trip2to_id") != null && entryProps.get((Object)"trip2from") != null && entryProps.get((Object)"trip2from_id") != null) {
                model.beginInit();
                model.setValue("trip2to", newEntry.get("to"), newRowIndex, toIndex);
                model.setValue("daycount", newEntry.get("tripday"), newRowIndex, toIndex);
                model.setValue("trip2to_id", (Object)ErCommonUtils.getPk((Object)newEntry.get("to")), newRowIndex, toIndex);
                model.setValue("trip2from", newEntry.get("from"), newRowIndex, toIndex);
                model.setValue("trip2from_id", (Object)ErCommonUtils.getPk((Object)newEntry.get("from")), newRowIndex, toIndex);
                model.endInit();
                model.setValue("triparea", newEntry.get("tripentryarea"));
            }
            this.addservicefee(model, toIndex, entry, newRowIndex);
            if (CollectionUtils.isNotEmpty((Collection)oriOrderNums)) {
                this.addOriServiceFee(oriOrderNums, model, tripIndex, entry);
            }
            TripReimburseServiceHelper.updateTripEntryAmount((IDataModel)model);
            DynamicObject data = model.getDataEntity(true);
            List entryEntitys = data.getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            List monthEntryEntitys = entryEntitys.stream().filter(x -> "2".equals(x.getString("settlementtype"))).collect(Collectors.toList());
            BigDecimal reimburseMonthMountTotal = AmountChangeUtil.sumAmountBy(monthEntryEntitys, (String)"entryappamount");
            BigDecimal reimburseTotal = AmountChangeUtil.sumAmountBy(entryEntitys, (String)"entryamount");
            model.setValue("monthsettleamount", (Object)reimburseMonthMountTotal);
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(toIndex)).getDynamicObjectCollection("entryentity");
            model.setValue("tripapporiamount", (Object)AmountChangeUtil.sumAmountBy((Collection)reimburseDetails, (String)"orientryappamount"), toIndex);
            model.setValue("tripappamount", (Object)AmountChangeUtil.sumAmountBy((Collection)reimburseDetails, (String)"entryappamount"), toIndex);
            model.setValue("encashamount", (Object)reimburseTotal.subtract(reimburseMonthMountTotal));
            model.setValue("approveamount", (Object)AmountChangeUtil.sumAmountBy(entryEntitys, (String)"entryappamount"));
            CoreBaseBillServiceHelper.refreshEntryRowSeq((IDataModel)model, (boolean)true, (int)tripIndex);
        }
    }

    private void addservicefee(IDataModel model, int toIndex, DynamicObject entry, int newRowIndex) {
        Long companyId = ErCommonUtils.getPk((Object)this.getModel().getDataEntity(true).getDynamicObject("company"));
        if (1 != SystemParamterUtil.getcheckparamDefaute((long)companyId, (String)"ticketservicesplit")) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u670d\u52a1\u8d39\u672a\u62c6\u5206 {}", (Object)companyId);
            return;
        }
        ArrayList<DynamicObject> orderbills = new ArrayList<DynamicObject>(1);
        DynamicObject tripentry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(toIndex);
        String orderformid = entry.getString("orderformid");
        DynamicObject orderbill = BusinessDataServiceHelper.loadSingle((String)orderformid, (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "=", (Object)entry.getString("ordernum"))});
        if (null != (orderbill = BusinessDataServiceHelper.loadSingle((Object)orderbill.getLong("id"), (String)orderformid))) {
            orderbills.add(orderbill);
            TripReimCreateOrderEntrysUtil.fillservicefee((DynamicObject)model.getDataEntity(true), (DynamicObject)tripentry, orderbills, (Boolean)entry.getBoolean("pulltravelorder"), (Boolean)false, null);
        }
        BigDecimal orientryappamount = ((DynamicObject)tripentry.getDynamicObjectCollection("entryentity").get(newRowIndex)).getBigDecimal("orientryappamount");
        model.beginInit();
        model.setValue("orientryappamount", (Object)0, newRowIndex, toIndex);
        model.endInit();
        model.setValue("orientryappamount", (Object)orientryappamount, newRowIndex, toIndex);
    }

    private Map<String, Object> getNeedDelData(DynamicObject currentMoveEntry, DynamicObject currentTripEntry, DynamicObject targetBill) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        if (1 != SystemParamterUtil.getcheckparamDefaute((long)ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company")), (String)"ticketservicesplit")) {
            logger.info("\u672a\u5f00\u542f\u670d\u52a1\u8d39\u62c6\u5206\u529f\u80fd");
            return resultMap;
        }
        String needMoveOrderNum = currentMoveEntry.getString("ordernum");
        if (StringUtils.isEmpty((String)needMoveOrderNum)) {
            logger.info("\u9700\u8981\u79fb\u52a8\u7684\u8ba2\u5355\u53f7\u4e3a\u7a7a,\u4e3a\u9519\u8bef\u6570\u636e,\u4e0d\u5141\u8bb8\u79fb\u52a8");
            return resultMap;
        }
        DynamicObjectCollection tripEntrys = currentTripEntry.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)tripEntrys)) {
            logger.info("\u5f53\u524d\u884c\u7a0b\u4e0b\u4e0d\u5305\u542b\u884c\u7a0b\u5206\u5f55,\u9519\u8bef\u64cd\u4f5c");
            return resultMap;
        }
        ArrayList needReCalcOrderNum = Lists.newArrayListWithCapacity((int)16);
        int needRemoveIndex = -1;
        int size = tripEntrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject expenseItem;
            DynamicObject iteraEntry = (DynamicObject)tripEntrys.get(i);
            List iteraOrdernum = Arrays.stream(iteraEntry.getString("ordernum").split(",")).collect(Collectors.toList());
            if (!iteraOrdernum.contains(needMoveOrderNum) || null == (expenseItem = iteraEntry.getDynamicObject("expenseitem"))) continue;
            Long id = expenseItem.getLong("id");
            DynamicObject tripExpenseItem = QueryServiceHelper.queryOne((String)"er_tripexpenseitem", (String)"operationtype,id,attribute,expenseitemicon,taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (null == tripExpenseItem || !tripExpenseItem.getString("operationtype").contains(AbstractOrderModel.OperationType.G.getKey())) continue;
            iteraOrdernum.remove(needMoveOrderNum);
            needReCalcOrderNum.addAll(iteraOrdernum);
            needRemoveIndex = i;
            break;
        }
        resultMap.put("orderNums", needReCalcOrderNum);
        resultMap.put("index", needRemoveIndex);
        return resultMap;
    }

    private void addOriServiceFee(List<String> orderNums, IDataModel model, int oriIndex, DynamicObject entry) {
        DynamicObject currentTripEntry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(oriIndex);
        if (CollectionUtils.isEmpty(orderNums)) {
            return;
        }
        Long companyId = ErCommonUtils.getPk((Object)this.getModel().getDataEntity(true).getDynamicObject("company"));
        if (1 != SystemParamterUtil.getcheckparamDefaute((long)companyId, (String)"ticketservicesplit")) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u670d\u52a1\u8d39\u672a\u62c6\u5206 {}", (Object)companyId);
            return;
        }
        DynamicObjectCollection tripEntrys = currentTripEntry.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)tripEntrys)) {
            return;
        }
        ArrayList notServiceFeeList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject tripEntry : tripEntrys) {
            String settlementtype = tripEntry.getString("settlementtype");
            if (!"2".equals(settlementtype)) continue;
            DynamicObject expenseItem = tripEntry.getDynamicObject("expenseitem");
            if (null == expenseItem) {
                if (!orderNums.contains(tripEntry.getString("ordernum"))) continue;
                notServiceFeeList.add(tripEntry);
                continue;
            }
            Long l = expenseItem.getLong("id");
            DynamicObject tripExpenseItem = QueryServiceHelper.queryOne((String)"er_tripexpenseitem", (String)"operationtype,id,attribute,expenseitemicon,taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)l)});
            if (null != tripExpenseItem && tripExpenseItem.getString("operationtype").contains(AbstractOrderModel.OperationType.G.getKey()) || !orderNums.contains(tripEntry.getString("ordernum"))) continue;
            notServiceFeeList.add(tripEntry);
        }
        if (CollectionUtils.isNotEmpty((Collection)notServiceFeeList)) {
            Map<String, List<DynamicObject>> collect = notServiceFeeList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("orderformid")));
            Set<Map.Entry<String, List<DynamicObject>>> entries = collect.entrySet();
            ArrayList<DynamicObject> orderbills = new ArrayList<DynamicObject>(16);
            for (Map.Entry entry2 : entries) {
                List value = (List)entry2.getValue();
                Set newOrderNums = value.stream().map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toSet());
                DynamicObject[] orderbillArr = BusinessDataServiceHelper.load((String)((String)entry2.getKey()), (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", newOrderNums)});
                if (orderbillArr == null || orderbillArr.length == 0) continue;
                List ids = Arrays.stream(orderbillArr).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                Object[] objects = new Object[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    objects[i] = ids.get(i);
                }
                MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)((String)entry2.getKey()));
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)billEntityType);
                if (load == null || load.length == 0) continue;
                orderbills.addAll(Arrays.asList(load));
            }
            DynamicObject tripentry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(oriIndex);
            if (CollectionUtils.isNotEmpty(orderbills)) {
                TripReimCreateOrderEntrysUtil.fillservicefee((DynamicObject)model.getDataEntity(true), (DynamicObject)tripentry, orderbills, (Boolean)entry.getBoolean("pulltravelorder"), (Boolean)false, null);
            }
        }
    }
}

