/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.order;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.fi.er.formplugin.trip.util.BatchEditUtil;
import org.apache.commons.lang.StringUtils;

public class BatchEditPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BatchEditPlugin.class);
    private static final Map<String, String> comboFieldMap = new HashMap<String, String>(16);

    private List<ControlAp<?>> getMetaItems(String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        FormMetadata taskMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return taskMeta.getItems();
    }

    private void initFieldList() {
        this.initConflictField();
    }

    private Map<String, Object> initConflictField() {
        HashMap<String, Object> resMap = new HashMap<String, Object>(2);
        ArrayList conflictFieldList = Lists.newArrayListWithCapacity((int)64);
        ArrayList conflictList = Lists.newArrayListWithCapacity((int)4);
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_hotelcheckingbill", "totalamount", "totalamounthotelchecking"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_planecheckingbill", "totalamount", "totalamounthotelchecking"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_traincheckingbill", "totalamount", "totalamounthotelchecking"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclecheckingbill", "totalamount", "totalamounthotelchecking"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_mealcheckingbill", "totalamount", "totalamounthotelchecking"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_trainbill", "ticketprice", "ticketpricetrain"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_traincheckingbill", "ticketprice", "ticketpricetrain"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_trainbill", "dealamount", "dealamounttrain"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclebill", "dealamount", "dealamountvihicle"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclecheckingbill", "dealamount", "dealamountvihicle"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_planebill", "ticketprice", "ticketpriceplane"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_planecheckingbill", "ticketprice", "ticketpriceplane"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_planebill", "orderstatus", "orderstatusplanebill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_trainbill", "orderstatus", "orderstatustrainbill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclebill", "orderstatus", "orderstatusvehiclebill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_mealbill", "orderstatus", "statusmealcheckingbill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_mealbill", "oabillnum", "oabillnummeal"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_planecheckingbill", "orderstatus", "statusplanecheckingbill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_traincheckingbill", "orderstatus", "statustraincheckingbill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclecheckingbill", "orderstatus", "statusvehiclecheckingbill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_mealcheckingbill", "orderstatus", "statusmealcheckingbill"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_mealcheckingbill", "oabillnum", "oabillnummeal"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_mealcheckingbill", "company", "bookedcompany"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclecheckingbill", "oabillnum", "oabillnumvehicle"));
        conflictFieldList.add(new ThreeTuple<String, String, String>("er_vehiclebill", "oabillnum", "oabillnumvehicle"));
        conflictList.add("ticketprice");
        conflictList.add("dealamount");
        conflictList.add("totalamount");
        conflictList.add("orderstatus");
        conflictList.add("oabillnum");
        conflictList.add("company");
        resMap.put("field", conflictFieldList);
        resMap.put("list", conflictList);
        return resMap;
    }

    private List<String> initCommonField() {
        ArrayList commonFieldList = Lists.newArrayListWithCapacity((int)10);
        commonFieldList.add("company");
        commonFieldList.add("expcommitdepnum");
        commonFieldList.add("expcommitcomnum");
        commonFieldList.add("oabillnum");
        commonFieldList.add("orderstatus");
        commonFieldList.add("servicefee");
        commonFieldList.add("isconfirm");
        commonFieldList.add("isreimburse");
        commonFieldList.add("isapprove");
        commonFieldList.add("bookeddate");
        commonFieldList.add("settlemain");
        commonFieldList.add("settledept");
        commonFieldList.add("orderamounttax");
        commonFieldList.add("orderdeductrate");
        commonFieldList.add("serviceamounttax");
        commonFieldList.add("servicedeductrate");
        commonFieldList.add("totaltax");
        commonFieldList.add("orderisrembureq");
        commonFieldList.add("orderisapproverep");
        commonFieldList.add("bookeddatereq");
        return commonFieldList;
    }

    private Map<String, List<String>> initVehicleBillAndVehicleCheckingBillField() {
        ArrayList vehicleBillFieldList = Lists.newArrayListWithCapacity((int)4);
        vehicleBillFieldList.add("dealamountvihicle");
        vehicleBillFieldList.add("bookeddept");
        vehicleBillFieldList.add("tripid");
        vehicleBillFieldList.add("totalamount");
        vehicleBillFieldList.add("orderstatusvehiclebill");
        vehicleBillFieldList.add("vehicletype");
        vehicleBillFieldList.add("oabillnumvehicle");
        vehicleBillFieldList.add("pricebillingtype");
        ArrayList vehicleCheckingBillFieldList = Lists.newArrayListWithCapacity((int)4);
        vehicleCheckingBillFieldList.add("dealamountvihicle");
        vehicleCheckingBillFieldList.add("totalamounthotelchecking");
        vehicleCheckingBillFieldList.add("isdeductible");
        vehicleCheckingBillFieldList.add("org");
        vehicleCheckingBillFieldList.add("statusvehiclecheckingbill");
        vehicleCheckingBillFieldList.add("vehicletype");
        vehicleCheckingBillFieldList.add("oabillnumvehicle");
        vehicleCheckingBillFieldList.add("pricebillingtype");
        return this.returnResMap(vehicleBillFieldList, vehicleCheckingBillFieldList);
    }

    private Map<String, List<String>> initMealBillAndMealCheckingBillField() {
        ArrayList mealBillFieldList = Lists.newArrayListWithCapacity((int)16);
        mealBillFieldList.add("ordertype");
        mealBillFieldList.add("statusmealcheckingbill");
        mealBillFieldList.add("bookeddept");
        mealBillFieldList.add("bookedcompany");
        mealBillFieldList.add("dinnerscene");
        mealBillFieldList.add("producttype");
        mealBillFieldList.add("totalamount");
        ArrayList mealCheckingBillFieldList = Lists.newArrayListWithCapacity((int)16);
        mealCheckingBillFieldList.add("reimbursenum");
        mealCheckingBillFieldList.add("statusmealcheckingbill");
        mealCheckingBillFieldList.add("ordertype");
        mealCheckingBillFieldList.add("org");
        mealCheckingBillFieldList.add("dinnerscene");
        mealCheckingBillFieldList.add("oabillnummeal");
        mealCheckingBillFieldList.add("mealcityname");
        mealCheckingBillFieldList.add("totalamounthotelchecking");
        mealCheckingBillFieldList.add("producttype");
        mealCheckingBillFieldList.add("personalfee");
        return this.returnResMap(mealBillFieldList, mealCheckingBillFieldList);
    }

    private Map<String, List<String>> initTrainBillAndTrainCheckingBillField() {
        ArrayList trainBillFieldList = Lists.newArrayListWithCapacity((int)6);
        trainBillFieldList.add("bookeddept");
        trainBillFieldList.add("tripid");
        trainBillFieldList.add("totalamount");
        trainBillFieldList.add("ticketpricetrain");
        trainBillFieldList.add("dealamounttrain");
        trainBillFieldList.add("refundamount");
        trainBillFieldList.add("orderstatustrainbill");
        ArrayList trainCheckingBillFieldList = Lists.newArrayListWithCapacity((int)5);
        trainCheckingBillFieldList.add("ticketpricetrain");
        trainCheckingBillFieldList.add("assuranceamount");
        trainCheckingBillFieldList.add("refundamount");
        trainCheckingBillFieldList.add("isdeductible");
        trainCheckingBillFieldList.add("org");
        trainCheckingBillFieldList.add("statustraincheckingbill");
        return this.returnResMap(trainBillFieldList, trainCheckingBillFieldList);
    }

    private Map<String, List<String>> initPlaneBillAndPlaneCheckingBillField() {
        ArrayList planeBillFieldList = Lists.newArrayListWithCapacity((int)12);
        planeBillFieldList.add("bookeddept");
        planeBillFieldList.add("tripid");
        planeBillFieldList.add("standprice");
        planeBillFieldList.add("discount");
        planeBillFieldList.add("lowestpirce");
        planeBillFieldList.add("ticketpriceplane");
        planeBillFieldList.add("airportprice");
        planeBillFieldList.add("fuelprice");
        planeBillFieldList.add("refundamount");
        planeBillFieldList.add("endorsementamount");
        planeBillFieldList.add("assuranceamount");
        planeBillFieldList.add("otheramount");
        planeBillFieldList.add("orderstatusplanebill");
        ArrayList planeCheckingBillFieldList = Lists.newArrayListWithCapacity((int)10);
        planeCheckingBillFieldList.add("ticketpriceplane");
        planeCheckingBillFieldList.add("airportprice");
        planeCheckingBillFieldList.add("fuelprice");
        planeCheckingBillFieldList.add("refundamount");
        planeCheckingBillFieldList.add("endorsementamount");
        planeCheckingBillFieldList.add("assuranceamount");
        planeCheckingBillFieldList.add("otheramount");
        planeCheckingBillFieldList.add("reimbursenum");
        planeCheckingBillFieldList.add("isdeductible");
        planeCheckingBillFieldList.add("org");
        planeCheckingBillFieldList.add("statusplanecheckingbill");
        return this.returnResMap(planeBillFieldList, planeCheckingBillFieldList);
    }

    private Map<String, List<String>> returnResMap(List<String> billFieldList, List<String> checkingBillFieldList) {
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>(2);
        resMap.put("bill", billFieldList);
        resMap.put("checkingBill", checkingBillFieldList);
        return resMap;
    }

    private Map<String, List<String>> initHotelBillAndHotelCheckingBillField() {
        ArrayList hotelBillFieldList = Lists.newArrayListWithCapacity((int)7);
        hotelBillFieldList.add("bookeddept");
        hotelBillFieldList.add("tripid");
        hotelBillFieldList.add("roomamount");
        hotelBillFieldList.add("roomcount");
        hotelBillFieldList.add("totalamount");
        hotelBillFieldList.add("unbookfee");
        hotelBillFieldList.add("personalfee");
        hotelBillFieldList.add("pricebillingtype");
        ArrayList hotelCheckingBillFieldList = Lists.newArrayListWithCapacity((int)8);
        hotelCheckingBillFieldList.add("productsontype");
        hotelCheckingBillFieldList.add("batchno");
        hotelCheckingBillFieldList.add("totalamounthotelchecking");
        hotelCheckingBillFieldList.add("roomcount");
        hotelCheckingBillFieldList.add("unbookfee");
        hotelCheckingBillFieldList.add("reimbursenum");
        hotelCheckingBillFieldList.add("isdeductible");
        hotelCheckingBillFieldList.add("org");
        hotelCheckingBillFieldList.add("pricebillingtype");
        return this.returnResMap(hotelBillFieldList, hotelCheckingBillFieldList);
    }

    public void afterBindData(EventObject e) {
        this.initFieldList();
        String entityId = this.getEntityId();
        if (!StringUtils.isEmpty((String)entityId)) {
            List<ControlAp<?>> items = this.getMetaItems(entityId);
            ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            Map<String, List<String>> hotelBillAndHotelCheckingBillField = this.initHotelBillAndHotelCheckingBillField();
            Map<String, List<String>> planeBillAndPlaneCheckingBillField = this.initPlaneBillAndPlaneCheckingBillField();
            Map<String, List<String>> trainBillAndTrainCheckingBillField = this.initTrainBillAndTrainCheckingBillField();
            Map<String, List<String>> vehicleBillAndVehicleCheckingBillField = this.initVehicleBillAndVehicleCheckingBillField();
            Map<String, List<String>> initMealBillAndMealCheckingBillField = this.initMealBillAndMealCheckingBillField();
            switch (entityId) {
                case "er_hotelbill": {
                    this.setComboItems(items, hotelBillAndHotelCheckingBillField.get("bill"), comboItems);
                    break;
                }
                case "er_planebill": {
                    this.setComboItems(items, planeBillAndPlaneCheckingBillField.get("bill"), comboItems);
                    break;
                }
                case "er_trainbill": {
                    this.setComboItems(items, trainBillAndTrainCheckingBillField.get("bill"), comboItems);
                    break;
                }
                case "er_vehiclebill": {
                    this.setComboItems(items, vehicleBillAndVehicleCheckingBillField.get("bill"), comboItems);
                    break;
                }
                case "er_mealbill": {
                    this.setComboItems(items, initMealBillAndMealCheckingBillField.get("bill"), comboItems);
                    break;
                }
                case "er_hotelcheckingbill": {
                    this.setComboItems(items, hotelBillAndHotelCheckingBillField.get("checkingBill"), comboItems);
                    break;
                }
                case "er_planecheckingbill": {
                    this.setComboItems(items, planeBillAndPlaneCheckingBillField.get("checkingBill"), comboItems);
                    break;
                }
                case "er_traincheckingbill": {
                    this.setComboItems(items, trainBillAndTrainCheckingBillField.get("checkingBill"), comboItems);
                    break;
                }
                case "er_vehiclecheckingbill": {
                    this.setComboItems(items, vehicleBillAndVehicleCheckingBillField.get("checkingBill"), comboItems);
                    break;
                }
                case "er_mealcheckingbill": {
                    this.setComboItems(items, initMealBillAndMealCheckingBillField.get("checkingBill"), comboItems);
                }
            }
            comboEdit.setComboItems(comboItems);
            this.hideOtherProp("combofield");
        }
    }

    private void setComboItems(List<ControlAp<?>> items, List<String> fieldList, List<ComboItem> comboItems) {
        List initFieldlist = (List)this.initConflictField().get("list");
        List<String> initCommonlist = this.initCommonField();
        for (ControlAp<?> control : items) {
            if (!(control instanceof FieldAp) || !initCommonlist.contains(control.getKey()) && !fieldList.contains(control.getKey()) && !initFieldlist.contains(control.getKey())) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(control.getName());
            comboItem.setValue(control.getKey());
            comboItems.add(comboItem);
            comboFieldMap.putIfAbsent(control.getKey(), control.getName().getLocaleValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        String entityId = this.getEntityId();
        ChangeData[] changeSet = e.getChangeSet();
        String string = newValue = changeSet[0].getNewValue() == null ? "" : changeSet[0].getNewValue().toString();
        if (((List)this.initConflictField().get("list")).contains(newValue)) {
            newValue = this.dealConflictField(newValue, entityId);
        }
        this.hideOtherProp(newValue);
        this.getView().setVisible(Boolean.TRUE, new String[]{newValue});
    }

    private void hideOtherProp(String newValue) {
        ArrayList<List<String>> hideList = new ArrayList<List<String>>();
        Map<String, List<String>> planeBillAndPlaneCheckingBillField = this.initPlaneBillAndPlaneCheckingBillField();
        Map<String, List<String>> hotelBillAndHotelCheckingBillField = this.initHotelBillAndHotelCheckingBillField();
        Map<String, List<String>> trainBillAndTrainCheckingBillField = this.initTrainBillAndTrainCheckingBillField();
        Map<String, List<String>> vehicleBillAndVehicleCheckingBillField = this.initVehicleBillAndVehicleCheckingBillField();
        Map<String, List<String>> initMealBillAndMealCheckingBillField = this.initMealBillAndMealCheckingBillField();
        hideList.add(this.initCommonField());
        hideList.add(planeBillAndPlaneCheckingBillField.get("bill"));
        hideList.add(planeBillAndPlaneCheckingBillField.get("checkingBill"));
        hideList.add(hotelBillAndHotelCheckingBillField.get("bill"));
        hideList.add(hotelBillAndHotelCheckingBillField.get("checkingBill"));
        hideList.add(trainBillAndTrainCheckingBillField.get("bill"));
        hideList.add(trainBillAndTrainCheckingBillField.get("checkingBill"));
        hideList.add(vehicleBillAndVehicleCheckingBillField.get("bill"));
        hideList.add(vehicleBillAndVehicleCheckingBillField.get("checkingBill"));
        hideList.add(initMealBillAndMealCheckingBillField.get("bill"));
        hideList.add(initMealBillAndMealCheckingBillField.get("checkingBill"));
        this.otherHide(hideList, newValue);
    }

    private void otherHide(List<List<String>> billFieldList, String newValue) {
        if (newValue == null || newValue.contains("bos_org")) {
            return;
        }
        billFieldList.forEach(fieldList -> fieldList.forEach(field -> {
            if (!field.equals(newValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{field});
            }
        }));
    }

    private String getEntityId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        return customParams.get("entityId") == null ? "" : customParams.get("entityId").toString();
    }

    private String dealConflictField(String newValue, String entityId) {
        String returnValue = newValue;
        for (ThreeTuple field : (List)this.initConflictField().get("field")) {
            String first = (String)field.first;
            String sourceKey = (String)field.second;
            String targetKey = (String)field.third;
            if (!entityId.equals(first) || !sourceKey.equals(newValue)) continue;
            returnValue = targetKey;
            break;
        }
        return returnValue;
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        HashMap<String, Object> returnParam = new HashMap<String, Object>();
        switch (key) {
            case "btnok": {
                Object combofield = model.getValue("combofield");
                if (!Objects.isNull(combofield)) {
                    Object value;
                    String prop = combofield.toString();
                    if (((List)this.initConflictField().get("list")).contains(prop)) {
                        prop = this.dealConflictField(prop, this.getEntityId());
                    }
                    if ((value = this.getModel().getValue(prop)) instanceof Date) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.s");
                        Date date = (Date)value;
                        String dateStr = format.format(date);
                        returnParam.put("dateStr", dateStr);
                    }
                    logger.info("\u5f53\u524d\u4e0b\u62c9\u5217\u8868\u5c5e\u6027" + combofield);
                    returnParam.put("key", combofield);
                    returnParam.put("value", value);
                    returnParam.put("entityId", this.getEntityId());
                    returnParam.put("relatedEntityId", this.returnRelatedEntityId());
                    String localeName = comboFieldMap.get(combofield);
                    logger.info("\u5bf9\u5e94\u5c5e\u6027\u4e2d\u6587" + localeName);
                    returnParam.put(combofield.toString(), localeName);
                    if (this.getControl(combofield.toString()) instanceof ComboEdit) {
                        DynamicObject dataEntity = this.getModel().getDataEntity();
                        Object o = dataEntity.get(prop);
                        MainEntityType dataEntityType = (MainEntityType)dataEntity.getDataEntityType();
                        DataEntityPropertyCollection properties = dataEntityType.getProperties();
                        ComboProp comboUnitProp = (ComboProp)properties.get((Object)prop);
                        String unitName = comboUnitProp.getItemByName(o.toString());
                        returnParam.put("afterLocaleName", unitName);
                        returnParam.put("combofieldList", BatchEditUtil.getCombofieldList(this.getView(), prop));
                    } else if (this.getControl(combofield.toString()) instanceof OrgEdit) {
                        assert (value instanceof DynamicObject);
                        DynamicObject dynamicObject = (DynamicObject)value;
                        String name = dynamicObject.getLocaleString("name").getLocaleValue();
                        returnParam.put("org", name);
                    }
                }
                this.getView().returnDataToParent(returnParam);
                this.getView().close();
            }
        }
    }

    private String returnRelatedEntityId() {
        String relatedEntityId = "";
        switch (this.getEntityId()) {
            case "er_hotelbill": {
                relatedEntityId = "er_hotelcheckingbill";
                break;
            }
            case "er_planebill": {
                relatedEntityId = "er_planecheckingbill";
                break;
            }
            case "er_trainbill": {
                relatedEntityId = "er_traincheckingbill";
                break;
            }
            case "er_vehiclebill": {
                relatedEntityId = "er_vehiclecheckingbill";
                break;
            }
            case "er_mealbill": {
                relatedEntityId = "er_mealcheckingbill";
                break;
            }
            case "er_hotelcheckingbill": {
                relatedEntityId = "er_hotelbill";
                break;
            }
            case "er_planecheckingbill": {
                relatedEntityId = "er_planebill";
                break;
            }
            case "er_traincheckingbill": {
                relatedEntityId = "er_trainbill";
                break;
            }
            case "er_vehiclecheckingbill": {
                relatedEntityId = "er_vehiclebill";
                break;
            }
            case "er_mealcheckingbill": {
                relatedEntityId = "er_mealbill";
            }
        }
        return relatedEntityId;
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                if (!this.checkRequiredProps("combofield").booleanValue()) {
                    evt.setCancel(true);
                    return;
                }
                Object combofield = this.getModel().getValue("combofield");
                String prop = combofield.toString();
                if (((List)this.initConflictField().get("list")).contains(prop)) {
                    prop = this.dealConflictField(prop, this.getEntityId());
                }
                if (this.checkRequiredProps(prop).booleanValue()) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    private Boolean checkRequiredProps(String prop) {
        IDataModel model = this.getModel();
        Object value = model.getValue(prop);
        IDataEntityProperty property = model.getProperty(prop);
        if (Objects.isNull(value) || StringUtils.equals((String)"", (String)value.toString())) {
            String displayNameStr = "";
            try {
                LocaleString displayName = (LocaleString)property.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)property, new Object[0]);
                displayNameStr = displayName.getLocaleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"BatchEditPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), displayNameStr));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static class ThreeTuple<A, B, C> {
        public final A first;
        public final B second;
        public final C third;

        public ThreeTuple(A a, B b, C c) {
            this.first = a;
            this.second = b;
            this.third = c;
        }
    }
}

