/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.order;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.TripOrderUtil;
import kd.fi.er.formplugin.trip.order.AbstractOrderNoticePlugin;

public class OrderNoticeMobPlugin
extends AbstractOrderNoticePlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"feedbackbutton"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "feedbackbutton": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId(this.getFeedbackFormId());
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                showParameter.getCustomParams().put("feedback", this.getModel().getValue("feedback"));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("confrim".equals(operateKey)) {
            this.getModel().setValue("isconfirm", (Object)"1");
            DynamicObject object = this.getModel().getDataEntity();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    @Override
    String getFeedbackFormId() {
        return "er_order_feedback_mb";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String type = this.getModel().getDataEntityType().getName();
        String orderTitle = TripOrderUtil.convertNameByOrderType((String)type);
        orderTitle = String.format(ResManager.loadKDString((String)"%s\u8ba2\u5355\u786e\u8ba4\u901a\u77e5\u5355", (String)"OrderNoticeMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), orderTitle);
        Label ordertitleLabel = (Label)this.getView().getControl("ordertitle");
        ordertitleLabel.setText(orderTitle);
        Label confirmed = (Label)this.getView().getControl("confirmed");
        Label confirming = (Label)this.getView().getControl("confirming");
        Label labelfeedback = (Label)this.getView().getControl("labelfeedback");
        confirmed.setText(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"OrderNoticeMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        confirming.setText(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"OrderNoticeMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        labelfeedback.setText(ResManager.loadKDString((String)"\u5df2\u53cd\u9988", (String)"OrderNoticeMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
    }
}

