/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryReimburseUpOrdersPlugin
extends AbstractFormPlugin
implements MobileSearchTextChangeListener {
    public void initialize() {
        super.initialize();
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        if (mobileSearch != null) {
            mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_confirm", "bar_close"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParam.get("opttype") && "view".equals(customParam.get("opttype").toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_close"});
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("selchexkbox", false);
            this.getView().updateControlMetadata("entryentity", map);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.searchOrder(null);
    }

    private void searchOrder(String value) {
        int size = this.getModel().getEntryEntity("entryentity").size();
        if (size > 0) {
            this.getModel().deleteEntryData("entryentity");
        }
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        List<Object> orderList = new ArrayList<DynamicObject>();
        if (null != customParam.get("opttype") && "view".equals(customParam.get("opttype").toString())) {
            JSONArray billNos = JSONArray.parseArray((String)JSONObject.toJSONString(customParam.get("billnos")));
            if (null == billNos || billNos.isEmpty()) {
                return;
            }
            this.listViewOrder(orderList, billNos);
        } else {
            JSONArray existOrderNums = (JSONArray)customParam.get("existOrderNums");
            Long applier = ErCommonUtils.getPk(customParam.get("applier"));
            Long creator = ErCommonUtils.getPk(customParam.get("creator"));
            Object[] tripUsers = null;
            if (customParam.get("tripUsers") != null) {
                tripUsers = ((JSONArray)customParam.get("tripUsers")).toArray();
            }
            JSONArray reqbillIds = (JSONArray)customParam.get("reqbillIds");
            if ("1".equals(customParam.get("onlychoosetriporder")) && (reqbillIds == null || reqbillIds.size() == 0)) {
                return;
            }
            Long companyId = ErCommonUtils.getPk(customParam.get("companyId"));
            companyId = companyId == null ? Long.valueOf(0L) : companyId;
            orderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByUp((Long)applier, (Object[])tripUsers, (Object[])existOrderNums.toArray(), (Object[])reqbillIds.toArray(), (Long)companyId, (String)value, (Long)creator);
            orderList.removeIf(m -> !TripNotReimbursedOrderUtil.checkAvailableOrder((DynamicObject)m));
            Set ordernums = orderList.stream().map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toSet());
            QFilter reimburFilter = new QFilter("tripentry.entryentity.ordernum", "in", ordernums).and(new QFilter("billstatus", "!=", (Object)"H"));
            DynamicObjectCollection reimburseObjects = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,tripentry.entryentity.ordernum", (QFilter[])new QFilter[]{reimburFilter});
            Set ordernumSet = reimburseObjects.stream().map(dynamicObject -> dynamicObject.getString("tripentry.entryentity.ordernum")).collect(Collectors.toSet());
            orderList.removeIf(m -> ordernumSet.contains(m.getString("ordernum")));
        }
        if (orderList.size() == 0) {
            return;
        }
        orderList.sort((e1, e2) -> ((Date)ObjectUtils.defaultIfNull((Object)e2.getDate("orderdate"), (Object)TripCommonUtil.convertToDate((String)"1900-01-01 00:00:00"))).compareTo((Date)ObjectUtils.defaultIfNull((Object)e1.getDate("orderdate"), (Object)TripCommonUtil.convertToDate((String)"1900-01-01 00:00:00"))));
        this.setEntryValue(orderList);
    }

    private void setEntryValue(List<DynamicObject> orderList) {
        this.getView().getModel().batchCreateNewEntryRow("entryentity", orderList.size());
        IDataModel model = this.getModel();
        if ("er_travel_up_mobileorder".equals(this.getView().getEntityId())) {
            Set set = orderList.stream().map(m -> {
                if ("er_mealbill".equals(m.getDataEntityType().getName())) {
                    return m.getString("bookedname");
                }
                if ("er_planebill".equals(m.getDataEntityType().getName()) || "er_hotelbill".equals(m.getDataEntityType().getName())) {
                    return m.getString("travelername");
                }
                return m.getString("passegername");
            }).collect(Collectors.toSet());
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(set.size());
            for (String s : set) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(s);
                comboItem.setCaption(new LocaleString(s));
                comboItem.setItemVisible(true);
                list.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("travelname");
            comboEdit.setComboItems(list);
        }
        for (int i = 0; i < orderList.size(); ++i) {
            DynamicObject dynamicObject = orderList.get(i);
            String type = dynamicObject.getDataEntityType().getName();
            String from = null;
            String to = null;
            Date beginTime = null;
            Date endTime = null;
            String travelName = null;
            Object status = null;
            Object ticketprice = null;
            String orderStatus = null;
            BigDecimal refundamount = null;
            BigDecimal assuranceamount = null;
            BigDecimal airportprice = null;
            BigDecimal fuelprice = null;
            BigDecimal endorsementamount = null;
            CardEntry cardEntry = null;
            if ("er_travel_up_mobileorder".equals(this.getView().getEntityId())) {
                cardEntry = (CardEntry)this.getView().getControl("entryentity");
            }
            switch (type) {
                case "er_planebill": {
                    from = dynamicObject.getString("fromcityname");
                    to = dynamicObject.getString("tocityname");
                    beginTime = dynamicObject.getDate("takeofftime");
                    endTime = dynamicObject.getDate("landingtime");
                    travelName = dynamicObject.getString("travelername");
                    ticketprice = dynamicObject.get("ticketprice");
                    status = dynamicObject.get("ticketstatus");
                    refundamount = dynamicObject.getBigDecimal("refundamount");
                    assuranceamount = dynamicObject.getBigDecimal("assuranceamount");
                    airportprice = dynamicObject.getBigDecimal("airportprice");
                    fuelprice = dynamicObject.getBigDecimal("fuelprice");
                    endorsementamount = dynamicObject.getBigDecimal("endorsementamount");
                    if (!"er_travel_up_mobileorder".equals(this.getView().getEntityId()) || cardEntry == null) break;
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"mealcardentry"});
                    break;
                }
                case "er_hotelbill": {
                    to = dynamicObject.getString("cityname");
                    beginTime = dynamicObject.getDate("checkindate");
                    endTime = dynamicObject.getDate("checkoutdate");
                    travelName = dynamicObject.getString("travelername");
                    ticketprice = dynamicObject.get("roomamount");
                    refundamount = dynamicObject.getBigDecimal("unbookfee");
                    if (!"er_travel_up_mobileorder".equals(this.getView().getEntityId()) || cardEntry == null) break;
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"mealcardentry"});
                    break;
                }
                case "er_trainbill": {
                    from = dynamicObject.getString("departcity");
                    to = dynamicObject.getString("arrivecity");
                    beginTime = dynamicObject.getDate("departtime");
                    endTime = dynamicObject.getDate("arrivetime");
                    travelName = dynamicObject.getString("passegername");
                    ticketprice = dynamicObject.get("ticketprice");
                    refundamount = dynamicObject.getBigDecimal("refundamount");
                    assuranceamount = dynamicObject.getBigDecimal("dealamount");
                    if (!"er_travel_up_mobileorder".equals(this.getView().getEntityId()) || cardEntry == null) break;
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"mealcardentry"});
                    break;
                }
                case "er_vehiclebill": {
                    from = dynamicObject.getString("departaddress");
                    to = dynamicObject.getString("arriveaddress");
                    beginTime = dynamicObject.getDate("usetime");
                    travelName = dynamicObject.getString("passegername");
                    ticketprice = dynamicObject.get("dealamount");
                    if (!"er_travel_up_mobileorder".equals(this.getView().getEntityId()) || cardEntry == null) break;
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"mealcardentry"});
                    break;
                }
                case "er_mealbill": {
                    to = dynamicObject.getString("mealcityname");
                    travelName = dynamicObject.getString("bookedname");
                    ticketprice = dynamicObject.getBigDecimal("totalamount").subtract(dynamicObject.getBigDecimal("servicefee"));
                    endTime = dynamicObject.getDate("mealtime");
                    if (!"er_travel_up_mobileorder".equals(this.getView().getEntityId())) break;
                    model.setValue("mealcityname", (Object)to, i);
                    model.setValue("mealtime", (Object)endTime, i);
                    if (cardEntry == null) break;
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardentryflexpanelap13", "cardentryflexpanelap21", "traincardentry", "cardentryflexpanelap7"});
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("orderstatus"))) {
                orderStatus = type + "_" + dynamicObject.getString("orderstatus");
            }
            if ("er_travel_up_mobileorder".equals(this.getView().getEntityId())) {
                model.setValue("from", (Object)from, i);
                model.setValue("to", (Object)to, i);
                model.setValue("begintime", (Object)beginTime, i);
                model.setValue("endtime", (Object)endTime, i);
                model.setValue("travelname", (Object)travelName, i);
                model.setValue("totalamount", (Object)dynamicObject.getString("totalamount"), i);
                model.setValue("orderdate", (Object)dynamicObject.getDate("orderdate"), i);
                model.setValue("type", (Object)type, i);
                model.setValue("orderstatus", (Object)orderStatus, i);
                model.setValue("id", dynamicObject.getPkValue(), i);
                continue;
            }
            for (String s : Arrays.asList("server", "expcommitdepnum", "expcommitcomnum", "ordertype", "ordernum", "parentordernum", "operationtype", "oabillnum", "orderdate", "sourcebookedid", "producttype", "totalamount", "servicefee", "bookeddept", "company", "currency")) {
                if (s.equals("totalamount") && dynamicObject.getBigDecimal(s).compareTo(ConvertUtil.getOrderAmountInit()) == 0) {
                    model.setValue(s, (Object)"", i);
                    continue;
                }
                model.setValue(s, dynamicObject.get(s), i);
            }
            model.setValue("booknum", (Object)(dynamicObject.getDynamicObject("sourcebookedid") == null ? "" : dynamicObject.getDynamicObject("sourcebookedid").getString("number")), i);
            model.setValue("id", (Object)ErCommonUtils.getPk((Object)dynamicObject), i);
            model.setValue("from", (Object)from, i);
            model.setValue("to", (Object)to, i);
            model.setValue("begintime", (Object)beginTime, i);
            model.setValue("endtime", (Object)endTime, i);
            model.setValue("travelname", (Object)travelName, i);
            model.setValue("ticketprice", ticketprice, i);
            model.setValue("status", status, i);
            model.setValue("type", (Object)type, i);
            model.setValue("orderstatus", (Object)orderStatus, i);
            if (null != refundamount) {
                model.setValue("refundamount", (Object)refundamount, i);
            }
            if (null != assuranceamount) {
                model.setValue("assuranceamount", (Object)assuranceamount, i);
            }
            if (null != airportprice) {
                model.setValue("airportprice", (Object)airportprice, i);
            }
            if (null != fuelprice) {
                model.setValue("fuelprice", (Object)fuelprice, i);
            }
            if (null == endorsementamount) continue;
            model.setValue("endorsementamount", (Object)endorsementamount, i);
        }
    }

    private void listViewOrder(List<DynamicObject> orderList, JSONArray billNos) {
        QFilter orderFilter = new QFilter("oabillnum", "in", (Object)billNos.toArray());
        List planeBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_planebill", (QFilter[])new QFilter[]{orderFilter}, null, (int)-1);
        MainEntityType planeType = EntityMetadataCache.getDataEntityType((String)"er_planebill");
        DynamicObject[] planeBills = BusinessDataServiceHelper.load((Object[])planeBillIds.toArray(), (DynamicObjectType)planeType);
        List trainBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_trainbill", (QFilter[])new QFilter[]{orderFilter}, null, (int)-1);
        MainEntityType trainType = EntityMetadataCache.getDataEntityType((String)"er_trainbill");
        DynamicObject[] trainBills = BusinessDataServiceHelper.load((Object[])trainBillIds.toArray(), (DynamicObjectType)trainType);
        List hotelBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_hotelbill", (QFilter[])new QFilter[]{orderFilter}, null, (int)-1);
        MainEntityType hotelType = EntityMetadataCache.getDataEntityType((String)"er_hotelbill");
        DynamicObject[] hotelBills = BusinessDataServiceHelper.load((Object[])hotelBillIds.toArray(), (DynamicObjectType)hotelType);
        List carBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_vehiclebill", (QFilter[])new QFilter[]{orderFilter}, null, (int)-1);
        MainEntityType carType = EntityMetadataCache.getDataEntityType((String)"er_vehiclebill");
        DynamicObject[] carBills = BusinessDataServiceHelper.load((Object[])carBillIds.toArray(), (DynamicObjectType)carType);
        List mealBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_mealbill", (QFilter[])new QFilter[]{orderFilter}, null, (int)-1);
        MainEntityType mealType = EntityMetadataCache.getDataEntityType((String)"er_mealbill");
        DynamicObject[] mealBills = BusinessDataServiceHelper.load((Object[])mealBillIds.toArray(), (DynamicObjectType)mealType);
        orderList.addAll(Arrays.stream(planeBills).collect(Collectors.toList()));
        orderList.addAll(Arrays.stream(trainBills).collect(Collectors.toList()));
        orderList.addAll(Arrays.stream(hotelBills).collect(Collectors.toList()));
        orderList.addAll(Arrays.stream(carBills).collect(Collectors.toList()));
        orderList.addAll(Arrays.stream(mealBills).collect(Collectors.toList()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int[] rows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        switch (key) {
            case "bar_confirm": {
                if (rows.length > 0) {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(rows.length);
                    DynamicObject[] dynamicObjects = ((EntryGrid)this.getView().getControl("entryentity")).getEntryData().getDataEntitys();
                    if (dynamicObjects != null && dynamicObjects.length > 0) {
                        for (int i : rows) {
                            list.add(dynamicObjects[i]);
                        }
                    }
                    HashMap<String, ArrayList<DynamicObject>> map = new HashMap<String, ArrayList<DynamicObject>>(2);
                    map.put("entryentity", list);
                    this.getView().returnDataToParent(map);
                }
                this.getView().close();
                break;
            }
            case "bar_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.searchOrder(mobileSearchTextChangeEvent.getText());
    }
}

