/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.order;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ViewOrderBillList
extends AbstractListPlugin {
    private static final String BAR_VIEWORDER = "bar_vieworder";
    private String formId = "er_travel_up_order";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean haveEnbleServer = TripCommonUtil.getEnbleServer();
        if (!haveEnbleServer.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_VIEWORDER});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Set ids;
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BAR_VIEWORDER) && ((ids = this.getSelectedRows().stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toSet())).size() == 0 || ids.size() > 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u67e5\u770b\u3002", (String)"ViewOrderBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_vieworder": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(this.formId);
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                Map customParam = showParameter.getCustomParams();
                customParam.put("billnos", this.getReqbillnos(((ListView)this.getView()).getBillFormId()));
                customParam.put("opttype", "view");
                this.getView().showForm(showParameter);
            }
        }
    }

    private Set<String> getReqbillnos(String entityId) {
        HashSet<String> billnos = new HashSet<String>();
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId) || "er_tripreimbill_grid".equals(entityId) || "er_layout_tripreimburse".equals(entityId)) {
            Long pkValue = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", (Object)pkValue);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"er_tripreimbursebill", (String)"id,writeoffapply.applybillno", (QFilter[])new QFilter[]{qFilter});
            if (null == bills) {
                return billnos;
            }
            for (DynamicObject bill : bills) {
                DynamicObjectCollection writeOffApplyEntry = bill.getDynamicObjectCollection("writeoffapply");
                if (null == writeOffApplyEntry) continue;
                for (DynamicObject dynamicObject : writeOffApplyEntry) {
                    String reqBillno = dynamicObject.getString("applybillno");
                    if (null == reqBillno || reqBillno.isEmpty()) continue;
                    billnos.add(reqBillno);
                }
            }
        } else if (ErEntityTypeUtils.isTripReqBill((String)entityId) || "er_layout_tripreqbill".equals(entityId) || "er_tripreqbill_ssc".equals(entityId)) {
            String billno = this.getSelectedRows().get(0).getBillNo();
            if (null == billno || billno.isEmpty()) {
                return billnos;
            }
            billnos.add(billno);
        }
        return billnos;
    }
}

