/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ListConstructorHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckingPayBillEditPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    private static List<String> PLANEAMOUNTLAB = Lists.newArrayList((Object[])new String[]{"tabplane", "labplane", "planetotalamount", "labplane1", "labrplane", "rplanetotalamount", "labrplane1"});
    private static List<String> TRAINAMOUNTLAB = Lists.newArrayList((Object[])new String[]{"tabtrain", "labtrain", "traintotalamount", "labtrain1", "labrtrain", "rtraintotalamount", "labrtrain1"});
    private static List<String> HOTELAMOUNTLAB = Lists.newArrayList((Object[])new String[]{"tabhotel", "labhotel", "hoteltotalamount", "labhotel1"});
    private static List<String> VEHICLEAMOUNTLAB = Lists.newArrayList((Object[])new String[]{"tabvehicle", "labvehicle", "vehicletotalamount", "labvehicle1"});
    private static List<String> MEALAMOUNTLAB = Lists.newArrayList((Object[])new String[]{"tabmeal", "labmeal", "mealtotalamount", "labmeal1"});
    private static List<String> SERVICEMOUNTLAB = Lists.newArrayList((Object[])new String[]{"labservice", "servicetotalamount"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payerAccount = (TextEdit)this.getControl("payeraccount");
        if (null != payerAccount) {
            payerAccount.addButtonClickListener((ClickListener)this);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Tab tab = (Tab)this.getView().getControl("tabtrip");
        if (null != tab) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("invoicedetailmatch".equals(itemKey)) {
            this.ticketNumMatch();
            this.tripInfoMatch();
        }
    }

    public void click(EventObject evt) {
        String keyName;
        super.click(evt);
        Control key = (Control)evt.getSource();
        switch (keyName = key.getKey()) {
            case "payeraccount": {
                this.selectAccountByPayer();
            }
        }
    }

    private void ticketNumMatch() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection invoiceentry = dynamicObject.getDynamicObjectCollection("invoiceentry");
        Map<String, List<DynamicObject>> entryMap = entryentity.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("ticketnum")) && e.getBoolean("travelbill") && "TICKET".equals(e.getString("serviceitem"))).collect(Collectors.groupingBy(e -> e.getString("ticketnum")));
        Map<String, List<DynamicObject>> invoiceMap = invoiceentry.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("invoiceno"))).collect(Collectors.groupingBy(e -> e.getString("invoiceno")));
        HashSet<String> entrySet = new HashSet<String>(entryMap.keySet());
        HashSet<String> invoiceSet = new HashSet<String>(invoiceMap.keySet());
        for (String invoiceNo : invoiceSet) {
            for (String ticketNum : entrySet) {
                if (!invoiceNo.contains(ticketNum) || !invoiceNo.endsWith(ticketNum)) continue;
                entryMap.get(ticketNum).forEach(e -> e.set("match", (Object)true));
                invoiceMap.get(invoiceNo).forEach(e -> e.set("invoicematch", (Object)true));
            }
        }
        this.getView().updateView("entryentity");
        this.getView().updateView("invoiceentry");
    }

    private void tripInfoMatch() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection invoiceentry = dynamicObject.getDynamicObjectCollection("invoiceentry");
        List entryList = entryentity.stream().filter(e -> !e.getBoolean("match") && e.getBoolean("travelbill") && "TICKET".equals(e.getString("serviceitem")) && "4".equals(e.getString("entry_operationtype"))).collect(Collectors.toList());
        List invoiceList = invoiceentry.stream().filter(e -> !e.getBoolean("invoicematch")).collect(Collectors.toList());
        block0: for (DynamicObject entry : entryList) {
            String fromcity = entry.getString("fromcity");
            String tocity = entry.getString("tocity");
            String departtime = TripCommonUtil.DateToShortStr((Date)entry.getDate("departtime"));
            String vendorname = entry.getString("vendorname");
            DynamicObject user = entry.getDynamicObject("user");
            if (StringUtils.isBlank((CharSequence)fromcity) || StringUtils.isBlank((CharSequence)tocity) || StringUtils.isBlank((CharSequence)departtime) || StringUtils.isBlank((CharSequence)vendorname) || user == null) continue;
            String name = user.getLocaleString("name").getLocaleValue_zh_CN();
            Iterator iterator = invoiceList.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (!fromcity.equals(next.getString("invoicefromcity")) || !tocity.equals(next.getString("invoicetocity")) || !departtime.equals(TripCommonUtil.DateToShortStr((Date)next.getDate("invoicedate"))) || !name.equals(next.getString("passengername")) || !vendorname.equals(next.getString("flighttrainnums"))) continue;
                entry.set("match", (Object)true);
                next.set("invoicematch", (Object)true);
                iterator.remove();
                continue block0;
            }
        }
        this.getView().updateView("entryentity");
        this.getView().updateView("invoiceentry");
    }

    private void setMapValueMatch(Map<String, List<DynamicObject>> entryMap, Set<String> entrySet, String matchField) {
        for (Map.Entry<String, List<DynamicObject>> entry : entryMap.entrySet()) {
            if (entrySet.contains(entry.getKey())) {
                entry.getValue().stream().forEach(e -> e.set(matchField, (Object)true));
                continue;
            }
            entry.getValue().stream().forEach(e -> e.set(matchField, (Object)false));
        }
    }

    private void selectAccountByPayer() {
        String payerType = (String)this.getModel().getValue("payertype");
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
        DynamicObject payer = (DynamicObject)this.getModel().getValue("payer");
        if (payer == null && payerTypeEnum != PayerTypeEnum.PAYER) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"CheckingPayBillEditPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showBankInfo(payerType, (Long)payer.getPkValue());
    }

    private void showBankInfo(String payerEntityType, Long payerId) {
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerEntityType);
        ListShowParameter lsp = null;
        switch (payerTypeEnum) {
            case SUPPLIER: {
                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)payerId);
                break;
            }
            case CUSTOMER: {
                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)payerId);
                break;
            }
            case CASORG: {
                lsp = ListConstructorHelper.getCasOrgBankInfoShowParameter((Object)payerId);
                break;
            }
        }
        if (lsp != null) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("payeeaccountbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            String payerType = (String)this.getModel().getValue("payertype");
            Object entryKey = PayerTypeEnum.CASORG.getType().equals(payerType) ? rowInfo.getPrimaryKeyValues()[0] : rowInfo.getEntryPrimaryKeyValues()[0];
            AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getBankInfo((String)payerType, (long)((Long)entryKey));
            this.fillBankInfo(this.getModel(), accountInfo);
        }
    }

    private void fillBankInfo(IDataModel model, AccountInfo accountInfo) {
        if (accountInfo != null) {
            this.getModel().setValue("payeraccount", (Object)accountInfo.getAccount());
            Object beBank = accountInfo.getBeBank();
            if (beBank instanceof Long && beBank.equals(0L)) {
                beBank = null;
            }
            this.getModel().setValue("payerbank", beBank);
            this.getModel().setValue("payeraccountname", (Object)accountInfo.getAccountName());
        } else {
            this.getModel().setValue("payeraccount", null);
            this.getModel().setValue("payerbank", null);
            this.getModel().setValue("payeraccountname", null);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("company", null);
        DynamicObject payMode = PayeeServiceHelper.getDefaultPayMode();
        this.getModel().setValue("paymode", (Object)ErCommonUtils.getPk((Object)payMode));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.inituserinfo();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (model.getValue("paymode") == null) {
            DynamicObject payMode = PayeeServiceHelper.getDefaultPayMode();
            model.setValue("paymode", (Object)ErCommonUtils.getPk((Object)payMode));
        }
        if (model.getValue("payer") == null) {
            this.setPayInfo();
        }
        Boolean planeVisible = Boolean.FALSE;
        Boolean hotelVisible = Boolean.FALSE;
        Boolean vehicleVisible = Boolean.FALSE;
        Boolean trainVisible = Boolean.FALSE;
        Boolean mealVisible = Boolean.FALSE;
        Boolean serverVisible = Boolean.FALSE;
        DynamicObjectCollection entryentity = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (null != entryentity && !entryentity.isEmpty()) {
            for (DynamicObject dynamicObject : entryentity) {
                String entry_operationtype;
                switch (entry_operationtype = dynamicObject.getString("entry_operationtype")) {
                    case "1": {
                        hotelVisible = Boolean.TRUE;
                        break;
                    }
                    case "2": {
                        planeVisible = Boolean.TRUE;
                        break;
                    }
                    case "3": {
                        vehicleVisible = Boolean.TRUE;
                        break;
                    }
                    case "4": {
                        trainVisible = Boolean.TRUE;
                        break;
                    }
                    case "5": {
                        mealVisible = Boolean.TRUE;
                    }
                }
            }
            serverVisible = Boolean.TRUE;
        }
        for (String s : PLANEAMOUNTLAB) {
            view.setVisible(planeVisible, new String[]{s});
        }
        for (String s : HOTELAMOUNTLAB) {
            view.setVisible(hotelVisible, new String[]{s});
        }
        for (String s : TRAINAMOUNTLAB) {
            view.setVisible(trainVisible, new String[]{s});
        }
        for (String s : VEHICLEAMOUNTLAB) {
            view.setVisible(vehicleVisible, new String[]{s});
        }
        for (String s : MEALAMOUNTLAB) {
            view.setVisible(mealVisible, new String[]{s});
        }
        for (String s : SERVICEMOUNTLAB) {
            view.setVisible(serverVisible, new String[]{s});
        }
        String billstatus = (String)this.getModel().getValue("billstatus");
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if ("A".equalsIgnoreCase(billstatus) && null != billShowParameter.getBillStatus() && billShowParameter.getBillStatus().equals((Object)BillOperationStatus.ADDNEW) && !this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
            toolbar.itemClick("drawchecking", "drawchecking");
        }
    }

    private void inituserinfo() {
        IDataModel model = this.getModel();
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        if (applier != null) {
            String url = ErCommonUtils.getUserImageFullPath((Long)applier.getLong("id"));
            Image applierPic = (Image)this.getControl("applierpic");
            applierPic.setUrl(url);
            DynamicObjectCollection entryentity = applier.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.size() == 0) {
                return;
            }
            entryentity.stream().filter(entry -> !entry.getBoolean("ispartjob")).forEach(entry -> ((Label)this.getControl("applier_position")).setText(entry.getString("position")));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object actentryamount;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object propValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if ("payer".equals(propName)) {
            AccountInfo accountInfo;
            Object payertype = model.getValue("payertype");
            DynamicObject payer = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (payer != null && (accountInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)((String)payertype), (Long)((Long)payer.getPkValue()))) != null) {
                model.setValue("payeraccount", (Object)accountInfo.getAccount());
                Object beBank = accountInfo.getBeBank();
                if (beBank instanceof Long && beBank.equals(0L)) {
                    beBank = null;
                }
                model.setValue("payerbank", beBank);
                model.setValue("payeraccountname", (Object)accountInfo.getAccountName());
                return;
            }
            model.setValue("payeraccount", null);
            model.setValue("payerbank", null);
            model.setValue("payeraccountname", null);
        } else if ("payertype".equals(propName)) {
            model.setValue("payeraccount", null);
            model.setValue("payerbank", null);
            model.setValue("payeraccountname", null);
        } else if ("payeraccount".equals(propName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null || StringUtils.isBlank((CharSequence)newValue.toString())) {
                model.setValue("payerbank", null);
                model.setValue("payeraccountname", null);
            }
        } else if (StringUtils.equals((CharSequence)"invoicecurrency", (CharSequence)propName)) {
            if (propValue != null) {
                long pkValue = (Long)((DynamicObject)propValue).getPkValue();
                InvoiceUtils.lockCurrency((IFormView)this.getView(), Collections.singleton(pkValue));
                InvoiceUtils.changeInvoiceCurrency((IFormView)this.getView(), (ChangeData)changeData);
            }
        } else if ("taxamount".equals(propName) && (actentryamount = model.getValue("actentryamount")) != null && propValue != null) {
            model.setValue("notaxoriamount", (Object)((BigDecimal)actentryamount).subtract((BigDecimal)propValue), rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("entryentity".equals(name) || "invoiceentry".equals(name)) {
            this.ticketNumMatch();
        }
    }

    private void setPayInfo() {
        IDataModel model = this.getModel();
        Object server = model.getValue("server");
        if (Objects.isNull(server)) {
            return;
        }
        String serverNum = (String)server;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serverNum)});
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        Object provider = dynamicObject.get("provider");
        if (Objects.isNull(provider)) {
            return;
        }
        List accountInfo = PublicReimbursePayerAcctUtils.getAccountInfoByPayerId((String)((String)model.getValue("payertype")), (Long)ErCommonUtils.getPk((Object)provider));
        if (CollectionUtils.isEmpty((Collection)accountInfo)) {
            return;
        }
        AccountInfo tmpAccountInfo = (AccountInfo)accountInfo.get(0);
        for (AccountInfo info : accountInfo) {
            if (!info.isDefault()) continue;
            tmpAccountInfo = info;
            break;
        }
        this.fillBankInfo(model, tmpAccountInfo);
        model.setValue("payer", (Object)ErCommonUtils.getPk((Object)provider));
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        EntryGrid tripentry = (EntryGrid)this.getControl("entryentity");
        ArrayList filter = new ArrayList();
        ArrayList<String> listtemp = new ArrayList<String>();
        HashMap<String, ArrayList<String>> maptemp = new HashMap<String, ArrayList<String>>();
        listtemp.add("entry_operationtype");
        maptemp.put("FieldName", listtemp);
        listtemp = new ArrayList();
        listtemp.add("17");
        maptemp.put("Compare", listtemp);
        filter.add(maptemp);
        listtemp = new ArrayList();
        switch (subTabKey) {
            case "tabplane": {
                listtemp.add("2");
                break;
            }
            case "tabhotel": {
                listtemp.add("1");
                break;
            }
            case "tabvehicle": {
                listtemp.add("3");
                break;
            }
            case "tabtrain": {
                listtemp.add("4");
                break;
            }
            case "tabmeal": {
                listtemp.add("5");
                break;
            }
            case "taball": {
                listtemp.add("1");
                listtemp.add("2");
                listtemp.add("3");
                listtemp.add("4");
                listtemp.add("5");
                listtemp.add(null);
            }
        }
        maptemp.put("Value", listtemp);
        tripentry.getGridDataByFilter(filter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            String operateKey;
            switch (operateKey = ((FormOperate)source).getOperateKey()) {
                case "drawchecking": {
                    this.openConfirmCheckingpayForm();
                }
            }
        }
    }

    private void openConfirmCheckingpayForm() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_confirmcheckingpay");
        paramMap.put("formType", "14");
        paramMap.put("needCallBack", Boolean.TRUE);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long settlemainId = null;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String server = dataEntity.getString("server");
        DynamicObject settlemain = dataEntity.getDynamicObject("company");
        if (settlemain != null) {
            settlemainId = settlemain.getLong("id");
            customParam.put("settlemain", settlemainId);
        }
        if (null != server) {
            HashSet<String> list = new HashSet<String>(1);
            list.add(server);
            Map tripServiceInfoDOMap = TripCommonUtil.getTripServiceInfoDOMap(list);
            if (null != tripServiceInfoDOMap && !tripServiceInfoDOMap.isEmpty()) {
                customParam.put("server", ((DynamicObject)tripServiceInfoDOMap.values().iterator().next()).getLong("id"));
            }
        }
        customParam.put("period", TripCommonUtil.getLastMonthFirstDay());
        paramMap.put("customParam", customParam);
        ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
    }
}

