/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.trip.model.TripType;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEnhancedConvertReportUtil;
import org.apache.commons.lang.math.NumberUtils;

public class ConfirmcheckingpayEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit org;
        super.registerListener(e);
        BasedataEdit server = (BasedataEdit)this.getControl("server");
        if (null != server) {
            server.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (org = (BasedataEdit)this.getControl("org"))) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"btnok"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setShowApproved(false);
        showParameter.setShowUsed(false);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (null != customParams.get("server")) {
            model.setValue("server", customParams.get("server"));
            model.setValue("server_id", customParams.get("server"));
            view.setEnable(Boolean.FALSE, new String[]{"server"});
            view.setEnable(Boolean.FALSE, new String[]{"settlemain"});
        }
        if (null != customParams.get("period")) {
            model.setValue("perioddate", customParams.get("period"));
        } else {
            model.setValue("perioddate", (Object)TripCommonUtil.getLastMonthDate());
        }
        if (null != customParams.get("settlemain")) {
            model.setValue("settlemain", customParams.get("settlemain"));
            model.setValue("settlemain_id", customParams.get("settlemain"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if ("btnok".equals(operateKey) && result.isSuccess()) {
            this.openCheckListForm();
        }
    }

    private void openCheckListForm() {
        IDataModel model = this.getModel();
        DynamicObject server = (DynamicObject)model.getValue("server");
        Date perioddate = (Date)model.getValue("perioddate");
        DynamicObject settlemain = (DynamicObject)model.getValue("settlemain");
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        if (null != server) {
            customParam.put("server", server.getString("number"));
        }
        if (null != perioddate) {
            customParam.put("periodstartdate", TripCommonUtil.convertToDate((String)TripCommonUtil.getMonthFirstDay((Date)perioddate)));
            customParam.put("periodenddate", TripCommonUtil.convertToDate((String)TripCommonUtil.getMonthLastDay((Date)perioddate)));
        }
        if (null != settlemain) {
            customParam.put("settlemain", settlemain.getLong("id"));
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setLookUp(true);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("er_checkingbill");
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_checkingbill"));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("650px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setCustomParams(customParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "er_checkingbill": {
                if (null == returnData || !(returnData instanceof ListSelectedRowCollection)) {
                    return;
                }
                ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
                if (null == returnData) {
                    return;
                }
                HashMap map = new HashMap(8);
                Set ids = list.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toSet());
                if (null == ids || ids.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RepaymentBillListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection checkingbills = QueryServiceHelper.query((String)"er_checkingbill", (String)"id,billnum,operationtype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (null == checkingbills || checkingbills.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RepaymentBillListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject check : checkingbills) {
                    String operationtype = check.getString("operationtype");
                    String billnum = check.getString("billnum");
                    String formid = "";
                    for (TripType value : TripType.values()) {
                        if (!value.getOperationtype().equals(operationtype)) continue;
                        formid = value.getChecking();
                    }
                    if (null == map.get(formid)) {
                        HashSet<String> maplist = new HashSet<String>(8);
                        maplist.add(billnum);
                        map.put(formid, maplist);
                        continue;
                    }
                    ((Set)map.get(formid)).add(billnum);
                }
                Iterator ite = map.entrySet().iterator();
                HashMap dynamicObjectMap = new HashMap(map.size());
                while (ite.hasNext()) {
                    Map.Entry next = ite.next();
                    Set value = (Set)next.getValue();
                    QFilter qA = new QFilter("checkingbillnum", "in", (Object)value);
                    QFilter qB = new QFilter("paybillid", "=", (Object)0);
                    QFilter qC = new QFilter("isbalance", "=", (Object)"1");
                    QFilter qD = new QFilter("billstatus", "=", (Object)"C");
                    QFilter qF = new QFilter("totalamount", "!=", (Object)0);
                    DynamicObject[] checkingbillnums = BusinessDataServiceHelper.load((String)((String)next.getKey()), (String)"id,ordernum", (QFilter[])new QFilter[]{qA, qB, qC, qD, qF});
                    if (null == checkingbillnums || checkingbillnums.length == 0) continue;
                    dynamicObjectMap.put(next.getKey(), checkingbillnums);
                }
                if (dynamicObjectMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e\u3002", (String)"RepaymentBillListPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Iterator iterator = dynamicObjectMap.entrySet().iterator();
                ListSelectedRowCollection rows = new ListSelectedRowCollection();
                boolean isFail = Boolean.FALSE;
                ArrayList<ConvertOperationResult> convertResults = new ArrayList<ConvertOperationResult>(10);
                DrawArgs failArgs = new DrawArgs();
                while (iterator.hasNext()) {
                    Map.Entry next = iterator.next();
                    DynamicObject[] checkingbillnums = (DynamicObject[])next.getValue();
                    int i = 0;
                    for (DynamicObject checkingbillnum : checkingbillnums) {
                        ListSelectedRow row = new ListSelectedRow();
                        row.setBillNo(checkingbillnum.getString("ordernum"));
                        row.setRowKey(i++);
                        row.setPrimaryKeyValue((Object)checkingbillnum.getLong("id"));
                        row.setPkLongType(true);
                        row.setFormID((String)next.getKey());
                        String mainOrgId = EntityTypeUtil.getMainOrgId((MainEntityType)((MainEntityType)checkingbillnum.getDataEntityType()));
                        if (NumberUtils.isDigits((String)mainOrgId)) {
                            row.setMainOrgId(Long.parseLong(mainOrgId));
                        }
                        rows.add((Object)row);
                    }
                    String entityName = checkingbillnums[0].getDataEntityType().getName();
                    ActionLocalCache.get().put("drawchecking", (Object)true);
                    DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)entityName, (String)"er_checkingpaybill", (IFormView)this.getView().getParentView(), (ListSelectedRowCollection)rows);
                    ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
                    if (result.isSuccess() && !result.getCachePageIds().isEmpty()) {
                        BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, (IFormView)this.getView().getParentView(), (DrawArgs)args);
                        continue;
                    }
                    isFail = Boolean.TRUE;
                    failArgs = args;
                    convertResults.add(result);
                }
                if (isFail && null != this.getView().getParentView()) {
                    ErEnhancedConvertReportUtil.showEnhancedConvertReport(convertResults, (DrawArgs)failArgs, (IFormView)this.getView().getParentView());
                }
                if (null != this.getView().getParentView()) {
                    this.getView().getParentView().updateView();
                }
                this.getView().close();
            }
        }
    }
}

