/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CheckingBillServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.ShowCompanyListPlugin;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;

public class ErCheckingPayBillList
extends ShowCompanyListPlugin {
    private static final String VIEW_ORDER_BTN = "vieworderbtn";
    private static final String CREATE_PAY_RECORD_BTN = "createpayrecordbtn";
    private static final String CHECKING_PAY_BILL = "checkingpaybill";

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        args.getQFilters().add(new QFilter("orgpattern", "in", (Object)new Object[]{1, 2, 5}));
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (VIEW_ORDER_BTN.equalsIgnoreCase(key)) {
            this.showOrderBill();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection rowCollection;
        if ("pushdown".equalsIgnoreCase(evt.getItemKey()) && (rowCollection = ((IListView)this.getView()).getSelectedRows()).size() == 0) {
            return;
        }
    }

    private void showOrderBill() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection RowCollection = view.getSelectedRows();
        if (RowCollection.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\u3002", (String)"ErCheckingPayBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (RowCollection.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ErCheckingPayBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = RowCollection.get(0);
        Object pkValue = row.getPrimaryKeyValue();
        IErDao checkingPayBillDao = ErDaoFactory.getInstance((String)"er_checkingpaybill");
        DynamicObject currentRowData = checkingPayBillDao.queryOne(pkValue);
        Date periodDate = currentRowData.getDate("happenddate");
        CheckingBillServiceHelper.CheckDateRange orderDateRange = CheckingBillServiceHelper.getCheckDateRange((Date)periodDate);
        Date startDate = orderDateRange.getStartDate();
        Date endDate = orderDateRange.getEndDate();
        Long companyId = (Long)currentRowData.getDynamicObject("company").getPkValue();
        String operationType = currentRowData.getString("operationtype");
        String orderFormId = currentRowData.getString("orderformid");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(orderFormId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        String filterStr = "company=? and operationtype=? and happenddate>=? and happenddate<=? and producttype!='2'";
        QFilter orderListFilter = QFilter.of((String)filterStr, (Object[])new Object[]{companyId, operationType, startDate, endDate});
        listFilterParameter.setFilter(orderListFilter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)listShowParameter);
    }

    private void createPayRecord() {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("operation", CHECKING_PAY_BILL);
        customParam.put("curApplier", CommonServiceHelper.getCurrentUserID());
        FormModel formModel = new FormModel("er_checkingsetting", ResManager.loadKDString((String)"\u751f\u6210\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355\u8bbe\u7f6e", (String)"ErCheckingPayBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "14", Boolean.TRUE.booleanValue(), customParam);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String operation;
        super.closedCallBack(e);
        Map returnData = (Map)e.getReturnData();
        String actionId = e.getActionId();
        if (returnData != null && "er_checkingsetting".equalsIgnoreCase(actionId) && CHECKING_PAY_BILL.equalsIgnoreCase(operation = (String)returnData.get("operation"))) {
            int result = CheckingBillServiceHelper.createCheckingPayBill((Map)returnData);
            if (result == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5bf9\u8d26\u6216\u8005\u5ba1\u6838\uff0c\u518d\u751f\u6210\u4ed8\u6b3e\u8bb0\u5f55\u3002", (String)"ErCheckingPayBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (result == 1) {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6708\u7ed3\u4ed8\u6b3e\u6570\u636e\u5df2\u6210\u529f\u751f\u6210\u3002", (String)"ErCheckingPayBillList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (result == 2) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6708\u7ed3\u4ed8\u6b3e\u6570\u636e\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErCheckingPayBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs event) {
        IListView view = (IListView)this.getView();
        ListSelectedRow currenctRow = view.getCurrentSelectedRowInfo();
        Object pk = currenctRow.getPrimaryKeyValue();
        if (pk == null) {
            return;
        }
        String fieldName = event.getFieldName();
        if ("paybillnum".equalsIgnoreCase(fieldName)) {
            event.setCancel(true);
            IErDao dao = null;
            dao = ErDaoFactory.getInstance((String)"er_checkingpaybill");
            DynamicObject checkingPay = dao.queryOne("paybillnum", pk);
            Object payBillNum = checkingPay.get("paybillnum");
            String formId = "cas_paybill";
            dao = ErDaoFactory.getInstance((String)formId);
            DynamicObject order = dao.queryOne("id", new QFilter("billno", "=", payBillNum));
            if (order != null) {
                this.openLinkedForm(order.getPkValue(), formId);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5173\u8054\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ErCheckingPayBillList_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openLinkedForm(Object pkValue, String FormId) {
        IFormView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(FormId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            String operateKey;
            switch (operateKey = ((FormOperate)source).getOperateKey()) {
                case "createpayrecordbtn": {
                    this.createPayRecord();
                    break;
                }
                case "newcheckingpay": {
                    this.openConfirmCheckingpayForm();
                }
            }
        }
    }

    private void openConfirmCheckingpayForm() {
        String appNum;
        List orgs;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_confirmcheckingpay");
        paramMap.put("formType", "14");
        paramMap.put("needCallBack", Boolean.TRUE);
        HashMap<String, Long> customParam = new HashMap<String, Long>();
        ListView list = (ListView)this.getView();
        ControlFilters filters = list.getControlFilters();
        List settlemains = filters.getFilter("settlemain.id");
        Long settlemainId = null;
        if (settlemains != null && settlemains.size() > 0 && StringUtils.isNotBlank((CharSequence)settlemains.get(0).toString())) {
            settlemainId = Long.valueOf(settlemains.get(0).toString());
        }
        if (settlemainId == null && (orgs = ErPermissionServiceHelper.getOrgListWithQueryPerm((String)(appNum = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getAppId()) ? "em" : this.getView().getFormShowParameter().getAppId()), (String)"er_checkingpaybill")) != null && orgs.size() > 0) {
            settlemainId = (Long)orgs.get(0);
        }
        if (settlemainId == null) {
            settlemainId = RequestContext.get().getOrgId();
        }
        customParam.put("settlemain", settlemainId);
        paramMap.put("customParam", customParam);
        ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
    }
}

