/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.payinvoice;

import com.alibaba.fastjson.JSON;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.ExternalConstants;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;

public class InvoiceOrderBillList
extends AbstractListPlugin
implements IConfirmCallBack {
    private static final String BILLLISTAP = "billlistap";
    public static final String SEND_BTN = "sendbtn";
    public static final String INVOICE_DOWNLOAD = "invoicedownload";
    public static final String GET_INVOICE = "getinvoice";
    private static final Log logger = LogFactory.getLog(InvoiceOrderBillList.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IFormView view = this.getView();
        switch (operateKey) {
            case "getinvoice": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() <= 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"InvoiceOrderBillList_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String entityNum = billList.getEntityType().getName();
                for (ListSelectedRow selectedRow : selectedRows) {
                    Object primaryKey = selectedRow.getPrimaryKeyValue();
                    QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", primaryKey)};
                    DynamicObject entryEntityObject = QueryServiceHelper.queryOne((String)entityNum, (String)"id,server,invoicecode,invoicestatus,batchno", (QFilter[])qFilters);
                    String server = entryEntityObject.getString("server").trim();
                    if (!Supplier.CHAILVYIHAO.getValue().equals(server)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5dee\u65c5\u58f9\u53f7\u53d1\u7968\u83b7\u53d6\u3002", (String)"InvoiceOrderBillList_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (null != entryEntityObject.getString("batchno")) continue;
                    view.showTipNotification(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceOrderBillList_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                break;
            }
            case "viewitinerary": {
                BillList billlistap = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection rows = billlistap.getSelectedRows();
                this.viewItinerarys(rows);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        OperationResult result = evt.getOperationResult();
        if (SEND_BTN.equals(operateKey) && result.isSuccess()) {
            DynamicObject[] invoiceOrders = this.getInvoiceData();
            if (invoiceOrders != null) {
                this.pushInvoice(invoiceOrders);
            }
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.refresh();
        } else if (INVOICE_DOWNLOAD.equals(operateKey) && result.isSuccess()) {
            this.invoiceDownload();
        } else if (GET_INVOICE.equals(operateKey) && result.isSuccess()) {
            this.getinvoice();
        }
    }

    private void getinvoice() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        String entityNum = billList.getEntityType().getName();
        StringBuffer msg = new StringBuffer();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKey = selectedRow.getPrimaryKeyValue();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", primaryKey).and(new QFilter("server", "=", (Object)Supplier.CHAILVYIHAO.name()))};
            DynamicObject entryEntityObject = QueryServiceHelper.queryOne((String)entityNum, (String)"id,server,invoicecode,invoicestatus,batchno", (QFilter[])qFilters);
            String server = entryEntityObject.getString("server");
            String tripServiceName = (String)TripCommonUtil.getStandtripname().get(server);
            ITripService tripService = TripServiceFactory.getTripService((String)tripServiceName);
            HashMap params = new HashMap(1);
            ArrayList<String> batchnos = new ArrayList<String>(1);
            batchnos.add(entryEntityObject.getString("batchno").split("-")[0]);
            params.put("batchnos", batchnos);
            logger.info("\u53d1\u7968\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
            String invoiceDetail = tripService.getInvoiceDetail(params);
            logger.info("\u53d1\u7968\u83b7\u53d6\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)invoiceDetail);
            if ("200".equals(invoiceDetail)) continue;
            msg.append(invoiceDetail);
        }
        if (msg.toString().isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u6210\u529f\u3002", (String)"InvoiceOrderBillList_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5b58\u5728\u5931\u8d25\uff1a%s", (String)"InvoiceOrderBillList_21", (String)"fi-er-formplugin", (Object[])new Object[0]), msg));
        }
    }

    private void invoiceDownload() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        IFormView view = this.getView();
        if (selectedRows.size() > 1 || selectedRows.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5f00\u7968\u7533\u8bf7\u5355\u8fdb\u884c\u53d1\u7968\u4e0b\u8f7d\u3002", (String)"InvoiceOrderBillList_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Object primaryKey = selectedRows.get(0).getPrimaryKeyValue();
        String entityNum = billList.getEntityType().getName();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", primaryKey)};
        DynamicObject entryEntityObject = QueryServiceHelper.queryOne((String)entityNum, (String)"id,server,invoicecode,invoicestatus", (QFilter[])qFilters);
        String server = entryEntityObject.getString("server");
        if (!Supplier.DIDI.getValue().equals(server)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u670d\u52a1\u5546\u4e3a\u6ef4\u6ef4\u7684\u5f00\u7968\u7533\u8bf7\u5355\u8fdb\u884c\u53d1\u7968\u4e0b\u8f7d\u3002", (String)"InvoiceOrderBillList_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String invoiceId = entryEntityObject.getString("invoicecode");
        String invoiceStatus = entryEntityObject.getString("invoicestatus");
        if (!"3".equals(invoiceStatus) || StringUtils.isEmpty((CharSequence)invoiceId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u7968\u7533\u8bf7\u5355\u5c1a\u672a\u6210\u529f\u5f00\u7968\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u53d1\u7968\u3002", (String)"InvoiceOrderBillList_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.invoiceDownload(invoiceId);
    }

    private void invoiceDownload(String invoiceId) {
        HashMap<String, Object> getParam = new HashMap<String, Object>();
        getParam.put("invoice_id", invoiceId);
        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.getOrCreate().getTraceId(), Supplier.DIDI.getValue(), "invoiceReceiveInvoke");
        DiDiServiceUtil.buildRequestParams(getParam, (TripSyncLogParam)tripSyncLogParam);
        String url = (String)ExternalConstants.DIDIURLMAP.get("invoiceDownLoadKey");
        tripSyncLogParam.setRequesturl(url);
        String uri = this.getExternalURI(url, getParam);
        this.getView().openUrl(uri);
    }

    private String getExternalURI(String url, Map<String, Object> getParam) {
        String uri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (getParam != null) {
                for (Map.Entry<String, Object> entry : getParam.entrySet()) {
                    uriBuilder.setParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            uri = httpGet.getURI().toString();
        }
        catch (URISyntaxException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u7ec4\u88c5\u8bf7\u6c42URI\u5f02\u5e38\uff1a" + e);
        }
        return uri;
    }

    private DynamicObject[] getInvoiceData() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        IFormView view = this.getView();
        if (selectedRows.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceOrderBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return null;
        }
        Object[] invoiceOrderBillIds = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)invoiceOrderBillIds);
        QFilter statusFilter = new QFilter("invoicestatus", "in", (Object)new Object[]{"1", "5", "6", "7"});
        List invoiceOrderIdlist = QueryServiceHelper.queryPrimaryKeys((String)"er_invoiceorderbill", (QFilter[])new QFilter[]{qFilter, statusFilter}, null, (int)-1);
        DynamicObject[] invoiceOrders = BusinessDataServiceHelper.load((Object[])invoiceOrderIdlist.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_invoiceorderbill"));
        return invoiceOrders;
    }

    private void pushInvoice(DynamicObject[] invoiceOrders) {
        Map<String, List<DynamicObject>> serverGroup = Stream.of(invoiceOrders).collect(Collectors.groupingBy(d -> d.getString("server")));
        try {
            for (Map.Entry<String, List<DynamicObject>> entry : serverGroup.entrySet()) {
                String server = entry.getKey().trim();
                if (StringUtils.equalsIgnoreCase((CharSequence)server, (CharSequence)Supplier.CHAILVYIHAO.name())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u65c5\u58f9\u53f7\u65e0\u9700\u63a8\u9001\u5f00\u7968\u3002", (String)"InvoiceOrderBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)server, (CharSequence)Supplier.DIDI.name())) {
                    String userId = RequestContext.getOrCreate().getUserId();
                    String email = null;
                    if (!StringUtils.isEmpty((CharSequence)userId)) {
                        DynamicObject user = CommonServiceHelper.getUser((Long)Long.valueOf(userId));
                        email = user.getString("email");
                    }
                    if (StringUtils.isEmpty(email)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5f53\u524d\u7528\u6237\u7684\u90ae\u7bb1\u5730\u5740\uff0c\u4ee5\u63a5\u6536\u5f00\u7968\u4fe1\u606f\u3002", (String)"InvoiceOrderBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                List<DynamicObject> tmpInvoiceOrders = entry.getValue();
                String tripServiceName = (String)TripCommonUtil.getStandtripname().get(server);
                ITripService iTripService = TripServiceFactory.getTripService((String)tripServiceName);
                logger.info("\u53ef\u5f00\u7968\u6570\u91cf\uff1a{}", (Object)tmpInvoiceOrders.size());
                iTripService.sendInvoiceRequest((Object[])tmpInvoiceOrders.toArray(new DynamicObject[tmpInvoiceOrders.size()]));
            }
            String msg = this.filterInvoice(invoiceOrders);
            if ("".equals(msg)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f", (String)"InvoiceOrderBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(msg);
            }
            logger.info("\u5546\u65c5\u96c6\u6210,sendinvoice end");
        }
        catch (Exception e) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u63a8\u9001\u5f00\u7968\u5931\u8d25\u539f\u56e0:" + e.getMessage(), (Object)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25:%s", (String)"InvoiceOrderBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private String filterInvoice(DynamicObject[] invoiceOrders) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] invoiceOrderBillIds = selectedRows.getPrimaryKeyValues();
        if (invoiceOrderBillIds != null && invoiceOrderBillIds.length != invoiceOrders.length) {
            QFilter qFilter = new QFilter("id", "in", (Object)invoiceOrderBillIds).and("invoicestatus", "in", (Object)new Object[]{"1", "5", "6", "7"});
            DynamicObjectCollection errorInvoices = QueryServiceHelper.query((String)"er_invoiceorderbill", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
            String msg = String.format(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f%1$s\u6761\uff0c\u63a8\u9001\u5931\u8d25%2$s\u6761\uff1b", (String)"InvoiceOrderBillList_16", (String)"fi-er-formplugin", (Object[])new Object[0]), invoiceOrderBillIds.length - errorInvoices.size(), errorInvoices.size());
            StringBuilder msgSb = new StringBuilder(msg);
            for (DynamicObject errorInvoice : errorInvoices) {
                msgSb.append(errorInvoice.getString("billno"));
                msgSb.append("\uff1b");
            }
            return msgSb.toString();
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void viewItinerarys(ListSelectedRowCollection selectedRows) {
        DynamicObjectCollection invoiceRelDyns;
        if (selectedRows.getBillListSelectedRowCollection().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u67e5\u8be2\u3002", (String)"InvoiceOrderBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InvoiceOrderBillList_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        ListSelectedRow selectedRow = selectedRows.get(0);
        Long invoiceId = (Long)selectedRow.getPrimaryKeyValue();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)invoiceId)};
        DynamicObject invoiceorderbill = QueryServiceHelper.queryOne((String)"er_invoiceorderbill", (String)"billno,expcommitcomnum,serviceitem", (QFilter[])qFilters);
        if (invoiceorderbill != null) {
            String serviceitem = invoiceorderbill.getString("serviceitem");
            if (!Serviceitem.ITINERARY.getName().equals(serviceitem)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u670d\u52a1\u9879\u76ee\u5e94\u4e3a\u673a\u7968\u884c\u7a0b\u5355\u3002", (String)"InvoiceOrderBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Long expcommitcomnumId = invoiceorderbill.getLong("expcommitcomnum");
            paraMap.put("expcommitcomnumId", expcommitcomnumId);
            String billno = invoiceorderbill.getString("billno");
            paraMap.put("billno", billno);
        }
        if ((invoiceRelDyns = QueryServiceHelper.query((String)"er_invoicesettle_rel", (String)"id, serviceitem, systemtaxrate, totalamount, taxamount, settleid, settleformid", (QFilter[])new QFilter[]{new QFilter("invoiceid", "=", (Object)invoiceId)})) != null && invoiceRelDyns.size() > 0) {
            Set settleIds = invoiceRelDyns.stream().map(v -> v.getLong("settleid")).collect(Collectors.toSet());
            String settleformId = ((DynamicObject)invoiceRelDyns.get(0)).getString("settleformid");
            DynamicObjectCollection settleDyns = QueryServiceHelper.query((String)settleformId, (String)"id, ordernum,ticketnum,settlemain", (QFilter[])new QFilter[]{new QFilter("id", "in", settleIds)});
            List itinerarynumList = settleDyns.stream().map(v -> v.getString("ticketnum")).collect(Collectors.toList());
            paraMap.put("itinerarynumSet", itinerarynumList);
            if (itinerarynumList.size() == 1 && itinerarynumList.contains("")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u6ca1\u6709\u884c\u7a0b\u5355\u3002", (String)"InvoiceOrderBillList_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        paraMap.put("isItinerar", true);
        FormModel formModel = new FormModel("er_invoiceinfo_query", ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u8be2", (String)"InvoiceOrderBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]), "3", true);
        formModel.setShowType(ShowType.MainNewTabPage);
        formModel.setCustomParam(paraMap);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }
}

