/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.sso.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang.StringUtils;

public class TripSSOUtils {
    public static final Map<String, String> SERVER_AND_CONTROLKEY_MAP = Maps.newHashMapWithExpectedSize((int)8);

    public static void didiLogin(String key, IFormView view) {
        Map paramMap = CommonServiceHelper.getUserMap((Long)CommonServiceHelper.getCurrentUserID());
        paramMap.put("view", view);
        if (StringUtils.equalsIgnoreCase((String)"didi_car", (String)key) || StringUtils.equalsIgnoreCase((String)"didi_carlabelap", (String)key)) {
            paramMap.put("businessType", "car");
        } else if (StringUtils.equalsIgnoreCase((String)"didi_list", (String)key) || StringUtils.equalsIgnoreCase((String)"didi_listabelap", (String)key)) {
            paramMap.put("businessType", "orderlist");
        } else if (StringUtils.equalsIgnoreCase((String)"didi_home", (String)key) || StringUtils.equalsIgnoreCase((String)"didi_homeabelap", (String)key)) {
            paramMap.put("businessType", "car");
        }
        ITripService tripService = TripServiceFactory.getTripService((String)"DiDiTripService");
        tripService.login(paramMap);
    }

    public static void commonLogin(String key, IFormView view) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(3);
        paraMap.put("dotneedreqbill", true);
        paraMap.put("isPC", false);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId())};
        DynamicObject userObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])qFilters);
        paraMap.put("employeeNumber", userObject.get("number"));
        paraMap.put("key", key);
        TripCommonUtil.openTripPage((IFormView)view, paraMap);
    }

    public static void judgeTrialOrg(IFormView view, Set<String> tmpList) {
        Map map = TripCommonUtil.getTripBusinessServerTrialOrg((List)Lists.newArrayList(tmpList));
        boolean enableRefreshOrder = Boolean.FALSE;
        boolean enableSyncApplyBill = Boolean.FALSE;
        boolean onlyMeiTuan = Boolean.FALSE;
        boolean otherServer = Boolean.FALSE;
        for (String server : tmpList) {
            Map enableMap = (Map)map.get(server);
            boolean enableHome = Boolean.FALSE;
            switch (server) {
                case "CHAILVYIHAO": 
                case "XIECHENG": {
                    enableRefreshOrder = enableRefreshOrder || enableMap.getOrDefault("enablehome", Boolean.FALSE) != false;
                }
                case "TONGCHENG": 
                case "ALI": 
                case "QICHENG": 
                case "MEIYA": {
                    enableHome = enableMap.getOrDefault("enablehome", Boolean.FALSE);
                    otherServer = otherServer ? otherServer : enableHome;
                    break;
                }
                case "GAODE": 
                case "DIDI": {
                    enableHome = enableMap.getOrDefault("enablecar", Boolean.FALSE);
                    otherServer = otherServer ? otherServer : enableHome;
                    break;
                }
                case "MEITUAN": {
                    onlyMeiTuan = enableHome = enableMap.getOrDefault("enabledinner", Boolean.FALSE).booleanValue();
                }
            }
            enableSyncApplyBill = enableSyncApplyBill ? enableSyncApplyBill : enableHome;
            view.setVisible(Boolean.valueOf(enableHome), new String[]{SERVER_AND_CONTROLKEY_MAP.get(server)});
        }
        if (onlyMeiTuan && !otherServer) {
            view.setVisible(Boolean.valueOf(otherServer), new String[]{"pushapplybill"});
        }
        view.setVisible(Boolean.valueOf(enableRefreshOrder), new String[]{"refreshorderbill"});
        view.setVisible(Boolean.valueOf(enableSyncApplyBill), new String[]{"er_trip"});
    }

    public static void setBillDatas(DynamicObjectCollection datas, IDataModel model, String preFix, String entryName) {
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObjectCollection entryEntity = model.getDataEntity().getDynamicObjectCollection(entryName);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            entryEntity.clear();
        }
        for (DynamicObject reqBill : datas) {
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set(preFix + "billno", (Object)reqBill.getString("billno"));
            dynamicObject.set(preFix + "date", (Object)format.format(reqBill.getDate("bizdate")));
            dynamicObject.set(preFix + "reason", (Object)reqBill.getString("description"));
        }
    }

    static {
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.CHAILVYIHAO.getValue(), "travelnoone_home");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.XIECHENG.getValue(), "corp_home");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.DIDI.getValue(), "didi_home");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.MEITUAN.getValue(), "meituan_dinner");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.GAODE.getValue(), "gaode_car");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.TONGCHENG.getValue(), "dtg_home");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.ALI.getValue(), "ali_home");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.QICHENG.getValue(), "qicheng_home");
        SERVER_AND_CONTROLKEY_MAP.put(Supplier.MEIYA.getValue(), "meiya_home");
    }
}

