/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.syncapplybill;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.formplugin.trip.sso.util.TripSSOUtils;

public class TripServerChoosePlugin
extends AbstractMobBillPlugIn {
    private final Log logger = LogFactory.getLog(TripServerChoosePlugin.class);

    public void registerListener(EventObject e) {
        String[] keys = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP.values().toArray(new String[0]);
        this.addClickListeners((String[])Arrays.stream(keys).distinct().toArray(String[]::new));
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, String> tmpMap = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP;
        Set<String> tmpList = tmpMap.keySet();
        IFormView view = this.getView();
        TripSSOUtils.judgeTrialOrg(view, tmpList);
    }

    public void click(EventObject evt) {
        try {
            Control control = (Control)evt.getSource();
            String key = control.getKey();
            Map<String, String> tmpMap = TripSSOUtils.SERVER_AND_CONTROLKEY_MAP;
            String server = tmpMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)).getOrDefault(key, "");
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            paramMap.put("number", server);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_biz_info", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)server)});
            paramMap.put("name", dynamicObject == null ? "" : dynamicObject.getString("name"));
            IFormView view = this.getView();
            view.returnDataToParent((Object)paramMap);
            view.close();
        }
        catch (Exception ex) {
            this.logger.error("kd.fi.er.formplugin.trip.syncapplybill.TripServerChoosePlugin.click \u70b9\u51fb\u4e8b\u4ef6\u9519\u8bef", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TripServerChoosePlugin_01", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }
}

